/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.util.Hashtable;
import java.util.Properties;
import javax.jdo.JDODataStoreException;
import javax.jdo.datastore.Sequence;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDOSequenceImpl
implements Sequence,
NucleusSequence {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", (class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = JDOSequenceImpl.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected final StoreManager storeManager;
    protected final SequenceMetaData seqMetaData;
    protected final ValueGenerator generator;
    protected final ObjectManager om;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public JDOSequenceImpl(ObjectManager objectMgr, final StoreManager storeMgr, SequenceMetaData seqmd) {
        this.om = objectMgr;
        this.storeManager = storeMgr;
        this.seqMetaData = seqmd;
        String poidGeneratorName = "sequence";
        Properties props = new Properties();
        ExtensionMetaData[] seqExtensions = seqmd.getExtensions();
        if (seqExtensions != null && seqExtensions.length > 0) {
            for (int i = 0; i < seqExtensions.length; ++i) {
                ((Hashtable)props).put(seqExtensions[i].getKey(), seqExtensions[i].getValue());
            }
        }
        ((Hashtable)props).put("sequence-name", this.seqMetaData.getDatastoreSequence());
        ValueGenerationManager mgr = storeMgr.getPoidManager();
        final ObjectManager thisOM = objectMgr;
        ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
            ManagedConnection mconn;

            public ManagedConnection retrieveConnection() {
                this.mconn = storeMgr.getConnection(thisOM);
                return this.mconn;
            }

            public void releaseConnection() {
                this.mconn.release();
                this.mconn = null;
            }
        };
        Class cls = null;
        ConfigurationElement elem = objectMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{poidGeneratorName, this.storeManager.getStoreManagerKey()});
        if (elem != null) {
            cls = objectMgr.getOMFContext().getPluginManager().loadClass(elem.getExtension().getPlugin().getSymbolicName(), elem.getAttribute("class-name"));
        }
        if (cls == null) {
            throw new NucleusException("Cannot create Poid Generator for strategy " + poidGeneratorName);
        }
        this.generator = mgr.createValueGenerator(this.seqMetaData.getName(), cls, props, this.storeManager, connProvider);
        if (NucleusLogger.JDO.isDebugEnabled()) {
            NucleusLogger.JDO.debug(LOCALISER.msg("017003", (Object)this.seqMetaData.getName(), (Object)poidGeneratorName));
        }
    }

    public String getName() {
        return this.seqMetaData.getName();
    }

    public void allocate(int additional) {
        try {
            this.generator.allocate(additional);
        }
        catch (NucleusException nucleusException) {
            // empty catch block
        }
    }

    public Object next() {
        try {
            return this.generator.next();
        }
        catch (NucleusDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public long nextValue() {
        try {
            return this.generator.nextValue();
        }
        catch (NucleusDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public Object current() {
        try {
            return this.generator.current();
        }
        catch (NucleusDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public long currentValue() {
        try {
            return this.generator.currentValue();
        }
        catch (NucleusDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

