/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Currency;
import java.util.Date;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.SingleFieldIdentity;
import org.datanucleus.util.I18nUtils;

public class ObjectIdentity
extends SingleFieldIdentity {
    private static final String STRING_DELIMITER = ":";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectIdentity(Class pcClass, Object param) {
        super(pcClass);
        this.assertKeyNotNull(param);
        String paramString = null;
        String keyString = null;
        String className = null;
        if (param instanceof String) {
            paramString = (String)param;
            if (paramString.length() < 3) {
                throw new NucleusUserException("ObjectIdentity should be passed a String greater than 3 characters in length");
            }
            int indexOfDelimiter = paramString.indexOf(STRING_DELIMITER);
            if (indexOfDelimiter < 0) {
                throw new NucleusUserException("ObjectIdentity should be passed a String with a delimiter present");
            }
            keyString = paramString.substring(indexOfDelimiter + 1);
            className = paramString.substring(0, indexOfDelimiter);
            if (className.equals("java.util.Date")) {
                this.keyAsObject = new Date(Long.parseLong(keyString));
            } else if (className.equals("java.util.Locale")) {
                this.keyAsObject = I18nUtils.getLocaleFromString(keyString);
            } else {
                if (!className.equals("java.util.Currency")) throw new NucleusUserException("Class for ObjectIdentity " + className + " is not supported as a PK type");
                this.keyAsObject = Currency.getInstance(keyString);
            }
        } else {
            this.keyAsObject = param;
        }
        this.hashCode = this.hashClassName() ^ this.keyAsObject.hashCode();
    }

    public ObjectIdentity() {
    }

    public Object getKey() {
        return this.keyAsObject;
    }

    public String toString() {
        return this.keyAsObject.getClass().getName() + STRING_DELIMITER + this.keyAsObject.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ObjectIdentity other = (ObjectIdentity)obj;
        return this.keyAsObject.equals(other.keyAsObject);
    }

    public int compareTo(Object o) {
        if (o instanceof ObjectIdentity) {
            ObjectIdentity other = (ObjectIdentity)o;
            return ((String)this.keyAsObject).compareTo(other.keyAsObject);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.keyAsObject);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.keyAsObject = in.readObject();
    }
}

