/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.fieldmanager;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected Table table;
    protected Map<String, Object> columnValueByName = new HashMap<String, Object>();

    public StoreFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, boolean insert, Table table) {
        super(ec, cmd, insert);
        this.table = table;
    }

    public StoreFieldManager(DNStateManager sm, boolean insert, Table table) {
        super(sm, insert);
        this.table = table;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public Map<String, Object> getColumnValueByName() {
        return this.columnValueByName;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), "" + value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column column = this.getColumnMapping(fieldNumber).getColumn(0);
        if (column.getJdbcType() == JdbcType.DECIMAL) {
            this.columnValueByName.put(column.getName(), BigDecimal.valueOf(value));
        } else if (column.getJdbcType() == JdbcType.DOUBLE) {
            this.columnValueByName.put(column.getName(), value);
        } else {
            this.columnValueByName.put(column.getName(), Float.valueOf(value));
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column column = this.getColumnMapping(fieldNumber).getColumn(0);
        if (column.getJdbcType() == JdbcType.DECIMAL) {
            this.columnValueByName.put(column.getName(), BigDecimal.valueOf(value));
        } else {
            this.columnValueByName.put(column.getName(), value);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        ClassLoaderResolver clr;
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr = this.ec.getClassLoaderResolver());
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                if (!(mmd.isCascadePersist() || this.ec.getApiAdapter().isDetached(value) || this.ec.getApiAdapter().isPersistent(value))) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                    }
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
                }
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                if (value == null) {
                    StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.insert, embMmds, this.table);
                    for (int i = 0; i < embMmdPosns.length; ++i) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                        if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                            ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                            colEmbMmds.add(embMmd);
                            MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                            for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                                this.columnValueByName.put(mapping.getColumn(j).getName(), null);
                            }
                            continue;
                        }
                        if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                        storeEmbFM.storeObjectField(embMmdPosns[i], null);
                    }
                    Map<String, Object> embColValuesByName = storeEmbFM.getColumnValueByName();
                    this.columnValueByName.putAll(embColValuesByName);
                    return;
                }
                DNStateManager embSM = this.ec.findStateManagerForEmbedded(value, this.sm, mmd, null);
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(embSM, this.insert, embMmds, this.table);
                embSM.provideFields(embMmdPosns, (FieldManager)storeEmbFM);
                Map<String, Object> embColValuesByName = storeEmbFM.getColumnValueByName();
                this.columnValueByName.putAll(embColValuesByName);
                return;
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                NucleusLogger.PERSISTENCE.warn((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded), storing as null"));
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), null);
                return;
            }
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }

    protected void storeNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr, Object value) {
        Collection coll;
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (value instanceof Optional) {
            Optional opt;
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            value = (opt = (Optional)value).isPresent() ? opt.get() : null;
        }
        if (value == null) {
            for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                this.columnValueByName.put(mapping.getColumn(i).getName(), null);
            }
            return;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (!(mmd.isCascadePersist() || this.ec.getApiAdapter().isDetached(value) || this.ec.getApiAdapter().isPersistent(value))) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                }
                throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
            }
            if (mmd.isSerialized() && value instanceof Serializable) {
                DNStateManager pcSM = this.ec.findStateManager(value);
                if (pcSM == null || this.ec.getApiAdapter().getExecutionContext(value) == null) {
                    pcSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, value, false, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_PC);
                }
                if (pcSM != null) {
                    pcSM.setStoringPC();
                }
                TypeConverter serialConv = value instanceof byte[] ? this.ec.getTypeManager().getTypeConverterForType(byte[].class, ByteBuffer.class) : this.ec.getTypeManager().getTypeConverterForType(Serializable.class, ByteBuffer.class);
                Object serValue = serialConv.toDatastoreType(value);
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), serValue);
                if (pcSM != null) {
                    pcSM.unsetStoringPC();
                }
                return;
            }
            Object valuePC = this.ec.persistObjectInternal(value, null, PersistableObjectType.PC, this.sm, fieldNumber);
            Object valueID = this.ec.getApiAdapter().getIdForObject(valuePC);
            this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), IdentityUtils.getPersistableIdentityForId((Object)valueID));
            return;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (mmd.hasCollection()) {
                if (mmd.getCollection().isSerializedElement()) {
                    throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName() + ". Serialise the whole field");
                }
                coll = (Collection)value;
                if (!mmd.isCascadePersist()) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                    }
                    for (Object element : coll) {
                        if (this.ec.getApiAdapter().isDetached(element) || this.ec.getApiAdapter().isPersistent(element)) continue;
                        throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), element);
                    }
                }
                AbstractCollection cassColl = value instanceof List || value instanceof Queue ? new ArrayList() : new HashSet();
                for (Object element : coll) {
                    if (element != null) {
                        Object elementPC = this.ec.persistObjectInternal(element, null, PersistableObjectType.PC, this.sm, fieldNumber);
                        Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                        cassColl.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                        continue;
                    }
                    cassColl.add("NULL");
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), cassColl);
                SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
            if (mmd.hasMap()) {
                if (mmd.getMap().isSerializedKey() || mmd.getMap().isSerializedValue()) {
                    throw new NucleusUserException("Don't currently support serialised map keys/values at " + mmd.getFullFieldName() + ". Serialise the whole field");
                }
                HashMap idMap = new HashMap();
                Map map = (Map)value;
                Iterator entryIter = map.entrySet().iterator();
                String keyCassType = null;
                if (!mmd.getMap().keyIsPersistent()) {
                    Class keyCls = clr.classForName(mmd.getMap().getKeyType());
                    keyCassType = CassandraUtils.getCassandraTypeForNonPersistableType(keyCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_MAP_KEY, clr);
                }
                String valCassType = null;
                if (!mmd.getMap().valueIsPersistent()) {
                    Class valCls = clr.classForName(mmd.getMap().getValueType());
                    valCassType = CassandraUtils.getCassandraTypeForNonPersistableType(valCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_MAP_VALUE, clr);
                }
                while (entryIter.hasNext()) {
                    Map.Entry entry = entryIter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (mmd.getMap().keyIsPersistent()) {
                        Object keyPC = this.ec.persistObjectInternal(key, null, PersistableObjectType.PC, this.sm, fieldNumber);
                        Object keyID = this.ec.getApiAdapter().getIdForObject(keyPC);
                        key = IdentityUtils.getPersistableIdentityForId((Object)keyID);
                    } else {
                        key = CassandraUtils.getDatastoreValueForNonPersistableValue(key, keyCassType, false, this.ec.getTypeManager(), mmd, FieldRole.ROLE_MAP_KEY);
                    }
                    if (mmd.getMap().valueIsPersistent()) {
                        if (val != null) {
                            Object valPC = this.ec.persistObjectInternal(val, null, PersistableObjectType.PC, this.sm, fieldNumber);
                            Object valID = this.ec.getApiAdapter().getIdForObject(valPC);
                            val = IdentityUtils.getPersistableIdentityForId((Object)valID);
                        } else {
                            val = "NULL";
                        }
                    } else {
                        val = CassandraUtils.getDatastoreValueForNonPersistableValue(val, valCassType, false, this.ec.getTypeManager(), mmd, FieldRole.ROLE_MAP_VALUE);
                    }
                    idMap.put(key, val);
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), idMap);
                SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
            if (mmd.hasArray()) {
                if (mmd.getArray().isSerializedElement()) {
                    throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName() + ". Serialise the whole field");
                }
                ArrayList<String> cassColl = new ArrayList<String>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    if (element != null) {
                        Object elementPC = this.ec.persistObjectInternal(element, null, PersistableObjectType.PC, this.sm, fieldNumber);
                        Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                        cassColl.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                        continue;
                    }
                    cassColl.add("NULL");
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), cassColl);
                return;
            }
        } else {
            Object datastoreValue;
            String cassandraType;
            if (mapping.getTypeConverter() != null) {
                Object datastoreValue2 = mapping.getTypeConverter().toDatastoreType(value);
                if (mapping.getNumberOfColumns() > 1) {
                    for (int i = 0; i < Array.getLength(datastoreValue2); ++i) {
                        this.columnValueByName.put(mapping.getColumn(i).getName(), Array.get(datastoreValue2, i));
                    }
                } else {
                    this.columnValueByName.put(mapping.getColumn(0).getName(), datastoreValue2);
                }
                return;
            }
            if (Optional.class.isAssignableFrom(mmd.getType())) {
                cassandraType = mapping.getColumn(0).getTypeName();
                datastoreValue = CassandraUtils.getDatastoreValueForNonPersistableValue(value, cassandraType, mmd.isSerialized(), this.ec.getTypeManager(), mmd, FieldRole.ROLE_FIELD);
                if (datastoreValue != null) {
                    this.columnValueByName.put(mapping.getColumn(0).getName(), datastoreValue);
                    SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                    return;
                }
            } else {
                if (mmd.hasCollection()) {
                    coll = (Collection)value;
                    if (coll.isEmpty()) {
                        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), null);
                        return;
                    }
                    AbstractCollection cassColl = value instanceof List || value instanceof Queue ? new ArrayList() : new HashSet();
                    TypeConverter elemConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_COLLECTION_ELEMENT);
                    Class elemCls = clr.classForName(mmd.getCollection().getElementType());
                    String elemCassType = CassandraUtils.getCassandraTypeForNonPersistableType(elemCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_COLLECTION_ELEMENT, clr);
                    Iterator collIter = coll.iterator();
                    while (collIter.hasNext()) {
                        Object element;
                        Object datastoreValue3 = element = collIter.next();
                        if (elemConv != null) {
                            datastoreValue3 = elemConv.toDatastoreType(element);
                        }
                        datastoreValue3 = CassandraUtils.getDatastoreValueForNonPersistableValue(datastoreValue3, elemCassType, false, this.ec.getTypeManager(), mmd, FieldRole.ROLE_COLLECTION_ELEMENT);
                        cassColl.add(datastoreValue3);
                    }
                    this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), cassColl);
                    SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                    return;
                }
                if (mmd.hasMap()) {
                    Map map = (Map)value;
                    if (map.isEmpty()) {
                        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), null);
                        return;
                    }
                    TypeConverter keyConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_MAP_KEY);
                    TypeConverter valConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_MAP_VALUE);
                    Iterator entryIter = map.entrySet().iterator();
                    Class keyCls = clr.classForName(mmd.getMap().getKeyType());
                    String keyCassType = CassandraUtils.getCassandraTypeForNonPersistableType(keyCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_MAP_KEY, clr);
                    Class valCls = clr.classForName(mmd.getMap().getValueType());
                    String valCassType = CassandraUtils.getCassandraTypeForNonPersistableType(valCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_MAP_VALUE, clr);
                    HashMap cassMap = new HashMap();
                    while (entryIter.hasNext()) {
                        Object val;
                        Object key;
                        Map.Entry entry = entryIter.next();
                        Object datastoreKey = key = entry.getKey();
                        if (keyConv != null) {
                            datastoreKey = keyConv.toDatastoreType(key);
                        }
                        Object datastoreVal = val = entry.getValue();
                        if (valConv != null) {
                            datastoreVal = valConv.toDatastoreType(val);
                        }
                        key = CassandraUtils.getDatastoreValueForNonPersistableValue(datastoreKey, keyCassType, false, this.ec.getTypeManager(), mmd, FieldRole.ROLE_MAP_KEY);
                        val = CassandraUtils.getDatastoreValueForNonPersistableValue(datastoreVal, valCassType, false, this.ec.getTypeManager(), mmd, FieldRole.ROLE_MAP_VALUE);
                        cassMap.put(key, val);
                    }
                    this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), cassMap);
                    SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                    return;
                }
                if (mmd.hasArray()) {
                    if (Array.getLength(value) == 0) {
                        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), null);
                        return;
                    }
                    if (mmd.isSerialized()) {
                        cassandraType = mapping.getColumn(0).getTypeName();
                        Object datastoreValue4 = CassandraUtils.getDatastoreValueForNonPersistableValue(value, cassandraType, mmd.isSerialized(), this.ec.getTypeManager(), mmd, FieldRole.ROLE_FIELD);
                        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), datastoreValue4);
                        return;
                    }
                    ArrayList<Object> cassArr = new ArrayList<Object>();
                    Class elemCls = clr.classForName(mmd.getArray().getElementType());
                    String elemCassType = CassandraUtils.getCassandraTypeForNonPersistableType(elemCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_ARRAY_ELEMENT, clr);
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        if (mmd.getArray().isSerializedElement()) {
                            throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName() + ". Serialise the whole field");
                        }
                        Object element = Array.get(value, i);
                        if (element == null) continue;
                        cassArr.add(CassandraUtils.getDatastoreValueForNonPersistableValue(element, elemCassType, false, this.ec.getTypeManager(), mmd, FieldRole.ROLE_ARRAY_ELEMENT));
                    }
                    this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), cassArr);
                    SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                    return;
                }
            }
            if ((datastoreValue = CassandraUtils.getDatastoreValueForNonPersistableValue(value, cassandraType = mapping.getColumn(0).getTypeName(), mmd.isSerialized(), this.ec.getTypeManager(), mmd, FieldRole.ROLE_FIELD)) != null) {
                this.columnValueByName.put(mapping.getColumn(0).getName(), datastoreValue);
                SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
        }
        NucleusLogger.PERSISTENCE.warn((Object)("Not generated persistable value for field " + mmd.getFullFieldName() + " so putting null"));
        this.columnValueByName.put(mapping.getColumn(0).getName(), null);
    }
}

