/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import java.util.Map;
import org.datanucleus.util.ConcurrentReferenceHashMap;

public class SessionStatementProvider {
    Map<String, PreparedStatement> preparedStatementCache = new ConcurrentReferenceHashMap(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public void close() {
        this.preparedStatementCache.clear();
    }

    public PreparedStatement prepare(String stmt, CqlSession session) {
        PreparedStatement ps = this.preparedStatementCache.get(stmt);
        if (ps == null) {
            ps = session.prepare(stmt);
            this.preparedStatementCache.put(stmt, ps);
        }
        return ps;
    }
}

