/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ConstraintMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.MultitenancyMetaData;
import org.datanucleus.metadata.SoftDeleteMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.SchemaVerifierImpl;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SchemaVerifier;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CassandraSchemaHandler
extends AbstractStoreSchemaHandler {
    public CassandraSchemaHandler(CassandraStoreManager storeMgr) {
        super((StoreManager)storeMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDatabase(String catalogName, String schemaName, Properties props, Object connection) {
        CqlSession session = (CqlSession)connection;
        ManagedConnection mconn = null;
        try {
            Boolean durable;
            if (session == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                session = (CqlSession)mconn.getConnection();
            }
            StringBuilder stmtBuilder = new StringBuilder("CREATE KEYSPACE IF NOT EXISTS ");
            stmtBuilder.append(schemaName).append(" WITH ");
            String replicationProp = props != null ? (String)props.get("replication") : "{'class': 'SimpleStrategy', 'replication_factor' : 3}";
            stmtBuilder.append("replication = ").append(replicationProp);
            if (props != null && props.containsKey("durable_writes") && !(durable = Boolean.valueOf((String)props.get("durable_writes"))).booleanValue()) {
                stmtBuilder.append(" AND durable_writes=false");
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateSchema", (Object[])new Object[]{stmtBuilder.toString()}));
            session.execute(stmtBuilder.toString());
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateSchema.Success"));
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        CqlSession session = (CqlSession)connection;
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        OutputStreamWriter ddlFileWriter = null;
        try {
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
            }
            ManagedConnection mconn = null;
            try {
                if (session == null) {
                    mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                    session = (CqlSession)mconn.getConnection();
                }
                ArrayList<String> tableStmts = new ArrayList<String>();
                ArrayList<String> constraintStmts = new ArrayList<String>();
                ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
                for (String className : classNames) {
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                    if (cmd == null) continue;
                    try {
                        this.createSchemaForClass(cmd, session, clr, tableStmts, constraintStmts);
                    }
                    catch (Exception e) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)("Could not create schema for class=" + cmd.getFullClassName() + " - see the nested exception"), (Throwable)e);
                    }
                }
                if (!tableStmts.isEmpty()) {
                    for (String stmt : tableStmts) {
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateTable", (Object[])new Object[]{stmt}));
                            session.execute(stmt);
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateTable.Success"));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmt + ";\n");
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!constraintStmts.isEmpty()) {
                    for (String stmt : constraintStmts) {
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateConstraint", (Object[])new Object[]{stmt}));
                            session.execute(stmt);
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateConstraint.Success"));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmt + ";\n");
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception e) {
                NucleusLogger.GENERAL.error((Object)"Exception in schema generation", (Throwable)e);
                throw e;
            }
            finally {
                if (mconn != null) {
                    mconn.release();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (ddlFileWriter != null) {
                try {
                    ddlFileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void createSchemaForClass(AbstractClassMetaData cmd, CqlSession session, ClassLoaderResolver clr, List<String> tableStmts, List<String> constraintStmts) {
        TableMetadata tmd;
        Optional schemaKeyspace;
        if (cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return;
        }
        if (cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) {
            return;
        }
        StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object table = null;
        table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
        String schemaName = table.getSchemaName();
        if (schemaName != null && (schemaKeyspace = session.getMetadata().getKeyspace(schemaName)).isEmpty() && this.autoCreateDatabase) {
            NucleusLogger.GENERAL.info((Object)("Creating DB since schema " + schemaName + " doesnt exist"));
            this.createDatabase(null, schemaName, null, session);
        }
        if ((tmd = CassandraSchemaHandler.getTableMetadata(session, schemaName, table.getName())) != null) {
            if (this.autoCreateColumns) {
                List columns = table.getColumns();
                for (Column column : columns) {
                    ColumnMetadata colmd = this.getColumnMetadataForColumn(tmd, column);
                    if (colmd == null) {
                        StringBuilder stmtBuilder = new StringBuilder("ALTER TABLE ");
                        if (schemaName != null) {
                            stmtBuilder.append(schemaName).append('.');
                        }
                        stmtBuilder.append(table.getName());
                        stmtBuilder.append(" ADD ");
                        stmtBuilder.append(column.getName()).append(" ").append(column.getTypeName());
                        tableStmts.add(stmtBuilder.toString());
                        continue;
                    }
                    String colTypeNameDB = this.getTypeNameForColumn(colmd);
                    if (colTypeNameDB == null || colTypeNameDB.equalsIgnoreCase(column.getTypeName())) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.TableColumnTypeIncorrect", (Object[])new Object[]{table.getName(), column.getName(), colTypeNameDB, column.getTypeName()}));
                }
            }
            if (this.autoDeleteColumns) {
                Map colmdById = tmd.getColumns();
                Collection colmds = colmdById.values();
                for (ColumnMetadata colmd : colmds) {
                    CqlIdentifier colNameId = colmd.getName();
                    String colName = colNameId.toString();
                    Column col = table.getColumnForName(colName);
                    if (col != null) continue;
                    StringBuilder stmtBuilder = new StringBuilder("ALTER TABLE ");
                    if (schemaName != null) {
                        stmtBuilder.append(schemaName).append('.');
                    }
                    stmtBuilder.append(table.getName());
                    stmtBuilder.append(" DROP ");
                    stmtBuilder.append(colName);
                    tableStmts.add(stmtBuilder.toString());
                }
            }
            if (this.isAutoCreateConstraints()) {
                SoftDeleteMetaData sdmd;
                IndexMetaData idxmd;
                MultitenancyMetaData mtmd;
                DiscriminatorMetaData dismd;
                String indexStmt;
                String indexStmt2;
                String idxName;
                Column column;
                VersionMetaData vermd;
                String indexStmt3;
                String indexStmt4;
                ColumnMetadata dbColMd;
                String idxName2;
                IndexMetaData idxmd22;
                NamingFactory namingFactory = this.storeMgr.getNamingFactory();
                for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                    List clsIdxMds = theCmd.getIndexMetaData();
                    if (clsIdxMds == null) continue;
                    int i = 0;
                    for (IndexMetaData idxmd22 : clsIdxMds) {
                        String[] colNames = idxmd22.getColumnNames();
                        if (colNames.length > 1) {
                            NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexForClassWithMultipleColumns", (Object[])new Object[]{theCmd.getFullClassName()}));
                            continue;
                        }
                        idxName2 = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd22, i++);
                        dbColMd = this.getColumnMetadataForColumnName(tmd, colNames[0]);
                        if (dbColMd == null) {
                            indexStmt4 = this.createIndexCQL(idxName2, schemaName, table.getName(), colNames[0], idxmd22);
                            constraintStmts.add(indexStmt4);
                            continue;
                        }
                        IndexMetadata dbIdxMdForCol = this.getIndexMetadataForColumn(tmd, colNames[0]);
                        if (dbIdxMdForCol == null) {
                            indexStmt3 = this.createIndexCQL(idxName2, schemaName, table.getName(), colNames[0], idxmd22);
                            constraintStmts.add(indexStmt3);
                            continue;
                        }
                        if (idxName2.equals(dbIdxMdForCol.getName().toString())) continue;
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName2, dbIdxMdForCol.getName()}));
                    }
                }
                Set mappings = table.getMemberColumnMappings();
                for (MemberColumnMapping mapping : mappings) {
                    Column[] cols;
                    idxmd22 = mapping.getMemberMetaData().getIndexMetaData();
                    if (idxmd22 == null || (cols = mapping.getColumns()) == null) continue;
                    if (cols.length > 1) {
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexForMemberWithMultipleColumns", (Object[])new Object[]{mapping.getMemberMetaData().getFullFieldName()}));
                        continue;
                    }
                    if (cols.length != 1) continue;
                    Column column2 = cols[0];
                    dbColMd = this.getColumnMetadataForColumn(tmd, column2);
                    String idxName3 = namingFactory.getConstraintName(cmd.getName(), mapping.getMemberMetaData(), (ConstraintMetaData)idxmd22);
                    if (dbColMd == null) {
                        indexStmt3 = this.createIndexCQL(idxName3, schemaName, table.getName(), column2.getName(), idxmd22);
                        constraintStmts.add(indexStmt3);
                        continue;
                    }
                    IndexMetadata dbIdxMd = this.getIndexMetadataForColumn(tmd, column2.getName());
                    if (dbIdxMd == null) {
                        String indexStmt5 = this.createIndexCQL(idxName3, schemaName, table.getName(), column2.getName(), idxmd22);
                        constraintStmts.add(indexStmt5);
                        continue;
                    }
                    if (idxName3.equalsIgnoreCase(dbIdxMd.getName().toString())) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName3, dbIdxMd.getName()}));
                }
                if (cmd.isVersioned() && cmd.getVersionMetaDataForClass() != null && cmd.getVersionMetaDataForClass().getMemberName() == null && (vermd = cmd.getVersionMetaDataForClass()).getIndexMetaData() != null) {
                    column = table.getSurrogateColumn(SurrogateColumnType.VERSION);
                    ColumnMetadata dbVerColMd = this.getColumnMetadataForColumn(tmd, column);
                    idxName = namingFactory.getConstraintName(cmd, (ConstraintMetaData)vermd.getIndexMetaData(), ColumnType.VERSION_COLUMN);
                    if (dbVerColMd == null) {
                        indexStmt2 = this.createIndexCQL(idxName, schemaName, table.getName(), column.getName(), vermd.getIndexMetaData());
                        constraintStmts.add(indexStmt2);
                    } else {
                        IndexMetadata dbVerIdxMd = this.getIndexMetadataForColumn(tmd, column.getName());
                        if (dbVerIdxMd == null) {
                            indexStmt = this.createIndexCQL(idxName, schemaName, table.getName(), column.getName(), vermd.getIndexMetaData());
                            constraintStmts.add(indexStmt);
                        } else if (!idxName.equals(dbVerIdxMd.getName().toString())) {
                            NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName, dbVerIdxMd.getName()}));
                        }
                    }
                }
                if (cmd.hasDiscriminatorStrategy() && (dismd = cmd.getDiscriminatorMetaData()).getIndexMetaData() != null) {
                    column = table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR);
                    ColumnMetadata dbDiscColMd = this.getColumnMetadataForColumn(tmd, column);
                    idxName = namingFactory.getConstraintName(cmd, (ConstraintMetaData)dismd.getIndexMetaData(), ColumnType.DISCRIMINATOR_COLUMN);
                    if (dbDiscColMd == null) {
                        indexStmt2 = this.createIndexCQL(idxName, schemaName, table.getName(), column.getName(), dismd.getIndexMetaData());
                        constraintStmts.add(indexStmt2);
                    } else {
                        IndexMetadata dbDiscIdxMd = this.getIndexMetadataForColumn(tmd, column.getName());
                        if (dbDiscIdxMd == null) {
                            indexStmt = this.createIndexCQL(idxName, schemaName, table.getName(), column.getName(), dismd.getIndexMetaData());
                            constraintStmts.add(indexStmt);
                        } else if (!idxName.equals(dbDiscIdxMd.getName().toString())) {
                            NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName, dbDiscIdxMd.getName()}));
                        }
                    }
                }
                if ((mtmd = cmd.getMultitenancyMetaData()) != null && (idxmd = mtmd.getIndexMetaData()) != null) {
                    Column column3 = table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY);
                    idxName = idxmd.getName() != null ? idxmd.getName() : namingFactory.getConstraintName(cmd, null, ColumnType.MULTITENANCY_COLUMN);
                    ColumnMetadata dbMultiColMd = this.getColumnMetadataForColumn(tmd, column3);
                    if (dbMultiColMd == null) {
                        indexStmt = this.createIndexCQL(idxName, schemaName, table.getName(), column3.getName(), null);
                        constraintStmts.add(indexStmt);
                    } else {
                        IndexMetadata dbMultiIdxMd = this.getIndexMetadataForColumn(tmd, column3.getName());
                        if (dbMultiIdxMd == null) {
                            indexStmt4 = this.createIndexCQL(idxName, schemaName, table.getName(), column3.getName(), null);
                            constraintStmts.add(indexStmt4);
                        } else if (!idxName.equals(dbMultiIdxMd.getName().toString())) {
                            NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName, dbMultiIdxMd.getName()}));
                        }
                    }
                }
                if ((sdmd = cmd.getSoftDeleteMetaData()) != null && (idxmd22 = sdmd.getIndexMetaData()) != null) {
                    Column column4 = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE);
                    idxName2 = idxmd22.getName() != null ? idxmd22.getName() : namingFactory.getConstraintName(cmd, null, ColumnType.SOFTDELETE_COLUMN);
                    ColumnMetadata dbMultiColMd = this.getColumnMetadataForColumn(tmd, column4);
                    if (dbMultiColMd == null) {
                        indexStmt4 = this.createIndexCQL(idxName2, schemaName, table.getName(), column4.getName(), null);
                        constraintStmts.add(indexStmt4);
                    } else {
                        IndexMetadata dbMultiIdxMd = this.getIndexMetadataForColumn(tmd, column4.getName());
                        if (dbMultiIdxMd == null) {
                            indexStmt3 = this.createIndexCQL(idxName2, schemaName, table.getName(), column4.getName(), null);
                            constraintStmts.add(indexStmt3);
                        } else if (!idxName2.equals(dbMultiIdxMd.getName().toString())) {
                            NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName2, dbMultiIdxMd.getName()}));
                        }
                    }
                }
            }
        } else {
            if (this.isAutoCreateTables()) {
                StringBuilder stmtBuilder = new StringBuilder("CREATE TABLE ");
                if (schemaName != null) {
                    stmtBuilder.append(schemaName).append('.');
                }
                stmtBuilder.append(table.getName());
                stmtBuilder.append(" (");
                ArrayList<String> pkColNames = new ArrayList<String>();
                for (Column column : table.getColumns()) {
                    stmtBuilder.append(column.getName()).append(' ').append(column.getTypeName()).append(',');
                    if (!column.isPrimaryKey()) continue;
                    pkColNames.add(column.getName());
                }
                stmtBuilder.append(" PRIMARY KEY (");
                Iterator pkColNameIter = pkColNames.iterator();
                while (pkColNameIter.hasNext()) {
                    stmtBuilder.append((String)pkColNameIter.next());
                    if (!pkColNameIter.hasNext()) continue;
                    stmtBuilder.append(',');
                }
                stmtBuilder.append(")");
                stmtBuilder.append(")");
                String[] options = cmd.getValuesForExtension("cassandra.createTable.options");
                if (options != null && options.length > 0) {
                    stmtBuilder.append(" WITH ");
                    for (int i = 0; i < options.length; ++i) {
                        if (i > 0) {
                            stmtBuilder.append(" AND ");
                        }
                        stmtBuilder.append(options[i]);
                    }
                }
                tableStmts.add(stmtBuilder.toString());
            }
            if (this.isAutoCreateConstraints()) {
                Column multitenancyCol;
                DiscriminatorMetaData dismd;
                String indexStmt;
                String idxName;
                VersionMetaData vermd;
                String indexStmt6;
                String idxName4;
                NamingFactory namingFactory = this.storeMgr.getNamingFactory();
                for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                    List clsIdxMds = theCmd.getIndexMetaData();
                    if (clsIdxMds == null) continue;
                    int i = 0;
                    for (IndexMetaData idxmd : clsIdxMds) {
                        String[] colNames = idxmd.getColumnNames();
                        if (colNames.length > 1) {
                            NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexForClassWithMultipleColumns", (Object[])new Object[]{theCmd.getFullClassName()}));
                            continue;
                        }
                        idxName4 = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd, i++);
                        indexStmt6 = this.createIndexCQL(idxName4, schemaName, table.getName(), colNames[0], idxmd);
                        constraintStmts.add(indexStmt6);
                    }
                }
                Set mappings = table.getMemberColumnMappings();
                Iterator i = mappings.iterator();
                while (i.hasNext()) {
                    MemberColumnMapping mapping = (MemberColumnMapping)i.next();
                    AbstractMemberMetaData mmd = mapping.getMemberMetaData();
                    IndexMetaData idxmd = mmd.getIndexMetaData();
                    if (idxmd == null || mapping.getNumberOfColumns() != 1) continue;
                    idxName4 = namingFactory.getConstraintName(cmd.getName(), mmd, (ConstraintMetaData)idxmd);
                    indexStmt6 = this.createIndexCQL(idxName4, schemaName, table.getName(), mapping.getColumn(0).getName(), idxmd);
                    constraintStmts.add(indexStmt6);
                }
                if (cmd.isVersioned() && cmd.getVersionMetaDataForClass() != null && cmd.getVersionMetaDataForClass().getMemberName() == null && (vermd = cmd.getVersionMetaDataForClass()).getIndexMetaData() != null) {
                    Column column = table.getSurrogateColumn(SurrogateColumnType.VERSION);
                    idxName = namingFactory.getConstraintName(cmd, (ConstraintMetaData)vermd.getIndexMetaData(), ColumnType.VERSION_COLUMN);
                    indexStmt = this.createIndexCQL(idxName, schemaName, table.getName(), column.getName(), vermd.getIndexMetaData());
                    constraintStmts.add(indexStmt);
                }
                if (cmd.hasDiscriminatorStrategy() && (dismd = cmd.getDiscriminatorMetaData()).getIndexMetaData() != null) {
                    Column column = table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR);
                    idxName = namingFactory.getConstraintName(cmd, (ConstraintMetaData)dismd.getIndexMetaData(), ColumnType.DISCRIMINATOR_COLUMN);
                    indexStmt = this.createIndexCQL(idxName, schemaName, table.getName(), column.getName(), dismd.getIndexMetaData());
                    constraintStmts.add(indexStmt);
                }
                if ((multitenancyCol = table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY)) != null) {
                    String idxName5 = namingFactory.getConstraintName(cmd, null, ColumnType.MULTITENANCY_COLUMN);
                    String indexStmt7 = this.createIndexCQL(idxName5, schemaName, table.getName(), multitenancyCol.getName(), null);
                    constraintStmts.add(indexStmt7);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatabase(String catalogName, String schemaName, Properties props, Object connection) {
        CqlSession session = (CqlSession)connection;
        ManagedConnection mconn = null;
        try {
            if (session == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                session = (CqlSession)mconn.getConnection();
            }
            StringBuilder stmtBuilder = new StringBuilder("DROP KEYSPACE IF EXISTS ");
            stmtBuilder.append(schemaName);
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropSchema", (Object[])new Object[]{stmtBuilder.toString()}));
            session.execute(stmtBuilder.toString());
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropSchema", (Object[])new Object[]{schemaName}));
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        CqlSession session = (CqlSession)connection;
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        OutputStreamWriter ddlFileWriter = null;
        try {
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
            }
            ManagedConnection mconn = null;
            try {
                if (session == null) {
                    mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                    session = (CqlSession)mconn.getConnection();
                }
                ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
                for (String className : classNames) {
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                    if (cmd == null || cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
                    StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                    Object table = null;
                    table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
                    String schemaName = table.getSchemaName();
                    String tableName = table.getName();
                    NamingFactory namingFactory = this.storeMgr.getNamingFactory();
                    TableMetadata tmd = CassandraSchemaHandler.getTableMetadata(session, schemaName, tableName);
                    if (tmd != null) {
                        String idxName;
                        StringBuilder stmtBuilder;
                        int i;
                        for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                            List clsIdxMds = theCmd.getIndexMetaData();
                            if (clsIdxMds == null) continue;
                            i = 0;
                            for (IndexMetaData idxmd : clsIdxMds) {
                                stmtBuilder = new StringBuilder("DROP INDEX ");
                                idxName = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd, i++);
                                if (ddlFileWriter == null) {
                                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropConstraint", (Object[])new Object[]{stmtBuilder.toString()}));
                                    session.execute(stmtBuilder.toString());
                                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropConstraint.Success", (Object[])new Object[]{idxName}));
                                    continue;
                                }
                                try {
                                    ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        int[] memberPositions = cmd.getAllMemberPositions();
                        for (i = 0; i < memberPositions.length; ++i) {
                            IndexMetaData idxmd;
                            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                            idxmd = mmd.getIndexMetaData();
                            if (idxmd == null) continue;
                            stmtBuilder = new StringBuilder("DROP INDEX ");
                            idxName = namingFactory.getConstraintName(null, mmd, (ConstraintMetaData)idxmd);
                            if (ddlFileWriter == null) {
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropConstraint", (Object[])new Object[]{stmtBuilder.toString()}));
                                session.execute(stmtBuilder.toString());
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropConstraint.Success", (Object[])new Object[]{idxName}));
                                continue;
                            }
                            try {
                                ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                                continue;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        StringBuilder stmtBuilder2 = new StringBuilder("DROP TABLE ");
                        if (schemaName != null) {
                            stmtBuilder2.append(schemaName).append('.');
                        }
                        stmtBuilder2.append(tableName);
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropTable", (Object[])new Object[]{stmtBuilder2.toString()}));
                            session.execute(stmtBuilder2.toString());
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropTable.Success", (Object[])new Object[]{tableName}));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmtBuilder2.toString() + ";\n");
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropTable.DoesntExist", (Object[])new Object[]{tableName}));
                }
            }
            finally {
                if (mconn != null) {
                    mconn.release();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (ddlFileWriter != null) {
                try {
                    ddlFileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        CqlSession session = (CqlSession)connection;
        boolean success = true;
        ManagedConnection mconn = null;
        try {
            if (session == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                session = (CqlSession)mconn.getConnection();
            }
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            for (String className : classNames) {
                String idxName;
                IndexMetadata dbIdxMd;
                ColumnMetadata dbColMd;
                String tableName;
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
                StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                Object table = null;
                table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
                String schemaName = table.getSchemaName();
                TableMetadata tmd = CassandraSchemaHandler.getTableMetadata(session, schemaName, tableName = table.getName());
                if (tmd == null) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.TableDoesntExist", (Object[])new Object[]{cmd.getFullClassName(), tableName, schemaName}));
                    success = false;
                    continue;
                }
                HashSet colsFound = new HashSet();
                List columns = table.getColumns();
                for (Column column : columns) {
                    ColumnMetadata colmd = this.getColumnMetadataForColumn(tmd, column);
                    if (colmd == null) {
                        if (column.getMemberColumnMapping() != null) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.ColumnForTableDoesntExist", (Object[])new Object[]{tableName, column.getName(), column.getMemberColumnMapping().getMemberMetaData().getFullFieldName()}));
                        } else {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.ColumnForTableInvalidType", (Object[])new Object[]{tableName, column.getName(), column.getColumnType()}));
                        }
                        success = false;
                        continue;
                    }
                    String datastoreType = this.getTypeNameForColumn(colmd);
                    if (column.getTypeName().equals(datastoreType)) continue;
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.ColumnTypeIncorrect", (Object[])new Object[]{tableName, column.getName(), datastoreType, column.getTypeName()}));
                }
                int numColsDB = tmd.getColumns().size();
                if (success && numColsDB != colsFound.size()) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.ColumnCountIncorrect", (Object[])new Object[]{tableName, colsFound.size(), numColsDB}));
                    success = false;
                }
                for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                    List clsIdxMds = theCmd.getIndexMetaData();
                    if (clsIdxMds == null) continue;
                    int i = 0;
                    for (IndexMetaData idxmd : clsIdxMds) {
                        String[] colNames = idxmd.getColumnNames();
                        if (colNames.length != 1) continue;
                        dbColMd = this.getColumnMetadataForColumnName(tmd, colNames[0].toLowerCase());
                        dbIdxMd = this.getIndexMetadataForColumn(tmd, colNames[0].toLowerCase());
                        idxName = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd, i++);
                        if (dbColMd == null || dbIdxMd == null) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.TableIndexMissingForColumn", (Object[])new Object[]{tableName, colNames[0]}));
                            continue;
                        }
                        if (idxName.equals(dbIdxMd.getName().toString())) continue;
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName, dbIdxMd.getName()}));
                    }
                }
                int[] memberPositions = cmd.getAllMemberPositions();
                for (int i = 0; i < memberPositions.length; ++i) {
                    IndexMetaData idxmd;
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                    idxmd = mmd.getIndexMetaData();
                    if (idxmd == null) continue;
                    String colName = namingFactory.getColumnName(mmd, ColumnType.COLUMN);
                    dbColMd = this.getColumnMetadataForColumnName(tmd, colName.toLowerCase());
                    dbIdxMd = this.getIndexMetadataForColumn(tmd, colName.toLowerCase());
                    idxName = namingFactory.getConstraintName(null, mmd, (ConstraintMetaData)idxmd);
                    if (dbColMd == null || dbIdxMd == null) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.TableIndexMissingForColumn", (Object[])new Object[]{tableName, colName}));
                        continue;
                    }
                    if (idxName.equals(dbIdxMd.getName().toString())) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName, dbIdxMd.getName()}));
                }
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
        if (!success) {
            throw new NucleusException("Errors were encountered during validation of Cassandra schema");
        }
    }

    protected String createIndexCQL(String indexName, String schemaName, String tableName, String columnName, IndexMetaData idxmd) {
        String using;
        StringBuilder stmtBuilder = new StringBuilder("CREATE INDEX ");
        stmtBuilder.append(indexName);
        stmtBuilder.append(" ON ");
        if (schemaName != null) {
            stmtBuilder.append(schemaName).append('.');
        }
        stmtBuilder.append(tableName);
        stmtBuilder.append(" (").append(columnName).append(")");
        if (idxmd != null && !StringUtils.isWhitespace((String)(using = idxmd.getValueForExtension("cassandra.createIndex.using")))) {
            stmtBuilder.append(" USING ").append(using);
        }
        return stmtBuilder.toString();
    }

    public static TableMetadata getTableMetadata(CqlSession session, String schemaName, String tableName) {
        KeyspaceMetadata ks = CassandraSchemaHandler.getKeyspaceMetadata(session, schemaName);
        if (ks == null) {
            return null;
        }
        Optional tabmd = ks.getTable(tableName.toLowerCase());
        return tabmd.isPresent() ? (TableMetadata)tabmd.get() : null;
    }

    public static KeyspaceMetadata getKeyspaceMetadata(CqlSession session, String schemaName) {
        if (schemaName == null) {
            throw new NucleusUserException("Schema name must be specified in order to check its existence");
        }
        Optional ksmd = session.getMetadata().getKeyspace(schemaName.toLowerCase());
        return ksmd.isPresent() ? (KeyspaceMetadata)ksmd.get() : null;
    }

    protected String getTypeNameForColumn(ColumnMetadata colmd) {
        String typeName = colmd.getType().toString();
        typeName = StringUtils.replaceAll((String)typeName, (String)"text", (String)"varchar");
        typeName = StringUtils.replaceAll((String)typeName, (String)", ", (String)",");
        return typeName;
    }

    protected ColumnMetadata getColumnMetadataForColumn(TableMetadata tmd, Column col) {
        String colName = col.getName();
        return this.getColumnMetadataForColumnName(tmd, colName);
    }

    protected ColumnMetadata getColumnMetadataForColumnName(TableMetadata tmd, String colName) {
        Optional colmd;
        if (colName.startsWith("\"")) {
            colName = colName.substring(1, colName.length() - 1);
        }
        return (colmd = tmd.getColumn(colName)).isPresent() ? (ColumnMetadata)colmd.get() : null;
    }

    protected IndexMetadata getIndexMetadataForColumn(TableMetadata tmd, String colName) {
        Map idxmdsById = tmd.getIndexes();
        Collection idxmds = idxmdsById.values();
        if (idxmds != null) {
            for (IndexMetadata idxmd : idxmds) {
                String dbIdxTarget = idxmd.getTarget();
                if (dbIdxTarget == null || !dbIdxTarget.equalsIgnoreCase(colName)) continue;
                return idxmd;
            }
        }
        return null;
    }
}

