/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.query.CassandraQueryCompilation;
import org.datanucleus.store.cassandra.query.QueryToCQLMapper;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.inmemory.JDOQLInMemoryEvaluator;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    private static final long serialVersionUID = 6703756870058220301L;
    protected transient CassandraQueryCompilation datastoreCompilation;

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JDOQLQuery)null);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, JDOQLQuery q) {
        super(storeMgr, ec, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateinmemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null) {
            throw new NucleusUserException(Localiser.msg((String)"021009", (Object[])new Object[]{this.candidateClassName}));
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (CassandraQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                this.setResultDistinct(this.compilation.getResultDistinct());
                return;
            }
        }
        CassandraQueryCompilation cassandraQueryCompilation = this.datastoreCompilation = new CassandraQueryCompilation();
        synchronized (cassandraQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues);
            }
        }
        if (cacheKey != null && this.datastoreCompilation.isPrecompilable()) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnectionManager().getConnection(this.ec);
        try {
            Object resultMapper;
            boolean filterInMemory;
            CqlSession session = (CqlSession)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{"JDOQL", this.getSingleStringQuery(), null}));
            }
            boolean bl = filterInMemory = this.filter != null;
            if (this.filter == null || this.datastoreCompilation.isFilterComplete()) {
                filterInMemory = false;
            }
            boolean orderInMemory = this.ordering != null;
            boolean rangeInMemory = this.range != null;
            List<Object> candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.evaluateInMemory()) {
                if (this.filter != null) {
                    filterInMemory = true;
                }
                if (this.ordering != null) {
                    orderInMemory = true;
                }
                candidates = this.getCandidatesForQuery(session);
            } else if (filterInMemory || this.filter == null && (this.type == Query.QueryType.BULK_UPDATE || this.type == Query.QueryType.BULK_DELETE)) {
                candidates = this.getCandidatesForQuery(session);
            } else {
                candidates = new ArrayList();
                Set<String> classNamesQueryable = this.datastoreCompilation.getClassNames();
                for (String className : classNamesQueryable) {
                    String cql = this.datastoreCompilation.getCQLForClass(className);
                    AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(className, this.clr);
                    CassandraUtils.logCqlStatement(cql, null, NucleusLogger.DATASTORE_NATIVE);
                    ResultSet rs = session.execute(cql);
                    for (Row row : rs) {
                        if (this.type == Query.QueryType.BULK_UPDATE) continue;
                        candidates.add(CassandraUtils.getPojoForRowForCandidate(row, cmd, this.ec, this.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers(), this.getIgnoreCache()));
                    }
                }
            }
            Collection results = candidates;
            if (filterInMemory || this.result != null || this.resultClass != null || rangeInMemory || orderInMemory) {
                if (candidates instanceof QueryResult) {
                    ((QueryResult)candidates).disconnect();
                }
                resultMapper = new JDOQLInMemoryEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
                results = resultMapper.execute(filterInMemory, orderInMemory, this.result != null, this.resultClass != null, rangeInMemory);
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{"JDOQL", "" + (System.currentTimeMillis() - startTime)}));
            }
            if (this.type == Query.QueryType.BULK_DELETE) {
                this.ec.deleteObjects(results.toArray());
                resultMapper = Long.valueOf(results.size());
                return resultMapper;
            }
            if (this.type == Query.QueryType.BULK_UPDATE) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            if (this.type == Query.QueryType.BULK_INSERT) {
                throw new NucleusException("Bulk Insert is not yet supported");
            }
            if (results instanceof QueryResult) {
                final QueryResult qr1 = (QueryResult)results;
                final ManagedConnection mconn1 = mconn;
                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                        qr1.disconnect();
                    }

                    public void managedConnectionPreClose() {
                        if (!JDOQLQuery.this.ec.getTransaction().isActive()) {
                            qr1.disconnect();
                        }
                    }

                    public void managedConnectionPostClose() {
                    }

                    public void resourcePostClose() {
                        mconn1.removeListener((ManagedConnectionResourceListener)this);
                    }
                };
                mconn.addListener(listener);
                if (qr1 instanceof AbstractQueryResult) {
                    ((AbstractQueryResult)qr1).addConnectionListener(listener);
                }
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            mconn.release();
        }
    }

    protected List getCandidatesForQuery(CqlSession session) {
        ArrayList<Object> candidateObjs = new ArrayList<Object>();
        CassandraStoreManager storeMgr = (CassandraStoreManager)this.storeMgr;
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)this.getCandidateClass(), (boolean)this.isSubclasses(), (ExecutionContext)this.ec);
        for (AbstractClassMetaData cmd : cmds) {
            Column softDeleteCol;
            String multitenancyValue;
            Table table;
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
            StoreData sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                storeMgr.manageClasses(this.ec.getClassLoaderResolver(), cmd.getFullClassName());
                sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            if ((table = sd.getTable()) == null) continue;
            StringBuilder stmtBuilder = new StringBuilder("SELECT * FROM ");
            stmtBuilder.append(table.getSchemaName()).append('.').append(table.getName());
            boolean addedWhere = false;
            Column multitenancyCol = table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY);
            if (multitenancyCol != null && (multitenancyValue = this.ec.getTenantId()) != null) {
                stmtBuilder.append(addedWhere ? " AND " : " WHERE ");
                stmtBuilder.append(multitenancyCol.getName()).append("='").append(multitenancyValue).append("'");
            }
            if ((softDeleteCol = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE)) != null) {
                stmtBuilder.append(addedWhere ? " AND " : " WHERE ");
                stmtBuilder.append(softDeleteCol.getName()).append("='").append(Boolean.FALSE).append("'");
            }
            CassandraUtils.logCqlStatement(stmtBuilder.toString(), null, NucleusLogger.DATASTORE_NATIVE);
            ResultSet rs = session.execute(stmtBuilder.toString());
            for (Row row : rs) {
                candidateObjs.add(CassandraUtils.getPojoForRowForCandidate(row, cmd, this.ec, this.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers(), this.getIgnoreCache()));
            }
        }
        return candidateObjs;
    }

    private void compileQueryFull(Map parameters) {
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021083", (Object[])new Object[]{this.getLanguage(), this.toString()}));
        }
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)this.getCandidateClass(), (boolean)this.isSubclasses(), (ExecutionContext)this.ec);
        for (AbstractClassMetaData cmd : cmds) {
            Table table;
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
            StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                this.storeMgr.manageClasses(this.ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            if ((table = sd.getTable()) == null) continue;
            QueryToCQLMapper mapper = new QueryToCQLMapper(this.compilation, parameters, cmd, this.ec, (Query)this, table);
            mapper.compile();
            this.datastoreCompilation.setFilterComplete(mapper.isFilterComplete());
            this.datastoreCompilation.setResultComplete(mapper.isResultComplete());
            this.datastoreCompilation.setOrderComplete(mapper.isOrderComplete());
            this.datastoreCompilation.setUpdateComplete(mapper.isUpdateComplete());
            this.datastoreCompilation.setCQLForClass(cmd.getFullClassName(), mapper.getCQL());
            this.datastoreCompilation.setPrecompilable(mapper.isPrecompilable());
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021084", (Object[])new Object[]{this.getLanguage(), System.currentTimeMillis() - startTime}));
        }
    }
}

