/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.fieldmanager;

import com.datastax.oss.driver.api.core.cql.Row;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.cassandra.fieldmanager.FetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;

public class FetchEmbeddedFieldManager
extends FetchFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public FetchEmbeddedFieldManager(DNStateManager sm, Row row, List<AbstractMemberMetaData> mmds, Table table) {
        super(sm, row, table);
        this.mmds = mmds;
    }

    public FetchEmbeddedFieldManager(ExecutionContext ec, Row row, AbstractClassMetaData cmd, List<AbstractMemberMetaData> mmds, Table table) {
        super(ec, row, cmd, table);
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            DNStateManager[] ownerSms = this.ec.getOwnersForEmbeddedStateManager(this.sm);
            return ownerSms != null && ownerSms.length > 0 ? ownerSms[0].getObject() : null;
        }
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
                embMmds.add(mmd);
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                DNStateManager embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, embCmd, this.sm, fieldNumber);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embSM, this.row, embMmds, this.table);
                embSM.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embSM.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded)"));
            }
            return null;
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }
}

