/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.SessionStatementProvider;
import org.datanucleus.store.cassandra.fieldmanager.FetchFieldManager;
import org.datanucleus.store.cassandra.fieldmanager.StoreFieldManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CassandraPersistenceHandler
extends AbstractPersistenceHandler {
    protected Map<String, String> insertStatementByClassName;
    protected Map<String, String> deleteStatementByClassName;
    protected Map<String, String> locateStatementByClassName;
    protected Map<String, String> getVersionStatementByClassName;

    public CassandraPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        AbstractClassMetaData cmd = op.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            Session session = (Session)mconn.getConnection();
            StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                ((CassandraStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            boolean enforceUniquenessInApp = this.storeMgr.getBooleanProperty("datanucleus.cassandra.enforceUniquenessInApplication");
            if (enforceUniquenessInApp) {
                NucleusLogger.DATASTORE_PERSIST.info((Object)"User requesting to enforce uniqueness of object identity in their application, so not checking for existence");
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
                try {
                    this.locateObject(op);
                    throw new NucleusUserException(Localiser.msg((String)"Cassandra.Insert.ObjectWithIdAlreadyExists", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
                }
                catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {
                    // empty catch block
                }
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Cassandra.Insert.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            Object versionValue = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd != null) {
                versionValue = ec.getLockManager().getNextVersion(vermd, null);
                if (vermd.getFieldName() != null) {
                    op.replaceField(cmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber(), versionValue);
                }
                op.setTransactionalVersion(versionValue);
            }
            String insertStmt = null;
            StoreFieldManager storeFM = new StoreFieldManager(op, true, table);
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)storeFM);
            Map<String, Object> columnValuesByName = storeFM.getColumnValueByName();
            insertStmt = this.getInsertStatementForClass(cmd, table, columnValuesByName, ec);
            if (this.insertStatementByClassName == null) {
                this.insertStatementByClassName = new HashMap<String, String>();
            }
            this.insertStatementByClassName.put(cmd.getFullClassName(), insertStmt);
            Object discrimValue = cmd.getDiscriminatorValue();
            String multitenancyValue = null;
            if (ec.getNucleusContext().isClassMultiTenant(cmd)) {
                multitenancyValue = ec.getNucleusContext().getMultiTenancyId(ec);
            }
            int numValues = columnValuesByName.size();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                ++numValues;
            }
            if (versionValue != null && vermd != null && vermd.getFieldName() == null) {
                ++numValues;
            }
            if (discrimValue != null) {
                ++numValues;
            }
            if (multitenancyValue != null) {
                ++numValues;
            }
            Object[] stmtValues = new Object[numValues];
            int pos = 0;
            for (String colName : columnValuesByName.keySet()) {
                stmtValues[pos++] = columnValuesByName.get(colName);
            }
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                stmtValues[pos++] = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId());
            }
            if (versionValue != null && vermd != null && vermd.getFieldName() == null) {
                stmtValues[pos++] = versionValue;
            }
            if (discrimValue != null) {
                stmtValues[pos++] = discrimValue;
            }
            if (multitenancyValue != null) {
                stmtValues[pos++] = multitenancyValue;
            }
            if (cmd.hasExtension("softdelete")) {
                stmtValues[pos++] = Boolean.FALSE;
            }
            CassandraUtils.logCqlStatement(insertStmt, stmtValues, NucleusLogger.DATASTORE_NATIVE);
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
            PreparedStatement stmt = stmtProvider.prepare(insertStmt, session);
            BoundStatement boundStmt = stmt.bind(stmtValues);
            session.execute((Statement)boundStmt);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Cassandra.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception inserting object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    protected String getInsertStatementForClass(AbstractClassMetaData cmd, Table table, Map<String, Object> colValuesByName, ExecutionContext ec) {
        int i;
        VersionMetaData vermd;
        StringBuilder insertStmtBuilder = new StringBuilder("INSERT INTO ");
        String schemaName = table.getSchemaName();
        if (schemaName != null) {
            insertStmtBuilder.append(schemaName).append('.');
        }
        insertStmtBuilder.append(table.getName()).append("(");
        int numParams = 0;
        if (colValuesByName != null && !colValuesByName.isEmpty()) {
            for (String colName : colValuesByName.keySet()) {
                if (numParams > 0) {
                    insertStmtBuilder.append(',');
                }
                insertStmtBuilder.append(colName);
                ++numParams;
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName());
            ++numParams;
        }
        if ((vermd = cmd.getVersionMetaDataForClass()) != null && vermd.getFieldName() == null) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
            ++numParams;
        }
        if (cmd.hasDiscriminatorStrategy()) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName());
            ++numParams;
        }
        if (ec.getNucleusContext().isClassMultiTenant(cmd)) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY).getName());
            ++numParams;
        }
        if (cmd.hasExtension("softdelete")) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE).getName());
            ++numParams;
        }
        insertStmtBuilder.append(") ");
        String[] options = cmd.getValuesForExtension("datanucleus.cassandra.insert.using");
        if (options != null && options.length > 0) {
            insertStmtBuilder.append("USING ");
            for (i = 0; i < options.length; ++i) {
                if (i > 0) {
                    insertStmtBuilder.append(" AND ");
                }
                insertStmtBuilder.append(options[i]);
            }
            insertStmtBuilder.append(' ');
        }
        insertStmtBuilder.append("VALUES (");
        for (i = 0; i < numParams; ++i) {
            if (i > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append('?');
        }
        insertStmtBuilder.append(")");
        return insertStmtBuilder.toString();
    }

    public void insertObjects(ObjectProvider ... ops) {
        super.insertObjects(ops);
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        AbstractClassMetaData cmd = op.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            VersionMetaData vermd;
            Session session = (Session)mconn.getConnection();
            StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                ((CassandraStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            boolean fieldsToUpdate = false;
            for (int fieldNum : fieldNumbers) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNum);
                if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                fieldsToUpdate = true;
            }
            if (!fieldsToUpdate) {
                return;
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Cassandra.Update.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), fieldStr.toString()}));
            }
            if ((vermd = cmd.getVersionMetaDataForClass()) != null) {
                Object currentVersion = op.getTransactionalVersion();
                if (ec.getTransaction().getOptimistic() && cmd.isVersioned()) {
                    this.performOptimisticCheck(op, session, table, vermd, currentVersion);
                }
                Object nextVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    op.replaceField(cmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber(), nextVersion);
                }
            }
            StoreFieldManager storeFM = new StoreFieldManager(op, false, table);
            op.provideFields(fieldNumbers, (FieldManager)storeFM);
            Map<String, Object> columnValuesByName = storeFM.getColumnValueByName();
            StringBuilder stmtBuilder = new StringBuilder("UPDATE ");
            String schemaName = table.getSchemaName();
            if (schemaName != null) {
                stmtBuilder.append(schemaName).append('.');
            }
            stmtBuilder.append(table.getName());
            String[] options = cmd.getValuesForExtension("datanucleus.cassandra.update.using");
            if (options != null && options.length > 0) {
                stmtBuilder.append(" USING ");
                for (int i = 0; i < options.length; ++i) {
                    if (i > 0) {
                        stmtBuilder.append(" AND ");
                    }
                    stmtBuilder.append(options[i]);
                }
            }
            ArrayList<Object> setVals = new ArrayList<Object>();
            stmtBuilder.append(" SET ");
            if (columnValuesByName != null && !columnValuesByName.isEmpty()) {
                boolean first = true;
                for (Map.Entry<String, Object> entry : columnValuesByName.entrySet()) {
                    if (!first) {
                        stmtBuilder.append(',');
                    }
                    stmtBuilder.append(entry.getKey()).append("=?");
                    first = false;
                    setVals.add(entry.getValue());
                }
            }
            if (vermd != null) {
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                        break;
                    }
                    if (!updatingVerField) {
                        stmtBuilder.append(',').append(table.getMemberColumnMappingForMember(verMmd).getColumn(0).getName()).append("=?");
                        setVals.add(op.getTransactionalVersion());
                    }
                } else {
                    stmtBuilder.append(",").append(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName()).append("=?");
                    Object verVal = op.getTransactionalVersion();
                    setVals.add(verVal);
                }
            }
            stmtBuilder.append(" WHERE ");
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNums = cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNums.length; ++i) {
                    if (i > 0) {
                        stmtBuilder.append(" AND ");
                    }
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                    Column pkCol = table.getMemberColumnMappingForMember(pkMmd).getColumn(0);
                    stmtBuilder.append(pkCol.getName());
                    stmtBuilder.append("=?");
                    RelationType relType = pkMmd.getRelationType(ec.getClassLoaderResolver());
                    if (RelationType.isRelationSingleValued((RelationType)relType)) {
                        Object pc = op.provideField(pkFieldNums[i]);
                        setVals.add(IdentityUtils.getPersistableIdentityForId((Object)ec.getApiAdapter().getIdForObject(pc)));
                        continue;
                    }
                    String cassandraType = pkCol.getTypeName();
                    setVals.add(CassandraUtils.getDatastoreValueForNonPersistableValue(op.provideField(pkFieldNums[i]), cassandraType, false, ec.getTypeManager(), pkMmd, FieldRole.ROLE_FIELD));
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                stmtBuilder.append(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName());
                stmtBuilder.append("=?");
                Object oidVal = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId());
                setVals.add(CassandraUtils.getDatastoreValueForNonPersistableValue(oidVal, table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getTypeName(), false, ec.getTypeManager(), null, FieldRole.ROLE_FIELD));
            }
            CassandraUtils.logCqlStatement(stmtBuilder.toString(), setVals.toArray(), NucleusLogger.DATASTORE_NATIVE);
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
            PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
            session.execute((Statement)stmt.bind(setVals.toArray()));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Cassandra.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception updating object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            StoreData sd;
            Session session = (Session)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Cassandra.Delete.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if ((sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName())) == null) {
                ((CassandraStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            if (cmd.isVersioned() && ec.getTransaction().getOptimistic()) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                Object currentVersion = op.getTransactionalVersion();
                this.performOptimisticCheck(op, session, table, vermd, currentVersion);
            }
            op.loadUnloadedFields();
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op, true));
            String deleteStmt = null;
            if (this.deleteStatementByClassName != null) {
                deleteStmt = this.deleteStatementByClassName.get(cmd.getFullClassName());
            }
            if (deleteStmt == null) {
                String[] options;
                StringBuilder stmtBuilder = new StringBuilder("DELETE FROM ");
                String schemaName = table.getSchemaName();
                if (schemaName != null) {
                    stmtBuilder.append(schemaName).append('.');
                }
                if ((options = cmd.getValuesForExtension("datanucleus.cassandra.delete.using")) != null && options.length > 0) {
                    stmtBuilder.append(" USING ");
                    for (int i = 0; i < options.length; ++i) {
                        if (i > 0) {
                            stmtBuilder.append(" AND ");
                        }
                        stmtBuilder.append(options[i]);
                    }
                }
                stmtBuilder.append(table.getName()).append(" WHERE ");
                List<Column> pkCols = this.getPrimaryKeyColumns(cmd, table, ec.getClassLoaderResolver());
                int pkColNo = 0;
                for (Column pkCol : pkCols) {
                    if (pkColNo > 0) {
                        stmtBuilder.append(" AND ");
                    }
                    stmtBuilder.append(pkCol.getName());
                    stmtBuilder.append("=?");
                    ++pkColNo;
                }
                deleteStmt = stmtBuilder.toString();
                if (this.deleteStatementByClassName == null) {
                    this.deleteStatementByClassName = new HashMap<String, String>();
                }
                this.deleteStatementByClassName.put(cmd.getFullClassName(), deleteStmt);
            }
            Object[] pkVals = this.getPkValuesForStatement(op, table, ec.getClassLoaderResolver());
            CassandraUtils.logCqlStatement(deleteStmt, pkVals, NucleusLogger.DATASTORE_NATIVE);
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
            PreparedStatement stmt = stmtProvider.prepare(deleteStmt, session);
            session.execute((Statement)stmt.bind(pkVals));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Cassandra.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception deleting object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(ObjectProvider ... ops) {
        super.deleteObjects(ops);
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            StoreData sd;
            Session session = (Session)mconn.getConnection();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(op.getObjectAsPrintable()).append("\" (id=");
                str.append(op.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"Cassandra.Fetch.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if ((sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName())) == null) {
                ((CassandraStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            HashSet<Integer> nonpersistableFields = null;
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            boolean first = true;
            StringBuilder stmtBuilder = new StringBuilder("SELECT ");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                    RelationType relationType = mmd.getRelationType(clr);
                    if (RelationType.isRelationSingleValued((RelationType)relationType) && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, null)) {
                        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                        embMmds.add(mmd);
                        ArrayList<String> embColNames = new ArrayList<String>();
                        this.getColumnNamesForEmbeddedMember(table, embMmds, embColNames, ec);
                        for (String embColName : embColNames) {
                            if (!first) {
                                stmtBuilder.append(',');
                            }
                            stmtBuilder.append(embColName);
                            first = false;
                        }
                        continue;
                    }
                    MemberColumnMapping mapping = table.getMemberColumnMappingForMember(mmd);
                    for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                        String colName = mapping.getColumn(j).getName();
                        if (!first) {
                            stmtBuilder.append(',');
                        }
                        stmtBuilder.append(colName);
                        first = false;
                    }
                    continue;
                }
                if (nonpersistableFields == null) {
                    nonpersistableFields = new HashSet<Integer>();
                }
                nonpersistableFields.add(fieldNumbers[i]);
            }
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd != null && op.getTransactionalVersion() == null) {
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    boolean selected = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        selected = true;
                        break;
                    }
                    if (!selected) {
                        Column col = table.getMemberColumnMappingForMember(verMmd).getColumn(0);
                        if (!first) {
                            stmtBuilder.append(',');
                        }
                        stmtBuilder.append(col.getName());
                        first = false;
                    }
                } else {
                    if (!first) {
                        stmtBuilder.append(',');
                    }
                    stmtBuilder.append(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
                    first = false;
                }
            }
            if (nonpersistableFields != null) {
                for (Integer fieldNum : nonpersistableFields) {
                    op.replaceField(fieldNum.intValue(), op.provideField(fieldNum.intValue()));
                }
            }
            if (nonpersistableFields == null || nonpersistableFields.size() != fieldNumbers.length) {
                stmtBuilder.append(" FROM ");
                String schemaName = table.getSchemaName();
                if (schemaName != null) {
                    stmtBuilder.append(schemaName).append('.');
                }
                stmtBuilder.append(table.getName()).append(" WHERE ");
                List<Column> pkCols = this.getPrimaryKeyColumns(cmd, table, clr);
                int pkColNo = 0;
                for (Column pkCol : pkCols) {
                    if (pkColNo > 0) {
                        stmtBuilder.append(" AND ");
                    }
                    stmtBuilder.append(pkCol.getName());
                    stmtBuilder.append("=?");
                    ++pkColNo;
                }
                Object[] pkVals = this.getPkValuesForStatement(op, table, clr);
                CassandraUtils.logCqlStatement(stmtBuilder.toString(), pkVals, NucleusLogger.DATASTORE_NATIVE);
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
                PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
                ResultSet rs = session.execute((Statement)stmt.bind(pkVals));
                if (rs.isExhausted()) {
                    throw new NucleusObjectNotFoundException("Could not find object with id " + IdentityUtils.getPersistableIdentityForId((Object)op.getInternalObjectId()));
                }
                Row row = rs.one();
                FetchFieldManager fetchFM = new FetchFieldManager(op, row, table);
                if (nonpersistableFields != null) {
                    int[] persistableFieldNums = new int[fieldNumbers.length - nonpersistableFields.size()];
                    int pos = 0;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (nonpersistableFields.contains(fieldNumbers[i])) continue;
                        persistableFieldNums[pos++] = fieldNumbers[i];
                    }
                    fieldNumbers = persistableFieldNums;
                }
                op.replaceFields(fieldNumbers, (FieldManager)fetchFM);
                if (vermd != null && op.getTransactionalVersion() == null) {
                    if (vermd.getFieldName() != null) {
                        Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                        op.setVersion(datastoreVersion);
                    } else {
                        Column verCol = table.getSurrogateColumn(SurrogateColumnType.VERSION);
                        Long datastoreVersion = verCol.getTypeName().equals("int") ? (long)row.getInt(verCol.getName()) : row.getLong(verCol.getName());
                        op.setVersion((Object)datastoreVersion);
                    }
                }
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"Cassandra.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
                }
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementFetchCount();
                }
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception fetching object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception fetching object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    protected void getColumnNamesForEmbeddedMember(Table table, List<AbstractMemberMetaData> mmds, List<String> colNames, ExecutionContext ec) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(mmds.get(mmds.size() - 1).getType(), clr);
        int[] embFieldNums = embCmd.getAllMemberPositions();
        for (int i = 0; i < embFieldNums.length; ++i) {
            AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embFieldNums[i]);
            RelationType relationType = embMmd.getRelationType(clr);
            if (RelationType.isRelationSingleValued((RelationType)relationType) && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, embMmd, relationType, mmds.get(mmds.size() - 1))) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
                embMmds.add(embMmd);
                this.getColumnNamesForEmbeddedMember(table, embMmds, colNames, ec);
                continue;
            }
            ArrayList<AbstractMemberMetaData> colMmds = new ArrayList<AbstractMemberMetaData>(mmds);
            colMmds.add(embMmd);
            MemberColumnMapping mapping = table.getMemberColumnMappingForEmbeddedMember(colMmds);
            if (mapping == null) {
                StringBuilder strBuilder = new StringBuilder();
                for (AbstractMemberMetaData mmd : mmds) {
                    if (strBuilder.length() > 0) {
                        strBuilder.append('.');
                    }
                    strBuilder.append(mmd.getName());
                }
                strBuilder.append('.').append(embMmd.getName());
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Attempt to find column schema in table=" + table.getName() + " for embedded member at " + strBuilder.toString() + " but not found! Schema generation must be incomplete for this table"));
                return;
            }
            for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                Column column = mapping.getColumn(j);
                if (column == null) continue;
                colNames.add(column.getName());
            }
        }
    }

    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                Session session = (Session)mconn.getConnection();
                StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                if (sd == null) {
                    ((CassandraStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
                    sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                }
                Table table = sd.getTable();
                String locateStmt = null;
                if (this.locateStatementByClassName != null) {
                    locateStmt = this.locateStatementByClassName.get(cmd.getFullClassName());
                }
                if (locateStmt == null) {
                    StringBuilder stmtBuilder = new StringBuilder("SELECT ");
                    List<Column> pkCols = this.getPrimaryKeyColumns(cmd, table, ec.getClassLoaderResolver());
                    int pkColNo = 0;
                    for (Column pkCol : pkCols) {
                        if (pkColNo > 0) {
                            stmtBuilder.append(",");
                        }
                        stmtBuilder.append(pkCol.getName());
                        ++pkColNo;
                    }
                    stmtBuilder.append(" FROM ");
                    String schemaName = table.getSchemaName();
                    if (schemaName != null) {
                        stmtBuilder.append(schemaName).append('.');
                    }
                    stmtBuilder.append(table.getName()).append(" WHERE ");
                    pkColNo = 0;
                    for (Column pkCol : pkCols) {
                        if (pkColNo > 0) {
                            stmtBuilder.append(" AND ");
                        }
                        stmtBuilder.append(pkCol.getName());
                        stmtBuilder.append("=?");
                        ++pkColNo;
                    }
                    locateStmt = stmtBuilder.toString();
                    if (this.locateStatementByClassName == null) {
                        this.locateStatementByClassName = new HashMap<String, String>();
                    }
                    this.locateStatementByClassName.put(cmd.getFullClassName(), locateStmt);
                }
                Object[] pkVals = this.getPkValuesForStatement(op, table, ec.getClassLoaderResolver());
                CassandraUtils.logCqlStatement(locateStmt, pkVals, NucleusLogger.DATASTORE_NATIVE);
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
                PreparedStatement stmt = stmtProvider.prepare(locateStmt, session);
                ResultSet rs = session.execute((Statement)stmt.bind(pkVals));
                if (rs.isExhausted()) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            catch (DriverException e) {
                NucleusLogger.PERSISTENCE.error((Object)("Exception locating object " + op), (Throwable)e);
                throw new NucleusDataStoreException("Exception locating object for " + op, (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    public void locateObjects(ObjectProvider[] ops) {
        super.locateObjects(ops);
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    protected String getVersionStatement(AbstractClassMetaData cmd, Table table, ClassLoaderResolver clr) {
        String verStmt = null;
        if (this.getVersionStatementByClassName != null) {
            verStmt = this.getVersionStatementByClassName.get(cmd.getFullClassName());
        }
        if (verStmt == null) {
            StringBuilder stmtBuilder = new StringBuilder("SELECT ");
            Column col = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() == null) {
                col = table.getSurrogateColumn(SurrogateColumnType.VERSION);
            } else {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                col = table.getMemberColumnMappingForMember(verMmd).getColumn(0);
            }
            stmtBuilder.append(col.getName());
            stmtBuilder.append(" FROM ");
            String schemaName = table.getSchemaName();
            if (schemaName != null) {
                stmtBuilder.append(schemaName).append('.');
            }
            stmtBuilder.append(table.getName()).append(" WHERE ");
            List<Column> pkCols = this.getPrimaryKeyColumns(cmd, table, clr);
            int pkColNo = 0;
            for (Column pkCol : pkCols) {
                if (pkColNo > 0) {
                    stmtBuilder.append(" AND ");
                }
                stmtBuilder.append(pkCol.getName());
                stmtBuilder.append("=?");
                ++pkColNo;
            }
            verStmt = stmtBuilder.toString();
            if (this.getVersionStatementByClassName == null) {
                this.getVersionStatementByClassName = new HashMap<String, String>();
            }
            this.getVersionStatementByClassName.put(cmd.getFullClassName(), verStmt);
        }
        return verStmt;
    }

    protected Object[] getPkValuesForStatement(ObjectProvider op, Table table, ClassLoaderResolver clr) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ArrayList<Object> pkVals = new ArrayList<Object>();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkFieldNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkFieldNums.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                RelationType relType = pkMmd.getRelationType(clr);
                Object fieldVal = op.provideField(pkFieldNums[i]);
                if (relType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.storeMgr.getMetaDataManager(), clr, pkMmd, relType, null)) {
                    ObjectProvider embOP = ec.findObjectProvider(fieldVal);
                    AbstractClassMetaData embCmd = embOP.getClassMetaData();
                    int[] memberPositions = embCmd.getAllMemberPositions();
                    for (int j = 0; j < memberPositions.length; ++j) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[j]);
                        if (embMmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                        Object embFieldVal = embOP.provideField(memberPositions[j]);
                        pkVals.add(embFieldVal);
                    }
                    continue;
                }
                if (RelationType.isRelationSingleValued((RelationType)relType)) {
                    pkVals.add(IdentityUtils.getPersistableIdentityForId((Object)ec.getApiAdapter().getIdForObject(fieldVal)));
                    continue;
                }
                String cassandraType = table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getTypeName();
                pkVals.add(CassandraUtils.getDatastoreValueForNonPersistableValue(fieldVal, cassandraType, false, this.storeMgr.getNucleusContext().getTypeManager(), pkMmd, FieldRole.ROLE_FIELD));
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkVals.add(IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId()));
        }
        return pkVals.toArray();
    }

    protected List<Column> getPrimaryKeyColumns(AbstractClassMetaData cmd, Table table, ClassLoaderResolver clr) {
        ArrayList<Column> pkCols = new ArrayList<Column>();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkFieldNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkFieldNums.length; ++i) {
                Column[] cols;
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                RelationType relType = pkMmd.getRelationType(clr);
                if (relType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.storeMgr.getMetaDataManager(), clr, pkMmd, relType, null)) {
                    ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                    embMmds.add(pkMmd);
                    AbstractClassMetaData embCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(pkMmd.getType(), clr);
                    int[] memberPositions = embCmd.getAllMemberPositions();
                    for (int j = 0; j < memberPositions.length; ++j) {
                        Column[] cols2;
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[j]);
                        if (embMmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                        embMmds.add(embMmd);
                        MemberColumnMapping mapping = table.getMemberColumnMappingForEmbeddedMember(embMmds);
                        embMmds.remove(embMmds.size() - 1);
                        for (Column col : cols2 = mapping.getColumns()) {
                            pkCols.add(col);
                        }
                    }
                    continue;
                }
                MemberColumnMapping mapping = table.getMemberColumnMappingForMember(pkMmd);
                for (Column col : cols = mapping.getColumns()) {
                    pkCols.add(col);
                }
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkCols.add(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID));
        }
        return pkCols;
    }

    protected void performOptimisticCheck(ObjectProvider op, Session session, Table table, VersionMetaData vermd, Object currentVersion) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        Object[] pkVals = this.getPkValuesForStatement(op, table, op.getExecutionContext().getClassLoaderResolver());
        String getVersStmt = this.getVersionStatement(cmd, table, op.getExecutionContext().getClassLoaderResolver());
        CassandraUtils.logCqlStatement(getVersStmt, pkVals, NucleusLogger.DATASTORE_NATIVE);
        SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
        PreparedStatement stmt = stmtProvider.prepare(getVersStmt, session);
        ResultSet rs = session.execute((Statement)stmt.bind(pkVals));
        if (rs.isExhausted()) {
            throw new NucleusDataStoreException("Could not find object with id " + op.getInternalObjectId() + " in the datastore, so cannot update it");
        }
        Row row = rs.one();
        String verColName = null;
        verColName = vermd.getFieldName() == null ? table.getSurrogateColumn(SurrogateColumnType.VERSION).getName() : table.getMemberColumnMappingForMember(cmd.getMetaDataForMember(vermd.getFieldName())).getColumn(0).getName();
        if (currentVersion instanceof Long) {
            long datastoreVersion = row.getLong(verColName);
            if ((Long)currentVersion != datastoreVersion) {
                throw new NucleusOptimisticException("Object " + op.getInternalObjectId() + " has version=" + datastoreVersion + " in the datastore yet version=" + currentVersion + " in memory");
            }
        } else if (currentVersion instanceof Integer) {
            int datastoreVersion = row.getInt(verColName);
            if ((Integer)currentVersion != datastoreVersion) {
                throw new NucleusOptimisticException("Object " + op.getInternalObjectId() + " has version=" + datastoreVersion + " in the datastore yet version=" + currentVersion + " in memory");
            }
        }
    }
}

