/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.store.cassandra.query.expression.CassandraBooleanExpression;
import org.datanucleus.store.cassandra.query.expression.CassandraExpression;
import org.datanucleus.store.cassandra.query.expression.CassandraFieldExpression;
import org.datanucleus.store.cassandra.query.expression.CassandraLiteral;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.compiler.CompilationComponent;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.store.query.expression.AbstractExpressionEvaluator;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.ExpressionEvaluator;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.OrderExpression;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryToCQLMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final Table table;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    int positionalParamNumber = -1;
    CompilationComponent compileComponent;
    boolean filterComplete = true;
    boolean resultComplete = true;
    boolean orderComplete = true;
    boolean updateComplete = true;
    boolean precompilable = true;
    Deque<CassandraExpression> stack = new ArrayDeque<CassandraExpression>();
    String cql = null;

    public QueryToCQLMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q, Table table) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
        this.table = table;
    }

    public String getCQL() {
        return this.cql;
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public boolean isResultComplete() {
        return this.resultComplete;
    }

    public boolean isOrderComplete() {
        return this.orderComplete;
    }

    public boolean isUpdateComplete() {
        return this.updateComplete;
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    public void compile() {
        String filterCql = this.compileFilter();
        StringBuilder str = new StringBuilder();
        if (this.query.getType() == Query.QueryType.BULK_UPDATE) {
            str.append("UPDATE ");
            if (this.table.getSchemaName() != null) {
                str.append(this.table.getSchemaName()).append('.').append(this.table.getName());
            } else {
                str.append(this.table.getName());
            }
            String updateCQL = this.compileUpdate();
            str.append(" ").append(updateCQL);
        } else if (this.query.getType() == Query.QueryType.BULK_DELETE) {
            str.append("DELETE FROM ");
            if (this.table.getSchemaName() != null) {
                str.append(this.table.getSchemaName()).append('.').append(this.table.getName());
            } else {
                str.append(this.table.getName());
            }
        } else {
            str.append("SELECT ");
            String resultCQL = this.compileResult();
            str.append(resultCQL != null ? resultCQL : "*");
            if (this.table.getSchemaName() != null) {
                str.append(" FROM ").append(this.table.getSchemaName()).append('.').append(this.table.getName());
            } else {
                str.append(" FROM ").append(this.table.getName());
            }
        }
        if (filterCql != null) {
            str.append(" WHERE ").append(filterCql);
        }
        this.compileGrouping();
        this.compileHaving();
        String orderCQL = this.compileOrdering();
        if (orderCQL != null) {
            str.append(" ORDER BY ").append(orderCQL);
        }
        this.cql = str.toString();
    }

    protected String compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            String cqlString = null;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                CassandraExpression filterExpr = this.stack.pop();
                cqlString = ((CassandraBooleanExpression)filterExpr).getCQL();
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of filter to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.filterComplete = false;
            }
            this.compileComponent = null;
            return cqlString;
        }
        return null;
    }

    protected String compileResult() {
        if (this.compilation.getExprResult() != null) {
            // empty if block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String compileUpdate() {
        if (this.compilation.getExprUpdate() != null) {
            try {
                this.compileComponent = CompilationComponent.UPDATE;
                try {
                    StringBuilder updateStr = new StringBuilder("SET ");
                    Expression[] updateExprs = this.compilation.getExprUpdate();
                    for (int i = 0; i < updateExprs.length; ++i) {
                        if (i > 0) {
                            updateStr.append(',');
                        }
                        DyadicExpression updateExpr = (DyadicExpression)updateExprs[i];
                        Expression leftExpr = updateExpr.getLeft();
                        Expression rightExpr = updateExpr.getRight();
                        CassandraExpression left = null;
                        if (!(updateExpr.getLeft() instanceof PrimaryExpression)) {
                            throw new NucleusException("Dont currently support update clause containing left expression of type " + leftExpr);
                        }
                        this.processPrimaryExpression((PrimaryExpression)leftExpr);
                        left = this.stack.pop();
                        if (left == null) continue;
                        CassandraExpression right = null;
                        if (rightExpr instanceof Literal) {
                            this.processLiteral((Literal)rightExpr);
                            right = this.stack.pop();
                        } else if (rightExpr instanceof ParameterExpression) {
                            this.processParameterExpression((ParameterExpression)rightExpr);
                            right = this.stack.pop();
                        } else if (rightExpr instanceof PrimaryExpression) {
                            this.processPrimaryExpression((PrimaryExpression)rightExpr);
                            right = this.stack.pop();
                        } else {
                            throw new NucleusException("Dont currently support update clause containing right expression of type " + rightExpr);
                        }
                        if (right == null) continue;
                        CassandraBooleanExpression assignExpr = new CassandraBooleanExpression(left, right, (Expression.Operator)Expression.OP_EQ);
                        updateStr.append(assignExpr.getCQL());
                    }
                    String string = updateStr.toString();
                    return string;
                }
                catch (NucleusException ne) {
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        NucleusLogger.QUERY.debug((Object)("Compilation of UPDATE clause to be evaluated completely in-datastore was impossible : " + ne.getMessage()));
                    }
                    this.updateComplete = false;
                    this.compileComponent = null;
                }
            }
            finally {
                this.compileComponent = null;
            }
        }
        return null;
    }

    protected void compileGrouping() {
        if (this.compilation.getExprFilter() != null) {
            // empty if block
        }
    }

    protected void compileHaving() {
        if (this.compilation.getExprHaving() != null) {
            // empty if block
        }
    }

    protected String compileOrdering() {
        if (this.compilation.getExprOrdering() != null) {
            StringBuilder orderStr = new StringBuilder();
            this.compileComponent = CompilationComponent.ORDERING;
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            try {
                for (int i = 0; i < orderingExpr.length; ++i) {
                    int direction;
                    OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                    CassandraFieldExpression orderCassExpr = (CassandraFieldExpression)orderExpr.getLeft().evaluate((ExpressionEvaluator)this);
                    String orderDir = orderExpr.getSortOrder();
                    int n = direction = orderDir == null || orderDir.equals("ascending") ? 1 : -1;
                    if (orderStr.length() > 0) {
                        orderStr.append(',');
                    }
                    orderStr.append(orderCassExpr.getColumnName()).append(" ");
                    orderStr.append(direction == 1 ? "ASC" : "DESC");
                }
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of order to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.orderComplete = false;
            }
            this.compileComponent = null;
            if (this.orderComplete && orderStr.length() > 0) {
                return orderStr.toString();
            }
        }
        return null;
    }

    protected Object processAndExpression(Expression expr) {
        CassandraExpression right = this.stack.pop();
        CassandraExpression left = this.stack.pop();
        CassandraBooleanExpression boolExpr = new CassandraBooleanExpression(left, right, expr.getOperator());
        this.stack.push(boolExpr);
        return boolExpr;
    }

    protected Object processOrExpression(Expression expr) {
        CassandraExpression right = this.stack.pop();
        CassandraExpression left = this.stack.pop();
        CassandraBooleanExpression boolExpr = new CassandraBooleanExpression(left, right, expr.getOperator());
        this.stack.push(boolExpr);
        return boolExpr;
    }

    protected Object processEqExpression(Expression expr) {
        CassandraExpression right = this.stack.pop();
        CassandraExpression left = this.stack.pop();
        NucleusLogger.GENERAL.info((Object)(">> processEq left=" + StringUtils.toJVMIDString((Object)left) + left + " right=" + StringUtils.toJVMIDString((Object)right) + " " + right));
        CassandraBooleanExpression boolExpr = new CassandraBooleanExpression(left, right, expr.getOperator());
        this.stack.push(boolExpr);
        return boolExpr;
    }

    protected Object processNoteqExpression(Expression expr) {
        CassandraExpression right = this.stack.pop();
        CassandraExpression left = this.stack.pop();
        CassandraBooleanExpression boolExpr = new CassandraBooleanExpression(left, right, expr.getOperator());
        this.stack.push(boolExpr);
        return boolExpr;
    }

    protected Object processGtExpression(Expression expr) {
        CassandraExpression right = this.stack.pop();
        CassandraExpression left = this.stack.pop();
        CassandraBooleanExpression boolExpr = new CassandraBooleanExpression(left, right, expr.getOperator());
        this.stack.push(boolExpr);
        return boolExpr;
    }

    protected Object processGteqExpression(Expression expr) {
        CassandraExpression right = this.stack.pop();
        CassandraExpression left = this.stack.pop();
        CassandraBooleanExpression boolExpr = new CassandraBooleanExpression(left, right, expr.getOperator());
        this.stack.push(boolExpr);
        return boolExpr;
    }

    protected Object processLtExpression(Expression expr) {
        CassandraExpression right = this.stack.pop();
        CassandraExpression left = this.stack.pop();
        CassandraBooleanExpression boolExpr = new CassandraBooleanExpression(left, right, expr.getOperator());
        this.stack.push(boolExpr);
        return boolExpr;
    }

    protected Object processLteqExpression(Expression expr) {
        CassandraExpression right = this.stack.pop();
        CassandraExpression left = this.stack.pop();
        CassandraBooleanExpression boolExpr = new CassandraBooleanExpression(left, right, expr.getOperator());
        this.stack.push(boolExpr);
        return boolExpr;
    }

    protected Object processInExpression(Expression expr) {
        return super.processInExpression(expr);
    }

    protected Object processNotInExpression(Expression expr) {
        return super.processNotInExpression(expr);
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        return super.processInvokeExpression(expr);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Expression left = expr.getLeft();
        if (left == null) {
            CassandraExpression memberExpr = this.getExpressionForPrimary(expr);
            if (memberExpr == null) {
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                } else if (this.compileComponent == CompilationComponent.RESULT) {
                    this.resultComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)(">> Primary " + expr + " is not stored in this table, so unexecutable in datastore"));
            } else {
                this.stack.push(memberExpr);
                return memberExpr;
            }
        }
        return super.processPrimaryExpression(expr);
    }

    protected CassandraExpression getExpressionForPrimary(PrimaryExpression primExpr) {
        List tuples = primExpr.getTuples();
        NucleusLogger.GENERAL.info((Object)(">> getExprForPrim " + primExpr));
        if (tuples == null || tuples.isEmpty()) {
            return null;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        MetaDataManager mmgr = this.ec.getMetaDataManager();
        AbstractClassMetaData cmd = this.candidateCmd;
        boolean firstTuple = true;
        Iterator iter = tuples.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (firstTuple && name.equals(this.candidateAlias)) {
                cmd = this.candidateCmd;
                continue;
            }
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(name);
            if (mmd == null) continue;
            RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
            NucleusLogger.GENERAL.info((Object)(">> getExprForPrim name=" + name + " mmd=" + mmd.getFullFieldName() + " relType=" + relationType));
            if (relationType == RelationType.NONE && iter.hasNext()) {
                throw new NucleusUserException("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " yet " + name + " is a non-relation field!");
            }
            if (relationType != RelationType.NONE && MetaDataUtils.isMemberEmbedded((AbstractMemberMetaData)mmd, (RelationType)relationType, (ClassLoaderResolver)clr, (MetaDataManager)mmgr)) {
                if (RelationType.isRelationSingleValued((RelationType)relationType) || !RelationType.isRelationMultiValued((RelationType)relationType)) continue;
                continue;
            }
            if (relationType == RelationType.NONE) {
                if (iter.hasNext()) {
                    NucleusLogger.GENERAL.info((Object)("Query involves primaryExpression through field " + mmd.getFullFieldName() + " yet CQL cannot join to related tables so handling in-memory"));
                    return null;
                }
                MemberColumnMapping mapping = this.table.getMemberColumnMappingForMember(mmd);
                if (this.compileComponent == CompilationComponent.FILTER && mmd.getIndexMetaData() == null) {
                    throw new NucleusUserException("Attempt to refer to " + mmd.getFullFieldName() + " in " + this.compileComponent + " yet this is not indexed. Must be indexed to evaluate in datastore");
                }
                return new CassandraFieldExpression(mapping.getColumn(0).getName(), mmd);
            }
            if (!RelationType.isRelationSingleValued((RelationType)relationType)) continue;
            MemberColumnMapping mapping = this.table.getMemberColumnMappingForMember(mmd);
            if (iter.hasNext()) {
                NucleusLogger.GENERAL.info((Object)("Query involves primaryExpression through relation " + mmd.getFullFieldName() + " yet CQL cannot join to related tables so handling in-memory"));
                return null;
            }
            return new CassandraFieldExpression(mapping.getColumn(0).getName(), mmd);
        }
        return null;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object paramValue = null;
        boolean paramValueSet = false;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(position)) {
                    paramValue = this.parameters.get(position);
                    paramValueSet = true;
                    this.positionalParamNumber = position + 1;
                }
            }
        }
        if (paramValueSet) {
            CassandraLiteral lit = new CassandraLiteral(paramValue);
            this.stack.push(lit);
            this.precompilable = false;
            return lit;
        }
        return super.processParameterExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        CassandraLiteral lit = new CassandraLiteral(litValue);
        this.stack.push(lit);
        return lit;
    }
}

