/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SchemaVerifier;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public class SchemaVerifierImpl
implements SchemaVerifier {
    StoreManager storeMgr;
    AbstractClassMetaData cmd;
    ClassLoaderResolver clr;

    public SchemaVerifierImpl(StoreManager storeMgr, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        this.storeMgr = storeMgr;
        this.cmd = cmd;
        this.clr = clr;
    }

    public TypeConverter verifyTypeConverterForMember(AbstractMemberMetaData mmd, TypeConverter conv) {
        Class datastoreType;
        if (conv != null && !(conv instanceof MultiColumnConverter) && (datastoreType = this.storeMgr.getNucleusContext().getTypeManager().getDatastoreTypeForTypeConverter(conv, mmd.getType())) != null) {
            if (Date.class.isAssignableFrom(datastoreType) && datastoreType != Date.class) {
                TypeConverter newConv = this.storeMgr.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), Date.class);
                if (newConv == null) {
                    NucleusLogger.DATASTORE.warn((Object)("Member " + mmd.getFullFieldName() + " required to convert to datastore type of " + datastoreType.getName() + " but no supported converter for this datastore!"));
                }
                return newConv;
            }
            if (UUID.class.isAssignableFrom(mmd.getType())) {
                ColumnMetaData[] colmds = mmd.getColumnMetaData();
                boolean jdbcTypeSpecified = false;
                if (colmds != null && colmds.length == 1 && !StringUtils.isWhitespace((String)colmds[0].getJdbcTypeName())) {
                    jdbcTypeSpecified = true;
                }
                if (!jdbcTypeSpecified) {
                    return null;
                }
            }
        }
        return conv;
    }

    public void attributeMember(MemberColumnMapping mapping) {
        if (mapping.getColumn(0).getColumnType() == ColumnType.DATASTOREID_COLUMN) {
            String type = "bigint";
            IdentityMetaData idmd = this.cmd.getIdentityMetaData();
            if (idmd != null && idmd.getColumnMetaData() != null && idmd.getColumnMetaData().getJdbcType() != null) {
                JdbcType jdbcType = idmd.getColumnMetaData().getJdbcType();
                if (MetaDataUtils.isJdbcTypeString((JdbcType)jdbcType)) {
                    type = "varchar";
                } else if (jdbcType == JdbcType.INTEGER) {
                    type = "int";
                }
            }
            mapping.getColumn(0).setTypeName(type);
        } else if (mapping.getColumn(0).getColumnType() == ColumnType.VERSION_COLUMN) {
            String cassandraType = this.cmd.getVersionMetaDataForClass().getVersionStrategy() == VersionStrategy.DATE_TIME ? "timestamp" : "bigint";
            mapping.getColumn(0).setTypeName(cassandraType);
        } else if (mapping.getColumn(0).getColumnType() == ColumnType.DISCRIMINATOR_COLUMN) {
            mapping.getColumn(0).setTypeName("varchar");
        } else if (mapping.getColumn(0).getColumnType() == ColumnType.MULTITENANCY_COLUMN) {
            mapping.getColumn(0).setTypeName("varchar");
        } else if (mapping.getColumn(0).getColumnType() == ColumnType.SOFTDELETE_COLUMN) {
            mapping.getColumn(0).setTypeName("boolean");
        }
    }

    public void attributeMember(MemberColumnMapping mapping, AbstractMemberMetaData mmd) {
        SchemaVerifierImpl.verifyMemberColumnMapping(mmd, mapping, this.storeMgr.getNucleusContext().getTypeManager(), this.clr);
    }

    public void attributeEmbeddedMember(MemberColumnMapping mapping, List<AbstractMemberMetaData> mmds) {
        AbstractMemberMetaData mmd = mmds.get(mmds.size() - 1);
        SchemaVerifierImpl.verifyMemberColumnMapping(mmd, mapping, this.storeMgr.getNucleusContext().getTypeManager(), this.clr);
    }

    public static void verifyMemberColumnMapping(AbstractMemberMetaData mmd, MemberColumnMapping mapping, TypeManager typeMgr, ClassLoaderResolver clr) {
        String type = null;
        if (mapping.getTypeConverter() != null) {
            if (mapping.getNumberOfColumns() > 1) {
                Class[] datastoreJavaTypes = ((MultiColumnConverter)mapping.getTypeConverter()).getDatastoreColumnTypes();
                for (int i = 0; i < datastoreJavaTypes.length; ++i) {
                    type = CassandraUtils.getCassandraTypeForDatastoreType(datastoreJavaTypes[i].getName());
                    mapping.getColumn(i).setTypeName(type);
                }
            } else {
                Class datastoreJavaType = typeMgr.getDatastoreTypeForTypeConverter(mapping.getTypeConverter(), mmd.getType());
                type = CassandraUtils.getCassandraTypeForDatastoreType(datastoreJavaType.getName());
                mapping.getColumn(0).setTypeName(type);
            }
        } else {
            RelationType relType = mmd.getRelationType(clr);
            boolean optional = false;
            if (Optional.class.isAssignableFrom(mmd.getType())) {
                if (relType != RelationType.NONE) {
                    relType = RelationType.ONE_TO_ONE_UNI;
                }
                optional = true;
            }
            if (relType == RelationType.NONE) {
                if (mmd.isSerialized()) {
                    type = "blob";
                } else if (!optional && mmd.hasContainer()) {
                    if (mmd.hasCollection()) {
                        Class elementType = clr.classForName(mmd.getCollection().getElementType());
                        String cqlElementType = null;
                        if (mmd.getElementMetaData() != null && mmd.getElementMetaData().hasExtension("type-converter-name")) {
                            TypeConverter elemTypeConv = typeMgr.getTypeConverterForName(mmd.getElementMetaData().getValueForExtension("type-converter-name"));
                            Class datastoreJavaType = typeMgr.getDatastoreTypeForTypeConverter(elemTypeConv, clr.classForName(mmd.getCollection().getElementType()));
                            cqlElementType = CassandraUtils.getCassandraTypeForDatastoreType(datastoreJavaType.getName());
                        } else {
                            String string = cqlElementType = mmd.getCollection().isSerializedElement() ? "blob" : CassandraUtils.getCassandraTypeForNonPersistableType(elementType, false, typeMgr, null, mmd, FieldRole.ROLE_COLLECTION_ELEMENT, clr);
                        }
                        type = List.class.isAssignableFrom(mmd.getType()) || Queue.class.isAssignableFrom(mmd.getType()) ? "list<" + cqlElementType + ">" : (Set.class.isAssignableFrom(mmd.getType()) ? "set<" + cqlElementType + ">" : (mmd.getOrderMetaData() != null ? "list<" + cqlElementType + ">" : "set<" + cqlElementType + ">"));
                    } else if (mmd.hasMap()) {
                        Class keyType = clr.classForName(mmd.getMap().getKeyType());
                        Class valType = clr.classForName(mmd.getMap().getValueType());
                        String cqlKeyType = null;
                        if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().hasExtension("type-converter-name")) {
                            TypeConverter keyTypeConv = typeMgr.getTypeConverterForName(mmd.getKeyMetaData().getValueForExtension("type-converter-name"));
                            Class datastoreJavaType = typeMgr.getDatastoreTypeForTypeConverter(keyTypeConv, clr.classForName(mmd.getMap().getKeyType()));
                            cqlKeyType = CassandraUtils.getCassandraTypeForDatastoreType(datastoreJavaType.getName());
                        } else {
                            cqlKeyType = mmd.getMap().isSerializedKey() ? "blob" : CassandraUtils.getCassandraTypeForNonPersistableType(keyType, false, typeMgr, null, mmd, FieldRole.ROLE_MAP_KEY, clr);
                        }
                        String cqlValType = null;
                        if (mmd.getValueMetaData() != null && mmd.getValueMetaData().hasExtension("type-converter-name")) {
                            TypeConverter valTypeConv = typeMgr.getTypeConverterForName(mmd.getValueMetaData().getValueForExtension("type-converter-name"));
                            Class datastoreJavaType = typeMgr.getDatastoreTypeForTypeConverter(valTypeConv, clr.classForName(mmd.getMap().getValueType()));
                            cqlValType = CassandraUtils.getCassandraTypeForDatastoreType(datastoreJavaType.getName());
                        } else {
                            cqlValType = mmd.getMap().isSerializedValue() ? "blob" : CassandraUtils.getCassandraTypeForNonPersistableType(valType, false, typeMgr, null, mmd, FieldRole.ROLE_MAP_VALUE, clr);
                        }
                        type = "map<" + cqlKeyType + "," + cqlValType + ">";
                    } else if (mmd.hasArray()) {
                        Class elementType = clr.classForName(mmd.getArray().getElementType());
                        String cqlElementType = mmd.getArray().isSerializedElement() ? "blob" : CassandraUtils.getCassandraTypeForNonPersistableType(elementType, false, typeMgr, null, mmd, FieldRole.ROLE_ARRAY_ELEMENT, clr);
                        type = "list<" + cqlElementType + ">";
                    }
                } else {
                    Column col = mapping.getColumn(0);
                    if (col.getJdbcType() != null) {
                        if (MetaDataUtils.isJdbcTypeString((JdbcType)col.getJdbcType())) {
                            type = "varchar";
                        } else if (col.getJdbcType() == JdbcType.BIGINT) {
                            type = "bigint";
                        } else if (col.getJdbcType() == JdbcType.CHAR) {
                            col.setJdbcType(JdbcType.VARCHAR);
                            type = "varchar";
                        } else if (col.getJdbcType() == JdbcType.BLOB) {
                            type = "blob";
                        } else if (col.getJdbcType() == JdbcType.INTEGER || col.getJdbcType() == JdbcType.SMALLINT || col.getJdbcType() == JdbcType.TINYINT) {
                            type = "int";
                        } else if (col.getJdbcType() == JdbcType.DECIMAL) {
                            type = "decimal";
                        } else if (col.getJdbcType() == JdbcType.FLOAT) {
                            type = "float";
                        } else if (col.getJdbcType() == JdbcType.DOUBLE) {
                            type = "double";
                        } else if (col.getJdbcType() == JdbcType.DATE || col.getJdbcType() == JdbcType.TIME || col.getJdbcType() == JdbcType.TIMESTAMP) {
                            type = "timestamp";
                        }
                    }
                    if (type == null) {
                        String typeName = mmd.getTypeName();
                        if (optional) {
                            typeName = mmd.getCollection().getElementType();
                        }
                        if ((type = CassandraUtils.getCassandraTypeForDatastoreType(typeName)) == null) {
                            if (Enum.class.isAssignableFrom(mmd.getType())) {
                                JdbcType jdbcType = TypeConversionHelper.getJdbcTypeForEnum((AbstractMemberMetaData)mmd, (FieldRole)FieldRole.ROLE_FIELD, (ClassLoaderResolver)clr);
                                type = MetaDataUtils.isJdbcTypeNumeric((JdbcType)jdbcType) ? "int" : "varchar";
                            } else {
                                TypeConverter stringConverter = typeMgr.getTypeConverterForType(mmd.getType(), String.class);
                                if (stringConverter != null) {
                                    type = "varchar";
                                    mapping.setTypeConverter(stringConverter);
                                } else {
                                    TypeConverter longConverter = typeMgr.getTypeConverterForType(mmd.getType(), Long.class);
                                    if (longConverter != null) {
                                        type = "bigint";
                                        mapping.setTypeConverter(longConverter);
                                    } else {
                                        TypeConverter intConverter = typeMgr.getTypeConverterForType(mmd.getType(), Integer.class);
                                        if (intConverter != null) {
                                            type = "int";
                                            mapping.setTypeConverter(intConverter);
                                        } else if (Serializable.class.isAssignableFrom(mmd.getType())) {
                                            type = "blob";
                                            mapping.setTypeConverter(typeMgr.getTypeConverterForType(Serializable.class, ByteBuffer.class));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (RelationType.isRelationSingleValued((RelationType)relType)) {
                type = mmd.isSerialized() ? "blob" : "varchar";
            } else if (RelationType.isRelationMultiValued((RelationType)relType)) {
                if (mmd.hasCollection()) {
                    type = List.class.isAssignableFrom(mmd.getType()) || Queue.class.isAssignableFrom(mmd.getType()) ? (mmd.getCollection().isSerializedElement() ? "list<blob>" : "list<varchar>") : (Set.class.isAssignableFrom(mmd.getType()) ? (mmd.getCollection().isSerializedElement() ? "set<blob>" : "set<varchar>") : (relType == RelationType.MANY_TO_MANY_BI ? (mmd.getCollection().isSerializedElement() ? "set<blob>" : "set<varchar>") : (mmd.getOrderMetaData() != null ? (mmd.getCollection().isSerializedElement() ? "list<blob>" : "list<varchar>") : (mmd.getCollection().isSerializedElement() ? "set<blob>" : "set<varchar>"))));
                } else if (mmd.hasMap()) {
                    String keyType = null;
                    String valType = null;
                    keyType = mmd.getMap().keyIsPersistent() ? (mmd.getMap().isSerializedKey() ? "blob" : "varchar") : CassandraUtils.getCassandraTypeForDatastoreType(mmd.getMap().getKeyType());
                    valType = mmd.getMap().valueIsPersistent() ? (mmd.getMap().isSerializedValue() ? "blob" : "varchar") : CassandraUtils.getCassandraTypeForDatastoreType(mmd.getMap().getValueType());
                    type = "map<" + keyType + "," + valType + ">";
                } else if (mmd.hasArray()) {
                    String string = type = mmd.getArray().isSerializedElement() ? "list<blob>" : "list<varchar>";
                }
            }
            if (!StringUtils.isWhitespace((String)type)) {
                mapping.getColumn(0).setTypeName(type);
            } else {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Member " + mmd.getFullFieldName() + " of type=" + mmd.getTypeName() + " could not be directly mapped for Cassandra. Using varchar column"));
                mapping.getColumn(0).setTypeName("varchar");
            }
        }
    }
}

