/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.query.CassandraQueryCompilation;
import org.datanucleus.store.cassandra.query.CassandraQueryResult;
import org.datanucleus.store.cassandra.query.ResultClassInfo;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CQLQuery
extends AbstractJavaQuery {
    private static final long serialVersionUID = 2808968696540162104L;
    protected transient CassandraQueryCompilation datastoreCompilation;
    String cql;

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (CQLQuery)null);
    }

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec, CQLQuery q) {
        super(storeMgr, ec);
        this.cql = q.cql;
    }

    public CQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec);
        this.cql = query;
    }

    public String getSingleStringQuery() {
        return this.cql;
    }

    public void compileGeneric(Map parameterValues) {
    }

    protected void compileInternal(Map parameterValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        if (this.type == Query.QueryType.SELECT) {
            ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
            try {
                ArrayList<Object> results = new ArrayList<Object>();
                Session session = (Session)mconn.getConnection();
                long startTime = System.currentTimeMillis();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{"CQL", this.getSingleStringQuery(), null}));
                }
                SimpleStatement stmt = new SimpleStatement(this.cql);
                int fetchSize = this.getFetchPlan().getFetchSize();
                if (0 < fetchSize) {
                    stmt.setFetchSize(fetchSize);
                }
                ResultSet rs = session.execute((Statement)stmt);
                TypeConverter typeConverter = this.storeMgr.getNucleusContext().getTypeManager().getTypeConverterForType(byte[].class, ByteBuffer.class);
                Class resultClazz = this.getResultClass();
                ResultClassInfo rci = null;
                if (resultClazz != null) {
                    rci = CassandraUtils.getResultClassInfoFromColumnDefinitions(resultClazz, rs.getColumnDefinitions());
                }
                CassandraQueryResult queryResult = new CassandraQueryResult((Query)this, rs);
                queryResult.initialise();
                Iterator iter = queryResult.iterator();
                while (iter.hasNext()) {
                    Object[] rowResult;
                    Row row = (Row)iter.next();
                    if (null != rci) {
                        rowResult = CassandraUtils.getObjectArrayFromRow(row, rs.getColumnDefinitions(), rci.getFieldsMatchingColumnIndexes(), typeConverter, rci.getFields().length);
                        results.add(this.getResultWithQueryUtils(rowResult, rci));
                        continue;
                    }
                    rowResult = CassandraUtils.getObjectArrayFromRow(row, rs.getColumnDefinitions(), new ArrayList<Integer>(), typeConverter, rs.getColumnDefinitions().size());
                    results.add(rowResult);
                }
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{"CQL", "" + (System.currentTimeMillis() - startTime)}));
                }
                queryResult.close();
                ArrayList<Object> arrayList = results;
                return arrayList;
            }
            finally {
                mconn.release();
            }
        }
        if (this.type == Query.QueryType.BULK_DELETE || this.type == Query.QueryType.BULK_UPDATE) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private Object getResultWithQueryUtils(Object[] result, ResultClassInfo rci) {
        return QueryUtils.createResultObjectUsingDefaultConstructorAndSetters((Class)this.resultClass, (String[])rci.getFieldNames(), (Field[])rci.getFields(), (Object[])result);
    }
}

