/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.query.CassandraQueryCompilation;
import org.datanucleus.store.cassandra.query.QueryToCQLMapper;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    private static final long serialVersionUID = -8227071426747396356L;
    protected transient CassandraQueryCompilation datastoreCompilation;

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (Object)((JPQLQuery)null));
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, Object q) {
        super(storeMgr, ec, (AbstractJPQLQuery)((JPQLQuery)((Object)q)));
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null || this.candidateClassName == null) {
            this.candidateClass = this.compilation.getCandidateClass();
            this.candidateClassName = this.candidateClass.getName();
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (CassandraQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                this.setResultDistinct(this.compilation.getResultDistinct());
                return;
            }
        }
        CassandraQueryCompilation cassandraQueryCompilation = this.datastoreCompilation = new CassandraQueryCompilation();
        synchronized (cassandraQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues);
            }
        }
        if (cacheKey != null && this.datastoreCompilation.isPrecompilable()) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            Object resultMapper;
            Session session = (Session)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{"JPQL", this.getSingleStringQuery(), null}));
            }
            boolean filterInMemory = this.filter != null;
            Boolean orderInMemory = this.ordering != null;
            Boolean rangeInMemory = this.range != null;
            List<Object> candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.evaluateInMemory()) {
                candidates = this.getCandidatesForQuery(session);
            } else if (this.filter != null && this.datastoreCompilation.isFilterComplete()) {
                candidates = new ArrayList();
                Set<String> classNamesQueryable = this.datastoreCompilation.getClassNames();
                for (String className : classNamesQueryable) {
                    String cql = this.datastoreCompilation.getCQLForClass(className);
                    AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(className, this.clr);
                    CassandraUtils.logCqlStatement(cql, null, NucleusLogger.DATASTORE_NATIVE);
                    ResultSet rs = session.execute(cql);
                    for (Row row : rs) {
                        candidates.add(CassandraUtils.getPojoForRowForCandidate(row, cmd, this.ec, this.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers(), this.getIgnoreCache()));
                    }
                }
                filterInMemory = false;
            } else {
                candidates = this.getCandidatesForQuery(session);
            }
            Collection results = candidates;
            if (filterInMemory || this.result != null || this.resultClass != null || rangeInMemory.booleanValue() || orderInMemory.booleanValue()) {
                if (candidates instanceof QueryResult) {
                    ((QueryResult)candidates).disconnect();
                }
                resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
                results = resultMapper.execute(filterInMemory, orderInMemory.booleanValue(), this.result != null, this.resultClass != null, rangeInMemory.booleanValue());
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{"JDOQL", "" + (System.currentTimeMillis() - startTime)}));
            }
            if (this.type == 2) {
                this.ec.deleteObjects(results.toArray());
                resultMapper = Long.valueOf(results.size());
                return resultMapper;
            }
            if (this.type == 1) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            if (results instanceof QueryResult) {
                final QueryResult qr1 = (QueryResult)results;
                final ManagedConnection mconn1 = mconn;
                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                        qr1.disconnect();
                    }

                    public void managedConnectionPreClose() {
                        if (!JPQLQuery.this.ec.getTransaction().isActive()) {
                            qr1.disconnect();
                        }
                    }

                    public void managedConnectionPostClose() {
                    }

                    public void resourcePostClose() {
                        mconn1.removeListener((ManagedConnectionResourceListener)this);
                    }
                };
                mconn.addListener(listener);
                if (qr1 instanceof AbstractQueryResult) {
                    ((AbstractQueryResult)qr1).addConnectionListener(listener);
                }
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            mconn.release();
        }
    }

    protected List getCandidatesForQuery(Session session) {
        ArrayList<Object> candidateObjs = new ArrayList<Object>();
        CassandraStoreManager storeMgr = (CassandraStoreManager)this.storeMgr;
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)this.getCandidateClass(), (boolean)this.isSubclasses(), (ExecutionContext)this.ec);
        for (AbstractClassMetaData cmd : cmds) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
            storeMgr.manageClasses(this.clr, cmd.getFullClassName());
            Table table = storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            if (table == null) continue;
            StringBuilder stmtBuilder = new StringBuilder("SELECT * FROM ");
            stmtBuilder.append(table.getSchemaName()).append('.').append(table.getName());
            if (storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                String multitenancyValue = storeMgr.getStringProperty("datanucleus.TenantID");
                stmtBuilder.append(" WHERE ").append(table.getMultitenancyColumn().getName()).append("='").append(multitenancyValue).append("'");
            }
            CassandraUtils.logCqlStatement(stmtBuilder.toString(), null, NucleusLogger.DATASTORE_NATIVE);
            ResultSet rs = session.execute(stmtBuilder.toString());
            for (Row row : rs) {
                candidateObjs.add(CassandraUtils.getPojoForRowForCandidate(row, cmd, this.ec, this.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers(), this.getIgnoreCache()));
            }
        }
        return candidateObjs;
    }

    private void compileQueryFull(Map parameters) {
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021083", (Object[])new Object[]{this.getLanguage(), this.toString()}));
        }
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)this.getCandidateClass(), (boolean)this.isSubclasses(), (ExecutionContext)this.ec);
        for (AbstractClassMetaData cmd : cmds) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isEmbeddedOnly() || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
            this.storeMgr.manageClasses(this.clr, new String[]{cmd.getFullClassName()});
            Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            if (table == null) continue;
            QueryToCQLMapper mapper = new QueryToCQLMapper(this.compilation, parameters, cmd, this.ec, (Query)this, table);
            mapper.compile();
            this.datastoreCompilation.setFilterComplete(mapper.isFilterComplete());
            this.datastoreCompilation.setResultComplete(mapper.isResultComplete());
            this.datastoreCompilation.setOrderComplete(mapper.isOrderComplete());
            this.datastoreCompilation.setCQLForClass(cmd.getFullClassName(), mapper.getCQL());
            this.datastoreCompilation.setPrecompilable(mapper.isPrecompilable());
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021084", (Object[])new Object[]{this.getLanguage(), System.currentTimeMillis() - startTime}));
        }
    }
}

