/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.transaction.xa.XAResource;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractEmulatedXAResource;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    public static final String CASSANDRA_CONNECTION_PER_MANAGER = "datanucleus.cassandra.sessionPerManager";
    public static final String CASSANDRA_COMPRESSION = "datanucleus.cassandra.compression";
    public static final String CASSANDRA_METRICS = "datanucleus.cassandra.metrics";
    public static final String CASSANDRA_SSL = "datanucleus.cassandra.ssl";
    public static final String CASSANDRA_SOCKET_READ_TIMEOUT_MILLIS = "datanucleus.cassandra.socket.readTimeoutMillis";
    public static final String CASSANDRA_SOCKET_CONNECT_TIMEOUT_MILLIS = "datanucleus.cassandra.socket.connectTimeoutMillis";
    protected static final String DEFAULT_IP_ADDR = "127.0.0.1";
    Cluster cluster;
    boolean sessionPerManager = false;
    Session session = null;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        int connectTimeout;
        Boolean sessionPerManagerProperty;
        Boolean useMetrics;
        Boolean useSSL;
        String compression;
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.trim().substring(9).trim();
        if (remains.length() > 0) {
            remains = remains.substring(1);
        }
        StringTokenizer tokeniser = new StringTokenizer(remains, ",");
        ArrayList hosts = new ArrayList();
        String port = null;
        while (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            if (token.indexOf(58) == 0) {
                token = token.substring(1).trim();
            }
            Object hostStr = null;
            if (!StringUtils.isWhitespace((String)token)) {
                int n = token.indexOf(58);
                if (n > 0) {
                    port = token.substring(n + 1);
                    hostStr = token.substring(0, n);
                } else {
                    hostStr = token.trim();
                }
            }
            hosts.add(hostStr);
        }
        Cluster.Builder builder = Cluster.builder();
        if (!hosts.isEmpty()) {
            NucleusLogger.CONNECTION.debug((Object)("Starting Cassandra Cluster for hosts " + StringUtils.collectionToString(hosts)));
            for (String string : hosts) {
                builder.addContactPoint(string);
            }
        } else {
            NucleusLogger.CONNECTION.debug((Object)"Starting Cassandra Cluster for host 127.0.0.1");
            builder.addContactPoint(DEFAULT_IP_ADDR);
        }
        if (port != null) {
            int portNumber = 0;
            try {
                portNumber = Integer.valueOf(port);
            }
            catch (NumberFormatException numberFormatException) {
                NucleusLogger.CONNECTION.warn((Object)("Unable to convert '" + port + "' to port number for Cassandra, so ignoring"));
            }
            if (portNumber > 0) {
                builder.withPort(portNumber);
            }
        }
        String user = storeMgr.getConnectionUserName();
        String string = storeMgr.getConnectionPassword();
        if (!StringUtils.isWhitespace((String)user)) {
            builder.withCredentials(user, string);
        }
        if (!StringUtils.isWhitespace((String)(compression = storeMgr.getStringProperty(CASSANDRA_COMPRESSION)))) {
            builder.withCompression(ProtocolOptions.Compression.valueOf((String)compression.toUpperCase()));
        }
        if ((useSSL = storeMgr.getBooleanObjectProperty(CASSANDRA_SSL)) != null && useSSL.booleanValue()) {
            builder.withSSL();
        }
        if ((useMetrics = storeMgr.getBooleanObjectProperty(CASSANDRA_METRICS)) != null && !useMetrics.booleanValue()) {
            builder.withoutMetrics();
        }
        if ((sessionPerManagerProperty = storeMgr.getBooleanObjectProperty(CASSANDRA_CONNECTION_PER_MANAGER)) != null && sessionPerManagerProperty.booleanValue()) {
            this.sessionPerManager = true;
        }
        SocketOptions socketOpts = null;
        int readTimeout = storeMgr.getIntProperty(CASSANDRA_SOCKET_READ_TIMEOUT_MILLIS);
        if (readTimeout != 0) {
            socketOpts = new SocketOptions();
            socketOpts.setReadTimeoutMillis(readTimeout);
        }
        if ((connectTimeout = storeMgr.getIntProperty(CASSANDRA_SOCKET_CONNECT_TIMEOUT_MILLIS)) != 0) {
            if (socketOpts == null) {
                socketOpts = new SocketOptions();
            }
            socketOpts.setConnectTimeoutMillis(connectTimeout);
        }
        if (socketOpts != null) {
            builder.withSocketOptions(socketOpts);
        }
        this.cluster = builder.build();
    }

    public void close() {
        if (this.session != null) {
            NucleusLogger.CONNECTION.debug((Object)"Closing Cassandra Session");
            this.session.close();
        }
        NucleusLogger.CONNECTION.debug((Object)"Closing Cassandra Cluster");
        this.cluster.close();
        super.close();
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map options) {
        return new ManagedConnectionImpl();
    }

    static class EmulatedXAResource
    extends AbstractEmulatedXAResource {
        EmulatedXAResource(ManagedConnectionImpl mconn, Session session) {
            super((ManagedConnection)mconn);
        }
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        XAResource xaRes = null;

        public Object getConnection() {
            if (this.conn == null) {
                this.obtainNewConnection();
            }
            return this.conn;
        }

        protected void obtainNewConnection() {
            if (this.conn == null) {
                if (ConnectionFactoryImpl.this.sessionPerManager) {
                    this.conn = ConnectionFactoryImpl.this.cluster.connect();
                    NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - obtained Session"));
                } else {
                    if (ConnectionFactoryImpl.this.session == null) {
                        ConnectionFactoryImpl.this.session = ConnectionFactoryImpl.this.cluster.connect();
                    }
                    NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - using connection"));
                    this.conn = ConnectionFactoryImpl.this.session;
                }
            }
        }

        public void release() {
            if (this.commitOnRelease) {
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - released connection"));
            }
        }

        public void close() {
            int i;
            if (this.conn == null) {
                return;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - closed connection"));
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
            if (ConnectionFactoryImpl.this.sessionPerManager) {
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " - close Session"));
                ((Session)this.conn).close();
            }
            this.conn = null;
            this.xaRes = null;
        }

        public XAResource getXAResource() {
            if (this.xaRes == null) {
                if (this.conn == null) {
                    this.obtainNewConnection();
                }
                this.xaRes = new EmulatedXAResource(this, (Session)this.conn);
            }
            return this.xaRes;
        }

        public boolean closeAfterTransactionEnd() {
            if (ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.connection.singleConnectionPerExecutionContext")) {
                return false;
            }
            return super.closeAfterTransactionEnd();
        }
    }
}

