/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.Row;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.fieldmanager.FetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class CassandraUtils {
    static Map<String, String> cassandraTypeByJavaType = new HashMap<String, String>();
    static Map<String, Class> datastoreTypeByCassandraType = new HashMap<String, Class>();

    private CassandraUtils() {
    }

    public static Class getJavaTypeForCassandraType(String cassandraType) {
        return datastoreTypeByCassandraType.get(cassandraType);
    }

    public static String getCassandraTypeForDatastoreType(String javaType) {
        return cassandraTypeByJavaType.get(javaType);
    }

    public static Object getMemberValueForColumnWithConverter(Row row, Column column, TypeConverter typeConv) {
        if (column.getTypeName().equals("varchar")) {
            return typeConv.toMemberType((Object)row.getString(column.getName()));
        }
        if (column.getTypeName().equals("int")) {
            return typeConv.toMemberType((Object)row.getInt(column.getName()));
        }
        if (column.getTypeName().equals("boolean")) {
            return typeConv.toMemberType((Object)row.getBool(column.getName()));
        }
        if (column.getTypeName().equals("double")) {
            return typeConv.toMemberType((Object)row.getDouble(column.getName()));
        }
        if (column.getTypeName().equals("float")) {
            return typeConv.toMemberType((Object)Float.valueOf(row.getFloat(column.getName())));
        }
        if (column.getTypeName().equals("bigint")) {
            return typeConv.toMemberType((Object)row.getLong(column.getName()));
        }
        if (column.getTypeName().equals("timestamp")) {
            return typeConv.toMemberType((Object)row.getDate(column.getName()));
        }
        if (column.getTypeName().equals("blob")) {
            return typeConv.toMemberType((Object)row.getBytes(column.getName()));
        }
        return null;
    }

    public static Object getJavaValueForDatastoreValue(Object datastoreValue, String cassandraType, Class javaType, ExecutionContext ec) {
        TypeConverter converter;
        if (datastoreValue == null) {
            return null;
        }
        if (cassandraType.equals("blob") && datastoreValue instanceof ByteBuffer) {
            TypeConverter serialConv = ec.getTypeManager().getTypeConverterForType(Serializable.class, ByteBuffer.class);
            return serialConv.toMemberType((Object)((ByteBuffer)datastoreValue));
        }
        if (javaType.isEnum()) {
            if (cassandraType.equals("int")) {
                return javaType.getEnumConstants()[(Integer)datastoreValue];
            }
            return Enum.valueOf(javaType, (String)datastoreValue);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            TypeConverter stringConverter;
            if (cassandraType.equals("varchar") && (stringConverter = ec.getTypeManager().getTypeConverterForType(javaType, String.class)) != null) {
                return stringConverter.toMemberType((Object)((String)datastoreValue));
            }
            return new Date(((java.util.Date)datastoreValue).getTime());
        }
        if (Time.class.isAssignableFrom(javaType)) {
            TypeConverter stringConverter;
            if (cassandraType.equals("varchar") && (stringConverter = ec.getTypeManager().getTypeConverterForType(javaType, String.class)) != null) {
                return stringConverter.toMemberType((Object)((String)datastoreValue));
            }
            return new Time(((java.util.Date)datastoreValue).getTime());
        }
        if (Timestamp.class.isAssignableFrom(javaType)) {
            TypeConverter stringConverter;
            if (cassandraType.equals("varchar") && (stringConverter = ec.getTypeManager().getTypeConverterForType(javaType, String.class)) != null) {
                return stringConverter.toMemberType((Object)((String)datastoreValue));
            }
            return new Timestamp(((java.util.Date)datastoreValue).getTime());
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            TypeConverter stringConverter;
            if (cassandraType.equals("varchar") && (stringConverter = ec.getTypeManager().getTypeConverterForType(javaType, String.class)) != null) {
                return stringConverter.toMemberType((Object)((String)datastoreValue));
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)datastoreValue);
            return cal;
        }
        if (java.util.Date.class.isAssignableFrom(javaType)) {
            TypeConverter stringConverter;
            if (cassandraType.equals("varchar") && (stringConverter = ec.getTypeManager().getTypeConverterForType(javaType, String.class)) != null) {
                return stringConverter.toMemberType((Object)((String)datastoreValue));
            }
            return (java.util.Date)datastoreValue;
        }
        if (datastoreValue instanceof String) {
            TypeConverter converter2 = ec.getTypeManager().getTypeConverterForType(javaType, String.class);
            if (converter2 != null) {
                return converter2.toMemberType((Object)((String)datastoreValue));
            }
        } else if (datastoreValue instanceof Long) {
            TypeConverter converter3 = ec.getTypeManager().getTypeConverterForType(javaType, Long.class);
            if (converter3 != null) {
                return converter3.toMemberType((Object)((Long)datastoreValue));
            }
        } else if (datastoreValue instanceof Integer && (converter = ec.getTypeManager().getTypeConverterForType(javaType, Integer.class)) != null) {
            return converter.toMemberType((Object)((Integer)datastoreValue));
        }
        return datastoreValue;
    }

    public static String getCassandraTypeForNonPersistableType(Class type, boolean serialised, TypeManager typeMgr, String jdbcType) {
        String cTypeName = cassandraTypeByJavaType.get(type.getName());
        if (cTypeName != null) {
            return cTypeName;
        }
        if (serialised && Serializable.class.isAssignableFrom(type)) {
            return "blob";
        }
        if (Enum.class.isAssignableFrom(type)) {
            if (jdbcType != null && jdbcType.equalsIgnoreCase("varchar")) {
                return "varchar";
            }
            return "int";
        }
        TypeConverter stringConverter = typeMgr.getTypeConverterForType(type, String.class);
        if (stringConverter != null) {
            return "varchar";
        }
        TypeConverter longConverter = typeMgr.getTypeConverterForType(type, Long.class);
        if (longConverter != null) {
            return "bigint";
        }
        TypeConverter intConverter = typeMgr.getTypeConverterForType(type, Integer.class);
        if (intConverter != null) {
            return "int";
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return "blob";
        }
        return "varchar";
    }

    public static Object getDatastoreValueForNonPersistableValue(Object value, String datastoreType, boolean serialised, TypeManager typeMgr) {
        TypeConverter stringConverter;
        if (value == null) {
            return value;
        }
        if (serialised && value instanceof Serializable) {
            TypeConverter serialConv = typeMgr.getTypeConverterForType(Serializable.class, ByteBuffer.class);
            return serialConv.toDatastoreType(value);
        }
        if (value.getClass() == Character.class) {
            return "" + value;
        }
        if (value.getClass() == Byte.class) {
            return ((Byte)value).intValue();
        }
        if (value.getClass() == Short.class) {
            return ((Short)value).intValue();
        }
        if (value.getClass() == Float.class) {
            if (datastoreType.equals("decimal")) {
                return BigDecimal.valueOf(((Float)value).floatValue());
            }
            if (datastoreType.equals("double")) {
                return (double)((Float)value).floatValue();
            }
            return value;
        }
        if (value.getClass() == Double.class) {
            if (datastoreType.equals("decimal")) {
                return BigDecimal.valueOf((Double)value);
            }
            return value;
        }
        if (ClassUtils.isPrimitiveWrapperType((String)value.getClass().getName())) {
            return value;
        }
        if (value.getClass() == BigInteger.class) {
            return ((BigInteger)value).longValue();
        }
        if (value.getClass() == BigDecimal.class) {
            return value;
        }
        if (value instanceof Enum) {
            if (datastoreType.equals("varchar")) {
                return ((Enum)value).name();
            }
            return ((Enum)value).ordinal();
        }
        if (value instanceof Calendar) {
            TypeConverter stringConverter2;
            if (datastoreType.equals("varchar") && (stringConverter2 = typeMgr.getTypeConverterForType(Calendar.class, String.class)) != null) {
                return stringConverter2.toDatastoreType(value);
            }
            return ((Calendar)value).getTime();
        }
        if (value instanceof java.util.Date) {
            if (datastoreType.equals("varchar")) {
                Class<java.util.Date> valueType = java.util.Date.class;
                if (value instanceof Time) {
                    valueType = Time.class;
                } else if (value instanceof Date) {
                    valueType = Date.class;
                } else if (value instanceof Timestamp) {
                    valueType = Timestamp.class;
                }
                TypeConverter stringConverter3 = typeMgr.getTypeConverterForType(valueType, String.class);
                if (stringConverter3 != null) {
                    return stringConverter3.toDatastoreType(value);
                }
            }
            return value;
        }
        if (value instanceof TimeZone ? (stringConverter = typeMgr.getTypeConverterForType(TimeZone.class, String.class)) != null : value instanceof Locale && (stringConverter = typeMgr.getTypeConverterForType(Locale.class, String.class)) != null) {
            return stringConverter.toDatastoreType(value);
        }
        stringConverter = typeMgr.getTypeConverterForType(value.getClass(), String.class);
        if (stringConverter != null) {
            return stringConverter.toDatastoreType(value);
        }
        TypeConverter longConverter = typeMgr.getTypeConverterForType(value.getClass(), Long.class);
        if (longConverter != null) {
            return longConverter.toDatastoreType(value);
        }
        return value;
    }

    public static Object getPojoForRowForCandidate(Row row, AbstractClassMetaData cmd, ExecutionContext ec, int[] fpMembers, boolean ignoreCache) {
        if (cmd.hasDiscriminatorStrategy()) {
            // empty if block
        }
        Object pojo = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            pojo = CassandraUtils.getObjectUsingApplicationIdForRow(row, cmd, ec, ignoreCache, fpMembers);
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pojo = CassandraUtils.getObjectUsingDatastoreIdForRow(row, cmd, ec, ignoreCache, fpMembers);
        } else {
            throw new NucleusUserException("Attempt to get candidate for class " + cmd.getFullClassName() + " but uses nondurable-identity and this is not supported by this datastore");
        }
        return pojo;
    }

    private static Object getObjectUsingApplicationIdForRow(Row row, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Table table = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        final FetchFieldManager fm = new FetchFieldManager(ec, row, cmd, table);
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)fm);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider op = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = op.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = table.getVersionColumn().getTypeName().equals("int") ? (Number)row.getInt(table.getVersionColumn().getName()) : (Number)row.getLong(table.getVersionColumn().getName());
            }
            op.setVersion(version);
        }
        return pc;
    }

    private static Object getObjectUsingDatastoreIdForRow(Row row, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Object idKey = null;
        StoreManager storeMgr = ec.getStoreManager();
        Table table = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        if (!storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
            Column col = table.getDatastoreIdColumn();
            idKey = col.getTypeName().equals("varchar") ? row.getString(col.getName()) : Long.valueOf(row.getLong(col.getName()));
        }
        final FetchFieldManager fm = new FetchFieldManager(ec, row, cmd, table);
        DatastoreId id = ec.getNucleusContext().getIdentityManager().getDatastoreId(cmd.getFullClassName(), idKey);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider op = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = op.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = table.getVersionColumn().getTypeName().equals("int") ? (Number)row.getInt(table.getVersionColumn().getName()) : (Number)row.getLong(table.getVersionColumn().getName());
            }
            op.setVersion(version);
        }
        return pc;
    }

    public static void logCqlStatement(String stmt, Object[] values, NucleusLogger logger) {
        if (values == null || values.length == 0) {
            logger.debug((Object)stmt);
            return;
        }
        StringBuilder str = new StringBuilder();
        int paramNo = 0;
        int currentPos = 0;
        boolean moreParams = true;
        while (moreParams) {
            int pos = stmt.indexOf(63, currentPos);
            if (pos > 0) {
                str.append(stmt.substring(currentPos, pos));
                str.append('<').append("" + values[paramNo]).append('>');
                ++paramNo;
                currentPos = pos + 1;
                continue;
            }
            moreParams = false;
        }
        str.append(stmt.substring(currentPos));
        logger.debug((Object)str.toString());
    }

    static {
        cassandraTypeByJavaType.put(Boolean.TYPE.getName(), "boolean");
        cassandraTypeByJavaType.put(Byte.TYPE.getName(), "int");
        cassandraTypeByJavaType.put(Character.TYPE.getName(), "varchar");
        cassandraTypeByJavaType.put(Double.TYPE.getName(), "double");
        cassandraTypeByJavaType.put(Float.TYPE.getName(), "float");
        cassandraTypeByJavaType.put(Integer.TYPE.getName(), "int");
        cassandraTypeByJavaType.put(Long.TYPE.getName(), "bigint");
        cassandraTypeByJavaType.put(Short.TYPE.getName(), "int");
        cassandraTypeByJavaType.put(Boolean.class.getName(), "boolean");
        cassandraTypeByJavaType.put(Byte.class.getName(), "int");
        cassandraTypeByJavaType.put(Character.class.getName(), "varchar");
        cassandraTypeByJavaType.put(Double.class.getName(), "double");
        cassandraTypeByJavaType.put(Float.class.getName(), "float");
        cassandraTypeByJavaType.put(Integer.class.getName(), "int");
        cassandraTypeByJavaType.put(Long.class.getName(), "bigint");
        cassandraTypeByJavaType.put(Short.class.getName(), "int");
        cassandraTypeByJavaType.put(String.class.getName(), "varchar");
        cassandraTypeByJavaType.put(BigDecimal.class.getName(), "decimal");
        cassandraTypeByJavaType.put(BigInteger.class.getName(), "bigint");
        cassandraTypeByJavaType.put(java.util.Date.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(Time.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(Date.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(Timestamp.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(Calendar.class.getName(), "timestamp");
        cassandraTypeByJavaType.put(TimeZone.class.getName(), "varchar");
        cassandraTypeByJavaType.put(Locale.class.getName(), "varchar");
        datastoreTypeByCassandraType.put("timestamp", java.util.Date.class);
        datastoreTypeByCassandraType.put("boolean", Boolean.class);
        datastoreTypeByCassandraType.put("int", Integer.class);
        datastoreTypeByCassandraType.put("double", Double.class);
        datastoreTypeByCassandraType.put("float", Float.class);
        datastoreTypeByCassandraType.put("bigint", Long.class);
        datastoreTypeByCassandraType.put("varchar", String.class);
        datastoreTypeByCassandraType.put("blob", ByteBuffer.class);
    }
}

