/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.valuegenerator;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.cassandra.CassandraSchemaHandler;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.SessionStatementProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.util.NucleusLogger;

public class IncrementGenerator
extends AbstractDatastoreGenerator<Long> {
    static final String INCREMENT_COL_NAME = "increment";
    private String key = this.properties.getProperty("sequence-name") != null ? this.properties.getProperty("sequence-name") : (this.properties.containsKey("field-name") ? this.properties.getProperty("field-name") : this.properties.getProperty("root-class-name"));
    private String schemaName = null;
    private String tableName = "incrementtable";
    private String keyColName = "key";
    private String valColName = "value";

    public IncrementGenerator(String name, Properties props) {
        super(name, props);
        if (this.properties.getProperty("sequence-table-name") != null) {
            this.tableName = this.properties.getProperty("sequence-table-name");
        }
        if (this.properties.getProperty("sequence-name-column-name") != null) {
            this.keyColName = this.properties.getProperty("sequence-name-column-name");
        }
        if (this.properties.getProperty("sequence-nextval-column-name") != null) {
            this.valColName = this.properties.getProperty("sequence-nextval-column-name");
        }
        this.allocationSize = this.properties.containsKey("key-cache-size") ? Integer.valueOf(this.properties.getProperty("key-cache-size")) : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueGenerationBlock<Long> reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        if (!this.repositoryExists) {
            this.createRepository();
        }
        ArrayList<Long> oids = new ArrayList<Long>();
        ManagedConnection mconn = this.connectionProvider.retrieveConnection();
        try {
            Session session = (Session)mconn.getConnection();
            StringBuilder stmtBuilder = new StringBuilder("SELECT ");
            stmtBuilder.append(this.valColName).append(" FROM ").append(this.getSchemaName()).append('.').append(this.tableName).append(" WHERE ").append(this.keyColName).append("=?");
            NucleusLogger.VALUEGENERATION.debug((Object)("Getting current value for increment strategy for key=" + this.key + " : " + stmtBuilder.toString()));
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
            PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
            ResultSet rs = session.execute((Statement)stmt.bind(new Object[]{this.key}));
            if (rs.isExhausted()) {
                long initialValue = 0L;
                if (this.properties.containsKey("key-initial-value")) {
                    initialValue = Long.valueOf(this.properties.getProperty("key-initial-value"));
                }
                stmtBuilder = new StringBuilder("INSERT INTO ");
                stmtBuilder.append(this.getSchemaName()).append('.').append(this.tableName).append("(").append(this.keyColName).append(',').append(this.valColName).append(") VALUES(?,?)");
                NucleusLogger.VALUEGENERATION.debug((Object)("Setting value for increment strategy for key=" + this.key + " val=" + (initialValue + size + 1L) + " : " + stmtBuilder.toString()));
                stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
                session.execute((Statement)stmt.bind(new Object[]{this.key, initialValue + size + 1L}));
                int i = 0;
                while ((long)i < size) {
                    oids.add(initialValue + (long)i);
                    ++i;
                }
            } else {
                Row row = rs.one();
                long val = row.getLong(this.valColName.toLowerCase());
                stmtBuilder = new StringBuilder("INSERT INTO ");
                stmtBuilder.append(this.getSchemaName()).append('.').append(this.tableName).append("(").append(this.keyColName).append(',').append(this.valColName).append(") VALUES(?,?)");
                NucleusLogger.VALUEGENERATION.debug((Object)("Setting next value for increment strategy for key=" + this.key + " val=" + (val + size) + " : " + stmtBuilder.toString()));
                stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
                session.execute((Statement)stmt.bind(new Object[]{this.key, val + size}));
                int i = 0;
                while ((long)i < size) {
                    oids.add(val + (long)i);
                    ++i;
                }
            }
        }
        finally {
            this.connectionProvider.releaseConnection();
        }
        return new ValueGenerationBlock(oids);
    }

    protected String getSchemaName() {
        if (this.schemaName != null) {
            return this.schemaName;
        }
        this.schemaName = this.properties.getProperty("schema-name");
        if (this.schemaName == null) {
            this.schemaName = this.storeMgr.getStringProperty("datanucleus.mapping.Schema");
        }
        return this.schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createRepository() {
        block7: {
            if (this.repositoryExists) {
                return true;
            }
            ManagedConnection mconn = this.connectionProvider.retrieveConnection();
            try {
                Session session = (Session)mconn.getConnection();
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
                if (CassandraSchemaHandler.checkTableExistence(session, stmtProvider, this.getSchemaName(), this.tableName)) {
                    this.repositoryExists = true;
                    boolean bl = true;
                    return bl;
                }
                if (this.storeMgr.getSchemaHandler().isAutoCreateTables()) {
                    StringBuilder stmtBuilder = new StringBuilder("CREATE TABLE ");
                    stmtBuilder.append(this.getSchemaName()).append('.').append(this.tableName).append("(");
                    stmtBuilder.append(this.keyColName).append(" varchar,").append(this.valColName).append(" bigint,PRIMARY KEY(").append(this.keyColName).append(")");
                    stmtBuilder.append(")");
                    NucleusLogger.VALUEGENERATION.debug((Object)("Creating value generator table : " + stmtBuilder.toString()));
                    session.execute(stmtBuilder.toString());
                    this.repositoryExists = true;
                    break block7;
                }
                throw new NucleusUserException("Table for increment strategy doesn't exist, but autoCreateTables is set to false. Set it to true");
            }
            finally {
                this.connectionProvider.releaseConnection();
            }
        }
        return true;
    }
}

