/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.fieldmanager;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected Table table;
    protected Map<String, Object> columnValueByName = new HashMap<String, Object>();

    public StoreFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, boolean insert, Table table) {
        super(ec, cmd, insert);
        this.table = table;
    }

    public StoreFieldManager(ObjectProvider op, boolean insert, Table table) {
        super(op, insert);
        this.table = table;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public Map<String, Object> getColumnValueByName() {
        return this.columnValueByName;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), "" + value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column column = this.getColumnMapping(fieldNumber).getColumn(0);
        if (column.getJdbcType() == JdbcType.DECIMAL) {
            this.columnValueByName.put(column.getIdentifier(), BigDecimal.valueOf(value));
        } else if (column.getJdbcType() == JdbcType.DOUBLE) {
            this.columnValueByName.put(column.getIdentifier(), value);
        } else {
            this.columnValueByName.put(column.getIdentifier(), Float.valueOf(value));
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column column = this.getColumnMapping(fieldNumber).getColumn(0);
        if (column.getJdbcType() == JdbcType.DECIMAL) {
            this.columnValueByName.put(column.getIdentifier(), BigDecimal.valueOf(value));
        } else {
            this.columnValueByName.put(column.getIdentifier(), value);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        ClassLoaderResolver clr;
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr = this.ec.getClassLoaderResolver());
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                if (value == null) {
                    StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.insert, embMmds, this.table);
                    for (int i = 0; i < embMmdPosns.length; ++i) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                        if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                            ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                            colEmbMmds.add(embMmd);
                            MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                            for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                                this.columnValueByName.put(mapping.getColumn(j).getIdentifier(), null);
                            }
                            continue;
                        }
                        if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                        storeEmbFM.storeObjectField(embMmdPosns[i], null);
                    }
                    Map<String, Object> embColValuesByName = storeEmbFM.getColumnValueByName();
                    this.columnValueByName.putAll(embColValuesByName);
                    return;
                }
                ObjectProvider embOP = this.ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(embOP, this.insert, embMmds, this.table);
                embOP.provideFields(embMmdPosns, (FieldManager)storeEmbFM);
                Map<String, Object> embColValuesByName = storeEmbFM.getColumnValueByName();
                this.columnValueByName.putAll(embColValuesByName);
                return;
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                NucleusLogger.PERSISTENCE.warn((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded), storing as null"));
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), null);
                return;
            }
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }

    protected void storeNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr, Object value) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (value == null) {
            for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                this.columnValueByName.put(mapping.getColumn(i).getIdentifier(), null);
            }
            return;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if ((this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) && !this.ec.getApiAdapter().isDetached(value) && !this.ec.getApiAdapter().isPersistent(value)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("007006", (Object)mmd.getFullFieldName()));
                }
                throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
            }
            Object valuePC = this.ec.persistObjectInternal(value, this.op, fieldNumber, -1);
            Object valueID = this.ec.getApiAdapter().getIdForObject(valuePC);
            if (mmd.isSerialized()) {
                throw new NucleusUserException("Don't currently support serialised PC fields at " + mmd.getFullFieldName() + ". Dont serialise it");
            }
            this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), IdentityUtils.getPersistableIdentityForId((Object)valueID));
            return;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (mmd.hasCollection()) {
                Collection coll = (Collection)value;
                if (this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("007006", (Object)mmd.getFullFieldName()));
                    }
                    for (Object element : coll) {
                        if (this.ec.getApiAdapter().isDetached(element) || this.ec.getApiAdapter().isPersistent(element)) continue;
                        throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), element);
                    }
                }
                AbstractCollection cassColl = value instanceof List || value instanceof Queue ? new ArrayList() : new HashSet();
                for (Object element : coll) {
                    if (element != null) {
                        Object elementPC = this.ec.persistObjectInternal(element, this.op, fieldNumber, -1);
                        Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                        if (mmd.getCollection().isSerializedElement()) {
                            throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName() + ". Serialise the whole field");
                        }
                        cassColl.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                        continue;
                    }
                    cassColl.add("NULL");
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), cassColl);
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
                return;
            }
            if (mmd.hasMap()) {
                HashMap idMap = new HashMap();
                Map map = (Map)value;
                Iterator entryIter = map.entrySet().iterator();
                String keyCassType = null;
                if (!mmd.getMap().keyIsPersistent()) {
                    Class keyCls = clr.classForName(mmd.getMap().getKeyType());
                    keyCassType = CassandraUtils.getCassandraTypeForNonPersistableType(keyCls, false, this.ec.getTypeManager(), null);
                }
                String valCassType = null;
                if (!mmd.getMap().valueIsPersistent()) {
                    Class valCls = clr.classForName(mmd.getMap().getValueType());
                    valCassType = CassandraUtils.getCassandraTypeForNonPersistableType(valCls, false, this.ec.getTypeManager(), null);
                }
                while (entryIter.hasNext()) {
                    Map.Entry entry = entryIter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (mmd.getMap().keyIsPersistent()) {
                        Object keyPC = this.ec.persistObjectInternal(key, this.op, fieldNumber, -1);
                        Object keyID = this.ec.getApiAdapter().getIdForObject(keyPC);
                        if (mmd.getMap().isSerializedKey()) {
                            throw new NucleusUserException("Don't currently support serialised map keys at " + mmd.getFullFieldName() + ". Serialise the whole field");
                        }
                        key = IdentityUtils.getPersistableIdentityForId((Object)keyID);
                    } else {
                        key = CassandraUtils.getDatastoreValueForNonPersistableValue(key, keyCassType, false, this.ec.getTypeManager());
                    }
                    if (mmd.getMap().valueIsPersistent()) {
                        if (val != null) {
                            Object valPC = this.ec.persistObjectInternal(val, this.op, fieldNumber, -1);
                            Object valID = this.ec.getApiAdapter().getIdForObject(valPC);
                            if (mmd.getMap().isSerializedValue()) {
                                throw new NucleusUserException("Don't currently support serialised map values at " + mmd.getFullFieldName() + ". Serialise the whole field");
                            }
                            val = IdentityUtils.getPersistableIdentityForId((Object)valID);
                        } else {
                            val = "NULL";
                        }
                    } else {
                        val = CassandraUtils.getDatastoreValueForNonPersistableValue(val, valCassType, false, this.ec.getTypeManager());
                    }
                    idMap.put(key, val);
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), idMap);
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
                return;
            }
            if (mmd.hasArray()) {
                ArrayList<String> cassColl = new ArrayList<String>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (mmd.getArray().isSerializedElement()) {
                        throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName() + ". Serialise the whole field");
                    }
                    Object element = Array.get(value, i);
                    if (element != null) {
                        Object elementPC = this.ec.persistObjectInternal(element, null, -1, -1);
                        Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                        cassColl.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                        continue;
                    }
                    cassColl.add("NULL");
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), cassColl);
                return;
            }
        } else {
            if (mapping.getTypeConverter() != null) {
                Object datastoreValue = mapping.getTypeConverter().toDatastoreType(value);
                if (mapping.getNumberOfColumns() > 1) {
                    for (int i = 0; i < Array.getLength(datastoreValue); ++i) {
                        this.columnValueByName.put(mapping.getColumn(i).getIdentifier(), Array.get(datastoreValue, i));
                    }
                } else {
                    this.columnValueByName.put(mapping.getColumn(0).getIdentifier(), datastoreValue);
                }
                return;
            }
            if (mmd.hasCollection()) {
                Collection coll = (Collection)value;
                if (coll.size() == 0) {
                    this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), null);
                    return;
                }
                AbstractCollection cassColl = null;
                cassColl = value instanceof List || value instanceof Queue ? new ArrayList() : new HashSet();
                Class elemCls = clr.classForName(mmd.getCollection().getElementType());
                String elemCassType = CassandraUtils.getCassandraTypeForNonPersistableType(elemCls, false, this.ec.getTypeManager(), null);
                for (Object element : coll) {
                    cassColl.add(CassandraUtils.getDatastoreValueForNonPersistableValue(element, elemCassType, false, this.ec.getTypeManager()));
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), cassColl);
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
                return;
            }
            if (mmd.hasMap()) {
                HashMap cassMap = new HashMap();
                Map map = (Map)value;
                if (map.size() == 0) {
                    this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), null);
                    return;
                }
                Iterator entryIter = map.entrySet().iterator();
                Class keyCls = clr.classForName(mmd.getMap().getKeyType());
                String keyCassType = CassandraUtils.getCassandraTypeForNonPersistableType(keyCls, false, this.ec.getTypeManager(), null);
                Class valCls = clr.classForName(mmd.getMap().getValueType());
                String valCassType = CassandraUtils.getCassandraTypeForNonPersistableType(valCls, false, this.ec.getTypeManager(), null);
                while (entryIter.hasNext()) {
                    Map.Entry entry = entryIter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    key = CassandraUtils.getDatastoreValueForNonPersistableValue(key, keyCassType, false, this.ec.getTypeManager());
                    val = CassandraUtils.getDatastoreValueForNonPersistableValue(val, valCassType, false, this.ec.getTypeManager());
                    cassMap.put(key, val);
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), cassMap);
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
                return;
            }
            if (mmd.hasArray()) {
                if (Array.getLength(value) == 0) {
                    this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), null);
                    return;
                }
                if (mmd.isSerialized()) {
                    String cassandraType = mapping.getColumn(0).getTypeName();
                    Object datastoreValue = CassandraUtils.getDatastoreValueForNonPersistableValue(value, cassandraType, mmd.isSerialized(), this.ec.getTypeManager());
                    this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), datastoreValue);
                    return;
                }
                ArrayList<Object> cassArr = new ArrayList<Object>();
                Class elemCls = clr.classForName(mmd.getArray().getElementType());
                String elemCassType = CassandraUtils.getCassandraTypeForNonPersistableType(elemCls, false, this.ec.getTypeManager(), null);
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (mmd.getArray().isSerializedElement()) {
                        throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName() + ". Serialise the whole field");
                    }
                    Object element = Array.get(value, i);
                    if (element == null) continue;
                    cassArr.add(CassandraUtils.getDatastoreValueForNonPersistableValue(element, elemCassType, false, this.ec.getTypeManager()));
                }
                this.columnValueByName.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), cassArr);
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
                return;
            }
            String cassandraType = mapping.getColumn(0).getTypeName();
            Object datastoreValue = CassandraUtils.getDatastoreValueForNonPersistableValue(value, cassandraType, mmd.isSerialized(), this.ec.getTypeManager());
            if (datastoreValue != null) {
                this.columnValueByName.put(mapping.getColumn(0).getIdentifier(), datastoreValue);
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
                return;
            }
        }
        NucleusLogger.PERSISTENCE.warn((Object)("Not generated persistable value for field " + mmd.getFullFieldName() + " so putting null"));
        this.columnValueByName.put(mapping.getColumn(0).getIdentifier(), null);
    }
}

