/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.SchemaVerifierImpl;
import org.datanucleus.store.cassandra.SessionStatementProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SchemaVerifier;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CassandraSchemaHandler
extends AbstractStoreSchemaHandler {
    protected static final Localiser LOCALISER_CASSANDRA = Localiser.getInstance((String)"org.datanucleus.store.cassandra.Localisation", (ClassLoader)CassandraStoreManager.class.getClassLoader());
    CassandraStoreManager casStoreMgr;

    public CassandraSchemaHandler(CassandraStoreManager storeMgr) {
        super((StoreManager)storeMgr);
        this.casStoreMgr = storeMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(String schemaName, Properties props, Object connection) {
        Session session = (Session)connection;
        ManagedConnection mconn = null;
        try {
            Boolean durable;
            if (session == null) {
                mconn = this.storeMgr.getConnection(-1);
                session = (Session)mconn.getConnection();
            }
            StringBuilder stmtBuilder = new StringBuilder("CREATE KEYSPACE IF NOT EXISTS ");
            stmtBuilder.append(schemaName).append(" WITH ");
            String replicationProp = props != null ? (String)props.get("replication") : "{'class': 'SimpleStrategy', 'replication_factor' : 3}";
            stmtBuilder.append("replication = ").append(replicationProp);
            if (props != null && props.containsKey("durable_writes") && !(durable = Boolean.valueOf((String)props.get("durable_writes"))).booleanValue()) {
                stmtBuilder.append(" AND durable_writes=false");
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CreateSchema", (Object)stmtBuilder.toString()));
            session.execute(stmtBuilder.toString());
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CreateSchema.Success"));
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        Session session = (Session)connection;
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        OutputStreamWriter ddlFileWriter = null;
        try {
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
            }
            ManagedConnection mconn = null;
            try {
                if (session == null) {
                    mconn = this.storeMgr.getConnection(-1);
                    session = (Session)mconn.getConnection();
                }
                ArrayList<String> tableStmts = new ArrayList<String>();
                ArrayList<String> constraintStmts = new ArrayList<String>();
                Iterator<String> classIter = classNames.iterator();
                ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
                while (classIter.hasNext()) {
                    String className = classIter.next();
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                    if (cmd == null) continue;
                    this.createSchemaForClass(cmd, session, clr, tableStmts, constraintStmts);
                }
                if (!tableStmts.isEmpty()) {
                    for (String stmt : tableStmts) {
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CreateTable", (Object)stmt));
                            session.execute(stmt);
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CreateTable.Success"));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmt + ";\n");
                        }
                        catch (IOException ioe) {}
                    }
                }
                if (!constraintStmts.isEmpty()) {
                    for (String stmt : constraintStmts) {
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CreateConstraint", (Object)stmt));
                            session.execute(stmt);
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CreateConstraint.Success"));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmt + ";\n");
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            finally {
                if (mconn != null) {
                    mconn.release();
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ddlFileWriter != null) {
                try {
                    ddlFileWriter.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createSchemaForClass(AbstractClassMetaData cmd, Session session, ClassLoaderResolver clr, List<String> tableStmts, List<String> constraintStmts) {
        DiscriminatorMetaData dismd;
        String indexStmt;
        String idxName;
        Column column;
        VersionMetaData vermd;
        void var7_10;
        if (cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return;
        }
        if (cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) {
            return;
        }
        StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object var7_7 = null;
        if (storeData != null) {
            Table table = (Table)storeData.getProperties().get("tableObject");
        } else {
            CompleteClassTable completeClassTable = new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
        }
        String schemaName = var7_10.getSchemaName();
        SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
        if (CassandraSchemaHandler.checkTableExistence(session, stmtProvider, schemaName, var7_10.getIdentifier())) {
            DiscriminatorMetaData dismd2;
            String indexStmt2;
            String idxName2;
            ColumnDetails colDetails;
            Column column2;
            VersionMetaData vermd2;
            StringBuilder stmtBuilder;
            Map<String, ColumnDetails> tableStructure = this.getColumnDetailsForTable(session, stmtProvider, schemaName, var7_10.getIdentifier());
            if (this.autoCreateColumns) {
                List columns = var7_10.getColumns();
                for (Column column3 : columns) {
                    ColumnDetails colDetails2 = this.getColumnDetailsForColumn(column3, tableStructure);
                    if (colDetails2 == null) {
                        stmtBuilder = new StringBuilder("ALTER TABLE ");
                        if (schemaName != null) {
                            stmtBuilder.append(schemaName).append('.');
                        }
                        stmtBuilder.append(var7_10.getIdentifier());
                        stmtBuilder.append(" ADD COLUMN ");
                        stmtBuilder.append(column3.getIdentifier()).append(" ").append(column3.getTypeName());
                        tableStmts.add(stmtBuilder.toString());
                        continue;
                    }
                    if (colDetails2.typeName == null || colDetails2.typeName.equals(column3.getTypeName())) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.TableColumnTypeIncorrect", (Object)var7_10.getIdentifier(), (Object)column3.getIdentifier(), (Object)colDetails2.typeName, (Object)column3.getTypeName()));
                }
            }
            if (this.autoDeleteColumns) {
                for (Map.Entry<String, ColumnDetails> entry : tableStructure.entrySet()) {
                    String colName = entry.getKey();
                    Column col = var7_10.getColumnForName(colName);
                    if (col != null) continue;
                    stmtBuilder = new StringBuilder("ALTER TABLE ");
                    if (schemaName != null) {
                        stmtBuilder.append(schemaName).append('.');
                    }
                    stmtBuilder.append(var7_10.getIdentifier());
                    stmtBuilder.append(" DROP COLUMN ");
                    stmtBuilder.append(colName);
                    tableStmts.add(stmtBuilder.toString());
                }
            }
            if (!this.isAutoCreateConstraints()) return;
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                IndexMetaData[] clsIdxMds = theCmd.getIndexMetaData();
                if (clsIdxMds == null) continue;
                for (int i = 0; i < clsIdxMds.length; ++i) {
                    IndexMetaData idxmd = clsIdxMds[i];
                    String[] colNames = idxmd.getColumnNames();
                    if (colNames.length > 1) {
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexForClassWithMultipleColumns", (Object)theCmd.getFullClassName()));
                        continue;
                    }
                    ColumnDetails colDetails3 = tableStructure.get(colNames[0]);
                    String idxName3 = namingFactory.getIndexName(theCmd, idxmd, i);
                    if (colDetails3 == null) {
                        String indexStmt3 = this.createIndexCQL(idxName3, schemaName, var7_10.getIdentifier(), colNames[0]);
                        constraintStmts.add(indexStmt3);
                        continue;
                    }
                    if (idxName3.equals(colDetails3.indexName)) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexHasWrongName", (Object)idxName3, (Object)colDetails3.indexName));
                }
            }
            Set mappings = var7_10.getMemberColumnMappings();
            for (MemberColumnMapping mapping : mappings) {
                IndexMetaData idxmd = mapping.getMemberMetaData().getIndexMetaData();
                if (idxmd == null) continue;
                String[] colNames = idxmd.getColumnNames();
                if (colNames.length > 1) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexForMemberWithMultipleColumns", (Object)mapping.getMemberMetaData().getFullFieldName()));
                    continue;
                }
                if (mapping.getNumberOfColumns() != 1) continue;
                Column column4 = mapping.getColumn(0);
                ColumnDetails colDetails4 = this.getColumnDetailsForColumn(column4, tableStructure);
                String idxName4 = namingFactory.getIndexName(mapping.getMemberMetaData(), idxmd);
                if (colDetails4 == null) {
                    String indexStmt4 = this.createIndexCQL(idxName4, schemaName, var7_10.getIdentifier(), column4.getIdentifier());
                    constraintStmts.add(indexStmt4);
                    continue;
                }
                if (idxName4.equals(colDetails4.indexName)) continue;
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexHasWrongName", (Object)idxName4, (Object)colDetails4.indexName));
            }
            if (cmd.isVersioned() && cmd.getVersionMetaDataForClass() != null && cmd.getVersionMetaDataForClass().getFieldName() == null && (vermd2 = cmd.getVersionMetaDataForClass()).getIndexMetaData() != null) {
                column2 = var7_10.getVersionColumn();
                colDetails = this.getColumnDetailsForColumn(column2, tableStructure);
                if (colDetails == null) {
                    idxName2 = namingFactory.getIndexName(cmd, vermd2.getIndexMetaData(), ColumnType.VERSION_COLUMN);
                    indexStmt2 = this.createIndexCQL(idxName2, schemaName, var7_10.getIdentifier(), column2.getIdentifier());
                    constraintStmts.add(indexStmt2);
                } else {
                    idxName2 = namingFactory.getIndexName(cmd, vermd2.getIndexMetaData(), ColumnType.VERSION_COLUMN);
                    if (!idxName2.equals(colDetails.indexName)) {
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexHasWrongName", (Object)idxName2, (Object)colDetails.indexName));
                    }
                }
            }
            if (cmd.hasDiscriminatorStrategy() && (dismd2 = cmd.getDiscriminatorMetaData()).getIndexMetaData() != null) {
                column2 = var7_10.getDiscriminatorColumn();
                colDetails = this.getColumnDetailsForColumn(column2, tableStructure);
                if (colDetails == null) {
                    idxName2 = namingFactory.getIndexName(cmd, dismd2.getIndexMetaData(), ColumnType.DISCRIMINATOR_COLUMN);
                    indexStmt2 = this.createIndexCQL(idxName2, schemaName, var7_10.getIdentifier(), column2.getIdentifier());
                    constraintStmts.add(indexStmt2);
                } else {
                    idxName2 = namingFactory.getIndexName(cmd, dismd2.getIndexMetaData(), ColumnType.DISCRIMINATOR_COLUMN);
                    if (!idxName2.equals(colDetails.indexName)) {
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexHasWrongName", (Object)idxName2, (Object)colDetails.indexName));
                    }
                }
            }
            if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && "true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) return;
        }
        if (this.isAutoCreateTables()) {
            StringBuilder stmtBuilder = new StringBuilder("CREATE TABLE ");
            if (schemaName != null) {
                stmtBuilder.append(schemaName).append('.');
            }
            stmtBuilder.append(var7_10.getIdentifier());
            stmtBuilder.append(" (");
            ArrayList<String> pkColNames = new ArrayList<String>();
            for (Column column5 : var7_10.getColumns()) {
                stmtBuilder.append(column5.getIdentifier()).append(' ').append(column5.getTypeName()).append(',');
                if (!column5.isPrimaryKey()) continue;
                pkColNames.add(column5.getIdentifier());
            }
            stmtBuilder.append(" PRIMARY KEY (");
            Iterator pkColNameIter = pkColNames.iterator();
            while (pkColNameIter.hasNext()) {
                stmtBuilder.append((String)pkColNameIter.next());
                if (!pkColNameIter.hasNext()) continue;
                stmtBuilder.append(',');
            }
            stmtBuilder.append(")");
            stmtBuilder.append(")");
            tableStmts.add(stmtBuilder.toString());
        }
        if (!this.isAutoCreateConstraints()) return;
        NamingFactory namingFactory = this.storeMgr.getNamingFactory();
        for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
            IndexMetaData[] clsIdxMds = theCmd.getIndexMetaData();
            if (clsIdxMds == null) continue;
            for (int i = 0; i < clsIdxMds.length; ++i) {
                IndexMetaData idxmd = clsIdxMds[i];
                String[] colNames = idxmd.getColumnNames();
                if (colNames.length > 1) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexForClassWithMultipleColumns", (Object)theCmd.getFullClassName()));
                    continue;
                }
                String idxName5 = namingFactory.getIndexName(theCmd, idxmd, i);
                String indexStmt5 = this.createIndexCQL(idxName5, schemaName, var7_10.getIdentifier(), colNames[0]);
                constraintStmts.add(indexStmt5);
            }
        }
        Set mappings = var7_10.getMemberColumnMappings();
        for (MemberColumnMapping mapping : mappings) {
            AbstractMemberMetaData mmd = mapping.getMemberMetaData();
            IndexMetaData idxmd = mmd.getIndexMetaData();
            if (idxmd == null || mapping.getNumberOfColumns() != 1) continue;
            String idxName6 = namingFactory.getIndexName(mmd, idxmd);
            String indexStmt6 = this.createIndexCQL(idxName6, schemaName, var7_10.getIdentifier(), mapping.getColumn(0).getIdentifier());
            constraintStmts.add(indexStmt6);
        }
        if (cmd.isVersioned() && cmd.getVersionMetaDataForClass() != null && cmd.getVersionMetaDataForClass().getFieldName() == null && (vermd = cmd.getVersionMetaDataForClass()).getIndexMetaData() != null) {
            column = var7_10.getVersionColumn();
            idxName = namingFactory.getIndexName(cmd, vermd.getIndexMetaData(), ColumnType.VERSION_COLUMN);
            indexStmt = this.createIndexCQL(idxName, schemaName, var7_10.getIdentifier(), column.getIdentifier());
            constraintStmts.add(indexStmt);
        }
        if (cmd.hasDiscriminatorStrategy() && (dismd = cmd.getDiscriminatorMetaData()).getIndexMetaData() != null) {
            column = var7_10.getDiscriminatorColumn();
            idxName = namingFactory.getIndexName(cmd, dismd.getIndexMetaData(), ColumnType.DISCRIMINATOR_COLUMN);
            indexStmt = this.createIndexCQL(idxName, schemaName, var7_10.getIdentifier(), column.getIdentifier());
            constraintStmts.add(indexStmt);
        }
        if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && "true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(String schemaName, Properties props, Object connection) {
        Session session = (Session)connection;
        ManagedConnection mconn = null;
        try {
            if (session == null) {
                mconn = this.storeMgr.getConnection(-1);
                session = (Session)mconn.getConnection();
            }
            StringBuilder stmtBuilder = new StringBuilder("DROP KEYSPACE IF EXISTS ");
            stmtBuilder.append(schemaName);
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropSchema", (Object)stmtBuilder.toString()));
            session.execute(stmtBuilder.toString());
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropSchema", (Object)schemaName));
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        Session session = (Session)connection;
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        OutputStreamWriter ddlFileWriter = null;
        try {
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
            }
            ManagedConnection mconn = null;
            try {
                if (session == null) {
                    mconn = this.storeMgr.getConnection(-1);
                    session = (Session)mconn.getConnection();
                }
                Iterator<String> classIter = classNames.iterator();
                ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
                while (classIter.hasNext()) {
                    String className = classIter.next();
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                    if (cmd == null || cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
                    StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                    Object table = null;
                    table = storeData != null ? (Table)storeData.getProperties().get("tableObject") : new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
                    String schemaName = table.getSchemaName();
                    String tableName = table.getIdentifier();
                    NamingFactory namingFactory = this.storeMgr.getNamingFactory();
                    SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
                    boolean tableExists = CassandraSchemaHandler.checkTableExistence(session, stmtProvider, schemaName, tableName);
                    if (tableExists) {
                        int i;
                        for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                            IndexMetaData[] clsIdxMds = theCmd.getIndexMetaData();
                            if (clsIdxMds == null) continue;
                            for (i = 0; i < clsIdxMds.length; ++i) {
                                IndexMetaData idxmd = clsIdxMds[i];
                                StringBuilder stmtBuilder = new StringBuilder("DROP INDEX ");
                                String idxName = namingFactory.getIndexName(theCmd, idxmd, i);
                                if (ddlFileWriter == null) {
                                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropConstraint", (Object)stmtBuilder.toString()));
                                    session.execute(stmtBuilder.toString());
                                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropConstraint.Success", (Object)idxName));
                                    continue;
                                }
                                try {
                                    ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                                    continue;
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                            }
                        }
                        int[] memberPositions = cmd.getAllMemberPositions();
                        for (i = 0; i < memberPositions.length; ++i) {
                            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                            IndexMetaData idxmd = mmd.getIndexMetaData();
                            if (idxmd == null) continue;
                            StringBuilder stmtBuilder = new StringBuilder("DROP INDEX ");
                            String idxName = namingFactory.getIndexName(mmd, idxmd);
                            if (ddlFileWriter == null) {
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropConstraint", (Object)stmtBuilder.toString()));
                                session.execute(stmtBuilder.toString());
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropConstraint.Success", (Object)idxName));
                                continue;
                            }
                            try {
                                ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                                continue;
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        StringBuilder stmtBuilder = new StringBuilder("DROP TABLE ");
                        if (schemaName != null) {
                            stmtBuilder.append(schemaName).append('.');
                        }
                        stmtBuilder.append(tableName);
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropTable", (Object)stmtBuilder.toString()));
                            session.execute(stmtBuilder.toString());
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropTable.Success", (Object)tableName));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                        }
                        catch (IOException ioe) {}
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.DropTable.DoesntExist", (Object)tableName));
                }
            }
            finally {
                if (mconn != null) {
                    mconn.release();
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ddlFileWriter != null) {
                try {
                    ddlFileWriter.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        Session session = (Session)connection;
        boolean success = true;
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
        ManagedConnection mconn = null;
        try {
            if (session == null) {
                mconn = this.storeMgr.getConnection(-1);
                session = (Session)mconn.getConnection();
            }
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            for (String className : classNames) {
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
                StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                Object table = null;
                table = storeData != null ? (Table)storeData.getProperties().get("tableObject") : new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
                String schemaName = table.getSchemaName();
                String tableName = table.getIdentifier();
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
                boolean tableExists = CassandraSchemaHandler.checkTableExistence(session, stmtProvider, schemaName, tableName);
                if (!tableExists) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.TableDoesntExist", (Object)cmd.getFullClassName(), (Object)tableName, (Object)schemaName));
                    success = false;
                    continue;
                }
                Map<String, ColumnDetails> tableStructure = this.getColumnDetailsForTable(session, stmtProvider, schemaName, tableName);
                HashSet colsFound = new HashSet();
                List columns = table.getColumns();
                for (Column column : columns) {
                    ColumnDetails colDetails = this.getColumnDetailsForColumn(column, tableStructure);
                    if (colDetails == null) {
                        if (column.getMemberColumnMapping() != null) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.ColumnForTableDoesntExist", (Object)tableName, (Object)column.getIdentifier(), (Object)column.getMemberColumnMapping().getMemberMetaData().getFullFieldName()));
                        } else {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.ColumnForTableInvalidType", (Object)tableName, (Object)column.getIdentifier(), (Object)column.getColumnType()));
                        }
                        success = false;
                        continue;
                    }
                    String datastoreType = colDetails.typeName;
                    if (column.getTypeName().equals(datastoreType)) continue;
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.ColumnTypeIncorrect", (Object)tableName, (Object)column.getIdentifier(), (Object)colDetails.typeName, (Object)column.getTypeName()));
                }
                if (success && tableStructure.size() != colsFound.size()) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.ColumnCountIncorrect", (Object)tableName, (Object)colsFound.size(), (Object)tableStructure.size()));
                    success = false;
                }
                for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                    IndexMetaData[] clsIdxMds = theCmd.getIndexMetaData();
                    if (clsIdxMds == null) continue;
                    for (int i = 0; i < clsIdxMds.length; ++i) {
                        IndexMetaData idxmd = clsIdxMds[i];
                        String[] colNames = idxmd.getColumnNames();
                        if (colNames.length != 1) continue;
                        ColumnDetails colDetails = tableStructure.get(colNames[0].toLowerCase());
                        String idxName = namingFactory.getIndexName(theCmd, idxmd, i);
                        if (colDetails == null || colDetails.indexName == null) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.TableIndexMissingForColumn", (Object)tableName, (Object)colNames[0]));
                            continue;
                        }
                        if (idxName.equals(colDetails.indexName)) continue;
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexHasWrongName", (Object)idxName, (Object)colDetails.indexName));
                    }
                }
                int[] memberPositions = cmd.getAllMemberPositions();
                for (int i = 0; i < memberPositions.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                    IndexMetaData idxmd = mmd.getIndexMetaData();
                    if (idxmd == null) continue;
                    String colName = namingFactory.getColumnName(mmd, ColumnType.COLUMN);
                    ColumnDetails colDetails = tableStructure.get(colName.toLowerCase());
                    String idxName = namingFactory.getIndexName(mmd, idxmd);
                    if (colDetails == null || colDetails.indexName == null) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.TableIndexMissingForColumn", (Object)tableName, (Object)colName));
                        continue;
                    }
                    if (idxName.equals(colDetails.indexName)) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.IndexHasWrongName", (Object)idxName, (Object)colDetails.indexName));
                }
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
        if (!success) {
            throw new NucleusException("Errors were encountered during validation of Cassandra schema");
        }
    }

    protected String createIndexCQL(String indexName, String schemaName, String tableName, String columnName) {
        StringBuilder stmtBuilder = new StringBuilder("CREATE INDEX ");
        stmtBuilder.append(indexName);
        stmtBuilder.append(" ON ");
        if (schemaName != null) {
            stmtBuilder.append(schemaName).append('.');
        }
        stmtBuilder.append(tableName);
        stmtBuilder.append(" (").append(columnName).append(")");
        return stmtBuilder.toString();
    }

    public static boolean checkTableExistence(Session session, SessionStatementProvider stmtProvider, String schemaName, String tableName) {
        if (schemaName == null) {
            throw new NucleusUserException("Schema must be specified for table=" + tableName + " in order to check its existence");
        }
        StringBuilder stmtBuilder = new StringBuilder("SELECT columnfamily_name FROM System.schema_columnfamilies WHERE keyspace_name=? AND columnfamily_name=?");
        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CheckTableExistence", (Object)tableName, (Object)stmtBuilder.toString()));
        PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
        ResultSet rs = session.execute((Statement)stmt.bind(new Object[]{schemaName.toLowerCase(), tableName.toLowerCase()}));
        return !rs.isExhausted();
    }

    public static boolean checkSchemaExistence(Session session, SessionStatementProvider stmtProvider, String schemaName) {
        if (schemaName == null) {
            throw new NucleusUserException("Schema must be specified in order to check its existence");
        }
        StringBuilder stmtBuilder = new StringBuilder("SELECT keyspace_name FROM system.schema_keyspaces WHERE keyspace_name=?;");
        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CheckSchemaExistence", (Object)schemaName, (Object)stmtBuilder.toString()));
        PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
        ResultSet rs = session.execute((Statement)stmt.bind(new Object[]{schemaName.toLowerCase()}));
        return !rs.isExhausted();
    }

    public Map<String, ColumnDetails> getColumnDetailsForTable(Session session, SessionStatementProvider stmtProvider, String schemaName, String tableName) {
        if (schemaName == null) {
            throw new NucleusUserException("Schema must be specified for table=" + tableName + " in order to check its structure");
        }
        StringBuilder stmtBuilder = new StringBuilder("SELECT column_name, index_name, validator FROM system.schema_columns WHERE keyspace_name=? AND columnfamily_name=?");
        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Schema.CheckTableStructure", (Object)tableName, (Object)stmtBuilder.toString()));
        PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
        ResultSet rs = session.execute((Statement)stmt.bind(new Object[]{schemaName.toLowerCase(), tableName.toLowerCase()}));
        HashMap<String, ColumnDetails> cols = new HashMap<String, ColumnDetails>();
        for (Row row : rs) {
            String typeName = null;
            String validator = row.getString("validator");
            if (validator.indexOf("LongType") >= 0) {
                typeName = "bigint";
            } else if (validator.indexOf("IntegerType") >= 0 || validator.indexOf("Int32Type") >= 0) {
                typeName = "int";
            } else if (validator.indexOf("DoubleType") >= 0) {
                typeName = "double";
            } else if (validator.indexOf("DecimalType") >= 0) {
                typeName = "decimal";
            } else if (validator.indexOf("FloatType") >= 0) {
                typeName = "float";
            } else if (validator.indexOf("BooleanType") >= 0) {
                typeName = "boolean";
            } else if (validator.indexOf("DateType") >= 0) {
                typeName = "timestamp";
            } else if (validator.indexOf("UTF8") >= 0) {
                typeName = "varchar";
            }
            String colName = row.getString("column_name");
            ColumnDetails col = new ColumnDetails(colName, row.getString("index_name"), typeName);
            cols.put(colName, col);
        }
        return cols;
    }

    private ColumnDetails getColumnDetailsForColumn(Column col, Map<String, ColumnDetails> tableStructure) {
        String colName = col.getIdentifier();
        if (colName.startsWith("\"")) {
            colName = colName.substring(1, colName.length() - 1);
        }
        return tableStructure.get(colName);
    }

    public class ColumnDetails {
        String name;
        String indexName;
        String typeName;

        public ColumnDetails(String name, String idxName, String typeName) {
            this.name = name;
            this.indexName = idxName;
            this.typeName = typeName;
        }
    }
}

