/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.SessionStatementProvider;
import org.datanucleus.store.cassandra.fieldmanager.FetchFieldManager;
import org.datanucleus.store.cassandra.fieldmanager.StoreFieldManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CassandraPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER_CASSANDRA = Localiser.getInstance((String)"org.datanucleus.store.cassandra.Localisation", (ClassLoader)CassandraStoreManager.class.getClassLoader());
    protected Map<String, String> insertStatementByClassName;
    protected Map<String, String> deleteStatementByClassName;
    protected Map<String, String> locateStatementByClassName;
    protected Map<String, String> getVersionStatementByClassName;

    public CassandraPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        AbstractClassMetaData cmd = op.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            Session session = (Session)mconn.getConnection();
            if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                ((CassandraStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
            }
            Table table = (Table)this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getProperty("tableObject");
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Insert.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            Object versionValue = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd != null) {
                versionValue = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), null);
                if (vermd.getFieldName() != null) {
                    op.replaceField(cmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber(), versionValue);
                }
                op.setTransactionalVersion(versionValue);
            }
            String insertStmt = null;
            StoreFieldManager storeFM = new StoreFieldManager(op, true, table);
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)storeFM);
            Map<String, Object> columnValuesByName = storeFM.getColumnValueByName();
            if (insertStmt == null) {
                insertStmt = this.getInsertStatementForClass(cmd, table, columnValuesByName);
                if (this.insertStatementByClassName == null) {
                    this.insertStatementByClassName = new HashMap<String, String>();
                }
                this.insertStatementByClassName.put(cmd.getFullClassName(), insertStmt);
            }
            String discrimValue = null;
            if (cmd.hasDiscriminatorStrategy()) {
                DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
                discrimValue = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
            }
            String multitenancyValue = null;
            if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                multitenancyValue = this.storeMgr.getStringProperty("datanucleus.TenantID");
            }
            int numValues = columnValuesByName.size();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                ++numValues;
            }
            if (versionValue != null && vermd.getFieldName() == null) {
                ++numValues;
            }
            if (discrimValue != null) {
                ++numValues;
            }
            if (multitenancyValue != null) {
                ++numValues;
            }
            Object[] stmtValues = new Object[numValues];
            int pos = 0;
            for (String colName : columnValuesByName.keySet()) {
                stmtValues[pos++] = columnValuesByName.get(colName);
            }
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                stmtValues[pos++] = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId());
            }
            if (versionValue != null && vermd.getFieldName() == null) {
                stmtValues[pos++] = versionValue;
            }
            if (discrimValue != null) {
                stmtValues[pos++] = discrimValue;
            }
            if (multitenancyValue != null) {
                stmtValues[pos++] = multitenancyValue;
            }
            CassandraUtils.logCqlStatement(insertStmt, stmtValues, NucleusLogger.DATASTORE_NATIVE);
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
            PreparedStatement stmt = stmtProvider.prepare(insertStmt, session);
            BoundStatement boundStmt = stmt.bind(stmtValues);
            session.execute((Statement)boundStmt);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception inserting object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    protected String getInsertStatementForClass(AbstractClassMetaData cmd, Table table, Map<String, Object> colValuesByName) {
        VersionMetaData vermd;
        StringBuilder insertStmtBuilder = new StringBuilder("INSERT INTO ");
        String schemaName = table.getSchemaName();
        if (schemaName != null) {
            insertStmtBuilder.append(schemaName).append('.');
        }
        insertStmtBuilder.append(table.getIdentifier()).append("(");
        int numParams = 0;
        if (colValuesByName != null && !colValuesByName.isEmpty()) {
            for (String colName : colValuesByName.keySet()) {
                if (numParams > 0) {
                    insertStmtBuilder.append(',');
                }
                insertStmtBuilder.append(colName);
                ++numParams;
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getDatastoreIdColumn().getIdentifier());
            ++numParams;
        }
        if ((vermd = cmd.getVersionMetaDataForClass()) != null && vermd.getFieldName() == null) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getVersionColumn().getIdentifier());
            ++numParams;
        }
        if (cmd.hasDiscriminatorStrategy()) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getDiscriminatorColumn().getIdentifier());
            ++numParams;
        }
        if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
            if (numParams > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append(table.getMultitenancyColumn().getIdentifier());
            ++numParams;
        }
        insertStmtBuilder.append(") ");
        insertStmtBuilder.append("VALUES (");
        for (int i = 0; i < numParams; ++i) {
            if (i > 0) {
                insertStmtBuilder.append(',');
            }
            insertStmtBuilder.append('?');
        }
        insertStmtBuilder.append(")");
        return insertStmtBuilder.toString();
    }

    public void insertObjects(ObjectProvider ... ops) {
        super.insertObjects(ops);
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        AbstractClassMetaData cmd = op.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            VersionMetaData vermd;
            Session session = (Session)mconn.getConnection();
            if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                ((CassandraStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), session);
            }
            Table table = (Table)ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getProperty("tableObject");
            boolean fieldsToUpdate = false;
            for (int fieldNum : fieldNumbers) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNum);
                if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                fieldsToUpdate = true;
            }
            if (!fieldsToUpdate) {
                return;
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Update.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            if ((vermd = cmd.getVersionMetaDataForClass()) != null) {
                Object currentVersion = op.getTransactionalVersion();
                if (ec.getTransaction().getOptimistic() && cmd.isVersioned()) {
                    this.performOptimisticCheck(op, session, table, vermd, currentVersion);
                }
                Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), (Object)currentVersion);
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    op.replaceField(cmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber(), nextVersion);
                }
            }
            StoreFieldManager storeFM = new StoreFieldManager(op, false, table);
            op.provideFields(fieldNumbers, (FieldManager)storeFM);
            Map<String, Object> columnValuesByName = storeFM.getColumnValueByName();
            StringBuilder stmtBuilder = new StringBuilder("UPDATE ");
            String schemaName = table.getSchemaName();
            if (schemaName != null) {
                stmtBuilder.append(schemaName).append('.');
            }
            stmtBuilder.append(table.getIdentifier());
            ArrayList<Object> setVals = new ArrayList<Object>();
            stmtBuilder.append(" SET ");
            if (columnValuesByName != null && !columnValuesByName.isEmpty()) {
                boolean first = true;
                for (Map.Entry<String, Object> entry : columnValuesByName.entrySet()) {
                    if (!first) {
                        stmtBuilder.append(',');
                    }
                    stmtBuilder.append(entry.getKey()).append("=?");
                    first = false;
                    setVals.add(entry.getValue());
                }
            }
            if (vermd != null) {
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                        break;
                    }
                    if (!updatingVerField) {
                        stmtBuilder.append(',').append(table.getMemberColumnMappingForMember(verMmd).getColumn(0).getIdentifier()).append("=?");
                        setVals.add(op.getTransactionalVersion());
                    }
                } else {
                    stmtBuilder.append(",").append(table.getVersionColumn().getIdentifier()).append("=?");
                    Object verVal = op.getTransactionalVersion();
                    setVals.add(verVal);
                }
            }
            stmtBuilder.append(" WHERE ");
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNums = cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNums.length; ++i) {
                    if (i > 0) {
                        stmtBuilder.append(" AND ");
                    }
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                    Column pkCol = table.getMemberColumnMappingForMember(pkMmd).getColumn(0);
                    stmtBuilder.append(pkCol.getIdentifier());
                    stmtBuilder.append("=?");
                    RelationType relType = pkMmd.getRelationType(ec.getClassLoaderResolver());
                    if (RelationType.isRelationSingleValued((RelationType)relType)) {
                        Object pc = op.provideField(pkFieldNums[i]);
                        setVals.add(IdentityUtils.getPersistableIdentityForId((Object)ec.getApiAdapter().getIdForObject(pc)));
                        continue;
                    }
                    String cassandraType = pkCol.getTypeName();
                    setVals.add(CassandraUtils.getDatastoreValueForNonPersistableValue(op.provideField(pkFieldNums[i]), cassandraType, false, this.storeMgr.getNucleusContext().getTypeManager()));
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                stmtBuilder.append(table.getDatastoreIdColumn().getIdentifier());
                stmtBuilder.append("=?");
                Object oidVal = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId());
                setVals.add(CassandraUtils.getDatastoreValueForNonPersistableValue(oidVal, table.getDatastoreIdColumn().getTypeName(), false, this.storeMgr.getNucleusContext().getTypeManager()));
            }
            CassandraUtils.logCqlStatement(stmtBuilder.toString(), setVals.toArray(), NucleusLogger.DATASTORE_NATIVE);
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
            PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
            session.execute((Statement)stmt.bind(setVals.toArray()));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception updating object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Delete.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            Table table = (Table)ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getProperty("tableObject");
            Session session = (Session)mconn.getConnection();
            if (cmd.isVersioned() && ec.getTransaction().getOptimistic()) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                Object currentVersion = op.getTransactionalVersion();
                this.performOptimisticCheck(op, session, table, vermd, currentVersion);
            }
            op.loadUnloadedFields();
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op, true));
            String deleteStmt = null;
            if (this.deleteStatementByClassName != null) {
                deleteStmt = this.deleteStatementByClassName.get(cmd.getFullClassName());
            }
            if (deleteStmt == null) {
                StringBuilder stmtBuilder = new StringBuilder("DELETE FROM ");
                String schemaName = table.getSchemaName();
                if (schemaName != null) {
                    stmtBuilder.append(schemaName).append('.');
                }
                stmtBuilder.append(table.getIdentifier()).append(" WHERE ");
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNums = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNums.length; ++i) {
                        if (i > 0) {
                            stmtBuilder.append(" AND ");
                        }
                        AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                        stmtBuilder.append(table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getIdentifier());
                        stmtBuilder.append("=?");
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    stmtBuilder.append(table.getDatastoreIdColumn().getIdentifier());
                    stmtBuilder.append("=?");
                }
                deleteStmt = stmtBuilder.toString();
                if (this.deleteStatementByClassName == null) {
                    this.deleteStatementByClassName = new HashMap<String, String>();
                }
                this.deleteStatementByClassName.put(cmd.getFullClassName(), deleteStmt);
            }
            Object[] pkVals = this.getPkValuesForStatement(op, table);
            CassandraUtils.logCqlStatement(deleteStmt, pkVals, NucleusLogger.DATASTORE_NATIVE);
            SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
            PreparedStatement stmt = stmtProvider.prepare(deleteStmt, session);
            session.execute((Statement)stmt.bind(pkVals));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception deleting object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(ObjectProvider ... ops) {
        super.deleteObjects(ops);
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(op.getObjectAsPrintable()).append("\" (id=");
                str.append(op.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.Fetch.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            Table table = (Table)ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getProperty("tableObject");
            HashSet<Integer> nonpersistableFields = null;
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            boolean first = true;
            StringBuilder stmtBuilder = new StringBuilder("SELECT ");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                    RelationType relationType = mmd.getRelationType(clr);
                    if (RelationType.isRelationSingleValued((RelationType)relationType) && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, null)) {
                        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                        embMmds.add(mmd);
                        ArrayList<String> embColNames = new ArrayList<String>();
                        this.getColumnNamesForEmbeddedMember(table, embMmds, embColNames, ec);
                        for (String embColName : embColNames) {
                            if (!first) {
                                stmtBuilder.append(',');
                            }
                            stmtBuilder.append(embColName);
                            first = false;
                        }
                        continue;
                    }
                    MemberColumnMapping mapping = table.getMemberColumnMappingForMember(mmd);
                    for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                        String colName = mapping.getColumn(j).getIdentifier();
                        if (!first) {
                            stmtBuilder.append(',');
                        }
                        stmtBuilder.append(colName);
                        first = false;
                    }
                    continue;
                }
                if (nonpersistableFields == null) {
                    nonpersistableFields = new HashSet<Integer>();
                }
                nonpersistableFields.add(fieldNumbers[i]);
            }
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd != null && op.getTransactionalVersion() == null) {
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    boolean selected = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        selected = true;
                        break;
                    }
                    if (!selected) {
                        Column col = table.getMemberColumnMappingForMember(verMmd).getColumn(0);
                        if (!first) {
                            stmtBuilder.append(',');
                        }
                        stmtBuilder.append(col.getIdentifier());
                        first = false;
                    }
                } else {
                    if (!first) {
                        stmtBuilder.append(',');
                    }
                    stmtBuilder.append(table.getVersionColumn().getIdentifier());
                    first = false;
                }
            }
            if (nonpersistableFields != null) {
                for (Integer fieldNum : nonpersistableFields) {
                    op.replaceField(fieldNum.intValue(), op.provideField(fieldNum.intValue()));
                }
            }
            if (nonpersistableFields == null || nonpersistableFields.size() != fieldNumbers.length) {
                stmtBuilder.append(" FROM ");
                String schemaName = table.getSchemaName();
                if (schemaName != null) {
                    stmtBuilder.append(schemaName).append('.');
                }
                stmtBuilder.append(table.getIdentifier()).append(" WHERE ");
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNums = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNums.length; ++i) {
                        if (i > 0) {
                            stmtBuilder.append(" AND ");
                        }
                        AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                        stmtBuilder.append(table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getIdentifier());
                        stmtBuilder.append("=?");
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    stmtBuilder.append(table.getDatastoreIdColumn().getIdentifier());
                    stmtBuilder.append("=?");
                }
                Object[] pkVals = this.getPkValuesForStatement(op, table);
                CassandraUtils.logCqlStatement(stmtBuilder.toString(), pkVals, NucleusLogger.DATASTORE_NATIVE);
                Session session = (Session)mconn.getConnection();
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
                PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString(), session);
                ResultSet rs = session.execute((Statement)stmt.bind(pkVals));
                if (rs.isExhausted()) {
                    throw new NucleusObjectNotFoundException("Could not find object with id " + op.getInternalObjectId() + " op=" + op);
                }
                Row row = rs.one();
                FetchFieldManager fetchFM = new FetchFieldManager(op, row, table);
                if (nonpersistableFields != null) {
                    int[] persistableFieldNums = new int[fieldNumbers.length - nonpersistableFields.size()];
                    int pos = 0;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (nonpersistableFields.contains(fieldNumbers[i])) continue;
                        persistableFieldNums[pos++] = fieldNumbers[i];
                    }
                    fieldNumbers = persistableFieldNums;
                }
                op.replaceFields(fieldNumbers, (FieldManager)fetchFM);
                if (vermd != null && op.getTransactionalVersion() == null) {
                    if (vermd.getFieldName() != null) {
                        Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                        op.setVersion(datastoreVersion);
                    } else {
                        Column verCol = table.getVersionColumn();
                        Long datastoreVersion = verCol.getTypeName().equals("int") ? (long)row.getInt(verCol.getIdentifier()) : row.getLong(verCol.getIdentifier());
                        op.setVersion((Object)datastoreVersion);
                    }
                }
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_CASSANDRA.msg("Cassandra.ExecutionTime", System.currentTimeMillis() - startTime));
                }
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementFetchCount();
                }
            }
        }
        catch (DriverException e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception fetching object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception fetching object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    protected void getColumnNamesForEmbeddedMember(Table table, List<AbstractMemberMetaData> mmds, List<String> colNames, ExecutionContext ec) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(mmds.get(mmds.size() - 1).getType(), clr);
        int[] embFieldNums = embCmd.getAllMemberPositions();
        for (int i = 0; i < embFieldNums.length; ++i) {
            AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embFieldNums[i]);
            RelationType relationType = embMmd.getRelationType(clr);
            if (RelationType.isRelationSingleValued((RelationType)relationType) && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, embMmd, relationType, mmds.get(mmds.size() - 1))) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
                embMmds.add(embMmd);
                this.getColumnNamesForEmbeddedMember(table, embMmds, colNames, ec);
                continue;
            }
            ArrayList<AbstractMemberMetaData> colMmds = new ArrayList<AbstractMemberMetaData>(mmds);
            colMmds.add(embMmd);
            MemberColumnMapping mapping = table.getMemberColumnMappingForEmbeddedMember(colMmds);
            if (mapping == null) {
                StringBuilder strBuilder = new StringBuilder();
                for (AbstractMemberMetaData mmd : mmds) {
                    if (strBuilder.length() > 0) {
                        strBuilder.append('.');
                    }
                    strBuilder.append(mmd.getName());
                }
                strBuilder.append('.').append(embMmd.getName());
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Attempt to find column schema in table=" + table.getIdentifier() + " for embedded member at " + strBuilder.toString() + " but not found!" + " Schema generation must be incomplete for this table"));
                return;
            }
            for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                Column column = mapping.getColumn(j);
                if (column == null) continue;
                colNames.add(column.getIdentifier());
            }
        }
    }

    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                String locateStmt = null;
                if (this.locateStatementByClassName != null) {
                    locateStmt = this.locateStatementByClassName.get(cmd.getFullClassName());
                }
                Table table = (Table)ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getProperty("tableObject");
                if (locateStmt == null) {
                    StringBuilder stmtBuilder = new StringBuilder("SELECT ");
                    if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                        int[] pkFieldNums = cmd.getPKMemberPositions();
                        for (int i = 0; i < pkFieldNums.length; ++i) {
                            if (i > 0) {
                                stmtBuilder.append(",");
                            }
                            AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                            stmtBuilder.append(table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getIdentifier());
                        }
                    } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        stmtBuilder.append(table.getDatastoreIdColumn().getIdentifier());
                    }
                    stmtBuilder.append(" FROM ");
                    String schemaName = table.getSchemaName();
                    if (schemaName != null) {
                        stmtBuilder.append(schemaName).append('.');
                    }
                    stmtBuilder.append(table.getIdentifier()).append(" WHERE ");
                    if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                        int[] pkFieldNums = cmd.getPKMemberPositions();
                        for (int i = 0; i < pkFieldNums.length; ++i) {
                            if (i > 0) {
                                stmtBuilder.append(" AND ");
                            }
                            AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                            stmtBuilder.append(table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getIdentifier());
                            stmtBuilder.append("=?");
                        }
                    } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        stmtBuilder.append(table.getDatastoreIdColumn().getIdentifier());
                        stmtBuilder.append("=?");
                    }
                    locateStmt = stmtBuilder.toString();
                    if (this.locateStatementByClassName == null) {
                        this.locateStatementByClassName = new HashMap<String, String>();
                    }
                    this.locateStatementByClassName.put(cmd.getFullClassName(), locateStmt);
                }
                Object[] pkVals = this.getPkValuesForStatement(op, table);
                CassandraUtils.logCqlStatement(locateStmt, pkVals, NucleusLogger.DATASTORE_NATIVE);
                Session session = (Session)mconn.getConnection();
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
                PreparedStatement stmt = stmtProvider.prepare(locateStmt, session);
                ResultSet rs = session.execute((Statement)stmt.bind(pkVals));
                if (rs.isExhausted()) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            catch (DriverException e) {
                NucleusLogger.PERSISTENCE.error((Object)("Exception locating object " + op), (Throwable)e);
                throw new NucleusDataStoreException("Exception locating object for " + op, (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    public void locateObjects(ObjectProvider[] ops) {
        super.locateObjects(ops);
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    protected String getVersionStatement(AbstractClassMetaData cmd, Table table) {
        String verStmt = null;
        if (this.getVersionStatementByClassName != null) {
            verStmt = this.getVersionStatementByClassName.get(cmd.getFullClassName());
        }
        if (verStmt == null) {
            StringBuilder stmtBuilder = new StringBuilder("SELECT ");
            Column col = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() == null) {
                col = table.getVersionColumn();
            } else {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                col = table.getMemberColumnMappingForMember(verMmd).getColumn(0);
            }
            stmtBuilder.append(col.getIdentifier());
            stmtBuilder.append(" FROM ");
            String schemaName = table.getSchemaName();
            if (schemaName != null) {
                stmtBuilder.append(schemaName).append('.');
            }
            stmtBuilder.append(table.getIdentifier()).append(" WHERE ");
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNums = cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNums.length; ++i) {
                    if (i > 0) {
                        stmtBuilder.append(" AND ");
                    }
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                    stmtBuilder.append(table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getIdentifier());
                    stmtBuilder.append("=?");
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                stmtBuilder.append(table.getDatastoreIdColumn().getIdentifier());
                stmtBuilder.append("=?");
            }
            verStmt = stmtBuilder.toString();
            if (this.getVersionStatementByClassName == null) {
                this.getVersionStatementByClassName = new HashMap<String, String>();
            }
            this.getVersionStatementByClassName.put(cmd.getFullClassName(), verStmt);
        }
        return verStmt;
    }

    protected Object[] getPkValuesForStatement(ObjectProvider op, Table table) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        Object[] pkVals = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkFieldNums = cmd.getPKMemberPositions();
            pkVals = new Object[pkFieldNums.length];
            for (int i = 0; i < pkFieldNums.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                RelationType relType = pkMmd.getRelationType(ec.getClassLoaderResolver());
                if (RelationType.isRelationSingleValued((RelationType)relType)) {
                    Object pc = op.provideField(pkFieldNums[i]);
                    pkVals[i] = IdentityUtils.getPersistableIdentityForId((Object)ec.getApiAdapter().getIdForObject(pc));
                    continue;
                }
                String cassandraType = table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getTypeName();
                pkVals[i] = CassandraUtils.getDatastoreValueForNonPersistableValue(op.provideField(pkFieldNums[i]), cassandraType, false, this.storeMgr.getNucleusContext().getTypeManager());
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            pkVals = new Object[]{IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId())};
        }
        return pkVals;
    }

    protected void performOptimisticCheck(ObjectProvider op, Session session, Table table, VersionMetaData vermd, Object currentVersion) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        Object[] pkVals = this.getPkValuesForStatement(op, table);
        String getVersStmt = this.getVersionStatement(cmd, table);
        CassandraUtils.logCqlStatement(getVersStmt, pkVals, NucleusLogger.DATASTORE_NATIVE);
        SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider();
        PreparedStatement stmt = stmtProvider.prepare(getVersStmt, session);
        ResultSet rs = session.execute((Statement)stmt.bind(pkVals));
        if (rs.isExhausted()) {
            throw new NucleusDataStoreException("Could not find object with id " + op.getInternalObjectId() + " in the datastore, so cannot update it");
        }
        Row row = rs.one();
        String verColName = null;
        if (vermd.getFieldName() == null) {
            verColName = table.getVersionColumn().getIdentifier();
        } else {
            AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
            verColName = table.getMemberColumnMappingForMember(verMmd).getColumn(0).getIdentifier();
        }
        if (currentVersion instanceof Long) {
            long datastoreVersion = row.getLong(verColName);
            if ((Long)currentVersion != datastoreVersion) {
                throw new NucleusOptimisticException("Object " + op.getInternalObjectId() + " has version=" + datastoreVersion + " in the datastore yet version=" + currentVersion + " in memory");
            }
        } else if (currentVersion instanceof Integer) {
            int datastoreVersion = row.getInt(verColName);
            if ((Integer)currentVersion != datastoreVersion) {
                throw new NucleusOptimisticException("Object " + op.getInternalObjectId() + " has version=" + datastoreVersion + " in the datastore yet version=" + currentVersion + " in memory");
            }
        }
    }
}

