/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import java.util.Map;
import java.util.Stack;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.store.cassandra.query.expression.CassandraExpression;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

public class QueryToCQLMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    CompilationComponent compileComponent;
    boolean filterComplete = true;
    boolean resultComplete = true;
    boolean precompilable = true;
    Stack<CassandraExpression> stack = new Stack();

    public QueryToCQLMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public boolean isResultComplete() {
        return this.resultComplete;
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    public void compile() {
        this.compileFilter();
        this.compileResult();
        this.compileGrouping();
        this.compileHaving();
        this.compileOrdering();
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of filter to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.filterComplete = false;
            }
            this.compileComponent = null;
        }
    }

    protected void compileResult() {
        if (this.compilation.getExprResult() != null) {
            // empty if block
        }
    }

    protected void compileGrouping() {
        if (this.compilation.getExprFilter() != null) {
            // empty if block
        }
    }

    protected void compileHaving() {
        if (this.compilation.getExprHaving() != null) {
            // empty if block
        }
    }

    protected void compileOrdering() {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            for (int i = 0; i < orderingExpr.length; ++i) {
                OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                NucleusLogger.QUERY.debug((Object)(">> TODO Need to process " + orderExpr));
            }
            this.compileComponent = null;
        }
    }

    protected Object processAndExpression(Expression expr) {
        return super.processAndExpression(expr);
    }

    protected Object processOrExpression(Expression expr) {
        return super.processOrExpression(expr);
    }

    protected Object processEqExpression(Expression expr) {
        return super.processEqExpression(expr);
    }

    protected Object processNoteqExpression(Expression expr) {
        return super.processNoteqExpression(expr);
    }

    protected Object processGtExpression(Expression expr) {
        return super.processGtExpression(expr);
    }

    protected Object processGteqExpression(Expression expr) {
        return super.processGteqExpression(expr);
    }

    protected Object processLtExpression(Expression expr) {
        return super.processLtExpression(expr);
    }

    protected Object processLteqExpression(Expression expr) {
        return super.processLteqExpression(expr);
    }

    protected Object compilePrimaryExpression(Expression expr) {
        return super.compilePrimaryExpression(expr);
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        return super.processParameterExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        return super.processLiteral(expr);
    }
}

