/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.fieldmanager;

import com.datastax.driver.core.Row;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected Table table;
    protected Row row;

    public FetchFieldManager(ObjectProvider op, Row row, Table table) {
        super(op);
        this.table = table;
        this.row = row;
    }

    public FetchFieldManager(ExecutionContext ec, Row row, AbstractClassMetaData cmd, Table table) {
        super(ec, cmd);
        this.table = table;
        this.row = row;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return this.row.getBool(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier());
    }

    public char fetchCharField(int fieldNumber) {
        return this.row.getString(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier()).charAt(0);
    }

    public byte fetchByteField(int fieldNumber) {
        return (byte)this.row.getInt(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier());
    }

    public short fetchShortField(int fieldNumber) {
        return (short)this.row.getInt(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier());
    }

    public int fetchIntField(int fieldNumber) {
        return this.row.getInt(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier());
    }

    public long fetchLongField(int fieldNumber) {
        return this.row.getLong(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier());
    }

    public float fetchFloatField(int fieldNumber) {
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        if (col.getJdbcType() == JdbcType.DECIMAL) {
            return this.row.getDecimal(col.getIdentifier()).floatValue();
        }
        if (col.getJdbcType() == JdbcType.DOUBLE) {
            return (float)this.row.getDouble(col.getIdentifier());
        }
        return this.row.getFloat(col.getIdentifier());
    }

    public double fetchDoubleField(int fieldNumber) {
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        if (col.getJdbcType() == JdbcType.DECIMAL) {
            return this.row.getDecimal(col.getIdentifier()).doubleValue();
        }
        return this.row.getDouble(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier());
    }

    public String fetchStringField(int fieldNumber) {
        return this.row.getString(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier());
    }

    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(embCmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embOP, this.row, embMmds, this.table);
                embOP.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embOP.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded)"));
                return null;
            }
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }

    protected Object fetchNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (this.row.isNull(mapping.getColumn(0).getIdentifier())) {
                return null;
            }
            String value = this.row.getString(mapping.getColumn(0).getIdentifier());
            return this.getValueForSingleRelationField(mmd, value, clr);
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            Collection value = null;
            if (mmd.hasCollection()) {
                Class elementCls;
                Class clazz = elementCls = mmd.getCollection().isSerializedElement() ? ByteBuffer.class : String.class;
                value = Set.class.isAssignableFrom(mmd.getType()) ? this.row.getSet(mapping.getColumn(0).getIdentifier(), elementCls) : (List.class.isAssignableFrom(mmd.getType()) || mmd.getOrderMetaData() != null ? this.row.getList(mapping.getColumn(0).getIdentifier(), elementCls) : this.row.getSet(mapping.getColumn(0).getIdentifier(), elementCls));
            } else if (mmd.hasMap()) {
                Class keyCls = clr.classForName(mmd.getMap().getKeyType());
                if (mmd.getMap().keyIsPersistent()) {
                    keyCls = mmd.getMap().isSerializedKey() ? ByteBuffer.class : String.class;
                }
                Class valCls = clr.classForName(mmd.getMap().getValueType());
                if (mmd.getMap().valueIsPersistent()) {
                    valCls = mmd.getMap().isSerializedValue() ? ByteBuffer.class : String.class;
                }
                value = this.row.getMap(mapping.getColumn(0).getIdentifier(), keyCls, valCls);
            } else if (mmd.hasArray()) {
                value = this.row.getList(mapping.getColumn(0).getIdentifier(), String.class);
            }
            return this.getValueForContainerRelationField(mmd, value, clr);
        }
        if (mapping.getNumberOfColumns() > 1) {
            boolean allNull = true;
            for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                if (this.row.isNull(mapping.getColumn(i).getIdentifier())) continue;
                allNull = false;
            }
            if (allNull) {
                return null;
            }
        } else if (this.row.isNull(mapping.getColumn(0).getIdentifier())) {
            return null;
        }
        if (mapping.getTypeConverter() != null && !mmd.isSerialized()) {
            if (mapping.getNumberOfColumns() > 1) {
                Object[] valuesArr = null;
                Class[] colTypes = ((MultiColumnConverter)mapping.getTypeConverter()).getDatastoreColumnTypes();
                valuesArr = colTypes[0] == Integer.TYPE ? new int[mapping.getNumberOfColumns()] : (colTypes[0] == Long.TYPE ? (Object[])new long[mapping.getNumberOfColumns()] : (colTypes[0] == Double.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == Float.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == String.class ? (Object[])new String[mapping.getNumberOfColumns()] : (Object[])new Object[mapping.getNumberOfColumns()]))));
                boolean isNull = true;
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    Column col = mapping.getColumn(i);
                    if (col.getTypeName().equals("int")) {
                        Array.set(valuesArr, i, this.row.getInt(col.getIdentifier()));
                    } else if (col.getTypeName().equals("bool")) {
                        Array.set(valuesArr, i, this.row.getBool(col.getIdentifier()));
                    } else if (col.getTypeName().equals("timestamp")) {
                        Array.set(valuesArr, i, this.row.getDate(col.getIdentifier()));
                    } else if (col.getTypeName().equals("decimal")) {
                        Array.set(valuesArr, i, this.row.getDecimal(col.getIdentifier()));
                    } else if (col.getTypeName().equals("double")) {
                        Array.set(valuesArr, i, this.row.getDouble(col.getIdentifier()));
                    } else if (col.getTypeName().equals("float")) {
                        Array.set(valuesArr, i, Float.valueOf(this.row.getFloat(col.getIdentifier())));
                    } else if (col.getTypeName().equals("bigint")) {
                        Array.set(valuesArr, i, this.row.getLong(col.getIdentifier()));
                    } else {
                        Array.set(valuesArr, i, this.row.getString(col.getIdentifier()));
                    }
                    if (!isNull || Array.get(valuesArr, i) == null) continue;
                    isNull = false;
                }
                if (isNull) {
                    return null;
                }
                return mapping.getTypeConverter().toMemberType((Object)valuesArr);
            }
            return CassandraUtils.getMemberValueForColumnWithConverter(this.row, mapping.getColumn(0), mapping.getTypeConverter());
        }
        if (mmd.hasCollection()) {
            Collection coll;
            Collection cassColl = null;
            Class elemCls = clr.classForName(mmd.getCollection().getElementType());
            String elemCassType = CassandraUtils.getCassandraTypeForNonPersistableType(elemCls, false, this.ec.getTypeManager(), null);
            Class cassElemCls = CassandraUtils.getJavaTypeForCassandraType(elemCassType);
            cassColl = Set.class.isAssignableFrom(mmd.getType()) ? this.row.getSet(mapping.getColumn(0).getIdentifier(), cassElemCls) : (List.class.isAssignableFrom(mmd.getType()) || mmd.getOrderMetaData() != null ? this.row.getList(mapping.getColumn(0).getIdentifier(), cassElemCls) : this.row.getSet(mapping.getColumn(0).getIdentifier(), cassElemCls));
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            if (cassColl != null) {
                for (Object cassElem : cassColl) {
                    Object elem = CassandraUtils.getJavaValueForDatastoreValue(cassElem, elemCassType, elemCls, this.ec);
                    coll.add(elem);
                }
            }
            if (this.op != null) {
                coll = (Collection)this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
            }
            return coll;
        }
        if (mmd.hasMap()) {
            Map map;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            Class keyCls = clr.classForName(mmd.getMap().getKeyType());
            String keyCassType = CassandraUtils.getCassandraTypeForNonPersistableType(keyCls, false, this.ec.getTypeManager(), null);
            Class cassKeyCls = CassandraUtils.getJavaTypeForCassandraType(keyCassType);
            Class valCls = clr.classForName(mmd.getMap().getValueType());
            String valCassType = CassandraUtils.getCassandraTypeForNonPersistableType(valCls, false, this.ec.getTypeManager(), null);
            Class cassValCls = CassandraUtils.getJavaTypeForCassandraType(valCassType);
            Map cassMap = this.row.getMap(mapping.getColumn(0).getIdentifier(), cassKeyCls, cassValCls);
            if (cassMap != null) {
                for (Map.Entry cassMapEntry : cassMap.entrySet()) {
                    Object key = CassandraUtils.getJavaValueForDatastoreValue(cassMapEntry.getKey(), cassKeyCls.getName(), keyCls, this.ec);
                    Object val = CassandraUtils.getJavaValueForDatastoreValue(cassMapEntry.getValue(), cassValCls.getName(), valCls, this.ec);
                    map.put(key, val);
                }
            }
            if (this.op != null) {
                map = (Map)this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
            }
            return map;
        }
        if (mmd.hasArray()) {
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)("Field=" + mmd.getFullFieldName() + " has datastore array; not supported yet"));
        } else {
            if (mmd.isSerialized()) {
                TypeConverter serialConv = this.ec.getTypeManager().getTypeConverterForType(Serializable.class, ByteBuffer.class);
                return serialConv.toMemberType((Object)this.row.getBytes(mapping.getColumn(0).getIdentifier()));
            }
            if (BigInteger.class.isAssignableFrom(mmd.getType())) {
                return BigInteger.valueOf(this.row.getLong(mapping.getColumn(0).getIdentifier()));
            }
            if (BigDecimal.class.isAssignableFrom(mmd.getType())) {
                return this.row.getDecimal(mapping.getColumn(0).getIdentifier());
            }
            if (Byte.class.isAssignableFrom(mmd.getType())) {
                return (byte)this.row.getInt(mapping.getColumn(0).getIdentifier());
            }
            if (Character.class.isAssignableFrom(mmd.getType())) {
                return Character.valueOf(this.row.getString(mapping.getColumn(0).getIdentifier()).charAt(0));
            }
            if (Double.class.isAssignableFrom(mmd.getType())) {
                return this.row.getDouble(mapping.getColumn(0).getIdentifier());
            }
            if (Float.class.isAssignableFrom(mmd.getType())) {
                return Float.valueOf(this.row.getFloat(mapping.getColumn(0).getIdentifier()));
            }
            if (Long.class.isAssignableFrom(mmd.getType())) {
                return this.row.getLong(mapping.getColumn(0).getIdentifier());
            }
            if (Integer.class.isAssignableFrom(mmd.getType())) {
                return this.row.getInt(mapping.getColumn(0).getIdentifier());
            }
            if (Short.class.isAssignableFrom(mmd.getType())) {
                return (short)this.row.getInt(mapping.getColumn(0).getIdentifier());
            }
            if (Boolean.class.isAssignableFrom(mmd.getType())) {
                return this.row.getBool(mapping.getColumn(0).getIdentifier());
            }
            if (Enum.class.isAssignableFrom(mmd.getType())) {
                if (mapping.getColumn(0).getTypeName().equals("varchar")) {
                    return Enum.valueOf(mmd.getType(), this.row.getString(mapping.getColumn(0).getIdentifier()));
                }
                return mmd.getType().getEnumConstants()[this.row.getInt(mapping.getColumn(0).getIdentifier())];
            }
            if (Date.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (mapping.getColumn(0).getTypeName().equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getIdentifier()));
                }
                return new Date(this.row.getDate(mapping.getColumn(0).getIdentifier()).getTime());
            }
            if (Time.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (mapping.getColumn(0).getTypeName().equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getIdentifier()));
                }
                return new Time(this.row.getDate(mapping.getColumn(0).getIdentifier()).getTime());
            }
            if (Timestamp.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (mapping.getColumn(0).getTypeName().equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getIdentifier()));
                }
                return new Timestamp(this.row.getDate(mapping.getColumn(0).getIdentifier()).getTime());
            }
            if (Calendar.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (mapping.getColumn(0).getTypeName().equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getIdentifier()));
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.row.getDate(mapping.getColumn(0).getIdentifier()));
                return cal;
            }
            if (java.util.Date.class.isAssignableFrom(mmd.getType())) {
                TypeConverter stringConverter;
                if (mapping.getColumn(0).getTypeName().equals("varchar") && (stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                    return stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getIdentifier()));
                }
                return this.row.getDate(mapping.getColumn(0).getIdentifier());
            }
            TypeConverter stringConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
            if (stringConverter != null) {
                return stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getIdentifier()));
            }
            TypeConverter longConverter = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), Long.class);
            if (longConverter != null) {
                return longConverter.toMemberType((Object)this.row.getLong(mapping.getColumn(0).getIdentifier()));
            }
        }
        NucleusLogger.PERSISTENCE.info((Object)("TODO FetchFM field=" + mmd.getFullFieldName() + " not supported currently. Type=" + mmd.getTypeName()));
        return null;
    }

    protected Object getValueForSingleRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (value == null) {
            return null;
        }
        String persistableId = (String)value;
        try {
            AbstractClassMetaData mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            if (mmdCmd != null) {
                return IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
            }
            String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 2, clr, this.ec.getMetaDataManager());
            if (implNames != null && implNames.length == 1) {
                mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                return IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
            }
            if (implNames != null && implNames.length > 1) {
                for (String implName : implNames) {
                    try {
                        mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(implName, clr);
                        return IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
                    }
                    catch (NucleusObjectNotFoundException nonfe) {
                        throw nonfe;
                    }
                    catch (Exception e) {
                    }
                }
            }
            throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an interdeterminate type (e.g interface or Object element types)");
        }
        catch (NucleusObjectNotFoundException onfe) {
            NucleusLogger.GENERAL.warn((Object)("Object=" + this.op + " field=" + mmd.getFullFieldName() + " has id=" + persistableId + " but could not instantiate object with that identity"));
            return null;
        }
    }

    protected Object getValueForContainerRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (mmd.hasCollection()) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 3, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length > 0) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            boolean changeDetected = false;
            while (idIter.hasNext()) {
                String persistableId = (String)idIter.next();
                if (persistableId.equals("NULL")) {
                    coll.add(null);
                    continue;
                }
                try {
                    coll.add(IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec));
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (this.op != null) {
                coll = (Collection)this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
                if (changeDetected) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return coll;
        }
        if (mmd.hasMap()) {
            Map map;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            Map mapIds = (Map)value;
            AbstractClassMetaData keyCmd = null;
            if (mmd.getMap().keyIsPersistent() && (keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager())) == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 5, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    keyCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (keyCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a map of interdeterminate key type (e.g interface or Object element types)");
                }
            }
            AbstractClassMetaData valCmd = null;
            if (mmd.getMap().valueIsPersistent() && (valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager())) == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 6, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    valCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (valCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a map of interdeterminate value type (e.g interface or Object element types)");
                }
            }
            Iterator entryIter = mapIds.entrySet().iterator();
            boolean changeDetected = false;
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                Object key = null;
                Object val = null;
                if (mmd.getMap().keyIsPersistent()) {
                    String keyPersistableId = (String)entry.getKey();
                    try {
                        key = IdentityUtils.getObjectFromPersistableIdentity((String)keyPersistableId, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec);
                    }
                    catch (NucleusObjectNotFoundException onfe) {
                        changeDetected = true;
                    }
                } else {
                    key = entry.getKey();
                }
                if (mmd.getMap().valueIsPersistent()) {
                    String valPersistableId = (String)entry.getValue();
                    if (valPersistableId.equals("NULL")) {
                        val = null;
                    } else {
                        try {
                            val = IdentityUtils.getObjectFromPersistableIdentity((String)valPersistableId, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec);
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            changeDetected = true;
                        }
                    }
                } else {
                    val = entry.getValue();
                }
                map.put(key, val);
            }
            if (this.op != null) {
                map = (Map)this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
                if (changeDetected) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return map;
        }
        if (mmd.hasArray()) {
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 4, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Object array = Array.newInstance(mmd.getType().getComponentType(), collIds.size());
            Iterator idIter = collIds.iterator();
            boolean changeDetected = false;
            int pos = 0;
            while (idIter.hasNext()) {
                String persistableId = (String)idIter.next();
                if (persistableId.equals("NULL")) {
                    Array.set(array, pos++, null);
                    continue;
                }
                try {
                    Array.set(array, pos++, IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec));
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (changeDetected) {
                if (pos < collIds.size()) {
                    Object arrayOld = array;
                    array = Array.newInstance(mmd.getType().getComponentType(), pos);
                    for (int j = 0; j < pos; ++j) {
                        Array.set(array, j, Array.get(arrayOld, j));
                    }
                }
                if (this.op != null) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return array;
        }
        return value;
    }
}

