/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.ColumnAttributerImpl;
import org.datanucleus.store.cassandra.SessionStatementProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.ColumnAttributer;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CassandraSchemaHandler
extends AbstractStoreSchemaHandler {
    CassandraStoreManager casStoreMgr;

    public CassandraSchemaHandler(CassandraStoreManager storeMgr) {
        super((StoreManager)storeMgr);
        this.casStoreMgr = storeMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(String schemaName, Properties props, Object connection) {
        ManagedConnection mconn = this.storeMgr.getConnection(-1);
        try {
            Boolean durable;
            Session session = (Session)mconn.getConnection();
            StringBuilder stmtBuilder = new StringBuilder("CREATE KEYSPACE IF NOT EXISTS ");
            stmtBuilder.append(schemaName).append(" WITH ");
            String replicationProp = props != null ? (String)props.get("replication") : "{'class': 'SimpleStrategy', 'replication_factor' : 3}";
            stmtBuilder.append("replication = ").append(replicationProp);
            if (props != null && props.containsKey("durable_writes") && !(durable = Boolean.valueOf((String)props.get("durable_writes"))).booleanValue()) {
                stmtBuilder.append(" AND durable_writes=false");
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)stmtBuilder.toString());
            session.execute(stmtBuilder.toString());
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Schema " + schemaName + " created successfully"));
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        Session session = (Session)connection;
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        OutputStreamWriter ddlFileWriter = null;
        try {
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
            }
            ManagedConnection mconn = null;
            try {
                if (session == null) {
                    mconn = this.storeMgr.getConnection(-1);
                    session = (Session)mconn.getConnection();
                }
                ArrayList<String> tableStmts = new ArrayList<String>();
                ArrayList<String> constraintStmts = new ArrayList<String>();
                Iterator<String> classIter = classNames.iterator();
                ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
                while (classIter.hasNext()) {
                    String className = classIter.next();
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                    if (cmd == null) continue;
                    this.createSchemaForClass(cmd, session, clr, tableStmts, constraintStmts);
                }
                if (!tableStmts.isEmpty()) {
                    for (String stmt : tableStmts) {
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Creating table : " + stmt));
                            session.execute(stmt);
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)"Created table successfully");
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmt + ";\n");
                        }
                        catch (IOException ioe) {}
                    }
                }
                if (!constraintStmts.isEmpty()) {
                    for (String stmt : constraintStmts) {
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Creating constraint : " + stmt));
                            session.execute(stmt);
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)"Created contraint successfully");
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmt + ";\n");
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            finally {
                if (mconn != null) {
                    mconn.release();
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ddlFileWriter != null) {
                try {
                    ddlFileWriter.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected void createSchemaForClass(AbstractClassMetaData cmd, Session session, ClassLoaderResolver clr, List<String> tableStmts, List<String> constraintStmts) {
        if (cmd.isEmbeddedOnly()) {
            return;
        }
        StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object table = null;
        table = storeData != null ? (Table)storeData.getProperties().get("tableObject") : new CompleteClassTable(this.storeMgr, cmd, (ColumnAttributer)new ColumnAttributerImpl(this.storeMgr, cmd, clr));
        String schemaName = table.getSchemaName();
        SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider(session);
        if (CassandraSchemaHandler.checkTableExistence(session, stmtProvider, schemaName, table.getIdentifier())) {
            if (!cmd.isVersioned() || cmd.getVersionMetaDataForClass() == null || cmd.getVersionMetaDataForClass().getFieldName() == null) {
                // empty if block
            }
            if (cmd.hasDiscriminatorStrategy()) {
                // empty if block
            }
            if (this.storeMgr.getStringProperty("datanucleus.TenantID") == null || !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                // empty if block
            }
            if (this.isAutoCreateConstraints()) {
                for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                    IndexMetaData[] clsIdxMds = theCmd.getIndexMetaData();
                    if (clsIdxMds == null) continue;
                    for (int i = 0; i < clsIdxMds.length; ++i) {
                    }
                }
                for (Column column : table.getColumns()) {
                    if (column.getMemberMetaData() == null) continue;
                }
            }
        } else {
            if (this.isAutoCreateTables()) {
                StringBuilder stmtBuilder = new StringBuilder("CREATE TABLE ");
                if (schemaName != null) {
                    stmtBuilder.append(schemaName).append('.');
                }
                stmtBuilder.append(table.getIdentifier());
                stmtBuilder.append(" (");
                ArrayList<String> pkColNames = new ArrayList<String>();
                for (Column column : table.getColumns()) {
                    stmtBuilder.append(column.getIdentifier()).append(' ').append(column.getTypeName()).append(',');
                    if (!column.isPrimaryKey()) continue;
                    pkColNames.add(column.getIdentifier());
                }
                stmtBuilder.append(" PRIMARY KEY (");
                Iterator pkColNameIter = pkColNames.iterator();
                while (pkColNameIter.hasNext()) {
                    stmtBuilder.append((String)pkColNameIter.next());
                    if (!pkColNameIter.hasNext()) continue;
                    stmtBuilder.append(',');
                }
                stmtBuilder.append(")");
                stmtBuilder.append(")");
                tableStmts.add(stmtBuilder.toString());
            }
            if (this.isAutoCreateConstraints()) {
                String indexStmt;
                String idxName;
                NamingFactory namingFactory = this.storeMgr.getNamingFactory();
                for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                    IndexMetaData[] clsIdxMds = theCmd.getIndexMetaData();
                    if (clsIdxMds == null) continue;
                    for (int i = 0; i < clsIdxMds.length; ++i) {
                        IndexMetaData idxmd = clsIdxMds[i];
                        String[] colNames = idxmd.getColumnNames();
                        if (colNames.length > 1) {
                            NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Class " + theCmd.getFullClassName() + " has an index defined with more than 1 column. Cassandra doesn't support composite indexes so ignoring"));
                            continue;
                        }
                        idxName = namingFactory.getIndexName(theCmd, idxmd, i);
                        indexStmt = this.createIndexCQL(idxName, schemaName, table.getIdentifier(), colNames[0]);
                        constraintStmts.add(indexStmt);
                    }
                }
                for (Column column : table.getColumns()) {
                    AbstractMemberMetaData mmd;
                    IndexMetaData idxmd;
                    if (column.getMemberMetaData() == null || (idxmd = (mmd = column.getMemberMetaData()).getIndexMetaData()) == null) continue;
                    idxName = namingFactory.getIndexName(mmd, idxmd);
                    indexStmt = this.createIndexCQL(idxName, schemaName, table.getIdentifier(), column.getIdentifier());
                    constraintStmts.add(indexStmt);
                }
                if (this.storeMgr.getStringProperty("datanucleus.TenantID") == null || !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                    // empty if block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(String schemaName, Properties props, Object connection) {
        ManagedConnection mconn = this.storeMgr.getConnection(-1);
        try {
            Session session = (Session)mconn.getConnection();
            StringBuilder stmtBuilder = new StringBuilder("DROP KEYSPACE IF EXISTS ");
            stmtBuilder.append(schemaName);
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)stmtBuilder.toString());
            session.execute(stmtBuilder.toString());
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Schema " + schemaName + " dropped successfully"));
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        OutputStreamWriter ddlFileWriter = null;
        try {
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
            }
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            ManagedConnection mconn = this.storeMgr.getConnection(-1);
            try {
                Session session = (Session)mconn.getConnection();
                Iterator<String> classIter = classNames.iterator();
                ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
                while (classIter.hasNext()) {
                    String className = classIter.next();
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                    if (cmd == null || cmd.isEmbeddedOnly()) continue;
                    StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                    Object table = null;
                    table = storeData != null ? (Table)storeData.getProperties().get("tableObject") : new CompleteClassTable(this.storeMgr, cmd, (ColumnAttributer)new ColumnAttributerImpl(this.storeMgr, cmd, clr));
                    String schemaName = table.getSchemaName();
                    String tableName = table.getIdentifier();
                    SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider(session);
                    boolean tableExists = CassandraSchemaHandler.checkTableExistence(session, stmtProvider, schemaName, tableName);
                    if (tableExists) {
                        IndexMetaData[] clsIdxMds = cmd.getIndexMetaData();
                        if (clsIdxMds != null) {
                            for (int i = 0; i < clsIdxMds.length; ++i) {
                                IndexMetaData idxmd = clsIdxMds[i];
                                StringBuilder stmtBuilder = new StringBuilder("DROP INDEX ");
                                String idxName = namingFactory.getIndexName(cmd, idxmd, i);
                                if (ddlFileWriter == null) {
                                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Dropping index : " + stmtBuilder.toString()));
                                    session.execute(stmtBuilder.toString());
                                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Dropped index " + idxName + " successfully"));
                                    continue;
                                }
                                try {
                                    ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                                    continue;
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                            }
                        }
                        int[] memberPositions = cmd.getAllMemberPositions();
                        for (int i = 0; i < memberPositions.length; ++i) {
                            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                            IndexMetaData idxmd = mmd.getIndexMetaData();
                            if (idxmd == null) continue;
                            StringBuilder stmtBuilder = new StringBuilder("DROP INDEX ");
                            String idxName = namingFactory.getIndexName(mmd, idxmd);
                            if (ddlFileWriter == null) {
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Dropping index : " + stmtBuilder.toString()));
                                session.execute(stmtBuilder.toString());
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Dropped index " + idxName + " successfully"));
                                continue;
                            }
                            try {
                                ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                                continue;
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        StringBuilder stmtBuilder = new StringBuilder("DROP TABLE ");
                        if (schemaName != null) {
                            stmtBuilder.append(schemaName).append('.');
                        }
                        stmtBuilder.append(tableName);
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Dropping table : " + stmtBuilder.toString()));
                            session.execute(stmtBuilder.toString());
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Dropped table for class " + cmd.getFullClassName() + " successfully"));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                        }
                        catch (IOException ioe) {}
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Class " + cmd.getFullClassName() + " table=" + tableName + " didnt exist so can't be dropped"));
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ddlFileWriter != null) {
                try {
                    ddlFileWriter.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        NamingFactory namingFactory = this.storeMgr.getNamingFactory();
        boolean success = true;
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
        ManagedConnection mconn = this.storeMgr.getConnection(-1);
        try {
            Session session = (Session)mconn.getConnection();
            for (String className : classNames) {
                IndexMetaData[] clsIdxMds;
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd.isEmbeddedOnly()) continue;
                StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                Object table = null;
                table = storeData != null ? (Table)storeData.getProperties().get("tableObject") : new CompleteClassTable(this.storeMgr, cmd, (ColumnAttributer)new ColumnAttributerImpl(this.storeMgr, cmd, clr));
                String schemaName = table.getSchemaName();
                String tableName = table.getIdentifier();
                SessionStatementProvider stmtProvider = ((CassandraStoreManager)this.storeMgr).getStatementProvider(session);
                boolean tableExists = CassandraSchemaHandler.checkTableExistence(session, stmtProvider, schemaName, tableName);
                if (!tableExists) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)("Table for class " + cmd.getFullClassName() + " doesn't exist : should have name " + tableName + " in schema " + schemaName));
                    success = false;
                    continue;
                }
                Map<String, ColumnDetails> colsByName = this.getColumnDetailsForTable(session, stmtProvider, schemaName, tableName);
                HashSet<String> colsFound = new HashSet<String>();
                int[] memberPositions = cmd.getAllMemberPositions();
                for (int i = 0; i < memberPositions.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                    String columnName = namingFactory.getColumnName(mmd, ColumnType.COLUMN);
                    ColumnDetails details = colsByName.get(columnName.toLowerCase());
                    if (details != null) {
                        String reqdType = CassandraUtils.getCassandraColumnTypeForMember(mmd, this.storeMgr.getNucleusContext().getTypeManager(), clr);
                        if (!(reqdType != null && reqdType.equals(details.typeName) || reqdType == null && details.typeName == null)) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)("Table " + tableName + " column " + columnName + " has type=" + details.typeName + " yet member type " + mmd.getFullFieldName() + " ought to be using type=" + reqdType));
                        }
                        colsFound.add(columnName.toLowerCase());
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)("Table " + tableName + " doesn't have column " + columnName + " for member " + mmd.getFullFieldName()));
                    success = false;
                }
                if (success && colsByName.size() != colsFound.size()) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)("Table " + tableName + " should have " + colsFound.size() + " columns but has " + colsByName.size() + " columns!"));
                    success = false;
                }
                if ((clsIdxMds = cmd.getIndexMetaData()) != null) {
                    for (int i = 0; i < clsIdxMds.length; ++i) {
                        ColumnDetails details;
                        IndexMetaData idxmd = clsIdxMds[i];
                        String[] colNames = idxmd.getColumnNames();
                        if (colNames.length != 1 || (details = colsByName.get(colNames[0].toLowerCase())) != null && details.indexName != null) continue;
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)("Table " + tableName + " column=" + colNames[0] + " should have an index but doesn't"));
                    }
                }
                for (int i = 0; i < memberPositions.length; ++i) {
                    String colName;
                    ColumnDetails details;
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                    IndexMetaData idxmd = mmd.getIndexMetaData();
                    if (idxmd == null || (details = colsByName.get((colName = namingFactory.getColumnName(mmd, ColumnType.COLUMN)).toLowerCase())) != null && details.indexName != null) continue;
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)("Table " + tableName + " column=" + colName + " should have an index but doesn't"));
                }
            }
        }
        finally {
            mconn.release();
        }
        if (!success) {
            throw new NucleusException("Errors were encountered during validation of Cassandra schema");
        }
    }

    protected String createIndexCQL(String indexName, String schemaName, String tableName, String columnName) {
        StringBuilder stmtBuilder = new StringBuilder("CREATE INDEX ");
        stmtBuilder.append(indexName);
        stmtBuilder.append(" ON ");
        if (schemaName != null) {
            stmtBuilder.append(schemaName).append('.');
        }
        stmtBuilder.append(tableName);
        stmtBuilder.append(" (").append(columnName).append(")");
        return stmtBuilder.toString();
    }

    public static boolean checkTableExistence(Session session, SessionStatementProvider stmtProvider, String schemaName, String tableName) {
        StringBuilder stmtBuilder = new StringBuilder("SELECT columnfamily_name FROM System.schema_columnfamilies WHERE keyspace_name=? AND columnfamily_name=?");
        NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Checking existence of table " + tableName + " using : " + stmtBuilder.toString()));
        PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString());
        ResultSet rs = session.execute((Statement)stmt.bind(new Object[]{schemaName.toLowerCase(), tableName.toLowerCase()}));
        return !rs.isExhausted();
    }

    public static boolean checkSchemaExistence(Session session, SessionStatementProvider stmtProvider, String schemaName) {
        StringBuilder stmtBuilder = new StringBuilder("SELECT keyspace_name FROM system.schema_keyspaces WHERE keyspace_name=?;");
        NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Checking existence of schema " + schemaName + " using : " + stmtBuilder.toString()));
        PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString());
        ResultSet rs = session.execute((Statement)stmt.bind(new Object[]{schemaName.toLowerCase()}));
        return !rs.isExhausted();
    }

    public Map<String, ColumnDetails> getColumnDetailsForTable(Session session, SessionStatementProvider stmtProvider, String schemaName, String tableName) {
        StringBuilder stmtBuilder = new StringBuilder("SELECT column_name, index_name, validator FROM system.schema_columns WHERE keyspace_name=? AND columnfamily_name=?");
        NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Checking structure of table " + tableName + " using : " + stmtBuilder.toString()));
        PreparedStatement stmt = stmtProvider.prepare(stmtBuilder.toString());
        ResultSet rs = session.execute((Statement)stmt.bind(new Object[]{schemaName.toLowerCase(), tableName.toLowerCase()}));
        HashMap<String, ColumnDetails> cols = new HashMap<String, ColumnDetails>();
        for (Row row : rs) {
            String typeName = null;
            String validator = row.getString("validator");
            if (validator.indexOf("LongType") >= 0) {
                typeName = "bigint";
            } else if (validator.indexOf("Int32Type") >= 0) {
                typeName = "int";
            } else if (validator.indexOf("DoubleType") >= 0) {
                typeName = "double";
            } else if (validator.indexOf("FloatType") >= 0) {
                typeName = "float";
            } else if (validator.indexOf("BooleanType") >= 0) {
                typeName = "boolean";
            } else if (validator.indexOf("UTF8") >= 0) {
                typeName = "varchar";
            }
            String colName = row.getString("column_name");
            ColumnDetails col = new ColumnDetails(colName, row.getString("index_name"), typeName);
            cols.put(colName, col);
        }
        return cols;
    }

    public class ColumnDetails {
        String name;
        String indexName;
        String typeName;

        public ColumnDetails(String name, String idxName, String typeName) {
            this.name = name;
            this.indexName = idxName;
            this.typeName = typeName;
        }
    }
}

