/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.xmemcached;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.util.NucleusLogger;

public class XmemcachedLevel2Cache
extends AbstractLevel2Cache {
    private static final long serialVersionUID = -5116427607754733694L;
    public static final String PROPERTY_CACHE_L2_MEMCACHED_SERVERS = "datanucleus.cache.level2.memcached.servers";
    private MemcachedClient client;
    private int expireSeconds = 0;

    public XmemcachedLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        String servers = conf.getStringProperty(PROPERTY_CACHE_L2_MEMCACHED_SERVERS);
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)servers));
        try {
            this.client = builder.build();
        }
        catch (IOException e) {
            NucleusLogger.CACHE.error((Object)"Exception caught creating cache", (Throwable)e);
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        this.expireSeconds = (int)this.expiryMillis / 1000;
    }

    public void close() {
        if (this.clearAtClose) {
            try {
                this.client.flushAll();
            }
            catch (Exception e) {
                NucleusLogger.CACHE.error((Object)"Exception caught flushing cache", (Throwable)e);
            }
        }
        try {
            this.client.shutdown();
        }
        catch (Exception e) {
            NucleusLogger.CACHE.error((Object)"Exception caught shutting down cache", (Throwable)e);
        }
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public void evict(Object oid) {
        try {
            this.client.delete(this.getCacheKeyForId(oid));
        }
        catch (Exception e) {
            throw new NucleusException("Exception evict entry from xmemcached", (Throwable)e);
        }
    }

    public void evictAll() {
        try {
            this.client.flushAll();
        }
        catch (Exception e) {
            throw new NucleusException("Exception evict entries from xmemcached", (Throwable)e);
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Class arg0, boolean arg1) {
    }

    public CachedPC get(Object oid) {
        try {
            return (CachedPC)this.client.get(this.getCacheKeyForId(oid));
        }
        catch (Exception e) {
            throw new NucleusException("Exception thrown in retrieval from xmemcached", (Throwable)e);
        }
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        try {
            this.client.set(this.getCacheKeyForId(oid), this.expireSeconds, (Object)pc);
        }
        catch (Exception e) {
            throw new NucleusException("Exception thrown in persistence to xmemcached", (Throwable)e);
        }
        return pc;
    }

    protected String getCacheKeyForId(Object id) {
        if (IdentityUtils.isSingleFieldIdentity((Object)id)) {
            String targetClassName = ((SingleFieldId)id).getTargetClassName();
            return this.cacheName + targetClassName + ":" + id.toString().hashCode();
        }
        return this.cacheName + id.toString().hashCode();
    }
}

