/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.spymemcached;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.cache.AbstractQueryResultsCache;
import org.datanucleus.util.NucleusLogger;

public class SpymemcachedQueryResultCache
extends AbstractQueryResultsCache {
    private static final long serialVersionUID = 4242859249224130913L;
    private MemcachedClient client;
    private String keyPrefix = "datanucleus-query:";
    private int expirySeconds = 0;

    public SpymemcachedQueryResultCache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        String keyPrefix = conf.getStringProperty("datanucleus.cache.queryResults.memcached.keyprefix");
        if (keyPrefix != null) {
            this.keyPrefix = keyPrefix;
        }
        this.expirySeconds = (int)this.expiryMillis / 1000;
        String servers = conf.getStringProperty("datanucleus.cache.queryResults.memcached.servers");
        try {
            this.client = new MemcachedClient(AddrUtil.getAddresses((String)servers));
        }
        catch (IOException e) {
            NucleusLogger.CACHE.error((Object)"Exception caught creating cache", (Throwable)e);
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
    }

    public void close() {
        this.client.shutdown();
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    public void evict(Class candidate) {
    }

    public void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache((Query)query, null);
        this.client.delete(this.keyPrefix + baseKey);
    }

    public void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params);
        this.client.delete(this.keyPrefix + key);
    }

    public void evictAll() {
        this.client.flush();
    }

    public List<Object> get(String queryKey) {
        return (List)this.client.get(this.keyPrefix + queryKey);
    }

    public List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        this.client.set(this.keyPrefix + queryKey, this.expirySeconds, results);
        return results;
    }
}

