/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.ehcache;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.NucleusLogger;

public class EhcacheLevel2Cache
extends AbstractLevel2Cache {
    private final CacheManager cacheManager;
    private final Cache cache;

    public EhcacheLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.level2.configurationFile");
        try {
            this.cacheManager = configFile == null ? CacheManager.create() : CacheManager.create((URL)CacheManager.class.getResource(configFile));
        }
        catch (CacheException e) {
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        if (!this.cacheManager.cacheExists(this.cacheName)) {
            try {
                this.cacheManager.addCache(this.cacheName);
            }
            catch (IllegalStateException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
            catch (ObjectExistsException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
            catch (CacheException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
        }
        this.cache = this.cacheManager.getCache(this.cacheName);
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
        this.cacheManager.shutdown();
    }

    public boolean containsOid(Object oid) {
        try {
            return this.get(oid) != null;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.containsOid : " + e.getMessage()));
            return false;
        }
    }

    public CachedPC get(Object oid) {
        try {
            Element element = this.cache.get((Serializable)oid);
            if (element == null) {
                return null;
            }
            return this.toPC(element);
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        return null;
    }

    private CachedPC toPC(Element object) {
        return (CachedPC)object.getObjectValue();
    }

    private Element toElement(Object oid, CachedPC object) {
        return new Element((Serializable)oid, (Serializable)object);
    }

    public int getSize() {
        try {
            return this.cache.getSize();
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSize : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSize : " + e.getMessage()));
        }
        return 0;
    }

    public boolean isEmpty() {
        try {
            return this.cache.getSize() == 0;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.isEmpty : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.isEmpty : " + e.getMessage()));
        }
        return true;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        this.cache.put(this.toElement(oid, pc));
        return pc;
    }

    public void evict(Object oid) {
        CachedPC pc = this.get(oid);
        if (pc != null) {
            this.cache.remove((Serializable)oid);
        }
    }

    public void evictAll() {
        try {
            this.cache.removeAll();
        }
        catch (Exception e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.clear : " + e.getMessage()));
        }
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        String[] subclassNames;
        if (!this.nucleusCtx.getApiAdapter().isPersistable(pcClass)) {
            return;
        }
        this.evictAllOfClass(pcClass.getName());
        if (subclasses && (subclassNames = this.nucleusCtx.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                this.evictAllOfClass(subclassNames[i]);
            }
        }
    }

    void evictAllOfClass(String className) {
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(className, this.nucleusCtx.getClassLoaderResolver(null));
        Iterator keyIter = this.cache.getKeys().iterator();
        while (keyIter.hasNext()) {
            String targetClassName;
            Object key = keyIter.next();
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                targetClassName = IdentityUtils.getTargetClassNameForIdentitySimple(key);
                if (!className.equals(targetClassName)) continue;
                keyIter.remove();
                continue;
            }
            if (cmd.getIdentityType() != IdentityType.DATASTORE || !className.equals(targetClassName = IdentityUtils.getTargetClassNameForIdentitySimple(key))) continue;
            keyIter.remove();
        }
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }
}

