/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.javaxcache;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxCacheQueryResultCache
implements QueryResultsCache {
    private Cache cache;

    public JavaxCacheQueryResultCache(NucleusContext nucleusCtx) {
        PersistenceConfiguration conf = nucleusCtx.getPersistenceConfiguration();
        String cacheName = conf.getStringProperty("datanucleus.cache.queryResults.cacheName");
        if (cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.queryResults.cacheName' specified so using name of 'DataNucleus-Query'");
            cacheName = "datanucleus-query";
        }
        try {
            Cache tmpcache = CacheManager.getInstance().getCache(cacheName);
            if (tmpcache == null) {
                this.cache = CacheManager.getInstance().getCacheFactory().createCache(Collections.EMPTY_MAP);
                CacheManager.getInstance().registerCache(cacheName, this.cache);
            } else {
                this.cache = tmpcache;
            }
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", (Throwable)e);
        }
    }

    public void close() {
        this.evictAll();
        this.cache = null;
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    public void evict(Class candidate) {
    }

    public synchronized void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache((Query)query, null);
        Iterator iter = this.cache.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(baseKey)) continue;
            iter.remove();
        }
    }

    public synchronized void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params);
        this.cache.remove((Object)key);
    }

    public synchronized void evictAll() {
        this.cache.clear();
    }

    public void pin(Query query, Map params) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void pin(Query query) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void unpin(Query query, Map params) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void unpin(Query query) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public List<Object> get(String queryKey) {
        return (List)this.cache.get((Object)queryKey);
    }

    public boolean isEmpty() {
        return false;
    }

    public synchronized List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            new ObjectOutputStream(os).writeObject(results);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.cache.put((Object)queryKey, results);
        return results;
    }

    public int size() {
        return this.cache.size();
    }
}

