/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.util.NucleusLogger;

public class EhcacheLevel2Cache
implements Level2Cache {
    private final CacheManager cacheManager;
    private final Cache cache;
    private int maxSize = -1;
    private final ApiAdapter apiAdapter;

    public EhcacheLevel2Cache(OMFContext omfCtx) {
        this.apiAdapter = omfCtx.getApiAdapter();
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.level2.configurationFile");
        String cacheName = conf.getStringProperty("datanucleus.cache.level2.cacheName");
        if (cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.level2.cacheName' specified so using name of 'datanucleus'");
            cacheName = "datanucleus";
        }
        try {
            this.cacheManager = configFile == null ? CacheManager.create() : CacheManager.create((URL)CacheManager.class.getResource(configFile));
        }
        catch (CacheException e) {
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        if (!this.cacheManager.cacheExists(cacheName)) {
            try {
                this.cacheManager.addCache(cacheName);
            }
            catch (IllegalStateException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
            catch (ObjectExistsException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
            catch (CacheException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
        }
        this.cache = this.cacheManager.getCache(cacheName);
        this.maxSize = conf.getIntProperty("datanucleus.cache.level2.maxSize");
    }

    public void close() {
        this.clear();
        this.cacheManager.shutdown();
    }

    public void clear() {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.clear : " + e.getMessage()));
        }
        catch (IOException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.clear : " + e.getMessage()));
        }
    }

    public boolean containsOid(Object oid) {
        try {
            return this.get(oid) != null;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.containsOid : " + e.getMessage()));
            return false;
        }
    }

    public CachedPC get(Object oid) {
        try {
            Element element = this.cache.get((Serializable)oid);
            if (element == null) {
                return null;
            }
            return this.toPC(element);
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        return null;
    }

    private CachedPC toPC(Element object) {
        return (CachedPC)object.getValue();
    }

    private Element toElement(Object oid, CachedPC object) {
        return new Element((Serializable)oid, (Serializable)object);
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by Ehcache plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by Ehcache plugin");
    }

    public int getSize() {
        try {
            return this.cache.getSize();
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSize : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSize : " + e.getMessage()));
        }
        return 0;
    }

    public boolean isEmpty() {
        try {
            return this.cache.getSize() == 0;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.isEmpty : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.isEmpty : " + e.getMessage()));
        }
        return true;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        if (this.apiAdapter.getObjectManager(pc.getPersistableObject()) != null) {
            return null;
        }
        this.cache.put(this.toElement(oid, pc));
        return pc;
    }

    public void evict(Object oid) {
        CachedPC pc = this.get(oid);
        if (pc != null) {
            this.cache.remove((Serializable)this.toElement(oid, pc));
        }
    }

    public void evictAll() {
        this.clear();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by Ehcache plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by Ehcache plugin");
    }

    public void pinAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by Ehcache plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by Ehcache plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by Ehcache plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by Ehcache plugin");
    }

    public void unpinAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by Ehcache plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by Ehcache plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by Ehcache plugin");
    }
}

