/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.coherence;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CoherenceLevel2Cache
implements Level2Cache {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)(class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = CoherenceLevel2Cache.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    private NamedCache cache;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public CoherenceLevel2Cache(OMFContext omfCtx) {
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        ClassLoaderResolver clr = omfCtx.getClassLoaderResolver(null);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.tangosol.net.CacheFactory", (String)"coherence.jar");
        String cacheName = conf.getStringProperty("datanucleus.cache.level2.cacheName");
        if (cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.level2.cacheName' specified so using name of 'DataNucleus'");
            cacheName = "DataNucleus";
        }
        this.cache = CacheFactory.getCache((String)cacheName);
    }

    public void close() {
        this.clear();
    }

    public NamedCache getTangosolCache() {
        return this.cache;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean containsOid(Object oid) {
        return this.cache.containsKey(oid);
    }

    public boolean lock(Object oid) {
        return this.cache.lock(oid);
    }

    public boolean lock(Object oid, int wait) {
        return this.cache.lock(oid, wait);
    }

    public boolean unlock(Object oid) {
        return this.cache.unlock(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPC get(Object oid) {
        this.cache.lock(oid, -1);
        try {
            CachedPC cachedPC = (CachedPC)this.cache.get(oid);
            return cachedPC;
        }
        finally {
            this.cache.unlock(oid);
        }
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by Tangosol plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by Tangosol plugin");
    }

    public int getSize() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            NucleusLogger.CACHE.warn((Object)LOCALISER.msg("004011"));
            return null;
        }
        if (ObjectManagerHelper.getObjectManager((Object)pc.getPersistableObject()) != null) {
            NucleusLogger.CACHE.error((Object)LOCALISER.msg("004012", oid));
            return null;
        }
        return (CachedPC)this.cache.put(oid, (Object)pc);
    }

    public void evict(Object oid) {
        this.cache.remove(oid);
    }

    public void evictAll() {
        this.cache.clear();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by Tangosol plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by Tangosol plugin");
    }

    public void pinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by Tangosol plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by Tangosol plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by Tangosol plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by Tangosol plugin");
    }

    public void unpinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by Tangosol plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by Tangosol plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by Tangosol plugin");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

