/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import javax.persistence.Cache;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.metadata.AbstractClassMetaData;

public class JPADataStoreCache
implements Cache {
    PersistenceNucleusContext nucleusCtx;
    Level2Cache cache = null;

    public JPADataStoreCache(PersistenceNucleusContext nucleusCtx) {
        this.nucleusCtx = nucleusCtx;
        this.cache = nucleusCtx.getLevel2Cache();
    }

    public Level2Cache getLevel2Cache() {
        return this.cache;
    }

    public boolean contains(Class cls, Object pk) {
        ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(null);
        AbstractClassMetaData acmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (acmd == null) {
            throw new EntityNotFoundException();
        }
        if (acmd.usesSingleFieldIdentityClass() && !(pk instanceof SingleFieldId)) {
            Class singleFieldIdType = IdentityUtils.getSingleFieldIdentityTypeForKeyType(pk.getClass());
            SingleFieldId sfId = this.nucleusCtx.getIdentityManager().getSingleFieldId(singleFieldIdType, cls, pk);
            return this.cache.containsOid((Object)sfId);
        }
        return this.cache.containsOid(pk);
    }

    public void evictAll() {
        this.cache.evictAll();
    }

    public void evict(Class cls) {
        this.cache.evictAll(cls, true);
    }

    public void evict(Class cls, Object pk) {
        ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(null);
        AbstractClassMetaData acmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (acmd == null) {
            throw new EntityNotFoundException();
        }
        if (acmd.usesSingleFieldIdentityClass() && !(pk instanceof SingleFieldId)) {
            Class singleFieldIdType = IdentityUtils.getSingleFieldIdentityTypeForKeyType(pk.getClass());
            SingleFieldId sfId = this.nucleusCtx.getIdentityManager().getSingleFieldId(singleFieldIdType, cls, pk);
            this.cache.evict((Object)sfId);
        } else {
            this.cache.evict(pk);
        }
    }

    public <T> T unwrap(Class<T> cls) {
        if (Level2Cache.class.isAssignableFrom(cls)) {
            return (T)this.cache;
        }
        throw new PersistenceException("Not yet supported");
    }
}

