/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.AttributeNode;
import javax.persistence.Cache;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.Subgraph;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.datanucleus.AbstractNucleusContext;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassLoaderResolverImpl;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchGroup;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.PersistenceNucleusContextImpl;
import org.datanucleus.api.jpa.JPAClassTransformer;
import org.datanucleus.api.jpa.JPADataStoreCache;
import org.datanucleus.api.jpa.JPAEntityGraph;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.api.jpa.JPAQuery;
import org.datanucleus.api.jpa.JPAQueryCache;
import org.datanucleus.api.jpa.PersistenceProviderImpl;
import org.datanucleus.api.jpa.SingletonEMFException;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.exceptions.NoPersistenceUnitException;
import org.datanucleus.api.jpa.exceptions.NotProviderException;
import org.datanucleus.api.jpa.metadata.JPAEntityGraphRegistrationListener;
import org.datanucleus.api.jpa.metadata.JPAMetaDataManager;
import org.datanucleus.api.jpa.metamodel.MetamodelImpl;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.store.query.cache.QueryCompilationCache;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPAEntityManagerFactory
implements EntityManagerFactory,
PersistenceUnitUtil,
JPAEntityGraphRegistrationListener,
Serializable {
    static final long serialVersionUID = -2306972481580259021L;
    public static final NucleusLogger LOGGER;
    private static ConcurrentHashMap<String, JPAEntityManagerFactory> emfByName;
    private static volatile Map<String, PersistenceUnitMetaData> unitMetaDataCache;
    private String name = null;
    private PersistenceUnitMetaData unitMetaData = null;
    private transient PersistenceNucleusContext nucleusCtx = null;
    private PersistenceContextType persistenceContextType = PersistenceContextType.EXTENDED;
    private boolean closed = false;
    private transient Cache datastoreCache = null;
    private transient JPAQueryCache queryCache = null;
    private transient MetamodelImpl metamodel = null;
    private transient Map<String, JPAEntityGraph> entityGraphsByName = null;
    private transient JPAClassTransformer transformer = null;
    private boolean containerManaged = false;
    Random random = new Random();
    List<JPAEntityGraph> entityGraphsToRegister = null;
    private Map<String, Object> deserialisationProps = null;

    public JPAEntityManagerFactory(PersistenceUnitInfo unitInfo, Map overridingProps) {
        Object addCTVal;
        this.containerManaged = true;
        Properties props = unitInfo.getProperties();
        this.persistenceContextType = PersistenceContextType.TRANSACTION;
        this.setPersistenceContextTypeFromProperties(props, overridingProps);
        boolean validProvider = false;
        if (unitInfo.getPersistenceProviderClassName() == null || unitInfo.getPersistenceProviderClassName().equals(PersistenceProviderImpl.class.getName()) || overridingProps != null && PersistenceProviderImpl.class.getName().equals(overridingProps.get("javax.persistence.provider"))) {
            validProvider = true;
        }
        if (!validProvider) {
            throw new NotProviderException(Localiser.msg((String)"EMF.NotProviderForPersistenceUnit", (Object[])new Object[]{unitInfo.getPersistenceUnitName()}));
        }
        URI rootURI = null;
        try {
            rootURI = unitInfo.getPersistenceUnitRootUrl().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.name = unitInfo.getPersistenceUnitName();
        if (unitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            this.unitMetaData = new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.JTA.toString(), rootURI);
        } else if (unitInfo.getTransactionType() == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            this.unitMetaData = new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.RESOURCE_LOCAL.toString(), rootURI);
        }
        List classNames = unitInfo.getManagedClassNames();
        Iterator classIter = classNames.iterator();
        while (classIter.hasNext()) {
            this.unitMetaData.addClassName((String)classIter.next());
        }
        List mappingFileNames = unitInfo.getMappingFileNames();
        Iterator mappingFileIter = mappingFileNames.iterator();
        while (mappingFileIter.hasNext()) {
            this.unitMetaData.addMappingFile((String)mappingFileIter.next());
        }
        List jarUrls = unitInfo.getJarFileUrls();
        Iterator jarUrlIter = jarUrls.iterator();
        while (jarUrlIter.hasNext()) {
            this.unitMetaData.addJarFile((URL)jarUrlIter.next());
        }
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                this.unitMetaData.addProperty(prop, props.getProperty(prop));
            }
        }
        this.unitMetaData.setExcludeUnlistedClasses(unitInfo.excludeUnlistedClasses());
        this.unitMetaData.setProvider(unitInfo.getPersistenceProviderClassName());
        overridingProps = overridingProps == null ? new HashMap() : new HashMap<String, Object>(overridingProps);
        PersistenceUnitTransactionType type = unitInfo.getTransactionType();
        if (type == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            if (unitInfo.getNonJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory", unitInfo.getNonJtaDataSource());
                overridingProps.put("datanucleus.connection.resourceType", ConnectionResourceType.RESOURCE_LOCAL.toString());
            }
            if (unitInfo.getJtaDataSource() != null) {
                LOGGER.warn((Object)Localiser.msg((String)"EMF.ContainerLocalWithJTADataSource"));
            }
        } else {
            if (unitInfo.getJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory", unitInfo.getJtaDataSource());
                overridingProps.put("datanucleus.connection.resourceType", ConnectionResourceType.JTA.toString());
            }
            if (unitInfo.getNonJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory2", unitInfo.getNonJtaDataSource());
                overridingProps.put("datanucleus.connection2.resourceType", ConnectionResourceType.RESOURCE_LOCAL.toString());
            } else {
                LOGGER.warn((Object)Localiser.msg((String)"EMF.ContainerJTAWithNoNonJTADataSource"));
            }
        }
        if (unitInfo.getClassLoader() != null) {
            overridingProps.put("datanucleus.primaryClassLoader", unitInfo.getClassLoader());
        }
        boolean addClassTransformer = false;
        if (this.unitMetaData.getProperties() != null && (addCTVal = this.unitMetaData.getProperties().get("datanucleus.jpa.addClassTransformer")) != null && ((String)addCTVal).equalsIgnoreCase("true")) {
            addClassTransformer = true;
        }
        if ((addCTVal = overridingProps.get("datanucleus.jpa.addClassTransformer")) != null && ((String)addCTVal).equalsIgnoreCase("true")) {
            addClassTransformer = true;
        }
        if (addClassTransformer) {
            try {
                LOGGER.debug((Object)"Adding ClassTransformer for enhancing classes at runtime");
                this.transformer = new JPAClassTransformer(overridingProps);
                unitInfo.addTransformer((ClassTransformer)this.transformer);
            }
            catch (IllegalStateException ise) {
                LOGGER.warn((Object)"Exception was caught when adding the class transformer. Ignoring it.", (Throwable)ise);
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)("Container EntityManagerFactory with persistence-unit defined as follows : \n" + this.unitMetaData.toString("", "    ")));
            for (Map.Entry entry : overridingProps.entrySet()) {
                NucleusLogger.PERSISTENCE.debug((Object)("Container EntityManagerFactory overriding property : name=" + (String)entry.getKey() + " value=" + entry.getValue()));
            }
        }
        this.nucleusCtx = this.initialiseNucleusContext(this.unitMetaData, overridingProps, null);
        if (this.entityGraphsToRegister != null) {
            for (JPAEntityGraph jPAEntityGraph : this.entityGraphsToRegister) {
                this.registerEntityGraph(jPAEntityGraph, jPAEntityGraph.getName());
            }
        }
        JPAEntityManagerFactory.assertSingleton(this.unitMetaData.getName(), this);
        boolean allowMetadataLoad = this.nucleusCtx.getConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime");
        if (!allowMetadataLoad) {
            this.nucleusCtx.getMetaDataManager().setAllowMetaDataLoad(false);
        }
        this.getMetamodel();
    }

    private void setPersistenceContextTypeFromProperties(Properties props, Map overridingProps) {
        String persistenceContextTypeProp = null;
        if (props != null && props.containsKey("datanucleus.jpa.persistenceContextType")) {
            persistenceContextTypeProp = (String)props.get("datanucleus.jpa.persistenceContextType");
        }
        if (overridingProps != null && overridingProps.containsKey("datanucleus.jpa.persistenceContextType")) {
            persistenceContextTypeProp = (String)overridingProps.get("datanucleus.jpa.persistenceContextType");
        }
        if ("extended".equals(persistenceContextTypeProp)) {
            this.persistenceContextType = PersistenceContextType.EXTENDED;
        } else if ("transaction".equals(persistenceContextTypeProp)) {
            this.persistenceContextType = PersistenceContextType.TRANSACTION;
        }
    }

    public JPAEntityManagerFactory(PersistenceUnitMetaData pumd, Map overridingProps) {
        this.name = pumd.getName();
        if (unitMetaDataCache == null) {
            unitMetaDataCache = new ConcurrentHashMap<String, PersistenceUnitMetaData>();
        }
        unitMetaDataCache.put(this.name, pumd);
        Properties props = pumd.getProperties();
        this.persistenceContextType = PersistenceContextType.EXTENDED;
        this.setPersistenceContextTypeFromProperties(props, overridingProps);
        this.initialise(pumd, overridingProps, null);
        this.getMetamodel();
    }

    public JPAEntityManagerFactory(String unitName, Map overridingProps) {
        this.name = unitName;
        if (unitMetaDataCache == null) {
            unitMetaDataCache = new ConcurrentHashMap<String, PersistenceUnitMetaData>();
        }
        PluginManager pluginMgr = null;
        this.unitMetaData = unitMetaDataCache.get(unitName);
        if (this.unitMetaData == null) {
            pluginMgr = PluginManager.createPluginManager((Map)overridingProps, (ClassLoader)this.getClass().getClassLoader());
            this.unitMetaData = JPAEntityManagerFactory.getPersistenceUnitMetaDataForName(unitName, pluginMgr, overridingProps);
            if (this.unitMetaData == null) {
                throw new NoPersistenceUnitException("No persistence unit found with name " + unitName + ". Check that your persistence.xml is in META-INF from the root of the CLASSPATH");
            }
        }
        this.persistenceContextType = PersistenceContextType.EXTENDED;
        Properties props = this.unitMetaData.getProperties();
        this.setPersistenceContextTypeFromProperties(props, overridingProps);
        this.initialise(this.unitMetaData, overridingProps, pluginMgr);
        this.getMetamodel();
    }

    public NucleusContext getNucleusContext() {
        return this.nucleusCtx;
    }

    private void initialise(PersistenceUnitMetaData pumd, Map overridingProps, PluginManager pluginMgr) {
        if (pumd == null) {
            throw new IllegalArgumentException("Persistence-unit supplied to initialise was null!");
        }
        HashMap<String, String> extraProps = new HashMap<String, String>();
        if (overridingProps != null) {
            extraProps.putAll(overridingProps);
        }
        boolean validProvider = false;
        if (pumd.getProvider() == null || pumd.getProvider().equals(PersistenceProviderImpl.class.getName())) {
            validProvider = true;
        } else if (PersistenceProviderImpl.class.getName().equals(extraProps.get("javax.persistence.provider"))) {
            validProvider = true;
        }
        if (!validProvider) {
            throw new NotProviderException(Localiser.msg((String)"EMF.NotProviderForPersistenceUnit", (Object[])new Object[]{pumd.getName()}));
        }
        this.unitMetaData = pumd;
        if (this.unitMetaData.getTransactionType() == TransactionType.RESOURCE_LOCAL) {
            if (this.unitMetaData.getNonJtaDataSource() != null) {
                extraProps.put("datanucleus.ConnectionFactoryName", this.unitMetaData.getNonJtaDataSource());
                extraProps.put("datanucleus.connection.resourceType", ConnectionResourceType.RESOURCE_LOCAL.toString());
            }
            if (this.unitMetaData.getJtaDataSource() != null) {
                LOGGER.warn((Object)Localiser.msg((String)"EMF.ContainerLocalWithJTADataSource"));
            }
        } else if (this.unitMetaData.getTransactionType() == TransactionType.JTA) {
            if (this.unitMetaData.getJtaDataSource() != null) {
                extraProps.put("datanucleus.ConnectionFactoryName", this.unitMetaData.getJtaDataSource());
                extraProps.put("datanucleus.connection.resourceType", ConnectionResourceType.JTA.toString());
            }
            if (this.unitMetaData.getNonJtaDataSource() != null) {
                extraProps.put("datanucleus.ConnectionFactory2Name", this.unitMetaData.getNonJtaDataSource());
                extraProps.put("datanucleus.connection2.resourceType", ConnectionResourceType.RESOURCE_LOCAL.toString());
            } else {
                LOGGER.warn((Object)Localiser.msg((String)"EMF.ContainerJTAWithNoNonJTADataSource"));
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)("Application EntityManagerFactory with persistence-unit defined as follows : \n" + this.unitMetaData.toString("", "    ")));
            for (Map.Entry entry : extraProps.entrySet()) {
                NucleusLogger.PERSISTENCE.debug((Object)("Application EntityManagerFactory overriding property : name=" + (String)entry.getKey() + " value=" + entry.getValue()));
            }
        }
        this.nucleusCtx = this.initialiseNucleusContext(pumd, extraProps, pluginMgr);
        if (this.entityGraphsToRegister != null) {
            for (JPAEntityGraph jPAEntityGraph : this.entityGraphsToRegister) {
                this.registerEntityGraph(jPAEntityGraph, jPAEntityGraph.getName());
            }
            this.entityGraphsToRegister = null;
        }
        JPAEntityManagerFactory.assertSingleton(pumd.getName(), this);
        boolean allowMetadataLoad = this.nucleusCtx.getConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime");
        if (!allowMetadataLoad) {
            this.nucleusCtx.getMetaDataManager().setAllowMetaDataLoad(false);
        }
    }

    public boolean isContainerManaged() {
        return this.containerManaged;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void close() {
        this.assertIsClosed();
        if (emfByName != null && this.name != null) {
            emfByName.remove(this.name);
        }
        if (this.queryCache != null) {
            this.queryCache.evictAll();
            this.queryCache = null;
        }
        if (this.datastoreCache != null) {
            this.datastoreCache.evictAll();
            this.datastoreCache = null;
        }
        if (this.metamodel != null) {
            this.metamodel = null;
        }
        if (this.unitMetaData != null) {
            this.unitMetaData = null;
        }
        if (this.entityGraphsByName != null) {
            this.entityGraphsByName.clear();
            this.entityGraphsByName = null;
        }
        if (this.entityGraphsToRegister != null) {
            this.entityGraphsToRegister.clear();
            this.entityGraphsToRegister = null;
        }
        this.nucleusCtx.close();
        this.nucleusCtx = null;
        this.closed = true;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public JPAQueryCache getQueryCache() {
        this.assertIsClosed();
        if (this.queryCache == null) {
            this.queryCache = new JPAQueryCache(this.nucleusCtx.getStoreManager().getQueryManager().getQueryResultsCache());
        }
        return this.queryCache;
    }

    public QueryCompilationCache getQueryGenericCompilationCache() {
        return this.nucleusCtx.getStoreManager().getQueryManager().getQueryCompilationCache();
    }

    public QueryDatastoreCompilationCache getQueryDatastoreCompilationCache() {
        return this.nucleusCtx.getStoreManager().getQueryManager().getQueryDatastoreCompilationCache();
    }

    public void addNamedQuery(String name, Query query) {
        this.assertIsClosed();
        if (query == null) {
            return;
        }
        org.datanucleus.store.query.Query intQuery = ((JPAQuery)query).getInternalQuery();
        QueryMetaData qmd = new QueryMetaData(name);
        qmd.setLanguage(QueryLanguage.JPQL.toString());
        qmd.setQuery(intQuery.toString());
        qmd.setResultClass(intQuery.getResultClassName());
        qmd.setUnique(intQuery.isUnique());
        Map queryExts = intQuery.getExtensions();
        if (queryExts != null && !queryExts.isEmpty()) {
            for (Map.Entry queryExtEntry : queryExts.entrySet()) {
                qmd.addExtension((String)queryExtEntry.getKey(), "" + queryExtEntry.getValue());
            }
        }
        this.nucleusCtx.getMetaDataManager().registerNamedQuery(qmd);
    }

    public EntityManager createEntityManager() {
        this.assertIsClosed();
        return this.newEntityManager(this.nucleusCtx, this.persistenceContextType, SynchronizationType.SYNCHRONIZED);
    }

    public EntityManager createEntityManager(Map overridingProps) {
        JPAEntityManager em = (JPAEntityManager)this.newEntityManager(this.nucleusCtx, this.persistenceContextType, SynchronizationType.SYNCHRONIZED);
        if (overridingProps != null && !overridingProps.isEmpty()) {
            for (Map.Entry entry : overridingProps.entrySet()) {
                em.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        return em;
    }

    public EntityManager createEntityManager(SynchronizationType syncType) {
        return this.createEntityManager(syncType, null);
    }

    public EntityManager createEntityManager(SynchronizationType syncType, Map overridingProps) {
        this.assertIsClosed();
        if (this.nucleusCtx.getConfiguration().getStringProperty("datanucleus.transaction.type").equalsIgnoreCase(TransactionType.RESOURCE_LOCAL.toString())) {
            throw new IllegalStateException("EntityManagerFactory is configured for RESOURCE_LOCAL");
        }
        JPAEntityManager em = (JPAEntityManager)this.newEntityManager(this.nucleusCtx, this.persistenceContextType, syncType);
        if (overridingProps != null && !overridingProps.isEmpty()) {
            for (Map.Entry entry : overridingProps.entrySet()) {
                em.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        return em;
    }

    protected EntityManager newEntityManager(PersistenceNucleusContext nucleusCtx, PersistenceContextType contextType, SynchronizationType syncType) {
        return new JPAEntityManager(this, nucleusCtx, contextType, syncType);
    }

    protected PersistenceNucleusContext initialiseNucleusContext(PersistenceUnitMetaData unitMetaData, Map overridingProps, PluginManager pluginMgr) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (unitMetaData.getJtaDataSource() != null) {
            props.put("datanucleus.ConnectionFactoryName".toLowerCase(Locale.ENGLISH), unitMetaData.getJtaDataSource());
        }
        if (unitMetaData.getNonJtaDataSource() != null) {
            props.put("datanucleus.ConnectionFactory2Name".toLowerCase(Locale.ENGLISH), unitMetaData.getNonJtaDataSource());
        }
        if (unitMetaData.getTransactionType() != null) {
            props.put("datanucleus.transaction.type".toLowerCase(Locale.ENGLISH), unitMetaData.getTransactionType().toString());
        }
        if (unitMetaData.getSharedCacheMode().equalsIgnoreCase("NONE")) {
            props.put("datanucleus.cache.level2.type", "none");
        } else if (!unitMetaData.getSharedCacheMode().equalsIgnoreCase("UNSPECIFIED")) {
            props.put("datanucleus.cache.level2.mode", unitMetaData.getSharedCacheMode());
        }
        Properties unitProps = unitMetaData.getProperties();
        if (unitProps != null) {
            for (Object object : unitProps.keySet()) {
                String propName = (String)object;
                props.put(propName.toLowerCase(Locale.ENGLISH), unitProps.getProperty(propName));
            }
        }
        if (this.persistenceContextType == PersistenceContextType.TRANSACTION) {
            if (!props.containsKey("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH), "true");
            }
            if (!props.containsKey("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH), "true");
            }
            if (!props.containsKey("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH), "false");
            }
        } else if (this.persistenceContextType == PersistenceContextType.EXTENDED) {
            if (!props.containsKey("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH), "false");
            }
            if (!props.containsKey("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH), "false");
            }
            if (!props.containsKey("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH), "true");
            }
        }
        if (overridingProps != null) {
            if (overridingProps.containsKey("datanucleus.ConnectionURL")) {
                props.remove("datanucleus.ConnectionFactoryName".toLowerCase(Locale.ENGLISH));
            } else if (overridingProps.containsKey("javax.persistence.jdbc.url")) {
                props.remove("datanucleus.ConnectionFactoryName".toLowerCase(Locale.ENGLISH));
            }
            props.putAll(overridingProps);
        }
        props.put("datanucleus.autoStartMechanism".toLowerCase(Locale.ENGLISH), "None");
        props.put("datanucleus.PersistenceUnitName".toLowerCase(Locale.ENGLISH), unitMetaData.getName());
        if (unitMetaData.getValidationMode() != null) {
            props.put("datanucleus.validation.mode".toLowerCase(Locale.ENGLISH), unitMetaData.getValidationMode());
        }
        props.remove("datanucleus.jpa.persistenceContextType");
        if (!props.containsKey("datanucleus.transaction.type".toLowerCase(Locale.ENGLISH))) {
            props.put("datanucleus.transaction.type".toLowerCase(Locale.ENGLISH), TransactionType.RESOURCE_LOCAL.toString());
        } else {
            String transactionType = (String)props.get("datanucleus.transaction.type".toLowerCase(Locale.ENGLISH));
            if (TransactionType.JTA.toString().equalsIgnoreCase(transactionType)) {
                props.put("datanucleus.connection.resourceType".toLowerCase(Locale.ENGLISH), ConnectionResourceType.JTA.toString());
                props.put("datanucleus.connection2.resourceType".toLowerCase(Locale.ENGLISH), ConnectionResourceType.JTA.toString());
            }
        }
        HashMap startupProps = null;
        for (String startupPropName : AbstractNucleusContext.STARTUP_PROPERTIES) {
            for (Map.Entry propsEntry : props.entrySet()) {
                if (!((String)propsEntry.getKey()).equalsIgnoreCase(startupPropName)) continue;
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put(startupPropName, propsEntry.getValue());
            }
        }
        PersistenceNucleusContextImpl persistenceNucleusContextImpl = pluginMgr != null ? new PersistenceNucleusContextImpl("JPA", startupProps, pluginMgr) : new PersistenceNucleusContextImpl("JPA", startupProps);
        Configuration propConfig = persistenceNucleusContextImpl.getConfiguration();
        propConfig.setPersistenceProperties(props);
        JPAMetaDataManager mmgr = (JPAMetaDataManager)persistenceNucleusContextImpl.getMetaDataManager();
        mmgr.setAllowXML(propConfig.getBooleanProperty("datanucleus.metadata.allowXML"));
        mmgr.setAllowAnnotations(propConfig.getBooleanProperty("datanucleus.metadata.allowAnnotations"));
        mmgr.setValidate(propConfig.getBooleanProperty("datanucleus.metadata.xml.validate"));
        mmgr.setDefaultNullable(propConfig.getBooleanProperty("datanucleus.metadata.defaultNullable"));
        mmgr.registerEntityGraphListener(this);
        persistenceNucleusContextImpl.getMetaDataManager().loadPersistenceUnit(unitMetaData, null);
        persistenceNucleusContextImpl.initialise();
        return persistenceNucleusContextImpl;
    }

    public Map<String, Object> getProperties() {
        return this.nucleusCtx.getConfiguration().getPersistenceProperties();
    }

    public Set<String> getSupportedProperties() {
        this.assertIsClosed();
        return this.nucleusCtx.getConfiguration().getSupportedProperties();
    }

    protected void assertIsClosed() {
        if (this.closed) {
            throw new IllegalStateException("EntityManagerFactory is already closed");
        }
    }

    public Cache getCache() {
        this.assertIsClosed();
        if (this.datastoreCache == null && this.nucleusCtx.hasLevel2Cache()) {
            this.datastoreCache = new JPADataStoreCache(this.nucleusCtx);
        }
        return this.datastoreCache;
    }

    public Metamodel getMetamodel() {
        this.assertIsClosed();
        if (this.metamodel == null) {
            this.metamodel = new MetamodelImpl(this.nucleusCtx.getMetaDataManager());
        }
        return this.metamodel;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.assertIsClosed();
        return new CriteriaBuilderImpl(this);
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this;
    }

    public Object getIdentifier(Object entity) {
        Object id;
        this.assertIsClosed();
        if (entity == null) {
            throw new IllegalArgumentException("Supplied object is null, so cannot have an identifier");
        }
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(entity.getClass(), this.nucleusCtx.getClassLoaderResolver(null));
        if (cmd == null) {
            throw new IllegalArgumentException("Object of type " + entity.getClass().getName() + " is not an entity");
        }
        if (cmd.usesSingleFieldIdentityClass() && (id = this.nucleusCtx.getApiAdapter().getIdForObject(entity)) instanceof SingleFieldId) {
            return ((SingleFieldId)id).getKeyAsObject();
        }
        return this.nucleusCtx.getApiAdapter().getIdForObject(entity);
    }

    public boolean isLoaded(Object entity, String attrName) {
        this.assertIsClosed();
        ExecutionContext ec = this.nucleusCtx.getApiAdapter().getExecutionContext(entity);
        if (ec == null) {
            return false;
        }
        DNStateManager sm = ec.findStateManager(entity);
        if (sm == null) {
            return false;
        }
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(entity.getClass(), ec.getClassLoaderResolver());
        if (cmd == null) {
            return false;
        }
        String[] loadedFields = sm.getLoadedFieldNames();
        if (loadedFields != null) {
            for (int j = 0; j < loadedFields.length; ++j) {
                if (!loadedFields[j].equals(attrName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLoaded(Object entity) {
        this.assertIsClosed();
        return !this.nucleusCtx.getApiAdapter().getObjectState(entity).equals("hollow");
    }

    public <T> T unwrap(Class<T> cls) {
        this.assertIsClosed();
        if (ClassConstants.PERSISTENCE_NUCLEUS_CONTEXT.isAssignableFrom(cls)) {
            return (T)this.nucleusCtx;
        }
        if (ClassConstants.NUCLEUS_CONTEXT.isAssignableFrom(cls)) {
            return (T)this.nucleusCtx;
        }
        if (ClassConstants.STORE_MANAGER.isAssignableFrom(cls)) {
            return (T)this.nucleusCtx.getStoreManager();
        }
        if (ClassConstants.METADATA_MANAGER.isAssignableFrom(cls)) {
            return (T)this.nucleusCtx.getMetaDataManager();
        }
        throw new PersistenceException("Not yet supported unwrapping of " + cls.getName());
    }

    public EntityGraph getNamedEntityGraph(String graphName) {
        if (this.entityGraphsByName != null) {
            return this.entityGraphsByName.get(graphName);
        }
        return null;
    }

    public Set<String> getEntityGraphNames() {
        if (this.entityGraphsByName == null) {
            return null;
        }
        return this.entityGraphsByName.keySet();
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphsByType(Class<T> entityClass) {
        if (this.entityGraphsByName == null) {
            return null;
        }
        ArrayList<EntityGraph<T>> results = new ArrayList<EntityGraph<T>>();
        for (JPAEntityGraph eg : this.entityGraphsByName.values()) {
            if (!eg.getClassType().isAssignableFrom(entityClass)) continue;
            results.add(eg);
        }
        return results;
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> graph) {
        this.assertIsClosed();
        if (graph == null) {
            return;
        }
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(((JPAEntityGraph)graph).getClassType(), this.nucleusCtx.getClassLoaderResolver(null));
        if (cmd == null) {
            throw new IllegalStateException("Attempt to add graph " + graph + " for type=" + ((JPAEntityGraph)graph).getClassType() + " but is not a known Entity");
        }
        String myGraphName = graphName != null ? graphName : cmd.getEntityName();
        ((JPAEntityGraph)graph).setName(myGraphName);
        if (this.entityGraphsByName == null) {
            this.entityGraphsByName = new HashMap<String, JPAEntityGraph>();
        }
        this.entityGraphsByName.put(myGraphName, (JPAEntityGraph)graph);
        this.registerEntityGraph((JPAEntityGraph)graph, graph.getName());
    }

    public void registerEntityGraph(JPAEntityGraph eg, String graphName) {
        this.assertIsClosed();
        FetchGroup fg = new FetchGroup((NucleusContext)this.nucleusCtx, graphName, eg.getClassType());
        if (eg.getIncludeAllAttributes()) {
            fg.addCategory("all");
        } else {
            Map<Class, Subgraph> subclassSubgraphs;
            List<AttributeNode<?>> graphNodes = eg.getAttributeNodes();
            if (graphNodes != null) {
                for (AttributeNode<?> node : graphNodes) {
                    fg.addMember(node.getAttributeName());
                    Map subgraphByTypeForNode = node.getSubgraphs();
                    if (subgraphByTypeForNode.isEmpty()) continue;
                    for (Map.Entry subgraphEntry : subgraphByTypeForNode.entrySet()) {
                        FetchGroup subFG = new FetchGroup((NucleusContext)this.nucleusCtx, graphName, (Class)subgraphEntry.getKey());
                        List subgraphNodes = ((Subgraph)subgraphEntry.getValue()).getAttributeNodes();
                        if (subgraphNodes != null) {
                            for (AttributeNode subNode : subgraphNodes) {
                                subFG.addMember(subNode.getAttributeName());
                            }
                        }
                        this.nucleusCtx.getFetchGroupManager().addFetchGroup(subFG);
                    }
                }
            }
            if ((subclassSubgraphs = eg.getSubclassSubgraphs()) != null && !subclassSubgraphs.isEmpty()) {
                for (Map.Entry<Class, Subgraph> subclassEntry : subclassSubgraphs.entrySet()) {
                    FetchGroup subFG = new FetchGroup((NucleusContext)this.nucleusCtx, graphName, subclassEntry.getKey());
                    List subgraphNodes = subclassEntry.getValue().getAttributeNodes();
                    if (subgraphNodes != null) {
                        for (AttributeNode subNode : subgraphNodes) {
                            subFG.addMember(subNode.getAttributeName());
                        }
                    }
                    this.nucleusCtx.getFetchGroupManager().addFetchGroup(subFG);
                }
            }
        }
        this.nucleusCtx.getFetchGroupManager().addFetchGroup(fg);
    }

    public void deregisterEntityGraph(String graphName) {
        this.assertIsClosed();
        Set fgs = this.nucleusCtx.getFetchGroupManager().getFetchGroupsWithName(graphName);
        if (fgs != null) {
            for (FetchGroup fg : fgs) {
                this.nucleusCtx.getFetchGroupManager().removeFetchGroup(fg);
            }
        }
    }

    public String getDefinedEntityGraphName() {
        return "DN_ENTITY_GRAPH" + this.random.nextLong();
    }

    @Override
    public void entityGraphRegistered(JPAEntityGraph eg) {
        if (this.entityGraphsByName == null) {
            this.entityGraphsByName = new HashMap<String, JPAEntityGraph>();
        }
        this.entityGraphsByName.put(eg.getName(), eg);
        if (this.nucleusCtx != null) {
            this.registerEntityGraph(eg, eg.getName());
        } else {
            if (this.entityGraphsToRegister == null) {
                this.entityGraphsToRegister = new ArrayList<JPAEntityGraph>();
            }
            this.entityGraphsToRegister.add(eg);
        }
    }

    private static PersistenceUnitMetaData getPersistenceUnitMetaDataForName(String unitName, PluginManager pluginMgr, Map overridingProps) {
        PersistenceFileMetaData[] files;
        PersistenceUnitMetaData pumd = null;
        String persistenceFileName = null;
        boolean validate = true;
        boolean namespaceAware = true;
        if (overridingProps != null) {
            if (overridingProps.containsKey("datanucleus.persistenceXmlFilename")) {
                persistenceFileName = (String)overridingProps.get("datanucleus.persistenceXmlFilename");
            }
            if (overridingProps.containsKey("datanucleus.metadata.xml.validate")) {
                validate = Boolean.getBoolean((String)overridingProps.get("datanucleus.metadata.xml.validate"));
            }
            if (overridingProps.containsKey("datanucleus.metadata.xml.namespaceAware")) {
                namespaceAware = Boolean.getBoolean((String)overridingProps.get("datanucleus.metadata.xml.namespaceAware"));
            }
        }
        if ((files = MetaDataUtils.parsePersistenceFiles((PluginManager)pluginMgr, persistenceFileName, (boolean)validate, (boolean)namespaceAware, (ClassLoaderResolver)new ClassLoaderResolverImpl())) == null) {
            LOGGER.warn((Object)Localiser.msg((String)"EMF.NoPersistenceXML"));
        } else {
            for (int i = 0; i < files.length; ++i) {
                PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
                for (int j = 0; j < unitmds.length; ++j) {
                    if (!unitMetaDataCache.containsKey(unitmds[j].getName())) {
                        unitMetaDataCache.put(unitmds[j].getName(), unitmds[j]);
                    } else {
                        LOGGER.warn((Object)("Found persistence-unit with name \"" + unitmds[j].getName() + "\" at " + unitmds[j].getRootURI() + " but already found one with same name at " + unitMetaDataCache.get(unitmds[j].getName()).getRootURI()));
                    }
                    if (!unitmds[j].getName().equals(unitName) || pumd != null) continue;
                    pumd = unitmds[j];
                    pumd.clearJarFiles();
                }
            }
        }
        if (pumd == null) {
            LOGGER.warn((Object)Localiser.msg((String)"EMF.PersistenceUnitNotFound", (Object[])new Object[]{unitName}));
        } else {
            unitMetaDataCache.put(unitName, pumd);
            if (overridingProps != null) {
                if (overridingProps.containsKey("javax.persistence.jtaDataSource")) {
                    pumd.setJtaDataSource((String)overridingProps.get("javax.persistence.jtaDataSource"));
                }
                if (overridingProps.containsKey("javax.persistence.nonJtaDataSource")) {
                    pumd.setNonJtaDataSource((String)overridingProps.get("javax.persistence.nonJtaDataSource"));
                }
                if (overridingProps.containsKey("javax.persistence.transactionType")) {
                    pumd.setTransactionType((String)overridingProps.get("javax.persistence.transactionType"));
                }
                if (overridingProps.containsKey("javax.persistence.sharedCache.mode")) {
                    pumd.setSharedCacheMode((String)overridingProps.get("javax.persistence.sharedCache.mode"));
                }
            }
        }
        return pumd;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.name == null) {
            throw new InvalidObjectException("Could not serialize EntityManagerFactory with null name");
        }
        oos.defaultWriteObject();
        oos.writeObject(this.nucleusCtx.getConfiguration().getPersistenceProperties());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.deserialisationProps = (Map)ois.readObject();
    }

    private Object readResolve() throws InvalidObjectException {
        JPAEntityManagerFactory emf = null;
        if (emfByName != null && (emf = emfByName.get(this.name)) != null) {
            return emf;
        }
        PersistenceUnitMetaData pumd = unitMetaDataCache != null ? unitMetaDataCache.get(this.name) : null;
        PluginManager pluginMgr = null;
        if (pumd == null) {
            pluginMgr = PluginManager.createPluginManager(this.deserialisationProps, (ClassLoader)this.getClass().getClassLoader());
            pumd = JPAEntityManagerFactory.getPersistenceUnitMetaDataForName(this.name, pluginMgr, this.deserialisationProps);
        }
        this.initialise(pumd, this.deserialisationProps, pluginMgr);
        this.deserialisationProps = null;
        return this;
    }

    private static synchronized void assertSingleton(String name, JPAEntityManagerFactory emf) {
        Boolean singleton = emf.getNucleusContext().getConfiguration().getBooleanObjectProperty("datanucleus.singletonEMFForName");
        if (singleton != null && singleton.booleanValue()) {
            if (emfByName == null) {
                emfByName = new ConcurrentHashMap();
            }
            if (emfByName.containsKey(name)) {
                JPAEntityManagerFactory singletonEMF = emfByName.get(name);
                emf.close();
                NucleusLogger.PERSISTENCE.warn((Object)("Requested EMF of name \"" + name + "\" but already exists and using singleton pattern, so returning existing EMF"));
                throw new SingletonEMFException("Requested EMF that already exists", singletonEMF);
            }
            emfByName.putIfAbsent(name, emf);
        }
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.api.jpa.Localisation", (ClassLoader)JPAEntityManagerFactory.class.getClassLoader());
        LOGGER = NucleusLogger.getLoggerInstance((String)"DataNucleus.JPA");
        emfByName = null;
        unitMetaDataCache = null;
    }
}

