/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.lang.reflect.Field;
import javax.persistence.EntityManager;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.ClassUtils;

public class DataNucleusHelperJPA {
    public static Object getSurrogateVersionForEntity(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnGetVersion();
        }
        return null;
    }

    public static Object getDatastoreIdForEntity(Object obj) {
        Object id;
        if (obj instanceof Persistable && (id = ((Persistable)obj).dnGetObjectId()) instanceof DatastoreId) {
            return ((DatastoreId)id).getKeyAsObject();
        }
        return null;
    }

    public static Object getObjectId(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnGetObjectId();
        }
        return null;
    }

    public static EntityManager getEntityManager(Object obj) {
        if (obj instanceof Persistable) {
            return (EntityManager)((Persistable)obj).dnGetExecutionContext().getOwner();
        }
        return null;
    }

    public static boolean isPersistent(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnIsPersistent();
        }
        return false;
    }

    public static boolean isDeleted(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnIsDeleted();
        }
        return false;
    }

    public static boolean isDetached(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnIsDetached();
        }
        return false;
    }

    public static boolean isTransactional(Object obj) {
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnIsTransactional();
        }
        return false;
    }

    public static String getObjectState(Object obj) {
        if (obj == null) {
            return null;
        }
        if (DataNucleusHelperJPA.isDetached(obj)) {
            return "detached";
        }
        if (DataNucleusHelperJPA.isPersistent(obj)) {
            if (DataNucleusHelperJPA.isTransactional(obj)) {
                if (DataNucleusHelperJPA.isDeleted(obj)) {
                    return "persistent-deleted";
                }
                return "persistent";
            }
            return "persistent";
        }
        return "transient";
    }

    public static Object[] getDetachedStateForObject(Object obj) {
        if (obj == null || !DataNucleusHelperJPA.isDetached(obj)) {
            return null;
        }
        try {
            Field fld = ClassUtils.getFieldForClass(obj.getClass(), (String)"dnDetachedState");
            fld.setAccessible(true);
            return (Object[])fld.get(obj);
        }
        catch (Exception e) {
            throw new NucleusException("Exception accessing dnDetachedState field", (Throwable)e);
        }
    }

    public static String[] getDirtyFields(Object obj, EntityManager em) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (DataNucleusHelperJPA.isDetached(pc)) {
            ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
            ObjectProvider op = ec.getNucleusContext().getObjectProviderFactory().newForDetached(ec, (Object)pc, pc.dnGetObjectId(), null);
            pc.dnReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            String[] dirtyFieldNames = op.getDirtyFieldNames();
            pc.dnReplaceStateManager(null);
            return dirtyFieldNames;
        }
        ExecutionContext ec = (ExecutionContext)pc.dnGetExecutionContext();
        ObjectProvider op = ec.findObjectProvider((Object)pc);
        return op == null ? null : op.getDirtyFieldNames();
    }

    public static String[] getLoadedFields(Object obj, EntityManager em) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (DataNucleusHelperJPA.isDetached(pc)) {
            ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
            ObjectProvider op = ec.getNucleusContext().getObjectProviderFactory().newForDetached(ec, (Object)pc, pc.dnGetObjectId(), null);
            pc.dnReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            String[] loadedFieldNames = op.getLoadedFieldNames();
            pc.dnReplaceStateManager(null);
            return loadedFieldNames;
        }
        ExecutionContext ec = (ExecutionContext)pc.dnGetExecutionContext();
        ObjectProvider op = ec.findObjectProvider((Object)pc);
        return op == null ? null : op.getLoadedFieldNames();
    }

    public static Boolean isFieldLoaded(Object obj, String memberName, EntityManager em) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (pc.dnIsDetached()) {
            ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
            ObjectProvider op = ec.getNucleusContext().getObjectProviderFactory().newForDetached(ec, (Object)pc, pc.dnGetObjectId(), null);
            pc.dnReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            int position = op.getClassMetaData().getAbsolutePositionOfMember(memberName);
            boolean loaded = op.isFieldLoaded(position);
            pc.dnReplaceStateManager(null);
            return loaded;
        }
        ExecutionContext ec = (ExecutionContext)pc.dnGetExecutionContext();
        ObjectProvider op = ec.findObjectProvider((Object)pc);
        if (op == null) {
            return null;
        }
        int position = op.getClassMetaData().getAbsolutePositionOfMember(memberName);
        return op.isFieldLoaded(position);
    }

    public static Boolean isFieldDirty(Object obj, String memberName, EntityManager em) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (pc.dnIsDetached()) {
            ExecutionContext ec = ((JPAEntityManager)em).getExecutionContext();
            ObjectProvider op = ec.getNucleusContext().getObjectProviderFactory().newForDetached(ec, (Object)pc, pc.dnGetObjectId(), null);
            pc.dnReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            int position = op.getClassMetaData().getAbsolutePositionOfMember(memberName);
            boolean[] dirtyFieldNumbers = op.getDirtyFields();
            pc.dnReplaceStateManager(null);
            return dirtyFieldNumbers[position];
        }
        ExecutionContext ec = (ExecutionContext)pc.dnGetExecutionContext();
        ObjectProvider op = ec.findObjectProvider((Object)pc);
        if (op == null) {
            return null;
        }
        int position = op.getClassMetaData().getAbsolutePositionOfMember(memberName);
        boolean[] dirtyFieldNumbers = op.getDirtyFields();
        return dirtyFieldNumbers[position];
    }

    public static void makeFieldDirty(Object obj, String memberName) {
        if (obj == null || !(obj instanceof Persistable)) {
            return;
        }
        ((Persistable)obj).dnMakeDirty(memberName);
    }
}

