/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.JPQLHelper;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.Literal;

public class ExpressionImpl<T>
implements Expression<T>,
Serializable {
    static final long serialVersionUID = -9180595377551709140L;
    protected CriteriaBuilderImpl cb;
    private final Class<T> cls;
    private String alias;
    org.datanucleus.store.query.expression.Expression queryExpr;

    public ExpressionImpl(CriteriaBuilderImpl cb, Class<T> cls) {
        this.cb = cb;
        this.cls = cls;
    }

    public <X> Expression<X> as(Class<X> cls) {
        ExpressionImpl<X> expr = new ExpressionImpl<X>(this.cb, cls);
        expr.queryExpr = this.queryExpr;
        return expr;
    }

    public Predicate in(Collection<?> values) {
        return this.cb.in(this, values.toArray());
    }

    public Predicate in(Expression<?> ... values) {
        return this.cb.in(this, (Expression<? extends X>[])values);
    }

    public Predicate in(Expression<Collection<?>> values) {
        return this.cb.in(this, (Expression<? extends X>[])new Expression[]{values});
    }

    public Predicate in(Object ... values) {
        return this.cb.in(this, values);
    }

    public Predicate isNotNull() {
        PredicateImpl pred = new PredicateImpl(this.cb);
        Literal lit = new Literal(null);
        DyadicExpression queryExpr = new DyadicExpression(this.getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_NOTEQ, (org.datanucleus.store.query.expression.Expression)lit);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate isNull() {
        PredicateImpl pred = new PredicateImpl(this.cb);
        Literal lit = new Literal(null);
        DyadicExpression queryExpr = new DyadicExpression(this.getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_EQ, (org.datanucleus.store.query.expression.Expression)lit);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Selection<T> alias(String alias) {
        this.alias = alias;
        return this;
    }

    public List<Selection<?>> getCompoundSelectionItems() {
        return null;
    }

    public boolean isCompoundSelection() {
        return false;
    }

    public String getAlias() {
        return this.alias;
    }

    public Class<? extends T> getJavaType() {
        return this.cls;
    }

    public org.datanucleus.store.query.expression.Expression getQueryExpression() {
        return this.queryExpr;
    }

    public String toString() {
        return JPQLHelper.getJPQLForExpression(this.queryExpr);
    }
}

