/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.persistence.spi.ProviderUtil;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassLoaderResolverImpl;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jpa.JPAAdapter;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.SingletonEMFException;
import org.datanucleus.api.jpa.exceptions.NoPersistenceUnitException;
import org.datanucleus.api.jpa.exceptions.NoPersistenceXmlException;
import org.datanucleus.api.jpa.exceptions.NotProviderException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.schema.SchemaTool;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class PersistenceProviderImpl
implements PersistenceProvider,
ProviderUtil {
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo unitInfo, Map properties) {
        try {
            return new JPAEntityManagerFactory(unitInfo, properties);
        }
        catch (SingletonEMFException se) {
            return se.getSingleton();
        }
        catch (NoPersistenceUnitException | NoPersistenceXmlException | NotProviderException ne) {
            return null;
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String unitName, Map properties) {
        try {
            return new JPAEntityManagerFactory(unitName, properties);
        }
        catch (SingletonEMFException se) {
            return se.getSingleton();
        }
        catch (NoPersistenceUnitException | NoPersistenceXmlException | NotProviderException ne) {
            return null;
        }
    }

    public LoadState isLoadedWithoutReference(Object entity, String memberName) {
        if (entity == null) {
            return LoadState.UNKNOWN;
        }
        JPAAdapter adapter = new JPAAdapter();
        ExecutionContext ec = adapter.getExecutionContext(entity);
        if (ec == null) {
            try {
                Method getterMethod = ClassUtils.getMethodWithArgument(entity.getClass(), (String)("dnGet" + memberName), entity.getClass());
                getterMethod.invoke(null, entity);
                return LoadState.LOADED;
            }
            catch (IllegalAccessException iae) {
                return LoadState.NOT_LOADED;
            }
            catch (Exception iae) {
                return LoadState.UNKNOWN;
            }
        }
        ObjectProvider op = ec.findObjectProvider(entity);
        if (op == null) {
            return LoadState.UNKNOWN;
        }
        String[] loadedFields = op.getLoadedFieldNames();
        if (loadedFields != null) {
            for (int i = 0; i < loadedFields.length; ++i) {
                if (!loadedFields[i].equals(memberName)) continue;
                return LoadState.LOADED;
            }
        }
        return LoadState.NOT_LOADED;
    }

    public LoadState isLoadedWithReference(Object entity, String memberName) {
        return this.isLoadedWithoutReference(entity, memberName);
    }

    public LoadState isLoaded(Object entity) {
        if (entity == null) {
            return LoadState.UNKNOWN;
        }
        JPAAdapter adapter = new JPAAdapter();
        ExecutionContext ec = adapter.getExecutionContext(entity);
        if (ec == null) {
            return LoadState.UNKNOWN;
        }
        ObjectProvider op = ec.findObjectProvider(entity);
        if (op == null) {
            return LoadState.UNKNOWN;
        }
        boolean allLoaded = true;
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(entity.getClass(), ec.getClassLoaderResolver());
        int[] dfgFieldNumbers = cmd.getDFGMemberPositions();
        for (int i = 0; i < dfgFieldNumbers.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(dfgFieldNumbers[i]);
            String[] loadedFields = op.getLoadedFieldNames();
            boolean memberLoaded = false;
            if (loadedFields != null) {
                for (int j = 0; j < loadedFields.length; ++j) {
                    if (!loadedFields[j].equals(mmd.getName())) continue;
                    memberLoaded = true;
                    break;
                }
            }
            if (memberLoaded) continue;
            allLoaded = false;
            break;
        }
        return allLoaded ? LoadState.LOADED : LoadState.NOT_LOADED;
    }

    public ProviderUtil getProviderUtil() {
        return this;
    }

    public void generateSchema(PersistenceUnitInfo unitInfo, Map overridingProps) {
        PersistenceUnitMetaData pumd = null;
        URI rootURI = null;
        try {
            rootURI = unitInfo.getPersistenceUnitRootUrl().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        pumd = unitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA ? new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.JTA.toString(), rootURI) : new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.RESOURCE_LOCAL.toString(), rootURI);
        List classNames = unitInfo.getManagedClassNames();
        Iterator classIter = classNames.iterator();
        while (classIter.hasNext()) {
            pumd.addClassName((String)classIter.next());
        }
        List mappingFileNames = unitInfo.getMappingFileNames();
        Iterator mappingFileIter = mappingFileNames.iterator();
        while (mappingFileIter.hasNext()) {
            pumd.addMappingFile((String)mappingFileIter.next());
        }
        List jarUrls = unitInfo.getJarFileUrls();
        Iterator jarUrlIter = jarUrls.iterator();
        while (jarUrlIter.hasNext()) {
            pumd.addJarFile((URL)jarUrlIter.next());
        }
        Properties unitProps = unitInfo.getProperties();
        if (unitProps != null) {
            Enumeration<?> e = unitProps.propertyNames();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                pumd.addProperty(prop, unitProps.getProperty(prop));
            }
        }
        pumd.setExcludeUnlistedClasses(unitInfo.excludeUnlistedClasses());
        pumd.setProvider(unitInfo.getPersistenceProviderClassName());
        this.generateSchemaForPersistentUnit(pumd, overridingProps);
    }

    public boolean generateSchema(String unitName, Map overridingProps) {
        PersistenceFileMetaData[] files;
        PluginManager pluginMgr = PluginManager.createPluginManager((Map)overridingProps, (ClassLoader)this.getClass().getClassLoader());
        String persistenceFileName = null;
        boolean validate = true;
        boolean namespaceAware = true;
        if (overridingProps != null) {
            if (overridingProps.containsKey("datanucleus.persistenceXmlFilename")) {
                persistenceFileName = (String)overridingProps.get("datanucleus.persistenceXmlFilename");
            }
            if (overridingProps.containsKey("datanucleus.metadata.xml.validate")) {
                validate = Boolean.getBoolean((String)overridingProps.get("datanucleus.metadata.xml.validate"));
            }
            if (overridingProps.containsKey("datanucleus.metadata.xml.namespaceAware")) {
                namespaceAware = Boolean.getBoolean((String)overridingProps.get("datanucleus.metadata.xml.namespaceAware"));
            }
        }
        if ((files = MetaDataUtils.parsePersistenceFiles((PluginManager)pluginMgr, persistenceFileName, (boolean)validate, (boolean)namespaceAware, (ClassLoaderResolver)new ClassLoaderResolverImpl())) == null) {
            throw new PersistenceException(Localiser.msg((String)"EMF.NoPersistenceXML"));
        }
        PersistenceUnitMetaData pumd = null;
        block0: for (int i = 0; i < files.length; ++i) {
            PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
            for (int j = 0; j < unitmds.length; ++j) {
                if (!unitmds[j].getName().equals(unitName)) continue;
                pumd = unitmds[j];
                pumd.clearJarFiles();
                continue block0;
            }
        }
        if (pumd == null) {
            throw new PersistenceException("Persistence unit " + unitName + " not found!");
        }
        this.generateSchemaForPersistentUnit(pumd, overridingProps);
        return true;
    }

    protected void generateSchemaForPersistentUnit(PersistenceUnitMetaData pumd, Map overridingProps) {
        String modeStr = (String)overridingProps.get("javax.persistence.schema-generation.database.action");
        if (modeStr == null || modeStr.equalsIgnoreCase("none")) {
            modeStr = (String)overridingProps.get("javax.persistence.schema-generation.scripts.action");
        }
        SchemaTool.Mode mode = null;
        if (modeStr != null) {
            if (modeStr.equalsIgnoreCase("create")) {
                mode = SchemaTool.Mode.CREATE;
            } else if (modeStr.equalsIgnoreCase("drop")) {
                mode = SchemaTool.Mode.DELETE;
            } else if (modeStr.equalsIgnoreCase("drop-and-create")) {
                mode = SchemaTool.Mode.DELETE_CREATE;
            }
        }
        if (mode == null) {
            return;
        }
        SchemaTool.getNucleusContextForMode((SchemaTool.Mode)mode, (String)"JPA", (Map)overridingProps, (String)pumd.getName(), null, (boolean)true);
    }
}

