/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.MapAttribute;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.JPAAttributeNode;
import org.datanucleus.api.jpa.JPASubgraph;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;

public abstract class AbstractJPAGraph<T> {
    MetaDataManager mmgr;
    Class<T> classType;
    Map<String, JPAAttributeNode<?>> attributeNodeMap = null;
    boolean mutable = true;

    public AbstractJPAGraph(MetaDataManager mmgr, Class<T> clsType) {
        this.mmgr = mmgr;
        this.classType = clsType;
        if (clsType == null) {
            throw new IllegalArgumentException("Unable to create JPA EntityGraph component with no defined class");
        }
    }

    public Class<T> getClassType() {
        return this.classType;
    }

    public void setNotMutable() {
        this.mutable = false;
    }

    public List<AttributeNode<?>> getAttributeNodes() {
        if (this.attributeNodeMap == null) {
            return null;
        }
        ArrayList attributeNodes = new ArrayList();
        attributeNodes.addAll(this.attributeNodeMap.values());
        return attributeNodes;
    }

    public void addAttributeNodes(String ... attributeNames) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            JPAAttributeNode node = new JPAAttributeNode(this.mmgr, this, attributeNames[i]);
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
    }

    public void addAttributeNodes(Attribute<? super T, ?> ... attributes) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        for (int i = 0; i < attributes.length; ++i) {
            JPAAttributeNode node = new JPAAttributeNode(this.mmgr, this, attributes[i].getName());
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
    }

    public <X> Subgraph<X> addSubgraph(Attribute<? super T, X> attribute) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        Class type = attribute.getJavaType();
        return this.addSubgraph(attribute, type);
    }

    public <X> Subgraph<? extends X> addSubgraph(Attribute<? super T, X> attribute, Class<? extends X> type) {
        JPAAttributeNode<Object> node;
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        if ((node = this.attributeNodeMap.get(attribute.getName())) == null) {
            node = new JPAAttributeNode(this.mmgr, this, attribute.getName());
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
        JPASubgraph<? extends X> subgraph = new JPASubgraph<X>(this.mmgr, type);
        node.addSubgraph(subgraph);
        return subgraph;
    }

    public <X> Subgraph<X> addSubgraph(String attributeName) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        ClassLoaderResolver clr = this.mmgr.getNucleusContext().getClassLoaderResolver(null);
        AbstractClassMetaData cmd = this.mmgr.getMetaDataForClass(this.classType, clr);
        AbstractMemberMetaData mmd = cmd.getMetaDataForMember(attributeName);
        Class type = mmd.getType();
        if (mmd.hasCollection()) {
            type = clr.classForName(mmd.getCollection().getElementType());
        } else if (mmd.hasArray()) {
            type = clr.classForName(mmd.getArray().getElementType());
        } else if (mmd.hasMap()) {
            type = clr.classForName(mmd.getMap().getValueType());
        }
        return this.addSubgraph(attributeName, type);
    }

    public <X> Subgraph<X> addSubgraph(String attributeName, Class<X> type) {
        JPAAttributeNode<Object> node;
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        if ((node = this.attributeNodeMap.get(attributeName)) == null) {
            node = new JPAAttributeNode(this.mmgr, this, attributeName);
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
        JPASubgraph<X> subgraph = new JPASubgraph<X>(this.mmgr, type);
        node.addSubgraph(subgraph);
        return subgraph;
    }

    public <X> Subgraph<X> addKeySubgraph(Attribute<? super T, X> attribute) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (!(attribute instanceof MapAttribute)) {
            throw new IllegalStateException("Cannot add key subgraph for attribute that is not a map");
        }
        MapAttribute mapAttr = (MapAttribute)attribute;
        Class type = mapAttr.getKeyJavaType();
        return this.addKeySubgraph(attribute, type);
    }

    public <X> Subgraph<? extends X> addKeySubgraph(Attribute<? super T, X> attribute, Class<? extends X> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<X> addKeySubgraph(String attributeName) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        ClassLoaderResolver clr = this.mmgr.getNucleusContext().getClassLoaderResolver(null);
        AbstractClassMetaData cmd = this.mmgr.getMetaDataForClass(this.classType, clr);
        AbstractMemberMetaData mmd = cmd.getMetaDataForMember(attributeName);
        Class type = clr.classForName(mmd.getMap().getKeyType());
        return this.addKeySubgraph(attributeName, type);
    }

    public <X> Subgraph<X> addKeySubgraph(String attributeName, Class<X> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

