/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.datanucleus.BeanValidationHandler;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.metadata.JPAMetaDataManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.ObjectProvider;

public class JPACallbackHandler
implements CallbackHandler {
    PersistenceNucleusContext nucleusCtx;
    BeanValidationHandler beanValidationHandler;

    public JPACallbackHandler(PersistenceNucleusContext nucleusCtx) {
        this.nucleusCtx = nucleusCtx;
    }

    public void setBeanValidationHandler(BeanValidationHandler handler) {
        this.beanValidationHandler = handler;
    }

    public void prePersist(Object pc) {
        if (this.nucleusCtx.getApiAdapter().isNew(pc)) {
            this.invokeCallback(pc, PrePersist.class);
        }
        if (this.beanValidationHandler != null) {
            this.beanValidationHandler.prePersist(pc);
        }
    }

    public void preStore(Object pc) {
        ObjectProvider op;
        if (!this.nucleusCtx.getApiAdapter().isNew(pc)) {
            this.invokeCallback(pc, PreUpdate.class);
        }
        if (this.beanValidationHandler != null && !(op = this.nucleusCtx.getApiAdapter().getExecutionContext(pc).findObjectProvider(pc)).getLifecycleState().isNew()) {
            this.beanValidationHandler.preStore(pc);
        }
    }

    public void postStore(Object pc) {
        if (this.nucleusCtx.getApiAdapter().isNew(pc)) {
            this.invokeCallback(pc, PostPersist.class);
        } else {
            this.invokeCallback(pc, PostUpdate.class);
        }
    }

    public void preDelete(Object pc) {
        this.invokeCallback(pc, PreRemove.class);
        if (this.beanValidationHandler != null) {
            this.beanValidationHandler.preDelete(pc);
        }
    }

    public void postDelete(Object pc) {
        this.invokeCallback(pc, PostRemove.class);
    }

    public void postLoad(Object pc) {
        this.invokeCallback(pc, PostLoad.class);
    }

    public void addListener(Object listener, Class[] classes) {
    }

    public void removeListener(Object listener) {
    }

    public void close() {
    }

    private void invokeCallback(Object pc, Class callbackClass) {
        ExecutionContext ec = this.nucleusCtx.getApiAdapter().getExecutionContext(pc);
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData acmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), clr);
        try {
            List listenerMetaData;
            if (!acmd.isExcludeDefaultListeners() && (listenerMetaData = ((JPAMetaDataManager)ec.getMetaDataManager()).getEventListeners()) != null && !listenerMetaData.isEmpty()) {
                for (EventListenerMetaData elmd : listenerMetaData) {
                    Class listenerClass = clr.classForName(elmd.getClassName());
                    String methodName = elmd.getMethodNameForCallbackClass(callbackClass.getName());
                    if (methodName == null) continue;
                    Object listener = this.getListenerInstance(listenerClass);
                    this.invokeCallbackMethod(listener, methodName, pc, clr);
                }
            }
            ArrayList<String> entityMethodsToInvoke = null;
            while (acmd != null) {
                List listenerMetaData2 = acmd.getListeners();
                if (listenerMetaData2 != null && !listenerMetaData2.isEmpty()) {
                    for (EventListenerMetaData elmd : listenerMetaData2) {
                        Class listenerClass = clr.classForName(elmd.getClassName());
                        String methodName = elmd.getMethodNameForCallbackClass(callbackClass.getName());
                        if (methodName == null) continue;
                        if (elmd.getClassName().equals(acmd.getFullClassName())) {
                            if (entityMethodsToInvoke == null) {
                                entityMethodsToInvoke = new ArrayList<String>();
                            }
                            if (entityMethodsToInvoke.contains(methodName)) continue;
                            entityMethodsToInvoke.add(methodName);
                            continue;
                        }
                        Object listener = this.getListenerInstance(listenerClass);
                        this.invokeCallbackMethod(listener, methodName, pc, clr);
                    }
                    if (acmd.isExcludeSuperClassListeners()) break;
                }
                acmd = acmd.getSuperAbstractClassMetaData();
            }
            if (entityMethodsToInvoke != null && !entityMethodsToInvoke.isEmpty()) {
                for (int i = 0; i < entityMethodsToInvoke.size(); ++i) {
                    String methodName = (String)entityMethodsToInvoke.get(i);
                    this.invokeCallbackMethod(pc, methodName, clr);
                }
            }
        }
        catch (SecurityException e) {
            JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
        }
        catch (InstantiationException e) {
            JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
        }
    }

    private void invokeCallbackMethod(final Object listener, String methodName, ClassLoaderResolver clr) {
        String callbackClassName = methodName.substring(0, methodName.lastIndexOf(46));
        final String callbackMethodName = methodName.substring(methodName.lastIndexOf(46) + 1);
        final Class callbackClass = callbackClassName.equals(listener.getClass().getName()) ? listener.getClass() : clr.classForName(callbackClassName);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method m = callbackClass.getDeclaredMethod(callbackMethodName, null);
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    m.invoke(listener, (Object[])null);
                }
                catch (NoSuchMethodException e) {
                    JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getTargetException();
                    }
                    throw new RuntimeException(e.getTargetException());
                }
                return null;
            }
        });
    }

    private void invokeCallbackMethod(final Object listener, String methodName, final Object obj, ClassLoaderResolver clr) {
        String callbackClassName = methodName.substring(0, methodName.lastIndexOf(46));
        final String callbackMethodName = methodName.substring(methodName.lastIndexOf(46) + 1);
        final Class callbackClass = callbackClassName.equals(listener.getClass().getName()) ? listener.getClass() : clr.classForName(callbackClassName);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    try {
                        Class[] argTypes = new Class[]{Object.class};
                        Object[] args = new Object[]{obj};
                        Method m = callbackClass.getDeclaredMethod(callbackMethodName, argTypes);
                        if (!m.isAccessible()) {
                            m.setAccessible(true);
                        }
                        m.invoke(listener, args);
                    }
                    catch (NoSuchMethodException ex) {
                        Object[] args = new Object[]{obj};
                        Method[] methods = callbackClass.getDeclaredMethods();
                        for (int i = 0; i < methods.length; ++i) {
                            Method m = methods[i];
                            if (!m.getName().equals(callbackMethodName) || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(obj.getClass())) continue;
                            if (!m.isAccessible()) {
                                m.setAccessible(true);
                            }
                            m.invoke(listener, args);
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    JPAEntityManagerFactory.LOGGER.debug((Object)"Exception in JPACallbackHandler", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getTargetException();
                    }
                    throw new RuntimeException(e.getTargetException());
                }
                return null;
            }
        });
    }

    protected Object getListenerInstance(Class listenerCls) throws InstantiationException, IllegalAccessException {
        return listenerCls.newInstance();
    }
}

