/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import org.datanucleus.ExecutionContext;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPAEntityTransaction
implements EntityTransaction {
    Transaction tx;

    public JPAEntityTransaction(ExecutionContext ec) {
        this.tx = ec.getTransaction();
    }

    public boolean isActive() {
        return this.tx.isActive();
    }

    public void begin() {
        this.assertNotActive();
        try {
            this.tx.begin();
        }
        catch (NucleusException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
        }
    }

    public void commit() {
        this.assertActive();
        if (this.tx.getRollbackOnly()) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug((Object)Localiser.msg((String)"015020"));
            }
            throw new RollbackException(Localiser.msg((String)"015020"));
        }
        try {
            this.tx.commit();
        }
        catch (NucleusTransactionException nte) {
            Throwable cause = nte.getCause();
            Throwable pe = null;
            pe = cause instanceof NucleusException ? NucleusJPAHelper.getJPAExceptionForNucleusException((NucleusException)cause) : cause;
            throw new RollbackException(Localiser.msg((String)"015007"), pe);
        }
        catch (NucleusException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
        }
    }

    public void rollback() {
        this.assertActive();
        try {
            this.tx.rollback();
        }
        catch (NucleusException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
        }
    }

    public boolean getRollbackOnly() {
        this.assertActive();
        return this.tx.getRollbackOnly();
    }

    public void setRollbackOnly() {
        this.assertActive();
        this.tx.setRollbackOnly();
    }

    public void setOption(String option, int value) {
        this.tx.setOption(option, value);
    }

    public void setOption(String option, boolean value) {
        this.tx.setOption(option, value);
    }

    public void setOption(String option, String value) {
        this.tx.setOption(option, value);
    }

    public void setSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot set savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot set savepoint");
        }
        this.tx.setSavepoint(name);
    }

    public void releaseSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot release savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot release a savepoint");
        }
        this.tx.releaseSavepoint(name);
    }

    public void rollbackToSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot rollback to savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot rollback to savepoint");
        }
        this.tx.rollbackToSavepoint(name);
    }

    protected void assertActive() {
        if (!this.tx.isActive()) {
            throw new IllegalStateException(Localiser.msg((String)"015040"));
        }
    }

    protected void assertNotActive() {
        if (this.tx.isActive()) {
            throw new IllegalStateException(Localiser.msg((String)"015032"));
        }
    }

    public void registerEventListener(TransactionEventListener listener) {
        this.tx.bindTransactionEventListener(listener);
    }

    public void deregisterEventListener(TransactionEventListener listener) {
        this.tx.removeTransactionEventListener(listener);
    }
}

