/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import org.datanucleus.api.jpa.JPAAttributeNode;
import org.datanucleus.api.jpa.JPASubgraph;
import org.datanucleus.metadata.MetaDataManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JPAGraph<T> {
    MetaDataManager mmgr;
    Class<T> classType;
    Map<String, JPAAttributeNode<?>> attributeNodeMap = null;
    boolean mutable = true;

    public JPAGraph(MetaDataManager mmgr, Class<T> clsType) {
        this.mmgr = mmgr;
        this.classType = clsType;
    }

    public Class<T> getClassType() {
        return this.classType;
    }

    public void setNotMutable() {
        this.mutable = false;
    }

    public List<AttributeNode<?>> getAttributeNodes() {
        if (this.attributeNodeMap == null) {
            return null;
        }
        ArrayList attributeNodes = new ArrayList();
        attributeNodes.addAll(this.attributeNodeMap.values());
        return attributeNodes;
    }

    public void addAttributeNodes(String ... attributeNames) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            JPAAttributeNode node = new JPAAttributeNode(this.mmgr, this, attributeNames[i]);
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
    }

    public void addAttributeNodes(Attribute<T, ?> ... attributes) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        for (int i = 0; i < attributes.length; ++i) {
            JPAAttributeNode node = new JPAAttributeNode(this.mmgr, this, attributes[i].getName());
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
    }

    public <X> Subgraph<X> addSubgraph(Attribute<T, X> attribute) {
        JPAAttributeNode<Object> node;
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        if ((node = this.attributeNodeMap.get(attribute.getName())) == null) {
            node = new JPAAttributeNode(this.mmgr, this, attribute.getName());
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
        JPASubgraph subgraph = new JPASubgraph(this.mmgr, attribute.getJavaType());
        node.addSubgraph(subgraph);
        return subgraph;
    }

    public <X> Subgraph<? extends X> addSubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        JPAAttributeNode<Object> node;
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        if ((node = this.attributeNodeMap.get(attribute.getName())) == null) {
            node = new JPAAttributeNode(this.mmgr, this, attribute.getName());
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
        JPASubgraph<? extends X> subgraph = new JPASubgraph<X>(this.mmgr, type);
        node.addSubgraph(subgraph);
        return subgraph;
    }

    public <X> Subgraph<X> addSubgraph(String attributeName) {
        JPAAttributeNode<Object> node;
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        if ((node = this.attributeNodeMap.get(attributeName)) == null) {
            node = new JPAAttributeNode(this.mmgr, this, attributeName);
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
        JPASubgraph subgraph = new JPASubgraph(this.mmgr, null);
        node.addSubgraph(subgraph);
        return subgraph;
    }

    public <X> Subgraph<X> addSubgraph(String attributeName, Class<X> type) {
        JPAAttributeNode<Object> node;
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        }
        if ((node = this.attributeNodeMap.get(attributeName)) == null) {
            node = new JPAAttributeNode(this.mmgr, this, attributeName);
            this.attributeNodeMap.put(node.getAttributeName(), node);
        }
        JPASubgraph<X> subgraph = new JPASubgraph<X>(this.mmgr, type);
        node.addSubgraph(subgraph);
        return subgraph;
    }

    public <X> Subgraph<X> addKeySubgraph(Attribute<T, X> attribute) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<? extends X> addKeySubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<X> addKeySubgraph(String attributeName) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <X> Subgraph<X> addKeySubgraph(String attributeName, Class<X> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

