/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metadata;

import java.lang.reflect.Method;
import javax.persistence.jpa21.AttributeConverter;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.metadata.JPATypeConverter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.StoredProcQueryMetaData;
import org.datanucleus.metadata.StoredProcQueryParameterMetaData;
import org.datanucleus.metadata.StoredProcQueryParameterMode;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JPAMetaDataHandler
extends AbstractMetaDataHandler {
    String defaultPackageName = null;
    boolean metaDataComplete = false;
    boolean defaultCascadePersist = false;
    boolean propertyAccess = false;
    String queryResultEntityName = null;
    AbstractMemberMetaData overrideMmd = null;

    public JPAMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new FileMetaData();
        ((FileMetaData)this.metadata).setFilename(filename);
        ((FileMetaData)this.metadata).setMetaDataManager(mgr);
        this.pushStack(this.metadata);
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs, boolean embeddedOnly) {
        String className = this.getAttr(attrs, "class");
        if (className.indexOf(46) > 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        if (StringUtils.isWhitespace((String)className)) {
            throw new InvalidClassMetaDataException(LOCALISER, "044061", pmd.getName());
        }
        ClassMetaData cmd = new ClassMetaData(pmd, className);
        cmd.setEntityName(this.getAttr(attrs, "name"));
        cmd.setRequiresExtent(true);
        cmd.setDetachable(true);
        cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
        cmd.setEmbeddedOnly(embeddedOnly);
        cmd.setIdentityType(embeddedOnly ? IdentityType.NONDURABLE : IdentityType.APPLICATION);
        cmd.setCacheable(this.getAttr(attrs, "cacheable"));
        String classMetaDataComplete = this.getAttr(attrs, "metadata-complete");
        if (this.metaDataComplete || classMetaDataComplete != null && classMetaDataComplete.equalsIgnoreCase("true")) {
            cmd.setMetaDataComplete();
        }
        return cmd;
    }

    protected AbstractMemberMetaData newFieldObject(AbstractClassMetaData acmd, Attributes attrs, String dfgDefault) {
        String orphanRemovalStr;
        String optionalStr;
        String dfg = dfgDefault.equalsIgnoreCase("EAGER") ? "true" : "false";
        String fetch = this.getAttr(attrs, "fetch");
        if (fetch != null) {
            if (fetch.equalsIgnoreCase("LAZY")) {
                dfg = "false";
            } else if (fetch.equalsIgnoreCase("EAGER")) {
                dfg = "true";
            }
        }
        Object mmd = null;
        mmd = acmd.getMetaDataForMember(this.getAttr(attrs, "name"));
        if (mmd != null) {
            String depString;
            if (dfg != null) {
                mmd.setDefaultFetchGroup(dfg.equals("true"));
            }
            if (!StringUtils.isWhitespace((String)(depString = this.getAttr(attrs, "dependent")))) {
                mmd.setDependent(depString.trim().equalsIgnoreCase("true"));
            }
            mmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
            String loadFg = this.getAttr(attrs, "load-fetch-group");
            if (!StringUtils.isWhitespace((String)loadFg)) {
                mmd.setLoadFetchGroup(loadFg);
            }
        } else {
            mmd = this.propertyAccess ? new PropertyMetaData((MetaData)acmd, this.getAttr(attrs, "name")) : new FieldMetaData((MetaData)acmd, this.getAttr(attrs, "name"));
            mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT.toString());
            mmd.setDefaultFetchGroup(dfg);
            mmd.setDependent(this.getAttr(attrs, "dependent"));
            mmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
            mmd.setLoadFetchGroup(this.getAttr(attrs, "load-fetch-group"));
            acmd.addMember(mmd);
        }
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        if ((optionalStr = this.getAttr(attrs, "optional")) != null && optionalStr.equalsIgnoreCase("false")) {
            mmd.setNullValue(NullValue.getNullValue((String)optionalStr));
        }
        if ((orphanRemovalStr = this.getAttr(attrs, "orphan-removal")) != null && orphanRemovalStr.equalsIgnoreCase("true")) {
            mmd.setCascadeRemoveOrphans(true);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newPKFieldObject(AbstractClassMetaData acmd, Attributes attrs) {
        Object mmd = null;
        mmd = acmd.getMetaDataForMember(this.getAttr(attrs, "name"));
        if (mmd != null) {
            mmd.setPrimaryKey(true);
        } else {
            mmd = this.propertyAccess ? new PropertyMetaData((MetaData)acmd, this.getAttr(attrs, "name")) : new FieldMetaData((MetaData)acmd, this.getAttr(attrs, "name"));
            mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT.toString());
            mmd.setPrimaryKey(true);
            if (this.defaultCascadePersist) {
                mmd.setCascadePersist(true);
            }
            acmd.addMember(mmd);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newTransientFieldObject(MetaData md, String name) {
        Object mmd = null;
        mmd = this.propertyAccess ? new PropertyMetaData(md, name) : new FieldMetaData(md, name);
        mmd.setNotPersistent();
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newEmbeddedFieldObject(MetaData md, String name) {
        Object mmd = null;
        mmd = this.propertyAccess ? new PropertyMetaData(md, name) : new FieldMetaData(md, name);
        mmd.setEmbedded(true);
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newOverriddenFieldObject(MetaData md, Attributes attrs) {
        Object mmd = null;
        mmd = this.propertyAccess ? new PropertyMetaData(md, "#UNKNOWN." + this.getAttr(attrs, "name")) : new FieldMetaData(md, "#UNKNOWN." + this.getAttr(attrs, "name"));
        String colName = this.getAttr(attrs, "column");
        if (colName != null) {
            mmd.setColumn(colName);
        }
        mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT.toString());
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newOverriddenEmbeddedFieldObject(EmbeddedMetaData embmd, Attributes attrs) {
        String memberName = this.getAttr(attrs, "name");
        return this.newOverriddenEmbeddedFieldObject(embmd, memberName, this.getAttr(attrs, "column"));
    }

    protected AbstractMemberMetaData newOverriddenEmbeddedFieldObject(EmbeddedMetaData embmd, String memberName, String columnName) {
        if (memberName.indexOf(46) > 0) {
            int position = memberName.indexOf(46);
            String baseMemberName = memberName.substring(0, position);
            String nestedMemberName = memberName.substring(position + 1);
            Object mmd = null;
            mmd = this.propertyAccess ? new PropertyMetaData((MetaData)embmd, baseMemberName) : new FieldMetaData((MetaData)embmd, baseMemberName);
            EmbeddedMetaData nestedEmbmd = new EmbeddedMetaData();
            nestedEmbmd.setParent((MetaData)mmd);
            mmd.setEmbeddedMetaData(nestedEmbmd);
            AbstractMemberMetaData nestedEmbMmd = this.newOverriddenEmbeddedFieldObject(nestedEmbmd, nestedMemberName, columnName);
            nestedEmbmd.addMember(nestedEmbMmd);
            this.overrideMmd = nestedEmbMmd;
            return mmd;
        }
        Object mmd = null;
        mmd = this.propertyAccess ? new PropertyMetaData((MetaData)embmd, memberName) : new FieldMetaData((MetaData)embmd, memberName);
        mmd.setParent((MetaData)embmd);
        if (columnName != null) {
            mmd.setColumn(columnName);
        }
        mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT.toString());
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        this.overrideMmd = mmd;
        return mmd;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block244: {
            if (localName.length() < 1) {
                localName = qName;
            }
            try {
                if (localName.equals("entity-mappings")) {
                    FileMetaData filemd = (FileMetaData)this.getStack();
                    filemd.setType(MetadataFileType.JPA_MAPPING_FILE);
                    break block244;
                }
                if (localName.equals("description") || localName.equals("persistence-unit-metadata")) break block244;
                if (localName.equals("xml-mapping-metadata-complete")) {
                    this.metaDataComplete = true;
                    break block244;
                }
                if (localName.equals("persistence-unit-defaults") || localName.equals("package") || localName.equals("schema") || localName.equals("catalog") || localName.equals("access") || localName.equals("column-name")) break block244;
                if (localName.equals("sequence-generator")) {
                    String allocSize;
                    PackageMetaData pmd = null;
                    FileMetaData filemd = (FileMetaData)this.metadata;
                    pmd = this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : (filemd.getNoOfPackages() > 0 ? filemd.getPackage(0) : filemd.newPackageMetadata(""));
                    String initValue = this.getAttr(attrs, "initial-value");
                    if (StringUtils.isWhitespace((String)initValue)) {
                        initValue = "1";
                    }
                    if (StringUtils.isWhitespace((String)(allocSize = this.getAttr(attrs, "allocation-size")))) {
                        allocSize = "50";
                    }
                    SequenceMetaData seqmd = pmd.newSequenceMetadata(this.getAttr(attrs, "name"), null);
                    String datastoreSeqName = this.getAttr(attrs, "sequence-name");
                    if (StringUtils.isWhitespace((String)datastoreSeqName)) {
                        datastoreSeqName = seqmd.getName();
                    }
                    seqmd.setDatastoreSequence(datastoreSeqName);
                    seqmd.setInitialValue(initValue);
                    seqmd.setAllocationSize(allocSize);
                    break block244;
                }
                if (localName.equals("table-generator")) {
                    PackageMetaData pmd = null;
                    FileMetaData filemd = (FileMetaData)this.metadata;
                    pmd = this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : (filemd.getNoOfPackages() > 0 ? filemd.getPackage(0) : filemd.newPackageMetadata(""));
                    TableGeneratorMetaData tgmd = pmd.newTableGeneratorMetadata(this.getAttr(attrs, "name"));
                    tgmd.setTableName(this.getAttr(attrs, "table"));
                    tgmd.setCatalogName(this.getAttr(attrs, "catalog"));
                    tgmd.setSchemaName(this.getAttr(attrs, "schema"));
                    tgmd.setPKColumnName(this.getAttr(attrs, "pk-column-name"));
                    tgmd.setPKColumnValue(this.getAttr(attrs, "pk-column-value"));
                    tgmd.setValueColumnName(this.getAttr(attrs, "value-column-name"));
                    tgmd.setInitialValue(this.getAttr(attrs, "initial-value"));
                    tgmd.setAllocationSize(this.getAttr(attrs, "allocation-size"));
                    break block244;
                }
                if (localName.equals("named-query")) {
                    MetaData md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd = (FileMetaData)md;
                        QueryMetaData qmd = filemd.newQueryMetadata(this.getAttr(attrs, "name"));
                        qmd.setLanguage(QueryLanguage.JPQL.toString());
                        this.pushStack((MetaData)qmd);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd = (ClassMetaData)md;
                        String name = this.getAttr(attrs, "name");
                        if (StringUtils.isWhitespace((String)name)) {
                            throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
                        }
                        QueryMetaData qmd = new QueryMetaData(name);
                        qmd.setLanguage(QueryLanguage.JPQL.toString());
                        cmd.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    }
                    break block244;
                }
                if (localName.equals("named-native-query")) {
                    MetaData md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd = (FileMetaData)md;
                        QueryMetaData qmd = filemd.newQueryMetadata(this.getAttr(attrs, "name"));
                        qmd.setLanguage(QueryLanguage.SQL.toString());
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setResultMetaDataName(this.getAttr(attrs, "result-set-mapping"));
                        this.pushStack((MetaData)qmd);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd = (ClassMetaData)md;
                        String name = this.getAttr(attrs, "name");
                        if (StringUtils.isWhitespace((String)name)) {
                            throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
                        }
                        QueryMetaData qmd = new QueryMetaData(name);
                        qmd.setLanguage(QueryLanguage.SQL.toString());
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setResultMetaDataName(this.getAttr(attrs, "result-set-mapping"));
                        cmd.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    }
                    break block244;
                }
                if (localName.equals("named-stored-procedure-query")) {
                    MetaData md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd = (FileMetaData)md;
                        StoredProcQueryMetaData spqmd = filemd.newStoredProcQueryMetaData(this.getAttr(attrs, "name"));
                        spqmd.setProcedureName(this.getAttr(attrs, "procedure-name"));
                        this.pushStack((MetaData)spqmd);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd = (ClassMetaData)md;
                        String name = this.getAttr(attrs, "name");
                        if (StringUtils.isWhitespace((String)name)) {
                            throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
                        }
                        StoredProcQueryMetaData spqmd = new StoredProcQueryMetaData(name);
                        spqmd.setProcedureName(this.getAttr(attrs, "procedure-name"));
                        cmd.addStoredProcQuery(spqmd);
                        this.pushStack((MetaData)spqmd);
                    }
                    break block244;
                }
                if (localName.equals("stored-procedure-parameter")) {
                    MetaData md = this.getStack();
                    if (md instanceof StoredProcQueryMetaData) {
                        StoredProcQueryMetaData spqmd = (StoredProcQueryMetaData)md;
                        StoredProcQueryParameterMetaData parammd = new StoredProcQueryParameterMetaData();
                        parammd.setName(this.getAttr(attrs, "name"));
                        parammd.setType(this.getAttr(attrs, "class"));
                        String mode = this.getAttr(attrs, "mode");
                        if (mode != null) {
                            if (mode.equalsIgnoreCase("IN")) {
                                parammd.setMode(StoredProcQueryParameterMode.IN);
                            } else if (mode.equalsIgnoreCase("OUT")) {
                                parammd.setMode(StoredProcQueryParameterMode.OUT);
                            } else if (mode.equalsIgnoreCase("INOUT")) {
                                parammd.setMode(StoredProcQueryParameterMode.INOUT);
                            } else if (mode.equalsIgnoreCase("REF_CURSOR")) {
                                parammd.setMode(StoredProcQueryParameterMode.REF_CURSOR);
                            }
                        }
                        spqmd.addParameter(parammd);
                    }
                    break block244;
                }
                if (localName.equals("result-class") || localName.equals("result-set-mapping")) break block244;
                if (localName.equals("sql-result-set-mapping")) {
                    MetaData md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd = (FileMetaData)md;
                        QueryResultMetaData qrmd = filemd.newQueryResultMetadata(this.getAttr(attrs, "name"));
                        this.pushStack((MetaData)qrmd);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd = (ClassMetaData)md;
                        QueryResultMetaData qrmd = new QueryResultMetaData(this.getAttr(attrs, "name"));
                        cmd.addQueryResultMetaData(qrmd);
                        this.pushStack((MetaData)qrmd);
                    }
                    break block244;
                }
                if (localName.equals("entity-result")) {
                    QueryResultMetaData qrmd = (QueryResultMetaData)this.getStack();
                    this.queryResultEntityName = this.getAttr(attrs, "entity-class");
                    qrmd.addPersistentTypeMapping(this.queryResultEntityName, null, this.getAttr(attrs, "discriminator-column"));
                    break block244;
                }
                if (localName.equals("field-result")) {
                    QueryResultMetaData qrmd = (QueryResultMetaData)this.getStack();
                    qrmd.addMappingForPersistentTypeMapping(this.queryResultEntityName, this.getAttr(attrs, "name"), this.getAttr(attrs, "column"));
                    break block244;
                }
                if (localName.equals("column-result")) {
                    QueryResultMetaData qrmd = (QueryResultMetaData)this.getStack();
                    qrmd.addScalarColumn(this.getAttr(attrs, "name"));
                    break block244;
                }
                if (localName.equals("constructor-result")) {
                    NucleusLogger.METADATA.info((Object)">> Dont currently support constructor-result element");
                    break block244;
                }
                if (localName.equals("mapped-superclass")) {
                    FileMetaData filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd = null;
                    if (packageName != null) {
                        pmd = filemd.getPackage(packageName);
                    }
                    if (pmd == null) {
                        pmd = packageName != null ? filemd.newPackageMetadata(packageName) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : filemd.newPackageMetadata(""));
                    }
                    ClassMetaData cmd = this.newClassObject(pmd, attrs, false);
                    pmd.addClass(cmd);
                    InheritanceMetaData inhmd = new InheritanceMetaData();
                    inhmd.setStrategy(InheritanceStrategy.SUBCLASS_TABLE);
                    cmd.setInheritanceMetaData(inhmd);
                    this.pushStack((MetaData)cmd);
                    break block244;
                }
                if (localName.equals("query")) break block244;
                if (localName.equals("entity")) {
                    FileMetaData filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd = null;
                    if (packageName != null) {
                        pmd = filemd.getPackage(packageName);
                    }
                    if (pmd == null) {
                        pmd = packageName != null ? filemd.newPackageMetadata(packageName) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : filemd.newPackageMetadata(""));
                    }
                    ClassMetaData cmd = this.newClassObject(pmd, attrs, false);
                    pmd.addClass(cmd);
                    this.pushStack((MetaData)cmd);
                    break block244;
                }
                if (localName.equals("embeddable")) {
                    FileMetaData filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd = null;
                    if (packageName != null) {
                        pmd = filemd.getPackage(packageName);
                    }
                    if (pmd == null) {
                        pmd = packageName != null ? filemd.newPackageMetadata(packageName) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : filemd.newPackageMetadata(""));
                    }
                    ClassMetaData cmd = this.newClassObject(pmd, attrs, true);
                    pmd.addClass(cmd);
                    this.pushStack((MetaData)cmd);
                    break block244;
                }
                if (localName.equals("attributes") || localName.equals("embeddable-attributes")) break block244;
                if (localName.equals("id-class")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    cmd.setObjectIdClass(this.getAttr(attrs, "class"));
                    break block244;
                }
                if (localName.equals("inheritance")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    String strategy = this.getAttr(attrs, "strategy");
                    String strategyType = null;
                    if (strategy != null) {
                        if (strategy.equalsIgnoreCase("JOINED")) {
                            strategyType = InheritanceStrategy.NEW_TABLE.toString();
                        } else if (strategy.equalsIgnoreCase("TABLE_PER_CLASS")) {
                            strategyType = InheritanceStrategy.COMPLETE_TABLE.toString();
                        }
                    }
                    InheritanceMetaData inhmd = new InheritanceMetaData();
                    inhmd.setStrategy(strategyType);
                    if (strategy != null) {
                        inhmd.setStrategyForTree(strategy.toUpperCase());
                    }
                    cmd.setInheritanceMetaData(inhmd);
                    break block244;
                }
                if (localName.equals("table")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    cmd.setCatalog(this.getAttr(attrs, "catalog"));
                    cmd.setSchema(this.getAttr(attrs, "schema"));
                    cmd.setTable(this.getAttr(attrs, "name"));
                    break block244;
                }
                if (localName.equals("secondary-table")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    JoinMetaData joinmd = new JoinMetaData();
                    joinmd.setTable(this.getAttr(attrs, "name"));
                    joinmd.setCatalog(this.getAttr(attrs, "catalog"));
                    joinmd.setSchema(this.getAttr(attrs, "schema"));
                    cmd.addJoin(joinmd);
                    this.pushStack((MetaData)joinmd);
                    break block244;
                }
                if (localName.equals("primary-key-join-column")) {
                    MetaData md = this.getStack();
                    if (md instanceof ClassMetaData) {
                        JoinMetaData inhJoinmd;
                        InheritanceMetaData inhmd;
                        ClassMetaData cmd = (ClassMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        String columnDdl = this.getAttr(attrs, "column-definition");
                        if (columnDdl != null) {
                            colmd.setColumnDdl(columnDdl);
                        }
                        if ((inhmd = cmd.getInheritanceMetaData()) == null) {
                            inhmd = new InheritanceMetaData();
                            cmd.setInheritanceMetaData(inhmd);
                        }
                        if ((inhJoinmd = inhmd.getJoinMetaData()) == null) {
                            inhJoinmd = new JoinMetaData();
                        }
                        inhJoinmd.addColumn(colmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        joinmd.addColumn(colmd);
                    }
                    break block244;
                }
                if (localName.equals("id")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newPKFieldObject((AbstractClassMetaData)cmd, attrs);
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("embedded-id")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newPKFieldObject((AbstractClassMetaData)cmd, attrs);
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("basic")) {
                    AbstractClassMetaData cmd = (AbstractClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newFieldObject(cmd, attrs, "EAGER");
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("convert")) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.getStack();
                    String converterClassName = this.getAttr(attrs, "converter");
                    if (!StringUtils.isWhitespace((String)converterClassName)) {
                        mmd.setTypeConverterName(converterClassName);
                        TypeManager typeMgr = this.mgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName(converterClassName) == null) {
                            ClassLoaderResolver clr = this.mgr.getNucleusContext().getClassLoaderResolver(null);
                            Class converterCls = clr.classForName(converterClassName);
                            AttributeConverter entityConv = (AttributeConverter)ClassUtils.newInstance((Class)converterCls, null, null);
                            Class memberType = clr.classForName(mmd.getTypeName());
                            Class<?> dbType = null;
                            try {
                                Method[] methods = entityConv.getClass().getDeclaredMethods();
                                if (methods != null) {
                                    for (int j = 0; j < methods.length; ++j) {
                                        Class<?> returnCls;
                                        if (!methods[j].getName().equals("convertToDatabaseColumn") || (returnCls = methods[j].getReturnType()) == Object.class) continue;
                                        dbType = returnCls;
                                    }
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            JPATypeConverter conv = new JPATypeConverter(entityConv, memberType, dbType);
                            typeMgr.registerConverter(converterCls.getName(), conv);
                        }
                    }
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("converter")) {
                    NucleusLogger.METADATA.info((Object)">> Dont currently support converter element");
                    break block244;
                }
                if (localName.equals("lob")) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.getStack();
                    fmd.setStoreInLob();
                    break block244;
                }
                if (localName.equals("enumerated") || localName.equals("temporal")) break block244;
                if (localName.equals("transient")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newTransientFieldObject((MetaData)cmd, this.getAttr(attrs, "name"));
                    cmd.addMember(mmd);
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("embedded")) {
                    AbstractClassMetaData cmd = (AbstractClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newEmbeddedFieldObject((MetaData)cmd, this.getAttr(attrs, "name"));
                    cmd.addMember(mmd);
                    mmd.setEmbedded(true);
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("one-to-many")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newFieldObject((AbstractClassMetaData)cmd, attrs, "LAZY");
                    String targetEntityName = this.getAttr(attrs, "target-entity");
                    if (!StringUtils.isWhitespace((String)targetEntityName)) {
                        mmd.setTargetClassName(targetEntityName);
                    }
                    mmd.setOrdered();
                    if (mmd.getMappedBy() == null && mmd.getJoinMetaData() == null && mmd.getColumnMetaData() == null) {
                        mmd.setJoinMetaData(new JoinMetaData());
                    }
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("one-to-one")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newFieldObject((AbstractClassMetaData)cmd, attrs, "EAGER");
                    String targetEntityName = this.getAttr(attrs, "target-entity");
                    if (!StringUtils.isWhitespace((String)targetEntityName)) {
                        mmd.setTargetClassName(targetEntityName);
                    }
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("many-to-one")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newFieldObject((AbstractClassMetaData)cmd, attrs, "EAGER");
                    String targetEntityName = this.getAttr(attrs, "target-entity");
                    if (!StringUtils.isWhitespace((String)targetEntityName)) {
                        mmd.setTargetClassName(targetEntityName);
                    }
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("many-to-many")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newFieldObject((AbstractClassMetaData)cmd, attrs, "LAZY");
                    String targetEntityName = this.getAttr(attrs, "target-entity");
                    if (!StringUtils.isWhitespace((String)targetEntityName)) {
                        mmd.setTargetClassName(targetEntityName);
                    }
                    mmd.setOrdered();
                    if (mmd.getMappedBy() == null && mmd.getJoinMetaData() == null) {
                        mmd.setJoinMetaData(new JoinMetaData());
                    }
                    this.pushStack((MetaData)mmd);
                    break block244;
                }
                if (localName.equals("element-collection")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd = this.newFieldObject((AbstractClassMetaData)cmd, attrs, "LAZY");
                    JoinMetaData joinmd = new JoinMetaData();
                    mmd.setJoinMetaData(joinmd);
                    mmd.setCascadePersist(true);
                    mmd.setCascadeUpdate(true);
                    mmd.setCascadeDelete(true);
                    mmd.setCascadeDetach(true);
                    mmd.setCascadeRefresh(true);
                    this.pushStack((MetaData)joinmd);
                    break block244;
                }
                if (localName.equals("collection-table")) {
                    String schStr;
                    String catStr;
                    JoinMetaData joinmd = (JoinMetaData)this.getStack();
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)joinmd.getParent();
                    String nameStr = this.getAttr(attrs, "name");
                    if (!StringUtils.isWhitespace((String)nameStr)) {
                        mmd.setTable(nameStr);
                    }
                    if (!StringUtils.isWhitespace((String)(catStr = this.getAttr(attrs, "catalog")))) {
                        mmd.setCatalog(catStr);
                    }
                    if (!StringUtils.isWhitespace((String)(schStr = this.getAttr(attrs, "schema")))) {
                        mmd.setSchema(schStr);
                    }
                    break block244;
                }
                if (localName.equals("map-key")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractMemberMetaData) {
                        KeyMetaData keymd;
                        AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.getStack();
                        String mappedByFieldName = this.getAttr(attrs, "name");
                        if (StringUtils.isWhitespace((String)mappedByFieldName)) {
                            mappedByFieldName = "#PK";
                        }
                        if ((keymd = fmd.getKeyMetaData()) == null) {
                            keymd = new KeyMetaData();
                            fmd.setKeyMetaData(keymd);
                        }
                        keymd.setMappedBy(mappedByFieldName);
                    } else if (md instanceof JoinMetaData) {
                        KeyMetaData keymd;
                        JoinMetaData joinmd = (JoinMetaData)md;
                        AbstractMemberMetaData mmd = (AbstractMemberMetaData)joinmd.getParent();
                        String mappedByFieldName = this.getAttr(attrs, "name");
                        if (StringUtils.isWhitespace((String)mappedByFieldName)) {
                            mappedByFieldName = "#PK";
                        }
                        if ((keymd = mmd.getKeyMetaData()) == null) {
                            keymd = new KeyMetaData();
                            mmd.setKeyMetaData(keymd);
                        }
                        keymd.setMappedBy(mappedByFieldName);
                    }
                    break block244;
                }
                if (localName.equals("map-key-temporal") || localName.equals("map-key-enumerated")) break block244;
                if (localName.equals("map-key-attribute-override")) {
                    NucleusLogger.METADATA.info((Object)">> Dont currently support map-key-attribute-override element");
                    break block244;
                }
                if (localName.equals("map-key-class")) {
                    NucleusLogger.METADATA.info((Object)">> Dont currently support map-key-class element");
                    break block244;
                }
                if (localName.equals("index")) {
                    String idxName = this.getAttr(attrs, "name");
                    String idxColStr = this.getAttr(attrs, "column-list");
                    String idxUnique = this.getAttr(attrs, "unique");
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        if (!StringUtils.isWhitespace((String)idxColStr)) {
                            IndexMetaData idxmd = cmd.newIndexMetadata();
                            String[] colNames = StringUtils.split((String)idxColStr, (String)",");
                            for (int i = 0; i < colNames.length; ++i) {
                                ColumnMetaData colmd = idxmd.newColumnMetaData();
                                colmd.setName(colNames[i]);
                            }
                            if (!StringUtils.isWhitespace((String)idxName)) {
                                idxmd.setName(idxName);
                            }
                            if (!StringUtils.isWhitespace((String)idxUnique)) {
                                idxmd.setUnique(idxUnique);
                            }
                        }
                    } else if (md instanceof AbstractMemberMetaData) {
                        NucleusLogger.METADATA.info((Object)">> Dont currently support index element");
                    } else if (md instanceof JoinMetaData) {
                        NucleusLogger.METADATA.info((Object)">> Dont currently support index element");
                    } else {
                        NucleusLogger.METADATA.info((Object)(">> Dont currently support index element with parent " + md.getClass().getName()));
                    }
                    break block244;
                }
                if (localName.equals("foreign-key")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        NucleusLogger.METADATA.info((Object)">> Dont currently support foreign-key element");
                    } else if (md instanceof AbstractMemberMetaData) {
                        NucleusLogger.METADATA.info((Object)">> Dont currently support foreign-key element");
                    } else {
                        NucleusLogger.METADATA.info((Object)(">> Dont currently support foreign-key element with parent " + md.getClass().getName()));
                    }
                    break block244;
                }
                if (localName.equals("order-by")) break block244;
                if (localName.equals("order-column")) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.getStack();
                    String columnName = this.getAttr(attrs, "name");
                    OrderMetaData ordermd = new OrderMetaData();
                    ordermd.setColumnName(columnName);
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                    colmd.setInsertable(this.getAttr(attrs, "insertable"));
                    colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                    String columnDdl = this.getAttr(attrs, "column-definition");
                    if (columnDdl != null) {
                        colmd.setColumnDdl(columnDdl);
                    }
                    ordermd.addColumn(colmd);
                    fmd.setOrderMetaData(ordermd);
                    break block244;
                }
                if (localName.equals("cascade") || localName.equals("cascade-type")) break block244;
                if (localName.equals("cascade-all")) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadePersist(true);
                    mmd.setCascadeUpdate(true);
                    mmd.setCascadeDelete(true);
                    mmd.setCascadeDetach(true);
                    mmd.setCascadeRefresh(true);
                    break block244;
                }
                if (localName.equals("cascade-persist")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                        mmd.setCascadePersist(true);
                    } else if (md instanceof FileMetaData) {
                        this.defaultCascadePersist = true;
                    }
                    break block244;
                }
                if (localName.equals("cascade-merge")) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeUpdate(true);
                    break block244;
                }
                if (localName.equals("cascade-remove")) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeDelete(true);
                    break block244;
                }
                if (localName.equals("cascade-refresh")) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeRefresh(true);
                    break block244;
                }
                if (localName.equals("cascade-detach")) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeDetach(true);
                    break block244;
                }
                if (localName.equals("version")) {
                    if (this.getStack() instanceof ClassMetaData) {
                        ClassMetaData cmd = (ClassMetaData)this.getStack();
                        AbstractMemberMetaData mmd = this.newFieldObject((AbstractClassMetaData)cmd, attrs, "EAGER");
                        VersionMetaData vermd = cmd.newVersionMetadata();
                        vermd.setStrategy(VersionStrategy.VERSION_NUMBER).setFieldName(mmd.getName());
                        this.pushStack((MetaData)mmd);
                    }
                    break block244;
                }
                if (localName.equals("discriminator-value")) break block244;
                if (localName.equals("discriminator-column")) {
                    DiscriminatorMetaData dismd;
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                    if (inhmd == null) {
                        inhmd = new InheritanceMetaData();
                        cmd.setInheritanceMetaData(inhmd);
                    }
                    if ((dismd = inhmd.getDiscriminatorMetaData()) == null) {
                        dismd = inhmd.newDiscriminatorMetadata();
                        dismd.setStrategy(DiscriminatorStrategy.VALUE_MAP);
                        dismd.setValue(cmd.getFullClassName());
                        dismd.setIndexed("true");
                    }
                    String jdbcType = null;
                    String discType = this.getAttr(attrs, "discriminator-type");
                    if (discType != null) {
                        if (discType.equalsIgnoreCase("STRING")) {
                            jdbcType = "VARCHAR";
                        } else if (discType.equalsIgnoreCase("CHAR")) {
                            jdbcType = "CHAR";
                        } else if (discType.equalsIgnoreCase("INTEGER")) {
                            jdbcType = "INTEGER";
                        }
                    }
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    colmd.setJdbcType(jdbcType);
                    colmd.setLength(this.getAttr(attrs, "length"));
                    String columnDdl = this.getAttr(attrs, "column-definition");
                    if (columnDdl != null) {
                        colmd.setColumnDdl(columnDdl);
                    }
                    dismd.setColumnMetaData(colmd);
                    break block244;
                }
                if (localName.equals("generated-value")) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.getStack();
                    String strategy = this.getAttr(attrs, "strategy");
                    if (strategy != null) {
                        if (strategy.equalsIgnoreCase("auto")) {
                            fmd.setValueStrategy(IdentityStrategy.NATIVE);
                        } else if (strategy.equalsIgnoreCase("table")) {
                            fmd.setValueStrategy(IdentityStrategy.INCREMENT);
                        } else if (strategy.equalsIgnoreCase("sequence")) {
                            fmd.setValueStrategy(IdentityStrategy.SEQUENCE);
                        } else if (strategy.equalsIgnoreCase("identity")) {
                            fmd.setValueStrategy(IdentityStrategy.IDENTITY);
                        }
                    }
                    fmd.setValueGeneratorName(this.getAttr(attrs, "generator"));
                    break block244;
                }
                if (localName.equals("join-table")) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.getStack();
                    JoinMetaData joinmd = new JoinMetaData();
                    String tableName = this.getAttr(attrs, "name");
                    String schemaName = this.getAttr(attrs, "schema");
                    String catalogName = this.getAttr(attrs, "catalog");
                    fmd.setJoinMetaData(joinmd);
                    if (!StringUtils.isWhitespace((String)tableName)) {
                        fmd.setTable(tableName);
                    }
                    if (!StringUtils.isWhitespace((String)schemaName)) {
                        fmd.setSchema(schemaName);
                    }
                    if (!StringUtils.isWhitespace((String)catalogName)) {
                        fmd.setSchema(catalogName);
                    }
                    this.pushStack((MetaData)joinmd);
                    break block244;
                }
                if (localName.equals("column")) {
                    String columnDdl;
                    String position;
                    MetaData md = this.getStack();
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    colmd.setLength(this.getAttr(attrs, "length"));
                    colmd.setScale(this.getAttr(attrs, "scale"));
                    colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                    colmd.setInsertable(this.getAttr(attrs, "insertable"));
                    colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                    colmd.setUnique(this.getAttr(attrs, "unique"));
                    String jdbcType = this.getAttr(attrs, "jdbc-type");
                    if (jdbcType != null) {
                        colmd.setJdbcType(jdbcType);
                    }
                    if ((position = this.getAttr(attrs, "position")) != null) {
                        colmd.setPosition(position);
                    }
                    if ((columnDdl = this.getAttr(attrs, "column-definition")) != null) {
                        colmd.setColumnDdl(columnDdl);
                    }
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd = (AbstractMemberMetaData)md;
                        if (this.overrideMmd != null) {
                            fmd = this.overrideMmd;
                        }
                        fmd.addColumn(colmd);
                        String table = this.getAttr(attrs, "table");
                        if (!StringUtils.isWhitespace((String)table)) {
                            fmd.setTable(table);
                        }
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        AbstractMemberMetaData mmd = (AbstractMemberMetaData)joinmd.getParent();
                        ElementMetaData elemmd = mmd.getElementMetaData();
                        if (elemmd == null) {
                            elemmd = new ElementMetaData();
                            mmd.setElementMetaData(elemmd);
                        }
                        elemmd.addColumn(colmd);
                    }
                    break block244;
                }
                if (localName.equals("map-key-column")) {
                    AbstractMemberMetaData mmd;
                    KeyMetaData keymd;
                    MetaData md = this.getStack();
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    if (this.getAttr(attrs, "precision") != null) {
                        colmd.setLength(this.getAttr(attrs, "precision"));
                    } else {
                        colmd.setLength(this.getAttr(attrs, "length"));
                    }
                    colmd.setScale(this.getAttr(attrs, "scale"));
                    colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                    colmd.setInsertable(this.getAttr(attrs, "insertable"));
                    colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                    colmd.setUnique(this.getAttr(attrs, "unique"));
                    String columnDdl = this.getAttr(attrs, "column-definition");
                    if (columnDdl != null) {
                        colmd.setColumnDdl(columnDdl);
                    }
                    if ((keymd = (mmd = (AbstractMemberMetaData)md).getKeyMetaData()) == null) {
                        keymd = new KeyMetaData();
                        mmd.setKeyMetaData(keymd);
                    }
                    keymd.addColumn(colmd);
                    break block244;
                }
                if (localName.equals("map-key-join-column")) {
                    NucleusLogger.METADATA.info((Object)">> Dont currently support map-key-join-column element");
                    break block244;
                }
                if (localName.equals("join-column")) {
                    MetaData md = this.getStack();
                    if (md instanceof JoinMetaData) {
                        String indexedStr;
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                        colmd.setInsertable(this.getAttr(attrs, "insertable"));
                        colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                        colmd.setUnique(this.getAttr(attrs, "unique"));
                        String columnDdl = this.getAttr(attrs, "column-definition");
                        if (columnDdl != null) {
                            colmd.setColumnDdl(columnDdl);
                        }
                        if (!StringUtils.isWhitespace((String)(indexedStr = this.getAttr(attrs, "indexed")))) {
                            joinmd.setIndexed(IndexedValue.getIndexedValue((String)indexedStr));
                        }
                        joinmd.addColumn(colmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd = (AbstractMemberMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                        colmd.setInsertable(this.getAttr(attrs, "insertable"));
                        colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                        colmd.setUnique(this.getAttr(attrs, "unique"));
                        fmd.addColumn(colmd);
                    }
                    break block244;
                }
                if (localName.equals("inverse-join-column")) {
                    MetaData md = this.getStack();
                    if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ElementMetaData elemmd = null;
                        AbstractMemberMetaData fmd = (AbstractMemberMetaData)joinmd.getParent();
                        if (fmd.getElementMetaData() != null) {
                            elemmd = fmd.getElementMetaData();
                        } else {
                            elemmd = new ElementMetaData();
                            fmd.setElementMetaData(elemmd);
                        }
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                        colmd.setInsertable(this.getAttr(attrs, "insertable"));
                        colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                        colmd.setUnique(this.getAttr(attrs, "unique"));
                        elemmd.addColumn(colmd);
                    }
                    break block244;
                }
                if (localName.equals("unique-constraint")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        UniqueMetaData unimd = new UniqueMetaData();
                        unimd.setTable(cmd.getTable());
                        cmd.addUniqueConstraint(unimd);
                        this.pushStack((MetaData)unimd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        UniqueMetaData unimd = new UniqueMetaData();
                        joinmd.setUniqueMetaData(unimd);
                        this.pushStack((MetaData)unimd);
                    } else {
                        NucleusLogger.METADATA.info((Object)(">> Dont currently support unique-constraint element with parent " + md.getClass().getName()));
                    }
                    break block244;
                }
                if (localName.equals("named-entity-graph")) {
                    NucleusLogger.METADATA.info((Object)">> Dont currently support named-entity-graph element");
                    break block244;
                }
                if (localName.equals("named-attribute-node")) {
                    NucleusLogger.METADATA.info((Object)">> Dont currently support named-attribute-node element");
                    break block244;
                }
                if (localName.equals("named-subgraph")) {
                    NucleusLogger.METADATA.info((Object)">> Dont currently support named-subgraph element");
                    break block244;
                }
                if (localName.equals("entity-listeners")) break block244;
                if (localName.equals("entity-listener")) {
                    MetaData md = this.getStack();
                    EventListenerMetaData elmd = new EventListenerMetaData(this.getAttr(attrs, "class"));
                    if (md instanceof AbstractClassMetaData) {
                        ((AbstractClassMetaData)md).addListener(elmd);
                    } else if (md instanceof FileMetaData) {
                        ((FileMetaData)md).addListener(elmd);
                    }
                    this.pushStack((MetaData)elmd);
                    break block244;
                }
                if (localName.equals("pre-persist")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd.getFullClassName());
                            cmd.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PrePersist", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PrePersist", this.getAttr(attrs, "method-name"));
                    }
                    break block244;
                }
                if (localName.equals("post-persist")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd.getFullClassName());
                            cmd.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostPersist", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostPersist", this.getAttr(attrs, "method-name"));
                    }
                    break block244;
                }
                if (localName.equals("pre-remove")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd.getFullClassName());
                            cmd.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PreRemove", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PreRemove", this.getAttr(attrs, "method-name"));
                    }
                    break block244;
                }
                if (localName.equals("post-remove")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd.getFullClassName());
                            cmd.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostRemove", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostRemove", this.getAttr(attrs, "method-name"));
                    }
                    break block244;
                }
                if (localName.equals("pre-update")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd.getFullClassName());
                            cmd.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PreUpdate", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PreUpdate", this.getAttr(attrs, "method-name"));
                    }
                    break block244;
                }
                if (localName.equals("post-update")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd.getFullClassName());
                            cmd.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostUpdate", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostUpdate", this.getAttr(attrs, "method-name"));
                    }
                    break block244;
                }
                if (localName.equals("post-load")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd.getFullClassName());
                            cmd.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostLoad", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostLoad", this.getAttr(attrs, "method-name"));
                    }
                    break block244;
                }
                if (localName.equals("attribute-override")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        AbstractMemberMetaData fmd = this.newOverriddenFieldObject((MetaData)cmd, attrs);
                        cmd.addMember(fmd);
                        this.pushStack((MetaData)fmd);
                    } else {
                        AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                        if (embmd == null) {
                            embmd = new EmbeddedMetaData();
                            embmd.setParent((MetaData)mmd);
                            mmd.setEmbeddedMetaData(embmd);
                        }
                        AbstractMemberMetaData embMmd = this.newOverriddenEmbeddedFieldObject(embmd, attrs);
                        embmd.addMember(embMmd);
                        this.pushStack((MetaData)mmd);
                    }
                    break block244;
                }
                if (localName.equals("association-override")) {
                    MetaData md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)this.getStack();
                        AbstractMemberMetaData fmd = this.newOverriddenFieldObject((MetaData)cmd, attrs);
                        cmd.addMember(fmd);
                        this.pushStack((MetaData)fmd);
                    } else {
                        AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                        if (embmd == null) {
                            embmd = new EmbeddedMetaData();
                            embmd.setParent((MetaData)mmd);
                            mmd.setEmbeddedMetaData(embmd);
                        }
                        AbstractMemberMetaData embMmd = this.newOverriddenEmbeddedFieldObject(embmd, attrs);
                        embmd.addMember(embMmd);
                        this.pushStack((MetaData)mmd);
                    }
                    break block244;
                }
                if (localName.equals("exclude-default-listeners")) {
                    AbstractClassMetaData cmd = (AbstractClassMetaData)this.getStack();
                    cmd.excludeDefaultListeners();
                    break block244;
                }
                if (localName.equals("exclude-superclass-listeners")) {
                    AbstractClassMetaData cmd = (AbstractClassMetaData)this.getStack();
                    cmd.excludeSuperClassListeners();
                    break block244;
                }
                if (localName.equals("extension")) {
                    MetaData md = this.getStack();
                    String vendorName = this.getAttr(attrs, "vendor-name");
                    if (vendorName == null) {
                        vendorName = "datanucleus";
                    }
                    md.addExtension(vendorName, this.getAttr(attrs, "key"), this.getAttr(attrs, "value"));
                    break block244;
                }
                if (localName.equals("query-hint")) {
                    MetaData md = this.getStack();
                    if (md instanceof QueryMetaData) {
                        md.addExtension(this.getAttr(attrs, "name"), this.getAttr(attrs, "value"));
                    } else if (md instanceof StoredProcQueryMetaData) {
                        md.addExtension(this.getAttr(attrs, "name"), this.getAttr(attrs, "value"));
                    }
                    break block244;
                }
                String message = LOCALISER.msg("044037", (Object)qName);
                NucleusLogger.METADATA.error((Object)message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                NucleusLogger.METADATA.error((Object)LOCALISER.msg("044042", (Object)qName, (Object)this.getStack(), (Object)uri), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (localName.length() < 1) {
            localName = qName;
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (localName.equals("schema")) {
                if (md instanceof FileMetaData) {
                    ((FileMetaData)md).setSchema(currentString);
                }
            } else if (localName.equals("catalog")) {
                if (md instanceof FileMetaData) {
                    ((FileMetaData)md).setCatalog(currentString);
                }
            } else if (localName.equals("access")) {
                if (md instanceof FileMetaData && currentString.equalsIgnoreCase("PROPERTY")) {
                    this.propertyAccess = true;
                }
            } else if (localName.equals("package")) {
                if (md instanceof FileMetaData) {
                    FileMetaData filemd = (FileMetaData)md;
                    filemd.newPackageMetadata(currentString);
                    this.defaultPackageName = currentString;
                }
            } else if (localName.equals("discriminator-value")) {
                if (md instanceof ClassMetaData) {
                    ClassMetaData cmd = (ClassMetaData)md;
                    InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                    if (inhmd == null) {
                        inhmd = new InheritanceMetaData();
                        cmd.setInheritanceMetaData(inhmd);
                    }
                    String discrimValue = currentString;
                    DiscriminatorMetaData dismd = inhmd.getDiscriminatorMetaData();
                    if (dismd == null) {
                        dismd = inhmd.newDiscriminatorMetadata();
                    }
                    dismd.setValue(discrimValue);
                    dismd.setStrategy(DiscriminatorStrategy.VALUE_MAP);
                }
            } else if (localName.equals("column-name")) {
                if (md instanceof UniqueMetaData) {
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(currentString);
                    ((UniqueMetaData)md).addColumn(colmd);
                }
            } else if (localName.equals("order-by")) {
                if (md instanceof AbstractMemberMetaData) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)md;
                    OrderMetaData ordmd = new OrderMetaData();
                    ordmd.setOrdering(currentString);
                    fmd.setOrderMetaData(ordmd);
                }
            } else if (localName.equals("result-class")) {
                if (md instanceof StoredProcQueryMetaData) {
                    ((StoredProcQueryMetaData)md).addResultClass(currentString);
                }
            } else if (localName.equals("result-set-mapping")) {
                if (md instanceof StoredProcQueryMetaData) {
                    ((StoredProcQueryMetaData)md).addResultSetMapping(currentString);
                }
            } else if (localName.equals("query")) {
                if (md instanceof QueryMetaData) {
                    ((QueryMetaData)md).setQuery(currentString);
                }
            } else if (localName.equals("enumerated")) {
                if (md instanceof AbstractMemberMetaData) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                    String enumerationType = currentString;
                    String jdbcType = "INTEGER";
                    if (enumerationType.equalsIgnoreCase("STRING")) {
                        jdbcType = "VARCHAR";
                    }
                    if (mmd.getColumnMetaData() == null) {
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setJdbcType(jdbcType);
                        mmd.addColumn(colmd);
                    } else {
                        mmd.getColumnMetaData()[0].setJdbcType(jdbcType);
                    }
                }
            } else if (localName.equals("temporal")) {
                if (md instanceof AbstractMemberMetaData) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                    String enumerationType = currentString;
                    String jdbcType = null;
                    if (enumerationType.equalsIgnoreCase("DATE")) {
                        jdbcType = "DATE";
                    } else if (enumerationType.equalsIgnoreCase("TIME")) {
                        jdbcType = "TIME";
                    } else if (enumerationType.equalsIgnoreCase("TIMESTAMP")) {
                        jdbcType = "TIMESTAMP";
                    }
                    if (mmd.getColumnMetaData() == null) {
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setJdbcType(jdbcType);
                        mmd.addColumn(colmd);
                    } else {
                        mmd.getColumnMetaData()[0].setJdbcType(jdbcType);
                    }
                }
            } else if (localName.equals("map-key-temporal")) {
                String enumerationType = currentString;
                String jdbcType = null;
                if (enumerationType.equalsIgnoreCase("DATE")) {
                    jdbcType = "DATE";
                } else if (enumerationType.equalsIgnoreCase("TIME")) {
                    jdbcType = "TIME";
                } else if (enumerationType.equalsIgnoreCase("TIMESTAMP")) {
                    jdbcType = "TIMESTAMP";
                }
                if (jdbcType != null) {
                    AbstractMemberMetaData mmd = null;
                    if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        mmd = (AbstractMemberMetaData)joinmd.getParent();
                    } else if (md instanceof AbstractMemberMetaData) {
                        mmd = (AbstractMemberMetaData)this.getStack();
                    }
                    if (mmd != null) {
                        KeyMetaData keymd = mmd.getKeyMetaData();
                        if (keymd == null) {
                            keymd = new KeyMetaData();
                            mmd.setKeyMetaData(keymd);
                        }
                        ColumnMetaData colmd = null;
                        colmd = keymd.getColumnMetaData() != null && keymd.getColumnMetaData().length == 1 ? keymd.getColumnMetaData()[0] : keymd.newColumnMetaData();
                        colmd.setJdbcType(jdbcType);
                    }
                }
            } else if (localName.equals("map-key-enumerated")) {
                String enumerationType = currentString;
                String jdbcType = "INTEGER";
                if (enumerationType.equalsIgnoreCase("STRING")) {
                    jdbcType = "VARCHAR";
                }
                AbstractMemberMetaData mmd = null;
                if (md instanceof JoinMetaData) {
                    JoinMetaData joinmd = (JoinMetaData)md;
                    mmd = (AbstractMemberMetaData)joinmd.getParent();
                } else if (md instanceof AbstractMemberMetaData) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                }
                if (mmd != null) {
                    KeyMetaData keymd = mmd.getKeyMetaData();
                    if (keymd == null) {
                        keymd = new KeyMetaData();
                        mmd.setKeyMetaData(keymd);
                    }
                    ColumnMetaData colmd = null;
                    colmd = keymd.getColumnMetaData() != null && keymd.getColumnMetaData().length == 1 ? keymd.getColumnMetaData()[0] : keymd.newColumnMetaData();
                    colmd.setJdbcType(jdbcType);
                }
            }
        }
        if (localName.equals("attribute-override") || localName.equals("association-override")) {
            this.overrideMmd = null;
        }
        if (localName.equals("entity") || localName.equals("mapped-superclass") || localName.equals("embeddable") || localName.equals("entity-listener") || localName.equals("attribute-override") || localName.equals("association-override") || localName.equals("id") || localName.equals("embedded-id") || localName.equals("basic") || localName.equals("transient") || localName.equals("embedded") || localName.equals("one-to-one") || localName.equals("one-to-many") || localName.equals("many-to-one") || localName.equals("many-to-many") || localName.equals("element-collection") || localName.equals("version") || localName.equals("secondary-table") || localName.equals("join-table") || localName.equals("unique-constraint") || localName.equals("named-query") || localName.equals("named-native-query") || localName.equals("named-stored-procedure-query") || localName.equals("sql-result-set-mapping")) {
            this.popStack();
        }
    }
}

