/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.jpa.JPAClassTransformer;
import org.datanucleus.api.jpa.JPADataStoreCache;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.api.jpa.JPAQueryCache;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.api.jpa.PersistenceProviderImpl;
import org.datanucleus.api.jpa.SingletonEMFException;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.exceptions.NotProviderException;
import org.datanucleus.api.jpa.metamodel.MetamodelImpl;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.query.cache.QueryCompilationCache;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAEntityManagerFactory
implements EntityManagerFactory,
PersistenceUnitUtil {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.api.jpa.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    public static final NucleusLogger LOGGER = NucleusLogger.getLoggerInstance((String)"DataNucleus.JPA");
    private static ConcurrentHashMap<String, JPAEntityManagerFactory> emfByName = null;
    NucleusContext nucleusCtx = null;
    private static Map<String, PersistenceUnitMetaData> unitMetaDataCache = null;
    private PersistenceUnitMetaData unitMetaData = null;
    private boolean closed = false;
    private boolean containerManaged = false;
    private Cache datastoreCache = null;
    private JPAQueryCache queryCache = null;
    private MetamodelImpl metamodel = null;

    public JPAEntityManagerFactory() {
    }

    public NucleusContext getNucleusContext() {
        return this.nucleusCtx;
    }

    public JPAEntityManagerFactory(PersistenceUnitInfo unitInfo, Map overridingProps) {
        Object addCTVal;
        this.containerManaged = true;
        boolean validProvider = false;
        if (unitInfo.getPersistenceProviderClassName() == null || unitInfo.getPersistenceProviderClassName().equals(PersistenceProviderImpl.class.getName()) || overridingProps != null && PersistenceProviderImpl.class.getName().equals(overridingProps.get("javax.persistence.provider"))) {
            validProvider = true;
        }
        if (!validProvider) {
            throw new NotProviderException(LOCALISER.msg("EMF.NotProviderForPersistenceUnit", (Object)unitInfo.getPersistenceUnitName()));
        }
        URI rootURI = null;
        try {
            rootURI = unitInfo.getPersistenceUnitRootUrl().toURI();
        }
        catch (URISyntaxException e1) {
            // empty catch block
        }
        if (unitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            this.unitMetaData = new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.JTA.toString(), rootURI);
        } else if (unitInfo.getTransactionType() == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            this.unitMetaData = new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.RESOURCE_LOCAL.toString(), rootURI);
        }
        List classNames = unitInfo.getManagedClassNames();
        Iterator classIter = classNames.iterator();
        while (classIter.hasNext()) {
            this.unitMetaData.addClassName((String)classIter.next());
        }
        List mappingFileNames = unitInfo.getMappingFileNames();
        Iterator mappingFileIter = mappingFileNames.iterator();
        while (mappingFileIter.hasNext()) {
            this.unitMetaData.addMappingFile((String)mappingFileIter.next());
        }
        List jarUrls = unitInfo.getJarFileUrls();
        Iterator jarUrlIter = jarUrls.iterator();
        while (jarUrlIter.hasNext()) {
            this.unitMetaData.addJarFile((URL)jarUrlIter.next());
        }
        Properties props = unitInfo.getProperties();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                this.unitMetaData.addProperty(prop, props.getProperty(prop));
            }
        }
        if (unitInfo.excludeUnlistedClasses()) {
            this.unitMetaData.setExcludeUnlistedClasses();
        }
        this.unitMetaData.setProvider(unitInfo.getPersistenceProviderClassName());
        overridingProps = overridingProps == null ? new HashMap<String, Object>() : new HashMap(overridingProps);
        PersistenceUnitTransactionType type = unitInfo.getTransactionType();
        if (type == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            if (unitInfo.getNonJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory", unitInfo.getNonJtaDataSource());
            }
        } else {
            if (unitInfo.getJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory", unitInfo.getJtaDataSource());
            }
            if (unitInfo.getNonJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory2", unitInfo.getNonJtaDataSource());
            }
        }
        if (unitInfo.getClassLoader() != null) {
            overridingProps.put("datanucleus.primaryClassLoader", unitInfo.getClassLoader());
        }
        boolean addClassTransformer = true;
        if (this.unitMetaData.getProperties() != null && (addCTVal = this.unitMetaData.getProperties().get("datanucleus.jpa.addClassTransformer")) != null && ((String)addCTVal).equalsIgnoreCase("false")) {
            addClassTransformer = false;
        }
        if (overridingProps != null && (addCTVal = overridingProps.get("datanucleus.jpa.addClassTransformer")) != null && ((String)addCTVal).equalsIgnoreCase("false")) {
            addClassTransformer = false;
        }
        if (addClassTransformer) {
            try {
                unitInfo.addTransformer((ClassTransformer)new JPAClassTransformer());
            }
            catch (IllegalStateException ise) {
                LOGGER.warn((Object)"Exception was caught when adding the class transformer. Ignoring it.", (Throwable)ise);
            }
        }
        this.nucleusCtx = this.initialiseNucleusContext(this.unitMetaData, overridingProps, null);
        JPAEntityManagerFactory.assertSingleton(this.unitMetaData.getName(), this);
        boolean allowMetadataLoad = this.nucleusCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime");
        if (!allowMetadataLoad) {
            this.nucleusCtx.getMetaDataManager().setAllowMetaDataLoad(false);
        }
    }

    public JPAEntityManagerFactory(PersistenceUnitMetaData pumd, Map overridingProps) {
        if (unitMetaDataCache == null) {
            unitMetaDataCache = new HashMap<String, PersistenceUnitMetaData>();
        }
        this.initialise(pumd, overridingProps, null);
    }

    public JPAEntityManagerFactory(String unitName, Map overridingProps) {
        if (unitMetaDataCache == null) {
            unitMetaDataCache = new HashMap<String, PersistenceUnitMetaData>();
        }
        PluginManager pluginMgr = null;
        this.unitMetaData = unitMetaDataCache.get(unitName);
        if (this.unitMetaData == null) {
            PersistenceFileMetaData[] files;
            pluginMgr = PluginManager.createPluginManager((Map)overridingProps, (ClassLoader)this.getClass().getClassLoader());
            String persistenceFileName = null;
            if (overridingProps.containsKey("datanucleus.persistenceXmlFilename")) {
                persistenceFileName = (String)overridingProps.get("datanucleus.persistenceXmlFilename");
            }
            boolean validate = false;
            if (overridingProps.containsKey("datanucleus.metadata.validate")) {
                validate = Boolean.getBoolean((String)overridingProps.get("datanucleus.metadata.validate"));
            }
            if ((files = MetaDataUtils.parsePersistenceFiles((PluginManager)pluginMgr, (String)persistenceFileName, (boolean)validate, null)) == null) {
                LOGGER.warn((Object)LOCALISER.msg("EMF.NoPersistenceXML"));
            } else {
                block0: for (int i = 0; i < files.length; ++i) {
                    PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
                    for (int j = 0; j < unitmds.length; ++j) {
                        unitMetaDataCache.put(unitmds[j].getName(), unitmds[j]);
                        if (!unitmds[j].getName().equals(unitName)) continue;
                        this.unitMetaData = unitmds[j];
                        this.unitMetaData.clearJarFiles();
                        continue block0;
                    }
                }
            }
            if (this.unitMetaData == null) {
                LOGGER.warn((Object)LOCALISER.msg("EMF.PersistenceUnitNotFound", (Object)unitName));
            } else {
                unitMetaDataCache.put(this.unitMetaData.getName(), this.unitMetaData);
            }
        }
        this.initialise(this.unitMetaData, overridingProps, pluginMgr);
    }

    private void initialise(PersistenceUnitMetaData pumd, Map overridingProps, PluginManager pluginMgr) {
        boolean validProvider = false;
        if (pumd != null && (pumd.getProvider() == null || pumd.getProvider().equals(PersistenceProviderImpl.class.getName()))) {
            validProvider = true;
        }
        if (overridingProps != null && PersistenceProviderImpl.class.getName().equals(overridingProps.get("javax.persistence.provider"))) {
            validProvider = true;
        }
        if (!validProvider) {
            throw new NotProviderException(LOCALISER.msg("EMF.NotProviderForPersistenceUnit", (Object)pumd.getName()));
        }
        this.unitMetaData = pumd;
        unitMetaDataCache.put(pumd.getName(), pumd);
        this.nucleusCtx = this.initialiseNucleusContext(pumd, overridingProps, pluginMgr);
        JPAEntityManagerFactory.assertSingleton(pumd.getName(), this);
        boolean allowMetadataLoad = this.nucleusCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime");
        if (!allowMetadataLoad) {
            this.nucleusCtx.getMetaDataManager().setAllowMetaDataLoad(false);
        }
    }

    private static synchronized void assertSingleton(String puName, JPAEntityManagerFactory emf) {
        Boolean singleton = emf.getNucleusContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.singletonEMFForName");
        if (singleton != null && singleton.booleanValue()) {
            if (emfByName == null) {
                emfByName = new ConcurrentHashMap();
            }
            if (emfByName.containsKey(puName)) {
                JPAEntityManagerFactory singletonEMF = emfByName.get(puName);
                emf.close();
                NucleusLogger.PERSISTENCE.warn((Object)("Requested EMF of name \"" + puName + "\" but already exists and using singleton pattern, so returning existing EMF"));
                throw new SingletonEMFException("Requested EMF that already exists", singletonEMF);
            }
            emfByName.putIfAbsent(puName, emf);
        }
    }

    public boolean isContainerManaged() {
        return this.containerManaged;
    }

    public synchronized void close() {
        this.assertIsClosed();
        if (emfByName != null && this.unitMetaData != null) {
            emfByName.remove(this.unitMetaData.getName());
        }
        this.closed = true;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public JPAQueryCache getQueryCache() {
        this.assertIsClosed();
        if (this.queryCache != null) {
            return this.queryCache;
        }
        this.queryCache = new JPAQueryCache(this.nucleusCtx.getStoreManager().getQueryManager().getQueryResultsCache());
        return this.queryCache;
    }

    public QueryCompilationCache getQueryGenericCompilationCache() {
        return this.nucleusCtx.getStoreManager().getQueryManager().getQueryCompilationCache();
    }

    public QueryDatastoreCompilationCache getQueryDatastoreCompilationCache() {
        return this.nucleusCtx.getStoreManager().getQueryManager().getQueryDatastoreCompilationCache();
    }

    public EntityManager createEntityManager() {
        this.assertIsClosed();
        return this.newEntityManager(this.nucleusCtx, this.containerManaged ? PersistenceContextType.TRANSACTION : PersistenceContextType.EXTENDED);
    }

    public EntityManager createEntityManager(Map overridingProps) {
        this.assertIsClosed();
        NucleusContext nucleusCtx = this.initialiseNucleusContext(this.unitMetaData, overridingProps, null);
        PersistenceContextType persistenceContext = PersistenceContextType.EXTENDED;
        if (this.containerManaged) {
            persistenceContext = PersistenceContextType.TRANSACTION;
        }
        return this.newEntityManager(nucleusCtx, persistenceContext);
    }

    protected EntityManager newEntityManager(NucleusContext nucleusCtx, PersistenceContextType contextType) {
        return new JPAEntityManager(this, nucleusCtx, contextType);
    }

    protected NucleusContext initialiseNucleusContext(PersistenceUnitMetaData unitMetaData, Map overridingProps, PluginManager pluginMgr) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (unitMetaData.getJtaDataSource() != null) {
            props.put("datanucleus.ConnectionFactoryName".toLowerCase(Locale.ENGLISH), unitMetaData.getJtaDataSource());
        }
        if (unitMetaData.getNonJtaDataSource() != null) {
            props.put("datanucleus.ConnectionFactory2Name".toLowerCase(Locale.ENGLISH), unitMetaData.getNonJtaDataSource());
        }
        if (unitMetaData.getTransactionType() != null) {
            props.put("datanucleus.TransactionType".toLowerCase(Locale.ENGLISH), unitMetaData.getTransactionType().toString());
        }
        if (unitMetaData.getCaching().equalsIgnoreCase("NONE")) {
            props.put("datanucleus.cache.level2.type", "none");
        } else if (!unitMetaData.getCaching().equalsIgnoreCase("UNSPECIFIED")) {
            props.put("datanucleus.cache.level2.mode", unitMetaData.getCaching());
        }
        Properties unitProps = unitMetaData.getProperties();
        if (unitProps != null) {
            for (Object key : unitProps.keySet()) {
                String propName = (String)key;
                props.put(propName.toLowerCase(Locale.ENGLISH), unitProps.getProperty(propName));
            }
        }
        String persistenceContextTypeProp = null;
        if (props.containsKey("datanucleus.jpa.persistencecontexttype")) {
            persistenceContextTypeProp = (String)props.get("datanucleus.jpa.persistencecontexttype");
        }
        if (overridingProps != null && overridingProps.containsKey("datanucleus.jpa.persistencecontexttype")) {
            persistenceContextTypeProp = (String)overridingProps.get("datanucleus.jpa.persistencecontexttype");
        }
        if (persistenceContextTypeProp != null && persistenceContextTypeProp.equalsIgnoreCase("transaction")) {
            if (!props.containsKey("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH), "true");
            }
            if (!props.containsKey("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH), "true");
            }
            if (!props.containsKey("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH), "false");
            }
        } else if (persistenceContextTypeProp != null && persistenceContextTypeProp.equalsIgnoreCase("extended")) {
            if (!props.containsKey("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH), "false");
            }
            if (!props.containsKey("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH), "false");
            }
            if (!props.containsKey("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH), "true");
            }
        } else if (this.containerManaged) {
            if (!props.containsKey("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH), "true");
            }
            if (!props.containsKey("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH), "true");
            }
            if (!props.containsKey("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH), "false");
            }
        } else {
            if (!props.containsKey("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH), "false");
            }
            if (!props.containsKey("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH), "false");
            }
            if (!props.containsKey("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH))) {
                props.put("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH), "true");
            }
        }
        if (overridingProps != null) {
            props.putAll(overridingProps);
        }
        props.put("datanucleus.autoStartMechanism".toLowerCase(Locale.ENGLISH), "None");
        props.put("datanucleus.PersistenceUnitName".toLowerCase(Locale.ENGLISH), unitMetaData.getName());
        if (unitMetaData.getValidationMode() != null) {
            props.put("datanucleus.validation.mode".toLowerCase(Locale.ENGLISH), unitMetaData.getValidationMode());
        }
        props.remove("datanucleus.jpa.persistencecontexttype");
        if (!props.containsKey("datanucleus.TransactionType".toLowerCase(Locale.ENGLISH)) && !props.containsKey("javax.jdo.option.transactiontype")) {
            props.put("datanucleus.TransactionType".toLowerCase(Locale.ENGLISH), TransactionType.RESOURCE_LOCAL.toString());
        } else {
            String transactionType;
            String string = transactionType = props.get("datanucleus.TransactionType".toLowerCase(Locale.ENGLISH)) != null ? (String)props.get("datanucleus.TransactionType".toLowerCase(Locale.ENGLISH)) : (String)props.get("javax.jdo.option.transactiontype");
            if (TransactionType.JTA.toString().equalsIgnoreCase(transactionType)) {
                props.put("datanucleus.connection.resourceType".toLowerCase(Locale.ENGLISH), ConnectionResourceType.JTA.toString());
                props.put("datanucleus.connection2.resourceType".toLowerCase(Locale.ENGLISH), ConnectionResourceType.JTA.toString());
            }
        }
        HashMap startupProps = null;
        for (String startupPropName : NucleusContext.STARTUP_PROPERTIES) {
            for (String currentPropName : props.keySet()) {
                if (!currentPropName.equalsIgnoreCase(startupPropName)) continue;
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put(startupPropName, props.get(currentPropName));
            }
        }
        NucleusContext nucleusCtx = pluginMgr != null ? new NucleusContext("JPA", startupProps, pluginMgr) : new NucleusContext("JPA", startupProps);
        PersistenceConfiguration propConfig = nucleusCtx.getPersistenceConfiguration();
        propConfig.setPersistenceProperties(props);
        nucleusCtx.getMetaDataManager().setAllowXML(propConfig.getBooleanProperty("datanucleus.metadata.allowXML"));
        nucleusCtx.getMetaDataManager().setAllowAnnotations(propConfig.getBooleanProperty("datanucleus.metadata.allowAnnotations"));
        nucleusCtx.getMetaDataManager().setValidate(propConfig.getBooleanProperty("datanucleus.metadata.validate"));
        nucleusCtx.getMetaDataManager().loadPersistenceUnit(unitMetaData, null);
        nucleusCtx.initialise();
        return nucleusCtx;
    }

    public Map<String, Object> getProperties() {
        return this.nucleusCtx.getPersistenceConfiguration().getPersistenceProperties();
    }

    public Set<String> getSupportedProperties() {
        return this.nucleusCtx.getPersistenceConfiguration().getSupportedProperties();
    }

    protected void assertIsClosed() {
        if (this.closed) {
            throw new IllegalStateException("EntityManagerFactory is already closed");
        }
    }

    public Cache getCache() {
        this.assertIsClosed();
        if (this.datastoreCache == null && this.nucleusCtx.hasLevel2Cache()) {
            this.datastoreCache = new JPADataStoreCache(this.nucleusCtx, this.nucleusCtx.getLevel2Cache());
        }
        return this.datastoreCache;
    }

    public Metamodel getMetamodel() {
        this.assertIsClosed();
        if (this.metamodel != null) {
            return this.metamodel;
        }
        this.metamodel = new MetamodelImpl(this.nucleusCtx.getMetaDataManager());
        return this.metamodel;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.assertIsClosed();
        return new CriteriaBuilderImpl((MetamodelImpl)this.getMetamodel());
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this;
    }

    public Object getIdentifier(Object entity) {
        return this.nucleusCtx.getApiAdapter().getIdForObject(entity);
    }

    public boolean isLoaded(Object entity, String attrName) {
        ExecutionContext ec = this.nucleusCtx.getApiAdapter().getExecutionContext(entity);
        if (ec == null) {
            return false;
        }
        ObjectProvider sm = ec.findObjectProvider(entity);
        if (sm == null) {
            return false;
        }
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(entity.getClass(), this.nucleusCtx.getClassLoaderResolver(entity.getClass().getClassLoader()));
        if (cmd == null) {
            return false;
        }
        return this.nucleusCtx.getApiAdapter().isLoaded(sm, cmd.getAbsolutePositionOfMember(attrName));
    }

    public boolean isLoaded(Object entity) {
        return !this.nucleusCtx.getApiAdapter().getObjectState(entity).equals("hollow");
    }

    public <T> T unwrap(Class<T> cls) {
        if (NucleusContext.class.isAssignableFrom(cls)) {
            return (T)this.nucleusCtx;
        }
        throw new PersistenceException("Not yet supported");
    }
}

