/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.state;

import org.datanucleus.FetchPlan;
import org.datanucleus.Transaction;
import org.datanucleus.api.jdo.exceptions.TransactionNotReadableException;
import org.datanucleus.api.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.state.IllegalStateTransitionException;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.StateManager;

class PersistentNontransactional
extends LifeCycleState {
    protected PersistentNontransactional() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = false;
        this.stateType = 9;
    }

    public LifeCycleState transitionDeletePersistent(StateManager sm) {
        sm.clearLoadedFlags();
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeTransactional(StateManager sm, boolean refreshFields) {
        if (refreshFields) {
            sm.refreshLoadedFields();
        }
        return this.changeState(sm, 2);
    }

    public LifeCycleState transitionMakeTransient(StateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionCommit(StateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException((LifeCycleState)this, "commit", sm);
    }

    public LifeCycleState transitionRollback(StateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException((LifeCycleState)this, "rollback", sm);
    }

    public LifeCycleState transitionRefresh(StateManager sm) {
        sm.refreshFieldsInFetchPlan();
        sm.unloadNonFetchPlanFields();
        return this;
    }

    public LifeCycleState transitionEvict(StateManager sm) {
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionReadField(StateManager sm, boolean isLoaded) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalRead()) {
            throw new TransactionNotReadableException(LOCALISER.msg("027002"), sm.getInternalObjectId());
        }
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            sm.refreshLoadedFields();
            return this.changeState(sm, 2);
        }
        return this;
    }

    public LifeCycleState transitionWriteField(StateManager sm) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalWrite()) {
            throw new TransactionNotWritableException(LOCALISER.msg("027001"), sm.getInternalObjectId());
        }
        if (tx.isActive()) {
            sm.saveFields();
            return this.changeState(sm, 3);
        }
        sm.saveFields();
        return this.changeState(sm, 10);
    }

    public LifeCycleState transitionRetrieve(StateManager sm, boolean fgOnly) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            if (fgOnly) {
                sm.loadUnloadedFieldsInFetchPlan();
            } else {
                sm.loadUnloadedFields();
            }
            return this.changeState(sm, 2);
        }
        if (tx.isActive() && tx.getOptimistic()) {
            sm.saveFields();
            if (fgOnly) {
                sm.loadUnloadedFieldsInFetchPlan();
            } else {
                sm.loadUnloadedFields();
            }
            return this;
        }
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        return this;
    }

    public LifeCycleState transitionRetrieve(StateManager sm, FetchPlan fetchPlan) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
            return this.changeState(sm, 2);
        }
        if (tx.isActive() && tx.getOptimistic()) {
            sm.saveFields();
            sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
            return this;
        }
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        return this;
    }

    public LifeCycleState transitionSerialize(StateManager sm) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            return this.changeState(sm, 2);
        }
        return this;
    }

    public LifeCycleState transitionDetach(StateManager sm) {
        return this.changeState(sm, 11);
    }

    public String toString() {
        return "P_NONTRANS";
    }
}

