/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import org.datanucleus.api.jdo.query.AbstractTypesafeQuery;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.CharacterExpressionImpl;
import org.datanucleus.api.jdo.query.CollectionExpressionImpl;
import org.datanucleus.api.jdo.query.DateExpressionImpl;
import org.datanucleus.api.jdo.query.DateTimeExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionImpl;
import org.datanucleus.api.jdo.query.JDOTypesafeQuery;
import org.datanucleus.api.jdo.query.NumericExpressionImpl;
import org.datanucleus.api.jdo.query.StringExpressionImpl;
import org.datanucleus.api.jdo.query.TimeExpressionImpl;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.typesafe.BooleanExpression;
import org.datanucleus.query.typesafe.CharacterExpression;
import org.datanucleus.query.typesafe.CollectionExpression;
import org.datanucleus.query.typesafe.DateExpression;
import org.datanucleus.query.typesafe.DateTimeExpression;
import org.datanucleus.query.typesafe.NumericExpression;
import org.datanucleus.query.typesafe.PersistableExpression;
import org.datanucleus.query.typesafe.StringExpression;
import org.datanucleus.query.typesafe.TimeExpression;
import org.datanucleus.query.typesafe.TypesafeSubquery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOTypesafeSubquery<T>
extends AbstractTypesafeQuery<T>
implements TypesafeSubquery<T> {
    JDOTypesafeQuery parentQuery = null;

    public JDOTypesafeSubquery(PersistenceManager pm, Class<T> candidateClass, String candidateAlias, JDOTypesafeQuery parentQuery) {
        super(pm, candidateClass, candidateAlias);
        this.parentQuery = parentQuery;
    }

    public String getAlias() {
        return "VAR_" + this.candidateAlias.toUpperCase();
    }

    public PersistableExpression candidate() {
        String candName = this.candidateCls.getName();
        int pos = candName.lastIndexOf(46);
        String qName = candName.substring(0, pos + 1) + JDOTypesafeQuery.getQueryClassNameForClassName(candName.substring(pos + 1));
        try {
            Class qClass = this.om.getClassLoaderResolver().classForName(qName);
            Constructor ctr = qClass.getConstructor(PersistableExpression.class, String.class);
            Object candObj = ctr.newInstance(null, this.candidateAlias);
            if (candObj == null || !(candObj instanceof PersistableExpression)) {
                throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
            }
            return (PersistableExpression)candObj;
        }
        catch (NoSuchMethodException nsfe) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
        catch (InvocationTargetException ite) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
        catch (InstantiationException ie) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
        catch (IllegalAccessException iae) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
    }

    public TypesafeSubquery filter(BooleanExpression expr) {
        this.discardCompiled();
        this.filter = (BooleanExpressionImpl)expr;
        return this;
    }

    public TypesafeSubquery groupBy(org.datanucleus.query.typesafe.Expression ... exprs) {
        this.discardCompiled();
        if (exprs != null && exprs.length > 0) {
            this.grouping = new ArrayList();
        }
        for (int i = 0; i < exprs.length; ++i) {
            this.grouping.add((ExpressionImpl)exprs[i]);
        }
        return this;
    }

    public TypesafeSubquery having(org.datanucleus.query.typesafe.Expression expr) {
        this.discardCompiled();
        this.having = (ExpressionImpl)expr;
        return this;
    }

    public <S> NumericExpression<S> selectUnique(NumericExpression<S> expr) {
        return (NumericExpression)this.internalSelect((org.datanucleus.query.typesafe.Expression)expr, NumericExpressionImpl.class);
    }

    public StringExpression selectUnique(StringExpression expr) {
        return (StringExpression)this.internalSelect((org.datanucleus.query.typesafe.Expression)expr, StringExpressionImpl.class);
    }

    public <S> DateExpression<S> selectUnique(DateExpression<S> expr) {
        return (DateExpression)this.internalSelect((org.datanucleus.query.typesafe.Expression)expr, DateExpressionImpl.class);
    }

    public <S> DateTimeExpression<S> selectUnique(DateTimeExpression<S> expr) {
        return (DateTimeExpression)this.internalSelect((org.datanucleus.query.typesafe.Expression)expr, DateTimeExpressionImpl.class);
    }

    public <S> TimeExpression<S> selectUnique(TimeExpression<S> expr) {
        return (TimeExpression)this.internalSelect((org.datanucleus.query.typesafe.Expression)expr, TimeExpressionImpl.class);
    }

    public CharacterExpression selectUnique(CharacterExpression expr) {
        return (CharacterExpression)this.internalSelect((org.datanucleus.query.typesafe.Expression)expr, CharacterExpressionImpl.class);
    }

    public CollectionExpression select(CollectionExpression expr) {
        return (CollectionExpression)this.internalSelect((org.datanucleus.query.typesafe.Expression)expr, CollectionExpressionImpl.class);
    }

    protected org.datanucleus.query.typesafe.Expression internalSelect(org.datanucleus.query.typesafe.Expression expr, Class implClass) {
        this.result = new ArrayList();
        this.result.add((ExpressionImpl)expr);
        VariableExpression varExpr = new VariableExpression(this.getAlias());
        try {
            Constructor ctr = implClass.getConstructor(Expression.class);
            return (org.datanucleus.query.typesafe.Expression)ctr.newInstance(varExpr);
        }
        catch (NoSuchMethodException nsme) {
            throw new JDOException("Unable to create expression of type " + expr.getClass().getName() + " since required constructor doesnt exist");
        }
        catch (InvocationTargetException ite) {
            throw new JDOException("Unable to create expression of type " + expr.getClass().getName() + " due to error in constructor");
        }
        catch (IllegalAccessException iae) {
            throw new JDOException("Unable to create expression of type " + expr.getClass().getName() + " due to error in constructor");
        }
        catch (InstantiationException ie) {
            throw new JDOException("Unable to create expression of type " + expr.getClass().getName() + " due to error in constructor");
        }
    }
}

