/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import org.databene.contiperf.AbstractInvocationRunner;
import org.databene.contiperf.ArgumentsProvider;
import org.databene.contiperf.Invoker;
import org.databene.contiperf.WaitTimer;
import org.databene.contiperf.util.ContiPerfUtil;

public class TimedRunner
extends AbstractInvocationRunner {
    private long duration;
    private ArgumentsProvider argsProvider;
    private Invoker invoker;

    public TimedRunner(Invoker invoker, ArgumentsProvider argsProvider, WaitTimer waitTimer, long duration) {
        super(waitTimer);
        this.invoker = invoker;
        this.argsProvider = argsProvider;
        this.duration = duration;
    }

    public void run() {
        try {
            long start = System.currentTimeMillis();
            long endTime = start + this.duration;
            do {
                this.invoker.invoke(this.argsProvider.next());
                this.sleep();
            } while (System.currentTimeMillis() < endTime);
        }
        catch (Exception e) {
            throw ContiPerfUtil.executionError(e);
        }
    }

    public void close() {
        this.invoker = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.duration + " ms)";
    }
}

