/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import java.io.File;
import org.databene.contiperf.report.HtmlReportModule;
import org.databene.contiperf.report.ReportContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static final String DEFAULT_REPORT_FOLDER_NAME = "contiperf-report";
    public static final String SYSPROP_ACTIVE = "contiperf.active";
    public static final String SYSPROP_CONFIG_FILENAME = "contiperf.config";
    public static final String DEFAULT_CONFIG_FILENAME = "contiperf.config.xml";
    private static Config instance;

    public boolean active() {
        String sysprop = System.getProperty(SYSPROP_ACTIVE);
        return sysprop == null || !"false".equals(sysprop.trim().toLowerCase());
    }

    public static String getConfigFileName() {
        String filename = System.getProperty(SYSPROP_CONFIG_FILENAME);
        if (filename == null || filename.trim().length() == 0) {
            filename = DEFAULT_CONFIG_FILENAME;
        }
        return filename;
    }

    public static Config instance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public int getInvocationCount(String testId) {
        return -1;
    }

    public ReportContext createDefaultReportContext(Class<? extends AssertionError> failureClass) {
        File reportFolder = this.getReportFolder();
        ReportContext context = new ReportContext(reportFolder, failureClass);
        context.addReportModule(new HtmlReportModule());
        return context;
    }

    public File getReportFolder() {
        File targetDir = new File("target");
        File reportFolder = targetDir.exists() ? new File(targetDir, DEFAULT_REPORT_FOLDER_NAME) : new File(DEFAULT_REPORT_FOLDER_NAME);
        return reportFolder;
    }
}

