/*
 * (c) Copyright 2009-2010 by Volker Bergmann. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted under the terms of the
 * GNU Lesser General Public License (LGPL), Eclipse Public License (EPL) 
 * and the BSD License.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * WITHOUT A WARRANTY OF ANY KIND. ALL EXPRESS OR IMPLIED CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
 * HEREBY EXCLUDED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package org.databene.contiperf;

/**
 * Executes the actual performance tests using an {@link ArgumentsProvider} 
 * to create arguments and an {@link Invoker} to call the target code.<br/><br/>
 * Created: 22.10.2009 06:30:28
 * @since 1.0
 * @author Volker Bergmann
 */
public class PerfTestRunner {

    private ExecutionConfig config;
    private ArgumentsProvider argsProvider;
    
    private PerformanceTracker tracker;

    public PerfTestRunner(ExecutionConfig config, 
    		PerformanceTracker tracker, ArgumentsProvider argsProvider) {
	    this.config = config;
	    this.tracker = tracker;
	    this.argsProvider = argsProvider;
    }

    public void run() throws Exception {
    	int duration = config.getDuration();
    	if (duration >= 0)
    		runWithDuration(duration);
    	else
    		runWithCount(config.getInvocations());
    }

	private void runWithDuration(int duration) throws Exception {
	    long start = System.currentTimeMillis();
	    do {
    	    tracker.invoke(argsProvider.next());
	    } while ((int) (System.currentTimeMillis() - start) < duration);
    }

	private void runWithCount(int invocations) throws Exception {
		for (int i = 0; i < invocations; i++)
    	    tracker.invoke(argsProvider.next());
    }

}
