/*
 * Decompiled with CFR 0.152.
 */
package khttp.structures.authorization;

import java.nio.charset.Charset;
import java.util.Base64;
import khttp.structures.authorization.Authorization;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lkhttp/structures/authorization/BasicAuthorization;", "Lkhttp/structures/authorization/Authorization;", "user", "", "password", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getUser", "()Ljava/lang/String;", "getPassword", "header", "Lkotlin/Pair;", "getHeader", "()Lkotlin/Pair;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "khttp"})
public final class BasicAuthorization
implements Authorization {
    @NotNull
    private final String user;
    @NotNull
    private final String password;

    public BasicAuthorization(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.user = user;
        this.password = password;
    }

    @NotNull
    public final String getUser() {
        return this.user;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @Override
    @NotNull
    public Pair<String, String> getHeader() {
        Base64.Encoder encoder = Base64.getEncoder();
        Object object = this.user + ':' + this.password;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = encoder.encode(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
        byte[] byArray3 = byArray2;
        object = Charsets.UTF_8;
        String b64 = new String(byArray3, (Charset)object);
        return TuplesKt.to((Object)"Authorization", (Object)("Basic " + b64));
    }

    @NotNull
    public final String component1() {
        return this.user;
    }

    @NotNull
    public final String component2() {
        return this.password;
    }

    @NotNull
    public final BasicAuthorization copy(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return new BasicAuthorization(user, password);
    }

    public static /* synthetic */ BasicAuthorization copy$default(BasicAuthorization basicAuthorization, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = basicAuthorization.user;
        }
        if ((n & 2) != 0) {
            string2 = basicAuthorization.password;
        }
        return basicAuthorization.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "BasicAuthorization(user=" + this.user + ", password=" + this.password + ')';
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = result * 31 + this.password.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicAuthorization)) {
            return false;
        }
        BasicAuthorization basicAuthorization = (BasicAuthorization)other;
        if (!Intrinsics.areEqual((Object)this.user, (Object)basicAuthorization.user)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.password, (Object)basicAuthorization.password);
    }
}

