/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css.impl;

import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleMargin;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.Selector;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.daisy.braille.css.AnyAtRule;
import org.daisy.braille.css.InlineStyle;
import org.daisy.braille.css.RuleCounterStyle;
import org.daisy.braille.css.RuleTextTransform;
import org.daisy.braille.css.RuleVolume;
import org.daisy.braille.css.RuleVolumeArea;
import org.daisy.braille.css.SelectorImpl;
import org.daisy.pipeline.braille.css.impl.BrailleCssSerializer;

public final class BrailleCssTreeBuilder {
    private BrailleCssTreeBuilder() {
    }

    private static String[] serializeSelector(List<Selector> combinedSelector) {
        ArrayList<String> selector = new ArrayList<String>();
        for (CombinatorSelectorPart part : BrailleCssTreeBuilder.flattenSelector(combinedSelector)) {
            selector.add("&" + part);
        }
        return selector.toArray(new String[selector.size()]);
    }

    private static List<CombinatorSelectorPart> flattenSelector(List<Selector> combinedSelector) {
        ArrayList<CombinatorSelectorPart> selector = new ArrayList<CombinatorSelectorPart>();
        for (Selector s : combinedSelector) {
            BrailleCssTreeBuilder.flattenSelector(selector, s);
        }
        return selector;
    }

    private static void flattenSelector(List<CombinatorSelectorPart> collect, Selector selector) {
        Selector.Combinator combinator = selector.getCombinator();
        for (Selector.SelectorPart part : selector) {
            BrailleCssTreeBuilder.flattenSelector(collect, combinator, part);
            combinator = null;
        }
    }

    private static void flattenSelector(List<CombinatorSelectorPart> collect, Selector.Combinator combinator, Selector.SelectorPart part) {
        collect.add(new CombinatorSelectorPart(combinator, part));
        if (part instanceof SelectorImpl.PseudoElementImpl) {
            SelectorImpl.PseudoElementImpl pe = (SelectorImpl.PseudoElementImpl)part;
            if (!pe.getCombinedSelectors().isEmpty()) {
                for (Selector s : pe.getCombinedSelectors()) {
                    BrailleCssTreeBuilder.flattenSelector(collect, s);
                }
            } else {
                if (!pe.getPseudoClasses().isEmpty()) {
                    for (Selector.PseudoClass pc : pe.getPseudoClasses()) {
                        collect.add(new CombinatorSelectorPart(null, (Selector.SelectorPart)pc));
                    }
                }
                if (pe.hasStackedPseudoElement()) {
                    BrailleCssTreeBuilder.flattenSelector(collect, null, (Selector.SelectorPart)pe.getStackedPseudoElement());
                }
            }
        }
    }

    private static class CombinatorSelectorPart {
        final Selector.Combinator combinator;
        final Selector.SelectorPart selector;

        CombinatorSelectorPart(Selector.Combinator combinator, Selector.SelectorPart selector) {
            this.combinator = combinator;
            this.selector = selector;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.combinator != null) {
                b.append(this.combinator.value());
            }
            if (this.selector instanceof SelectorImpl.PseudoElementImpl) {
                SelectorImpl.PseudoElementImpl pe = (SelectorImpl.PseudoElementImpl)this.selector;
                b.append(":");
                if (!pe.isSpecifiedAsClass()) {
                    b.append(":");
                }
                b.append(pe.getName());
                String[] args = pe.getArguments();
                if (args.length > 0) {
                    b.append("(");
                    for (int i = 0; i < args.length; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(args[i]);
                    }
                    b.append(")");
                }
            } else {
                b.append(this.selector);
            }
            return b.toString();
        }
    }

    public static class Style
    implements Comparator<String> {
        List<Declaration> declarations;
        SortedMap<String, Style> nestedStyles;

        @Override
        public int compare(String selector1, String selector2) {
            if (selector1.startsWith("&") && !selector2.startsWith("&")) {
                return 1;
            }
            if (!selector1.startsWith("&") && selector2.startsWith("&")) {
                return -1;
            }
            return selector1.compareTo(selector2);
        }

        private Style add(Declaration declaration) {
            if (declaration != null) {
                if (this.declarations == null) {
                    this.declarations = new ArrayList<Declaration>();
                }
                this.declarations.add(declaration);
            }
            return this;
        }

        private Style add(Iterable<Declaration> declarations) {
            if (declarations != null) {
                for (Declaration d : declarations) {
                    this.add(d);
                }
            }
            return this;
        }

        Style add(String selector, Style nestedStyle) {
            if (this.nestedStyles == null) {
                this.nestedStyles = new TreeMap<String, Style>(this);
            }
            if (selector == null) {
                this.add(nestedStyle);
            }
            if (this.nestedStyles.containsKey(selector)) {
                ((Style)this.nestedStyles.get(selector)).add(nestedStyle);
            } else {
                this.nestedStyles.put(selector, nestedStyle);
            }
            return this;
        }

        Style add(String[] selector, Style nestedStyle) {
            if (selector.length == 0) {
                return this;
            }
            for (int i = selector.length - 1; i > 0; --i) {
                nestedStyle = new Style().add(selector[i], nestedStyle);
            }
            return this.add(selector[0], nestedStyle);
        }

        private Style add(Style style) {
            this.add(style.declarations);
            if (style.nestedStyles != null) {
                for (Map.Entry<String, Style> e : style.nestedStyles.entrySet()) {
                    this.add(e.getKey(), e.getValue());
                }
            }
            return this;
        }

        static Style of(RulePage page) {
            Style style = new Style();
            for (Rule r : page) {
                if (r instanceof Declaration) {
                    style.add((Declaration)r);
                    continue;
                }
                if (r instanceof RuleMargin) {
                    style.add("@" + ((RuleMargin)r).getMarginArea(), new Style().add((Iterable<Declaration>)r));
                    continue;
                }
                throw new RuntimeException("coding error");
            }
            String pseudo = page.getPseudo();
            return pseudo == null ? style : new Style().add("&:" + pseudo, style);
        }

        private static Style of(RuleVolumeArea volumeArea) {
            Style style = new Style();
            for (Rule r : volumeArea) {
                if (r instanceof Declaration) {
                    style.add((Declaration)r);
                    continue;
                }
                if (r instanceof RulePage) {
                    style.add("@page", Style.of((RulePage)r));
                    continue;
                }
                throw new RuntimeException("coding error");
            }
            return style;
        }

        private static Style of(RuleVolume volume) {
            Style style = new Style();
            for (Rule r : volume) {
                if (r instanceof Declaration) {
                    style.add((Declaration)r);
                    continue;
                }
                if (r instanceof RuleVolumeArea) {
                    style.add("@" + ((RuleVolumeArea)r).getVolumeArea().value, Style.of((RuleVolumeArea)r));
                    continue;
                }
                throw new RuntimeException("coding error");
            }
            String pseudo = volume.getPseudo();
            return pseudo == null ? style : new Style().add("&:" + pseudo, style);
        }

        private static Style of(AnyAtRule rule) {
            Style style = new Style();
            for (Rule r : rule) {
                if (r instanceof Declaration) {
                    style.add((Declaration)r);
                    continue;
                }
                if (r instanceof AnyAtRule) {
                    style.add("@" + ((AnyAtRule)r).getName(), Style.of((AnyAtRule)r));
                    continue;
                }
                throw new RuntimeException("coding error");
            }
            return style;
        }

        public static Style of(InlineStyle inlineStyle) {
            Style style = new Style();
            for (RuleBlock rule : inlineStyle) {
                String name;
                if (rule instanceof InlineStyle.RuleMainBlock) {
                    style.add((Iterable<Declaration>)rule);
                    continue;
                }
                if (rule instanceof InlineStyle.RuleRelativeBlock) {
                    String[] selector = BrailleCssTreeBuilder.serializeSelector(((InlineStyle.RuleRelativeBlock)rule).getSelector());
                    Style decls = new Style();
                    for (Rule r : (InlineStyle.RuleRelativeBlock)rule) {
                        if (r instanceof Declaration) {
                            decls.add((Declaration)r);
                            continue;
                        }
                        if (r instanceof RulePage) {
                            decls.add("@page", Style.of((RulePage)r));
                            continue;
                        }
                        throw new RuntimeException("coding error");
                    }
                    style.add(selector, decls);
                    continue;
                }
                if (rule instanceof RulePage) {
                    style.add("@page", Style.of((RulePage)rule));
                    continue;
                }
                if (rule instanceof RuleVolume) {
                    style.add("@volume", Style.of((RuleVolume)rule));
                    continue;
                }
                if (rule instanceof RuleTextTransform) {
                    name = ((RuleTextTransform)rule).getName();
                    Style textTransform = new Style().add((Iterable<Declaration>)rule);
                    if (name == null) {
                        style.add("@text-transform", textTransform);
                        continue;
                    }
                    style.add("@text-transform", new Style().add("& " + name, textTransform));
                    continue;
                }
                if (rule instanceof RuleCounterStyle) {
                    name = ((RuleCounterStyle)rule).getName();
                    Style counterStyle = new Style().add((Iterable<Declaration>)rule);
                    style.add("@counter-style", new Style().add("& " + name, counterStyle));
                    continue;
                }
                if (rule instanceof RuleMargin) {
                    style.add("@" + ((RuleMargin)rule).getMarginArea(), new Style().add((Iterable<Declaration>)rule));
                    continue;
                }
                if (rule instanceof RuleVolumeArea) {
                    style.add("@" + ((RuleVolumeArea)rule).getVolumeArea().value, Style.of((RuleVolumeArea)rule));
                    continue;
                }
                if (rule instanceof InlineStyle.RuleRelativePage) {
                    style.add(Style.of(((InlineStyle.RuleRelativePage)rule).asRulePage()));
                    continue;
                }
                if (rule instanceof InlineStyle.RuleRelativeVolume) {
                    style.add(Style.of(((InlineStyle.RuleRelativeVolume)rule).asRuleVolume()));
                    continue;
                }
                if (rule instanceof AnyAtRule) {
                    style.add("@" + ((AnyAtRule)rule).getName(), Style.of((AnyAtRule)rule));
                    continue;
                }
                throw new RuntimeException("coding error");
            }
            return style;
        }

        public String toString() {
            return BrailleCssSerializer.toString(this);
        }
    }
}

