/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css.calabash.impl;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermPair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.s9api.SaxonApiException;
import org.daisy.braille.css.BrailleCSSProperty;
import org.daisy.braille.css.PropertyValue;
import org.daisy.common.stax.BaseURIAwareXMLStreamReader;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.stax.XMLStreamWriterHelper;
import org.daisy.common.transform.InputValue;
import org.daisy.common.transform.OutputValue;
import org.daisy.common.transform.SingleInSingleOutXMLTransformer;
import org.daisy.common.transform.TransformerException;
import org.daisy.common.transform.XMLInputValue;
import org.daisy.common.transform.XMLOutputValue;
import org.daisy.common.xproc.calabash.XMLCalabashInputValue;
import org.daisy.common.xproc.calabash.XMLCalabashOutputValue;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.daisy.pipeline.braille.css.impl.BrailleCssSerializer;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssShiftStringSetStep
extends DefaultStep
implements XProcStep {
    private ReadablePipe sourcePipe = null;
    private WritablePipe resultPipe = null;
    private static final String XMLNS_CSS = "http://www.daisy.org/ns/pipeline/braille-css";
    private static final QName CSS_STRING_SET = new QName("http://www.daisy.org/ns/pipeline/braille-css", "string-set");
    private static final QName CSS_BOX = new QName("http://www.daisy.org/ns/pipeline/braille-css", "box");
    private static final QName CSS__ = new QName("http://www.daisy.org/ns/pipeline/braille-css", "_");
    private static final QName _TYPE = new QName("type");
    private static final Logger logger = LoggerFactory.getLogger(CssShiftStringSetStep.class);

    private CssShiftStringSetStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.sourcePipe = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.resultPipe = pipe;
    }

    public void reset() {
        this.sourcePipe.resetReader();
        this.resultPipe.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            new CssShiftStringSetTransformer().transform((InputValue)new XMLCalabashInputValue(this.sourcePipe), (OutputValue)new XMLCalabashOutputValue(this.resultPipe, this.runtime)).run();
        }
        catch (Throwable e) {
            throw XProcStep.raiseError((Throwable)e, (XAtomicStep)this.step);
        }
    }

    private static void parseStringSet(String value, List<TermPair<String, TermList>> appendTo) {
        PropertyValue decl = PropertyValue.parse((String)"string-set", (String)value);
        if (decl != null) {
            BrailleCSSProperty.StringSet stringSet = (BrailleCSSProperty.StringSet)decl.getProperty();
            switch (stringSet) {
                case INHERIT: {
                    throw new RuntimeException("'string-set: inherit' not supported");
                }
                case list_values: {
                    for (Term t : (TermList)decl.getValue()) {
                        appendTo.add((TermPair<String, TermList>)((TermPair)t));
                    }
                    break;
                }
            }
        }
    }

    private static String serializeStringSet(List<TermPair<String, TermList>> stringSet) {
        if (stringSet.isEmpty()) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        Iterator<TermPair<String, TermList>> it = stringSet.iterator();
        while (it.hasNext()) {
            s.append(BrailleCssSerializer.toString((Term)it.next()));
            if (!it.hasNext()) continue;
            s.append(", ");
        }
        return s.toString();
    }

    private static class CssShiftStringSetTransformer
    extends SingleInSingleOutXMLTransformer {
        private CssShiftStringSetTransformer() {
        }

        public Runnable transform(XMLInputValue<?> source, XMLOutputValue<?> result, InputValue<?> params) throws IllegalArgumentException {
            if (source == null || result == null) {
                throw new IllegalArgumentException();
            }
            return () -> this.transform(source.ensureSingleItem().asXMLStreamReader(), result.asXMLStreamWriter());
        }

        void transform(BaseURIAwareXMLStreamReader reader, BaseURIAwareXMLStreamWriter output) throws TransformerException {
            XMLStreamWriterHelper.BufferedXMLStreamWriter writer = new XMLStreamWriterHelper.BufferedXMLStreamWriter(output);
            boolean insideInlineBox = false;
            Stack<Boolean> blockBoxes = new Stack<Boolean>();
            Stack<Boolean> inlineBoxes = new Stack<Boolean>();
            ArrayList pendingStringSet = new ArrayList();
            ShiftedStringSet shiftedStringSet = null;
            try {
                int event = reader.getEventType();
                try {
                    while (true) {
                        switch (event) {
                            case 1: {
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)writer, (XMLStreamReader)reader);
                                boolean isInlineBox = false;
                                boolean isBlockBox = false;
                                if (insideInlineBox) {
                                    XMLStreamWriterHelper.writeAttributes((XMLStreamWriter)writer, (XMLStreamReader)reader);
                                } else {
                                    boolean isBox = CSS_BOX.equals(reader.getName());
                                    String stringSet = null;
                                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                                        QName name = reader.getAttributeName(i);
                                        String value = reader.getAttributeValue(i);
                                        if (CSS_STRING_SET.equals(name)) {
                                            stringSet = value;
                                            continue;
                                        }
                                        if (isBox && _TYPE.equals(name)) {
                                            if ("inline".equalsIgnoreCase(value)) {
                                                isInlineBox = true;
                                            } else if ("block".equalsIgnoreCase(value)) {
                                                isBlockBox = true;
                                            }
                                        }
                                        XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)name, (String)value);
                                    }
                                    if ((isBlockBox || isInlineBox) && shiftedStringSet != null) {
                                        shiftedStringSet.render();
                                        shiftedStringSet = null;
                                    }
                                    if (isInlineBox) {
                                        if (stringSet != null) {
                                            if (!pendingStringSet.isEmpty()) {
                                                CssShiftStringSetStep.parseStringSet(stringSet, pendingStringSet);
                                            } else {
                                                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)CSS_STRING_SET, (String)stringSet);
                                            }
                                        }
                                        if (!pendingStringSet.isEmpty()) {
                                            stringSet = CssShiftStringSetStep.serializeStringSet(pendingStringSet);
                                            pendingStringSet.clear();
                                            if (stringSet != null) {
                                                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)CSS_STRING_SET, (String)stringSet);
                                            }
                                        }
                                    } else if (stringSet != null) {
                                        CssShiftStringSetStep.parseStringSet(stringSet, pendingStringSet);
                                    }
                                    if (isInlineBox) {
                                        insideInlineBox = true;
                                    }
                                }
                                blockBoxes.push(isBlockBox);
                                inlineBoxes.push(isInlineBox);
                                break;
                            }
                            case 2: {
                                boolean isBlockBox = (Boolean)blockBoxes.pop();
                                boolean isInlineBox = (Boolean)inlineBoxes.pop();
                                if (isBlockBox && !pendingStringSet.isEmpty()) {
                                    if (shiftedStringSet == null) {
                                        throw new RuntimeException();
                                    }
                                    shiftedStringSet.putAll(pendingStringSet);
                                    pendingStringSet.clear();
                                }
                                if (isInlineBox) {
                                    if (shiftedStringSet != null) {
                                        throw new RuntimeException("coding error");
                                    }
                                    shiftedStringSet = new ShiftedStringSet();
                                    writer.writeEvent((XMLStreamWriterHelper.FutureWriterEvent)shiftedStringSet);
                                }
                                if (isInlineBox) {
                                    insideInlineBox = false;
                                }
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)writer, (XMLStreamReader)reader);
                                break;
                            }
                            default: {
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)writer, (XMLStreamReader)reader);
                            }
                        }
                        event = reader.next();
                    }
                }
                catch (NoSuchElementException e) {
                    if (!pendingStringSet.isEmpty()) {
                        if (shiftedStringSet == null) {
                            throw new RuntimeException("invalid input");
                        }
                        shiftedStringSet.putAll(pendingStringSet);
                    }
                    if (shiftedStringSet != null) {
                        shiftedStringSet.render();
                    }
                    writer.flush();
                }
            }
            catch (XMLStreamException e) {
                throw new TransformerException((Throwable)e);
            }
        }

        private static class ShiftedStringSet
        implements XMLStreamWriterHelper.FutureWriterEvent {
            private List<TermPair<String, TermList>> stringSet;
            private boolean ready = false;

            private ShiftedStringSet() {
            }

            private void put(TermPair<String, TermList> stringSet) {
                if (this.stringSet == null) {
                    this.stringSet = new ArrayList<TermPair<String, TermList>>();
                }
                this.stringSet.add(stringSet);
            }

            private void putAll(List<TermPair<String, TermList>> stringSet) {
                for (TermPair<String, TermList> s : stringSet) {
                    this.put(s);
                }
            }

            private void render() {
                this.ready = true;
            }

            public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
                if (!this.ready) {
                    throw new XMLStreamException("not ready");
                }
                if (this.stringSet != null) {
                    String value = CssShiftStringSetStep.serializeStringSet(this.stringSet);
                    if (value != null) {
                        XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)CSS__);
                    }
                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)CSS_STRING_SET, (String)value);
                    writer.writeEndElement();
                }
            }

            public boolean isReady() {
                return this.ready;
            }
        }
    }

    @Component(name="css:shift-string-set", service={XProcStepProvider.class}, property={"type:String={http://www.daisy.org/ns/pipeline/braille-css}shift-string-set"})
    public static class Provider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
            return new CssShiftStringSetStep(runtime, step);
        }
    }
}

