/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css;

import cz.vutbr.web.css.RuleBlock;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.daisy.braille.css.InlineStyle;
import org.daisy.braille.css.RuleTextTransform;
import org.daisy.braille.css.SimpleInlineStyle;

public class CSSStyledText
implements Cloneable {
    private final String text;
    private Map<String, String> textAttributes;
    private Style style;
    private static final Function<String, Style> parseCSS = CSSStyledText.memoize(Style::parse);

    public CSSStyledText(String text, SimpleInlineStyle style) {
        this(text, style, null);
    }

    public CSSStyledText(String text, SimpleInlineStyle style, Map<String, String> textAttributes) {
        this.text = text;
        this.style = new Style();
        this.style.properties = style;
        this.textAttributes = textAttributes;
    }

    public CSSStyledText(String text, String style) {
        this(text, style, null);
    }

    public CSSStyledText(String text, String style, Map<String, String> textAttributes) {
        this.text = text;
        this.style = style == null ? null : parseCSS.apply(style);
        this.textAttributes = textAttributes;
    }

    public CSSStyledText(String text) {
        this.text = text;
        this.style = null;
        this.textAttributes = null;
    }

    public String getText() {
        return this.text;
    }

    public SimpleInlineStyle getStyle() {
        if (this.style == null) {
            return null;
        }
        return this.style.properties;
    }

    public RuleTextTransform getDefaultTextTransformDefinition() {
        if (this.style == null) {
            return null;
        }
        return this.style.defaultTextTransformDef;
    }

    public RuleTextTransform getTextTransformDefinition(String name) {
        if (this.style == null || this.style.textTransformDefs == null) {
            return null;
        }
        return this.style.textTransformDefs.get(name);
    }

    public Map<String, String> getTextAttributes() {
        return this.textAttributes;
    }

    public CSSStyledText clone() {
        CSSStyledText clone;
        try {
            clone = (CSSStyledText)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("coding error");
        }
        if (this.style != null) {
            clone.style = (Style)this.style.clone();
        }
        if (this.textAttributes != null) {
            clone.textAttributes = new HashMap<String, String>(this.textAttributes);
        }
        return clone;
    }

    public String toString() {
        String s = this.text;
        if (this.style != null && this.style.properties != null && !this.style.properties.isEmpty()) {
            s = s + "{" + this.style.properties + "}";
        }
        return s;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CSSStyledText)) {
            return false;
        }
        CSSStyledText that = (CSSStyledText)other;
        if (this.text != null) {
            if (that.text == null) {
                return false;
            }
            if (!this.text.equals(that.text)) {
                return false;
            }
        } else if (that.text != null) {
            return false;
        }
        if (this.textAttributes != null && !this.textAttributes.isEmpty()) {
            if (that.textAttributes == null || that.textAttributes.isEmpty()) {
                return false;
            }
            if (!this.textAttributes.equals(that.textAttributes)) {
                return false;
            }
        } else if (that.textAttributes != null && !that.textAttributes.isEmpty()) {
            return false;
        }
        if (this.style != null && this.style.properties != null && !this.style.properties.isEmpty()) {
            if (that.style == null || that.style.properties == null || that.style.properties.isEmpty()) {
                return false;
            }
            if (!this.style.equals(that.style)) {
                return false;
            }
        } else if (that.style != null && that.style.properties != null && !that.style.properties.isEmpty()) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + (this.text == null ? 0 : this.text.hashCode());
        hash = 31 * hash + (this.textAttributes == null ? 0 : this.textAttributes.hashCode());
        hash = 31 * hash + (this.style == null ? 0 : this.style.hashCode());
        return hash;
    }

    private static <K, V extends Cloneable> Function<K, V> memoize(final Function<K, V> function) {
        final HashMap cache = new HashMap();
        return new Function<K, V>(){

            @Override
            public V apply(K key) {
                Cloneable value;
                if (cache.containsKey(key)) {
                    value = (Cloneable)cache.get(key);
                } else {
                    value = (Cloneable)function.apply(key);
                    if (value != null) {
                        cache.put(key, value);
                    }
                }
                if (value == null) {
                    return null;
                }
                try {
                    return (Cloneable)value.getClass().getMethod("clone", new Class[0]).invoke((Object)value, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException("Could not invoke clone() method", e);
                }
            }
        };
    }

    private static class Style
    implements Cloneable {
        SimpleInlineStyle properties;
        RuleTextTransform defaultTextTransformDef;
        Map<String, RuleTextTransform> textTransformDefs;

        private Style() {
        }

        public Object clone() {
            Style clone;
            try {
                clone = (Style)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("coding error");
            }
            if (this.properties != null) {
                clone.properties = (SimpleInlineStyle)this.properties.clone();
            }
            return clone;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Style)) {
                return false;
            }
            Style that = (Style)other;
            if (this.properties != null) {
                if (that.properties == null) {
                    return false;
                }
                if (!this.properties.equals((Object)that.properties)) {
                    return false;
                }
            } else if (that.properties != null) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + (this.properties == null ? 0 : this.properties.hashCode());
            return hash;
        }

        public static Style parse(String style) {
            InlineStyle inlineStyle = new InlineStyle(style);
            Style s = new Style();
            s.properties = new SimpleInlineStyle((List)inlineStyle.getMainStyle());
            for (RuleBlock b : inlineStyle) {
                if (b instanceof InlineStyle.RuleMainBlock) continue;
                if (b instanceof RuleTextTransform) {
                    RuleTextTransform def = (RuleTextTransform)b;
                    String name = def.getName();
                    if (name != null) {
                        if (s.textTransformDefs == null) {
                            s.textTransformDefs = new HashMap<String, RuleTextTransform>();
                        }
                        s.textTransformDefs.put(name, def);
                        continue;
                    }
                    s.defaultTextTransformDef = def;
                    continue;
                }
                throw new RuntimeException("Unexpected style: " + b);
            }
            return s;
        }
    }
}

