/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.modules.impl.tracker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.daisy.common.spi.ServiceLoader;
import org.daisy.common.spi.ServiceWithProperties;
import org.daisy.pipeline.modules.Module;
import org.daisy.pipeline.modules.impl.tracker.DefaultModuleRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleRegistry_SPI
extends DefaultModuleRegistry
implements ServiceWithProperties {
    private static final Logger spi_log = LoggerFactory.getLogger(DefaultModuleRegistry_SPI.class);
    private final Map spi_props;
    private boolean spi_deactivated = false;

    public DefaultModuleRegistry_SPI() {
        spi_log.trace("Creating DefaultModuleRegistry");
        this.spi_props = new HashMap();
        this.spi_props.put("component.name", "module-registry");
        spi_log.trace("Binding org.daisy.pipeline.modules.Module services...");
        int minRef = 0;
        int maxRef = -1;
        int refCount = 0;
        try {
            Iterator services = ServiceLoader.load(Module.class).iterator();
            while (services.hasNext()) {
                try {
                    Module service = (Module)services.next();
                    this.addModule(service);
                    spi_log.trace("Bound org.daisy.pipeline.modules.Module service: " + service.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(service)));
                    if (maxRef <= 0 || ++refCount != maxRef) continue;
                    break;
                }
                catch (Throwable e) {
                    spi_log.error("Error while binding org.daisy.pipeline.modules.Module service", e);
                }
            }
        }
        catch (Throwable e) {
            spi_log.error("Error while binding org.daisy.pipeline.modules.Module services", e);
        }
        if (refCount < minRef) {
            spi_log.warn("No org.daisy.pipeline.modules.Module found");
            throw new RuntimeException("No org.daisy.pipeline.modules.Module found");
        }
        spi_log.trace("Bound " + refCount + " org.daisy.pipeline.modules.Module services.");
        spi_log.trace("Activating DefaultModuleRegistry");
        this.init();
    }

    protected void finalize() throws Throwable {
        this.spi_deactivate();
        super.finalize();
    }

    public void spi_deactivate() {
        if (!this.spi_deactivated) {
            spi_log.trace("Deactivating DefaultModuleRegistry");
            try {
                this.close();
            }
            catch (Throwable e) {
                spi_log.error("Caught exception while deactivating DefaultModuleRegistry", e);
            }
            finally {
                this.spi_deactivated = true;
            }
        }
    }

    public Map spi_getProperties() {
        return this.spi_props;
    }
}

