/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.modules.impl.tracker;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.daisy.pipeline.modules.Component;
import org.daisy.pipeline.modules.Entity;
import org.daisy.pipeline.modules.Module;
import org.daisy.pipeline.modules.ModuleRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.osgi.service.component.annotations.Component(name="module-registry", service={ModuleRegistry.class})
public class DefaultModuleRegistry
implements ModuleRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DefaultModuleRegistry.class);
    private final HashMap<URI, Module> componentsMap = new HashMap();
    private final HashMap<String, Module> entityMap = new HashMap();
    private final HashSet<Module> modules = new HashSet();

    @Activate
    public void init() {
        logger.trace("Module registry up");
    }

    @Deactivate
    public void close() {
    }

    @Override
    public Iterator<Module> iterator() {
        return this.modules.iterator();
    }

    @Override
    public Module getModuleByComponent(URI uri) {
        return this.componentsMap.get(uri);
    }

    @Override
    public Module resolveDependency(URI component, Module source) {
        return null;
    }

    @Override
    public Iterable<URI> getComponents() {
        return this.componentsMap.keySet();
    }

    @Reference(name="Module", unbind="-", service=Module.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    public void addModule(Module module) {
        logger.debug("Registring module {}", (Object)module.getName());
        this.modules.add(module);
        for (Component component : module.getComponents()) {
            logger.debug("  - {}", (Object)component.getURI());
            this.componentsMap.put(component.getURI(), module);
        }
        for (Entity entity : module.getEntities()) {
            logger.debug("  - {}", (Object)entity.getPublicId());
            this.entityMap.put(entity.getPublicId(), module);
        }
    }

    public void removeModule(Module module) {
    }

    @Override
    public Module getModuleByEntity(String publicId) {
        return this.entityMap.get(publicId);
    }

    @Override
    public Iterable<String> getEntities() {
        return this.entityMap.keySet();
    }
}

