/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.modules;

import com.google.common.collect.Iterators;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.daisy.common.file.URLs;
import org.daisy.pipeline.modules.Component;
import org.daisy.pipeline.modules.Entity;
import org.daisy.pipeline.modules.ResourceLoader;
import org.daisy.pipeline.xmlcatalog.XmlCatalog;
import org.daisy.pipeline.xmlcatalog.XmlCatalogParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Module {
    private String name;
    private String version;
    private String title;
    private final Map<URI, Component> components = new HashMap<URI, Component>();
    private final Map<String, Entity> entities = new HashMap<String, Entity>();
    private static final Logger mLogger = LoggerFactory.getLogger(Module.class);

    protected Module(String name, String version, String title) {
        this.name = name;
        this.version = version;
        this.title = title;
    }

    protected void init(XmlCatalogParser parser) {
        Class<?> thisClass = this.getClass();
        try {
            URI jarFileURI = thisClass.getProtectionDomain().getCodeSource().getLocation().toURI();
            try {
                final File jarFile = new File(jarFileURI);
                mLogger.trace("Creating module from JAR: " + jarFile);
                this.parseCatalog(parser, new ResourceLoader(){

                    @Override
                    public URL loadResource(String path) {
                        if (!path.startsWith("../")) {
                            throw new RuntimeException("Paths must start with '../' but got '" + path + "'");
                        }
                        path = path.substring(2);
                        try {
                            return jarFile.isDirectory() ? new URL(jarFile.toURI().toASCIIString() + path) : new URL("jar:" + jarFile.toURI().toASCIIString() + "!" + path);
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public Iterable<URL> loadResources(String path) {
                        throw new UnsupportedOperationException("Not supported without OSGi.");
                    }
                });
            }
            catch (IllegalArgumentException e) {
                OSGiHelper.init(this, parser);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseCatalog(XmlCatalogParser parser, ResourceLoader loader) {
        URL catalogURL = loader.loadResource("../META-INF/catalog.xml");
        if (catalogURL == null) {
            throw new RuntimeException("/META-INF/catalog.xml file not found");
        }
        XmlCatalog catalog = parser.parse(URLs.asURI((URL)catalogURL));
        this.parseCatalog(catalog, loader);
    }

    void parseCatalog(XmlCatalog catalog, ResourceLoader loader) {
        for (Map.Entry<URI, URI> entry : catalog.getSystemIdMappings().entrySet()) {
            this.addComponent(entry.getKey(), entry.getValue().toString(), loader);
        }
        for (Map.Entry<URI, URI> entry : catalog.getUriMappings().entrySet()) {
            this.addComponent(entry.getKey(), entry.getValue().toString(), loader);
        }
        for (Map.Entry<Object, URI> entry : catalog.getPublicMappings().entrySet()) {
            this.addEntity((String)entry.getKey(), entry.getValue().toString(), loader);
        }
        for (Map.Entry<Object, URI> entry : catalog.getRewriteUris().entrySet()) {
            Iterable<URL> entries = loader.loadResources(entry.getValue().toString());
            for (URL url : entries) {
                try {
                    String path = url.toURI().getPath().toString().replace(entry.getValue().toString().replace("..", ""), "");
                    this.addComponent(((URI)entry.getKey()).resolve(URI.create(path)), url.toString(), loader);
                }
                catch (URISyntaxException e) {
                    mLogger.warn("Exception while generating paths");
                }
            }
        }
    }

    private void addComponent(URI uri, String path, ResourceLoader loader) {
        mLogger.trace("add component:" + uri.toString() + ", path: " + path);
        Component component = new Component(uri, path, loader);
        component.setModule(this);
        this.components.put(component.getURI(), component);
    }

    private void addEntity(String publicId, String path, ResourceLoader loader) {
        mLogger.trace("add entity:" + publicId.toString() + ", path: " + path);
        Entity entity = new Entity(publicId, path, loader);
        entity.setModule(this);
        this.entities.put(entity.getPublicId(), entity);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public Iterable<Component> getComponents() {
        return this.components.values();
    }

    public Component getComponent(URI uri) {
        return this.components.get(uri);
    }

    public Iterable<Entity> getEntities() {
        return this.entities.values();
    }

    public Entity getEntity(String publicId) {
        return this.entities.get(publicId);
    }

    public String toString() {
        return this.getName() + " [" + this.getVersion() + "]";
    }

    private static abstract class OSGiHelper {
        private OSGiHelper() {
        }

        static void init(Module thiz, XmlCatalogParser parser) {
            final Bundle bundle = FrameworkUtil.getBundle(thiz.getClass());
            mLogger.trace("Creating module from OSGi bundle: " + bundle);
            ResourceLoader loader = new ResourceLoader(){

                @Override
                public URL loadResource(String path) {
                    if (!path.startsWith("../")) {
                        throw new RuntimeException("Paths must start with '../' but got '" + path + "'");
                    }
                    path = path.substring(3);
                    URL url = bundle.getResource(path);
                    return url;
                }

                @Override
                public Iterable<URL> loadResources(final String path) {
                    return new Iterable<URL>(){

                        @Override
                        public Iterator<URL> iterator() {
                            return Iterators.forEnumeration((Enumeration)bundle.findEntries(path.replace("../", ""), "*", true));
                        }
                    };
                }
            };
            thiz.parseCatalog(parser, loader);
            thiz.name = ((String)bundle.getHeaders().get("Bundle-Name")).toString();
            thiz.version = bundle.getVersion().toString();
            thiz.title = bundle.getSymbolicName();
        }
    }
}

